/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/prntdd/pscript/inc/prdpcone.h, postscript, osdd, 13.355 90/08/21";*/

/**********************************************************************/
/*                                                                    */
/*   File            = PRDPCONE                                       */
/*                                                                    */
/*   Description     = Printer Device Driver Printer Control constants*/
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Error codes                                                        */
/**********************************************************************/

#define PRDPERR          700

/**********************************************************************/
/* Size of memory (in bytes) required to contain a single Text Entry's*/
/* worth of codepoints and control sequences for the printer.         */
/**********************************************************************/

#define MIN_TEXT_SIZE    200

/**********************************************************************/
/* Size of stack (in bytes) required for Printer Control separate     */
/* thread processing of a Band. The value below should be conservative*/
/* to allow for reasonable future expansion of Printer Control's      */
/* stack requirements.                                                */
/* If the value here is too small, then the Printer Control thread    */
/* for asynchronous Band processing will corrupt items allocated in   */
/* the Device Driver's global heap (usually PDB Instance Data).       */
/*                                                                    */
/* The value should also be an even number to keep the stack word     */
/* aligned.                                                           */
/**********************************************************************/

#define SIZE_PRINT_STACK        800

/**********************************************************************/
/* printer command constants                                          */
/**********************************************************************/

/**********************************************************************/
/* constants to be used for SplMessageBox                             */
/**********************************************************************/

/**********************************************************************/
/* error_info constants                                             */
/**********************************************************************/
#define EI_SPL_QUEUE_PROC       1
#define EI_WIN_DEV_DRIVER       2
#define EI_OTHER_ERROR        128
#define EI_INFO               256
#define EI_WARNING            512
#define EI_ERROR             1024
#define EI_SEVERE            2048

/**********************************************************************/
/* error_info constants                                             */
/**********************************************************************/
#define ED_PRINTER_JAM          1
#define ED_FORM_CHANGE_REQ      2
#define ED_CART_CHANGE_REQ      4
#define ED_PEN_CHANGE_REQ       8
#define ED_DATA_ERROR          16
#define ED_UNEXPECTED_OS2      32
#define ED_OTHER            32768
