/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************
 *
 * SOURCE FILE NAME = PRDDTYPT.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE        : ??/??/88
 *
 * DESCRIPTION : Printer Device Driver DDT/DVT/DCT Table constants and types
 *
 * FUNCTIONS
 *
 * NOTES       : Reference - Winthorn Functional Specification
 *			   - Device Driver Interface Specification
 *			   - Printer Device Driver Design Specification
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


/*
** Device Value Table (DVT) types.
*/

/*
**  removed DVT defs - fix for prdttypt.h		              
*/

#include "prdttypt.h"

/*
**  Device Description Table (DVT) type.
*/

typedef struct
    {
ULONG	 DDTPaperSize;	    /* lpDVTPaperSize */
PB	 DDTPrinterFonts[MAX_PRINTER_FONTS];
ULONG	 DDTRasterMode;     /*	      lpDVTRasterMode*/
ULONG	 DDTColorTable1;    /*	      lpDVTColorTable*/
ULONG	 DDTColorTable4;    /*	      lpDVTColorTable*/
ULONG	 DDTColorTable8;    /*	      lpDVTColorTable*/
ULONG	 DDTDevColorTable;  /*	      lpDVTColorTable*/
ULONG	 DDTBandsPerPage;   /*	      lpDVTBandsPerPage*/
    } DDTType;
typedef DDTType  *pDDTType;


/*
**  Device Command Table (DCT) types.
*/

typedef struct DCTcommand
    {
	SHORT		 DCTCommandLen;
	char		DCTCommandSeq[DCT_MAX_SIMPLE];
	SHORT		 DCTParamMask;
	SHORT		 DCTSlotMask;
	SHORT		 DCTNextCommand;
    } DCTCommandType;

typedef DCTCommandType	*lpDCTCommand;

/*
**  Define Slot type and pointer to it.
**  Temporary Usage : Slots not used for currently supported printers.
*/

typedef struct
    {
	SHORT		 DCTStateMask;
	SHORT		 DCTSlotCommand;
	BOOL	     DCTSlotExplicit;
    } DCTSlotType;

typedef DCTSlotType  *lpDCTSlot;

/*
**  Define DCT Entry and pointer to it.
*/

typedef struct
    {
	DCTCommandType	DCTCommand;
	SHORT		 DCTSelector;
	lpDCTSlot	DCTSlotList;
    } DCTEntry;

typedef DCTEntry   *lpDCT;

/*
** TLP (Type/Length/Pointer) Record type, for use by End-User Setup
** Utility.
*/

#if 0
typedef struct
    {
	SHORT		 TLPValue;	/* Value		       */
	SHORT		 TLPLength;	/* Length of item	       */
	char	       *TLPOffset;	 /* Offset of item in Data seg	*/
    } TLPRecordType;
#endif
