/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDDCONE.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Printer Device Driver Table error constants
 *
 * FUNCTIONS
 *
 * NOTES       : Reference - Device Driver Interface Specification
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#if (PRD_P5201 || PRD_P5202)
#define PRD_HIGH_RESOLUTION_PRINTER
#endif  /* 5201 or 5202 */

#if (PRD_P5201 || PRD_P5202 || PRD_P4201 || PRD_P4202 || PRD_P4207 || \
     PRD_P4208 || PRD_P5182 || PRD_P5200)
#define PRD_PRINT_QUALITY_SELECTION
#endif /* PRD_P5201 || PRD_P5202 || PRD_P4201 || PRD_P4202 || PRD_P4207
       PRD_P4208 || PRD_P5182 */

/*
**  Error codes
*/

#define PRDDERR          800
#define DCT_ERR_SEL_SLOT PRDDERR+1     /* both Selector/Slot in DCT   */


/*
**  Device Value Table (DVT) constants.
*/

#define MAX_PRINTER_FONTS         4
#define MAX_RASTER_MODES          2

#define DDT_NO_FONTS              0
#define DDT_ONE_FONT              1
#define DDT_FOUR_FONTS            4

#define DDT_NO_RASTER             0
#define DDT_ONE_LINE_RASTER       1
#define DDT_EIGHT_LINE_RASTER     8

#define DDT_NOT_ALL_CODEPOINTS    0
#define DDT_ALL_CODEPOINTS        1
#define DDT_CHAR_SET_2            2

#define DDT_NO_MOVEMENT           0
#define DDT_NEAREST_CELL          1
#define DDT_FINE_MOVEMENT         2
#define DDT_NO_BACK_SPACE         3
#define DDT_FINE_MOVEMENT_RIGHT   4

#define DDT_TWO_COLORS            2
#define DDT_EIGHT_COLORS          8

#define DDT_NO_DOWNLOAD_FONT      0

#if (PRD_P3852)
#define DDT_PRINTER_FONTS         DDT_NO_FONTS
#define DDT_RASTER_TYPE           DDT_ONE_LINE_RASTER
#define DDT_PRINT_TEXT_TYPE       DDT_NOT_ALL_CODEPOINTS
#define DDT_HORIZ_MOVE_TYPE       DDT_NO_MOVEMENT
#define DDT_MAX_COLORS            DDT_EIGHT_COLORS
#define DDT_DOWNLOAD_FONT_TYPE    DDT_NO_DOWNLOAD_FONT
#endif

#if (PRD_P4201 || PRD_P4202)
#define DDT_PRINTER_FONTS         DDT_ONE_FONT
#define DDT_RASTER_TYPE           DDT_EIGHT_LINE_RASTER
#define DDT_PRINT_TEXT_TYPE       DDT_ALL_CODEPOINTS
#define DDT_HORIZ_MOVE_TYPE       DDT_NEAREST_CELL
#define DDT_MAX_COLORS            DDT_TWO_COLORS
#define DDT_DOWNLOAD_FONT_TYPE    DDT_NO_DOWNLOAD_FONT
#endif

#if (PRD_P4207 || PRD_P4208)
#define DDT_PRINTER_FONTS         DDT_ONE_FONT
#define DDT_RASTER_TYPE           DDT_EIGHT_LINE_RASTER
#define DDT_PRINT_TEXT_TYPE       DDT_ALL_CODEPOINTS
#define DDT_HORIZ_MOVE_TYPE       DDT_FINE_MOVEMENT_RIGHT
#define DDT_MAX_COLORS            DDT_TWO_COLORS
#define DDT_DOWNLOAD_FONT_TYPE    DDT_NO_DOWNLOAD_FONT
#endif

#if (PRD_P5152)
#define DDT_PRINTER_FONTS         DDT_ONE_FONT
#define DDT_RASTER_TYPE           DDT_EIGHT_LINE_RASTER
#define DDT_PRINT_TEXT_TYPE       DDT_CHAR_SET_2
#define DDT_HORIZ_MOVE_TYPE       DDT_NO_BACK_SPACE
#define DDT_MAX_COLORS            DDT_TWO_COLORS
#define DDT_DOWNLOAD_FONT_TYPE    DDT_NO_DOWNLOAD_FONT
#endif

#if (PRD_P5182)
#define DDT_PRINTER_FONTS         DDT_ONE_FONT
#define DDT_RASTER_TYPE           DDT_EIGHT_LINE_RASTER
#define DDT_PRINT_TEXT_TYPE       DDT_ALL_CODEPOINTS
#define DDT_HORIZ_MOVE_TYPE       DDT_FINE_MOVEMENT
#define DDT_MAX_COLORS            DDT_TWO_COLORS
#define DDT_DOWNLOAD_FONT_TYPE    DDT_NO_DOWNLOAD_FONT
#endif

#if (PRD_P5200)
#define DDT_PRINTER_FONTS         DDT_ONE_FONT
#define DDT_RASTER_TYPE           DDT_NO_RASTER
#define DDT_PRINT_TEXT_TYPE       DDT_ALL_CODEPOINTS
#define DDT_HORIZ_MOVE_TYPE       DDT_FINE_MOVEMENT
#define DDT_MAX_COLORS            DDT_TWO_COLORS
#define DDT_DOWNLOAD_FONT_TYPE    DDT_NO_DOWNLOAD_FONT
#endif

#if (PRD_P5201)
#define DDT_PRINTER_FONTS         DDT_ONE_FONT
#define DDT_RASTER_TYPE           DDT_EIGHT_LINE_RASTER
#define DDT_PRINT_TEXT_TYPE       DDT_ALL_CODEPOINTS
#define DDT_HORIZ_MOVE_TYPE       DDT_FINE_MOVEMENT
#define DDT_MAX_COLORS            DDT_TWO_COLORS
#define DDT_DOWNLOAD_FONT_TYPE    DDT_NO_DOWNLOAD_FONT
#endif

#if (PRD_P5202)
#define DDT_PRINTER_FONTS         DDT_FOUR_FONTS
#define DDT_RASTER_TYPE           DDT_EIGHT_LINE_RASTER
#define DDT_PRINT_TEXT_TYPE       DDT_ALL_CODEPOINTS
#define DDT_HORIZ_MOVE_TYPE       DDT_FINE_MOVEMENT
#define DDT_MAX_COLORS            DDT_TWO_COLORS
#define DDT_DOWNLOAD_FONT_TYPE    DDT_NO_DOWNLOAD_FONT
#endif

#if (PRD_P5216 || PRD_P5223)
#define DDT_PRINTER_FONTS         DDT_ONE_FONT
#define DDT_RASTER_TYPE           DDT_NO_RASTER
#define DDT_PRINT_TEXT_TYPE       DDT_ALL_CODEPOINTS
#define DDT_HORIZ_MOVE_TYPE       DDT_NEAREST_CELL
#define DDT_MAX_COLORS            DDT_TWO_COLORS
#define DDT_DOWNLOAD_FONT_TYPE    DDT_NO_DOWNLOAD_FONT
#endif

/*
**  Device Command Table (DCT) constants.
*/

/*
** Device Command Table (DCT) Logical Commands.
** The numbers defined here are indices into the DCT, and need to be
** in step with DCT initialisation.
*/

#define DCT_PRINTER_INIT_1      0
#define DCT_PRINTER_INIT_2      1
#define DCT_PRINTER_INIT_3      2
#define DCT_RASTER_MODE_1       3
#define DCT_RASTER_MODE_2       4
#define DCT_SELECT_FONT_1       5
#define DCT_SELECT_FONT_2       6
#define DCT_SELECT_FONT_3       7
#define DCT_SELECT_FONT_4       8
#define DCT_RETURN              9
#define DCT_LINE_FEED           10
#define DCT_FORM_FEED           11
#define DCT_CELL_LEFT           12
#define DCT_CELL_RIGHT          13
#define DCT_MOVE_LEFT           14
#define DCT_MOVE_RIGHT          15
#define DCT_PRINT_TEXT          16
#define DCT_VARIABLE_LINE       17
#define DCT_VERTICAL_TAB        18
#define DCT_PAGE_LENGTH         19
#define DCT_VERTICAL_UNITS      20
#define DCT_ASPECT_RATIO        21
#define DCT_DOWNLOAD_FONT       22
#define DCT_SELECT_PRINT_MODE   23

/*
** Define DCT maximum string length (also used for simple output in
** Printer Control subroutines).
*/

#define DCT_MAX_SIMPLE          16

/*
** TLP (Type/Length/Pointer) Type values.
** These are used in the definition of the PRD, DDT, DVT, and DCT
** Headers, which are used by the End-User Setup Utility to change
** "patch" the contents of the DDT, DVT or DCT.
**
** Note that the TLP Type values related to DCT items match exactly
** the corresponding DCT logical commands.
*/

#if 0

#define DVT_HEADER_TLP          1      /* start of DVT Header         */
#define DCT_HEADER_TLP          2      /* start of DCT Header         */

#define DVT_PAGESIZE_TLP        1      /* DVT Page Size entry         */
#define DVT_BANDSPERPAGE_TLP    2      /* DVT Bands-per-Page entry    */

#define DCT_PRINTER_INIT_1_TLP      DCT_PRINTER_INIT_1
#define DCT_PRINTER_INIT_2_TLP      DCT_PRINTER_INIT_2
#define DCT_PRINTER_INIT_3_TLP      DCT_PRINTER_INIT_3
#define DCT_RASTER_MODE_1_TLP       DCT_RASTER_MODE_1
#define DCT_RASTER_MODE_2_TLP       DCT_RASTER_MODE_2
#define DCT_SELECT_FONT_1_TLP       DCT_SELECT_FONT_1
#define DCT_SELECT_FONT_2_TLP       DCT_SELECT_FONT_2
#define DCT_SELECT_FONT_3_TLP       DCT_SELECT_FONT_3
#define DCT_SELECT_FONT_4_TLP       DCT_SELECT_FONT_4
#define DCT_RETURN_TLP              DCT_RETURN
#define DCT_LINE_FEED_TLP           DCT_LINE_FEED
#define DCT_FORM_FEED_TLP           DCT_FORM_FEED
#define DCT_CELL_LEFT_TLP           DCT_CELL_LEFT
#define DCT_CELL_RIGHT_TLP          DCT_CELL_RIGHT
#define DCT_MOVE_LEFT_TLP           DCT_MOVE_LEFT
#define DCT_MOVE_RIGHT_TLP          DCT_MOVE_RIGHT
#define DCT_PRINT_TEXT_TLP          DCT_PRINT_TEXT
#define DCT_VARIABLE_LINE_TLP       DCT_VARIABLE_LINE
#define DCT_VERTICAL_TAB_TLP        DCT_VERTICAL_TAB
#define DCT_PAGE_LENGTH_TLP         DCT_PAGE_LENGTH
#define DCT_VERTICAL_UNITS_TLP      DCT_VERTICAL_UNITS
#define DCT_ASPECT_RATIO_TLP        DCT_ASPECT_RATIO
#define DCT_DOWNLOAD_FONT_TLP       DCT_DOWNLOAD_FONT
#define DCT_SELECT_PRINT_MODE_TLP   DCT_SELECT_PRINT_MODE

#endif
