/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*								      */
/*   File	     = PRDAEXTF 				      */
/*								      */
/*   Description     = Printer Device Driver external files for       */
/*		       Attributes routines			      */
/*								      */
/*   Function	     =						      */
/*								      */
/*   Reference	     = Device Driver Interface Specification	      */
/*								      */
/*								      */
/**********************************************************************/

ULONG	prda_DeviceSetAttributes(
	    HDC,
	    ULONG,		       /* BundleType		      */
	    ULONG,		       /* DefsMask		      */
	    ULONG,		       /* AttrsMask		      */
	    Dptr,		       /* Attributes		      */
	    PDDC,
	    ULONG);

ULONG	prda_DeviceGetAttributes(
	    HDC,
	    ULONG,		       /* BundleType		      */
	    ULONG,		       /* AttrsMask		      */
	    Dptr,		       /* Attributes		      */
	    PDDC,
	    ULONG);

ULONG	prda_DeviceSetGlobalAttribute(
	    HDC,
	    ULONG,		       /* AttrType		      */
	    ULONG,		       /* AttrValue		      */
	    ULONG,		       /* Options		      */
	    PDDC,
	    ULONG);

ULONG	prda_NotifyClipChange(
	    HDC,
	    WcsRect  *, 	    /* BoundClip		   */
	    ULONG,		       /* Complexity		      */
/*	    ULONG, */		       /* ClipPath		      */
	    PDDC,
	    ULONG);

ULONG	prda_RealizeFont(
	    HDC,
	    ULONG,		       /* Command		      */
	    PFATTRS,		       /* Logical Font		      */
	    PFATTRS,		       /* Engine Font		      */
	    PDDC,
	    ULONG);

ULONG	prda_GetDCCaps(
	    HDC,
	    ULONG  *,		    /* Flags			   */
	    PDDC,
	    ULONG);

ULONG	prda_DeviceQueryFontAttributes (
	    HDC,
	    ULONG,		       /* Size			      */
	    PFONTMETRICS,	       /* Metrics		      */
	    PDDC,
	    ULONG);

/*!!!CR according to orig. engine spec, should be LONG function (6-13-88) */
LONG	prda_DeviceQueryFonts (
	    HDC,
	    Dptr,		       /* Filter		      */
	    PFONTMETRICS,	       /* Metrics		      */
	    ULONG,		       /* Size			      */
	    ULONG  *,		    /* Count			   */
	    PDDC,
	    ULONG);

ULONG	prda_GetPatternOrigin(
	    HDC,
	    WcsPoint  *,	    /* NewXY			   */
	    PDDC,
	    ULONG);

ULONG	prda_SetPatternOrigin (
	    HDC,
	    WcsPoint  *,	    /* NewXY			   */
	    PDDC,
	    ULONG);

ULONG	prda_SetCodePage (
	    HDC,
	    ULONG,
	    PDDC,
	    ULONG);

ULONG	prda_GetCodePage (
	    HDC,
	    PDDC,
	    ULONG);

SHORT  prda_SetTextAttrs (
	    SHORT,		      /* DefsMask		     */
	    SHORT,		      /* AttrsMask		     */
	    PDCHARBUNDLE,	       /* Attributes		      */
	    PDDC);

SHORT  prda_SetLineAttrs (
	    SHORT,		      /* DefsMask		     */
	    SHORT,		      /* AttrsMask		     */
	    PDLINEBUNDLE,	       /* Attributes		      */
	    PDDC);

void  prda_SetMarkAttrs (
	    SHORT,		      /* DefsMask		     */
	    SHORT,		      /* AttrsMask		     */
	    PDMARKERBUNDLE,	       /* New Attributes	      */
	    PDDC);

void  prda_SetPtrnAttrs (
	    SHORT,		      /* DefsMask		     */
	    SHORT,		      /* AttrsMask		     */
	    DAREABUNDLE  *,	    /* Attributes		   */
	    PDDC);

void  prda_SetImagAttrs (
	    SHORT,		      /* DefsMask		     */
	    SHORT,		      /* AttrsMask		     */
	    lpImageAt,		       /* Attributes		      */
	    PDDC);

void  prda_GetTextAttrs (
	    SHORT,		      /* AttrsMask		     */
	    PDCHARBUNDLE,	       /* Attributes		      */
	    PDDC);

void  prda_GetLineAttrs (
	    SHORT,		      /* AttrsMask		     */
	    PDLINEBUNDLE,	       /* Attributes		      */
	    PDDC);

void  prda_GetMarkAttrs (
	    SHORT,		      /* AttrsMask		     */
	    PDMARKERBUNDLE,	       /* New Attributes	      */
	    PDDC);

void  prda_GetPtrnAttrs (
	    SHORT,		      /* AttrsMask		     */
	    lpPtrnAt,		       /* Attributes		      */
	    PDDC);

void  prda_GetImagAttrs (
	    SHORT,		      /* AttrsMask		     */
	    lpImageAt,		       /* Attributes		      */
	    PDDC);

void   prda_DefaultClip (
	    PDDC);

