/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PPDIALOG.H
 *
 * DESCRIPTIVE NAME = PPD setting
 *
 *
 * VERSION = V2.0
 *
 * DATE        : 11/27/91
 *
 * DESCRIPTION : Header file for PPD setting
 *
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define  ALLPPDS       450
#define  DIRECTORY_PPB 1
#define  TRUE          1
#define  FALSE         0
#define  NONE          -1
#define  BANNER        0
#define  NOBANNER      1
#define  NORMAL        0
#define  REVERSE       1
#define  PORTRAIT      0
#define  LANDSCAPE     1
#define  CNFRES        0
#define  PPDRES        1
#define  RESBUF        2
#define  SGNRES        3
#define  DIRRES        4
#define  LCLRES        5
#define  IMAXRES       5
#define  SYSTEM        0
#define  RAW           1
#define  ENCAPS        2
#define  ATRAY         0
#define  BTRAY         1
#define  CTRAY         2
#define  DTRAY         3
#define  ETRAY         4
#define  MANUAL        5     /* treated as the last tray                    */
#define  MAX_FNAMESIZE 40    /* Maximum size of a file name                 */
/*
**           
** Increase MAX_INPUT from 128 to 256 to allow for more PPD files.
*/
#define  MAX_INPUT     256   /* Maximum number of PPD files in directory
                                segment                                     */
#define  DRENTRYSIZE   48    /* Size of each directory table entry          */
/* @V3.0LMMOORE */
/* Change INPBINS from 5 to 8. */
#define  INPBINS       8     /* Max no of input bins                        */
#define  OUTBINS       3     /* Max no of output bins                       */
#define  PRBUFSZ       4096
#define  MAX_PSIZE     64
#define  APPKEYSIZE    20
#define  MAX_KEYAPPSIZE 78   /* Max size for application name in ini        */

/*
**  The driver version should be changed when any changes in DRIVDATA
**  could cause a problem.  Newer versions should be greater then
**  previous to allow logical comparisons.  Fill in defaults for
**  DRIVDATA for newer drivers in ValidateDriveData()
**  DRIVERSION always has the most current version
*/

#define  DRIVERSION_1_3  0X00010003L
#define  DRIVERSION_1_31 0X00010301L
#define  DRIVERSION_2_11 0X00020011L  /* For Warp summer '94 */
#define  DRIVERSION      0X00020011L
#define  DEF_IEXT      ".ppd"
#define  DEF_OEXT      ".ppb"
#define  PB            CHAR *
#define  MAX_CHARS_IN_EXTENSION 3
#define  MAX_CHARS_IN_FILENAME 8

/*
**  defines for the duplex options
*/

#define  DUPLEX_NONE   -1
#define  DUPLEX_FALSE  0
#define  DUPLEX_DUPLEXNOTUMBLE 1
#define  DUPLEX_DUPLEXTUMBLE 2


/*
** typedef declarations for use by prdefpdb.c,filelist.c and other modules.
** These declarations relate to printer configuration .
** Description of typedef struc defined :
**            CNFDATA : structure typedef defined so that a device context
**                      data can be stored and accessed by various routines.
**            PPD1    : A typedef defined so that various assorted printer
**                      descriptive items can be stored in a group.
**            PPD2    : A typedef defined so that various printer paper related
**                      values and command lists can be stored under one group.
**            PPD3    : A typedef defined so that Input Paper Tray related
**                      items can be kept under a group.
**            PPD4    : A typedef defined so that Output Paper Tray related
**                      items can be kept under a group.
**            PPD5    : A typedef defined so that Fonts related items can be
**                      kept under a group .
**          DESPPD    : An agglomeration of items PPD1 to PPD5 .The structure
**                      desPpd (with Type DESPPD) is used to access all the
**                      relevant parameters of an adobe printer descriptor file
*/
/* @V3.0LMMOORE */
/* This is the old source for compatibility's sake */
typedef struct _DUMMYSRC
{
  /*
  **  paper name lying in the upper tray
  */
  CHAR szPaperName[5][MAX_PSIZE];
  SHORT shCustomWidth;
  SHORT shCustomHeight;
} DUMMYSRC;

/* @V3.0LMMOORE
** The new 8 tray structure
*/
typedef struct _SOURCE
{
  CHAR szPaperName[INPBINS][MAX_PSIZE];
  SHORT shCustomWidth;
  SHORT shCustomHeight;
} SOURCE, *PSOURCE;

/* @V3.0LMMOORE
** This is an Internal Variable (IV) struct which can be used for
** any vars that do not need to passed out of the driver as job
** properties.  You can extend this but obey the WARNING below.
**
** WARNING   WARNING    WARNING    WARNING    WARNING
**
** Make sure the size of IV does NOT get greater than DUMMYSRC or
** the alignment will be off for older drivers.
*/
typedef struct _IV
{
  PSOURCE pSourcePaper;
} IV, *PIV;

typedef union _U
{
  DUMMYSRC dummy;
  IV       iv;
} U, *PU;
                             /* defines paper types lying in various trays  */
typedef struct _EFFECTS
{
  SHORT fIsFliptb;           /* whether to flip top to bottom               */
  SHORT fIsDrawInverted;     /* whether to draw source image bit inverted   */
  SHORT fIsFliplr;           /* whether to draw flipped left to right       */
  SHORT iJobTimeout;         /* The value of job timeout in seconds         */
  SHORT iWaitTimeout;        /* The value of wait timeout in seconds        */
} EFFECTS;
                             /* structure for output printing effects       */
typedef struct _JOBPROP
{
  CHAR szFormName[MAX_PSIZE];/* form name on which job is tobe printed      */
  /*
  **  form size i.e. letter,A4 ,on which job is tobe printed
  */
  CHAR szFormSize[MAX_PSIZE];
  SHORT iOutPlace;           /* paper placement in output bin               */
  SHORT iOrient;             /* orientation : Portrait or Landscape         */
  SHORT fIsColorDevice;      /* whether colour support required or not      */
  /*
  **  The enlargement value in terms of percentage
  */
  SHORT uScale;
  SHORT iManualfeed;         /* default manual feed true=1,false=0,none=-1  */
} JOBPROP;
                             /* structure for job properties                */
typedef struct _CNFDATA
{
/*HMODULE hmod;              +* Dummy since HMODULE is 4 bytes in 32bit     */
  SHORT   oldhmod;           /* Pscript.drv module handle                   */
  ULONG uHelp;               /* the handle to help resources                */
  USHORT uPrinterPropFlags;  /* Used for Printer properties                 */
#define  MODESWITCH    1     /* Bit 0; Printer mode switch 0=off 1=on       */
  SHORT iCntFiles;           /* count of input files                        */
  /*
  **  this option signify what action to take whether to display dialog
  **  box or not
  */
  SHORT uSaveOptions;
  /*
  **  version no maintined to support compatibility with different
  **  versions of driver
  */
  LONG lVersion;
  LONG lGetPtr;              /* to indicate current offset in input file    */
  CHAR szPrtName[MAX_FNAMESIZE]; /* Used to be szKeyApp                     */
  CHAR szSegName[MAX_FNAMESIZE]; /* info segment name                       */

  /*
  **  name of the paper selected for various trays
  */
  /* @V3.0LMMOORE
  ** Create a union of dummy structure and a IV. The IV contains a pointer
  ** to SOURCE.
  */
  U u;

  CHAR szFontName[MAX_FNAMESIZE];/* name of the font selected               */
  /*
  **  a structure to contain various print effect parameters
  */
  EFFECTS effOutput;
  /*
  **  Job properties set under job property dialog box
  */
  JOBPROP jobProperties;
  SHORT iCntCopies;          /* no of output copies to be produced          */
  /*
  **  type of destination : 0-System(LPT1 or COM1),1-Raw mode file,
  *                         2-Encapsulated postscript file
  */
  SHORT iDestnType;
  CHAR szDestnFile[MAX_FNAMESIZE];/* Name of output file                    */

  /*
  ** Do not change the rel position of above structure it will mess up old
  ** drivers on the network.  Make any changes to the end
  --
  **  variable to get allppd resource segment, it replaces the old
  **  selReousrce variable on 1.2
  */
  PVOID pvResource;

  /*
  **  DCR 1462 JOB PROP DUPLEX MODE
  */
  SHORT sDuplexMode;         /* Job prop duplex mode                        */

  /*
  **  DCR 1399 NAME OF APP IN INI FILE WHERE SPECIFIC PRINTER DETAILS
  **  ARE KEPT
  */
  /*
  **  Name of App in ini file where specific printer details are kept
  */
  CHAR szKeyApp[MAX_KEYAPPSIZE];

  /*
  **            Contains currently selected printer resolution.
  */
  SHORT uResolution;

  /*           
  ** The amount of user downloaded fonts
  */
  LONG lFontCount;

  HMODULE hmod;               /* Pscript.drv module handle */

  SHORT sUseDLFonts;          /*            */

  USHORT usPSLevel1;          /* D746091 - support level 1 compatibility */
/*DRIVERSION      0X00020011L ends here */

  /*
  ** @3.0GAMMA1
  ** This stores the gamma correction value.  Since the gamma value is in the
  ** order of 0.1 to 9.0 in increments of 0.1, store the value multiplied by
  ** 10, so that the value is stored as an integer and not as a floating point
  ** value.  The gamma function divides this value by 10 to get the real value.
  ** When defining NO_GAMMA, take the above into consideration.  Currently,
  ** a value if 1 means not gamma should be applied.
  */
  LONG lGammaValue;      // Range -> (1 to 90) for gamma values (0.1 to 9.0)
  #define NO_GAMMA       10           // 'Normal' (or no) gamma value
  #define MIN_GAMMA       1
  #define MAX_GAMMA      50
  #define RED_OFFSET      0
  #define GREEN_OFFSET  256
  #define BLUE_OFFSET   512

} CNFDATA, *PCNFDATA;

/*
**  structure for Device Driver data
*/

typedef struct _LDRIVDATA
{                            /* driv                                        */
  LONG cb;
  LONG lVersion;
  CHAR szDeviceName[32];
  CNFDATA cnfData;
} LDRIVDATA, *PLDRIVDATA;

/*           
** RESLIST is a structure that points to a variable array of RESTYPE
** structures.
** uNumOfRes - Number of RESTYPE structures in pResType.
** uResOffset - This contains a zero-based offset where the resolution
** information is kept in a variable-length buffer.  The information
** for the resolution is kept the following way (in order):
** 2-byte resolution value, in dots-per-inch
** ------------------------------------------
** 1-byte length of the following string:
** ------------------------------------------
** string length, this string does not always
** have a terminating NULL character
**
** PRESLIST - Pointer to a RESLIST structure.
*/
/*
** @V3.0115171
** Add a flag to indicate if this resolution is used as part of the JCL
** format.  If TRUE, the resoluion is part of JCL.  False otherwise.
*/
typedef struct _RESLIST
{
    SHORT uNumOfRes;
    SHORT uResOffset;
    BOOL  bIsJCLResolution;             // @V3.0115171
} RESLIST;
typedef RESLIST *PRESLIST;

typedef struct _PPD1
{
  SHORT iSizeBuffer;         /* size buffer where params are stored         */
  SHORT ofsPswrd;            /* offset pointer to password                  */
  SHORT iPpm;                /* No of pages printed/minute                  */
  LONG lFreeVM;              /* amount of free virtual memory               */
  SHORT ofsPrType;           /* offset pointer to printer type              */
  SHORT ofsPrName;           /* offset pointer to printer name              */
  SHORT iResDpi;             /* Resolution in dots per inch                 */

  /*
  **  Structure containing the available PostScript resolutions.
  */
  RESLIST ResList;

  /*
  **  Screen frequencly in cells per inch multiplied by 100
  */
  LONG lScrFreq;
  SHORT fIsColorDevice;       /* whether device supports colour or not       */
  /*
  **  whether device supports independent file system or not
  */
  SHORT fIsFileSystem;
  SHORT ofsReset;            /* offset to printer reset command string      */
  SHORT ofsExitserver;       /* offset to exitserver command string         */
  LONG iScreenAngle;         /* Halftone Screen angle                       */

  /*
  **           
  ** Added this field to the structure.  This field is an
  ** offset that allows the driver to identify what PostScript
  ** level the current device supports.
  */
  USHORT usLanguageLevel;    /* Contains language level                     */
  SHORT ofsTransferNor;      /* offset to Normalised transfer function      */
  /*
  **  offset to Normalised Inverse transfer function
  */
  SHORT ofsTransferInv;
  /*
  **  @1462 offset to PS mode emul. init. string
  */
  SHORT ofsInitString;       /* offset to PS mode emul. init. string        */

  /*
  ** @V3.0115171
  ** This offset points to the JCL to PS interpreter string.
  */
  SHORT ofsJCLToPS;

  /*
  **  @1462 offset to PS mode emul. terminate string
  */
  SHORT ofsTermString;       /* offset to PS mode emul. terminate string    */
  SHORT sDefaultDuplex;      /* default duplex mode                         */
  SHORT ofsDuplexFalse;      /* string to turn off duplex/tumble            */
  SHORT ofsDuplexNoTumble;   /* string to turn on duplex                    */
  SHORT ofsDuplexTumble;     /* string to turn on duplex/tumble             */
} PPD1;

typedef struct _PPD2
{
  SHORT ofsDfpgsz;           /* offset pointer to default paper size        */
                             /* - now an index value                        */
  SHORT fIsVariablePaper;    /* true if variable paper supported            */
  SHORT ofsDefimagearea;     /* offset to paper name string                 */
  SHORT ofsDefpaperdim;      /* offset to paper dim string                  */
  SHORT iCmpgpairs;          /* no of paper command pairs                   */
  SHORT ofsLspgCmnds;        /* offset pointer to list of paper commands    */
  SHORT iDmpgpairs;          /* no of paper dimension pairs                 */
  SHORT ofsDimxyPgsz;        /* offset pointer to list of xy dimensions     */
  SHORT iImgpgpairs;         /* no of paper imageable coordinate pairs      */
  /*
  **  offset pointer to list of Imageable page and coordinates pairs
  */
  SHORT ofsImgblPgsz;
} PPD2;

typedef struct _PPD3
{
  SHORT iManualfeed;         /* default manual feed true=1,false=0,none=-1  */
  /*
  **  offset pointer to command for manual feed true
  */
  SHORT ofsManualtrue;
  /*
  **  offset pointer to command for manual feed false
  */
  SHORT ofsManualfalse;
  SHORT ofsDefinputslot;     /* offset pointer to default input bin         */
  SHORT iInpbinpairs;        /* no of bin name and command pairs            */
  /*
  **  offset pointer to list of bin names & select commands
  */
  SHORT ofsCmInpbins;
} PPD3;

typedef struct _PPD4
{
  /*
  **  Default output order can be normal or reverse
  */
  SHORT fIsDefoutorder;
  /*
  **  offset pointer to command string for output order normal
  */
  SHORT ofsOrdernormal;
  /*
  **  offset pointer to command string for output order reverse
  */
  SHORT ofsOrderreverse;
  /*
  **  offset pointer to name of default output order
  */
  SHORT ofsDefoutputbin;
  /*
  **  no of bin name and command pairs
  */
  SHORT iOutbinpairs;
  /*
  **  offset pointer to list of bin select commands
  */
  SHORT ofsCmOutbins;
} PPD4;

typedef struct _PPD5
{
  SHORT ofsDeffont;          /* offset pointer to default font name         */
  SHORT iFonts;              /* no of fonts supported                       */
  SHORT ofsFontnames;        /* offset pointer to list of font names        */
} PPD5;

typedef struct _PPD6
{
  USHORT usFormCount;        /* Count of forms                              */
  SHORT  ofsFormTable;       /* Forms Table                                 */
  SHORT  ofsFormIndex;       /* Index Table                                 */
} PPD6;

typedef struct _FORMSTRUCT
{
  PSZ FormName;              /* Pointer to form name                        */
  PBYTE Data;                /* Pointer to data of interest                 */
} FORMSTRUCT, *PFORMSTRUCT;

typedef struct _DESPPD
{
  PPD1 desItems;             /* Individual items defined                    */
  PPD2 desPage;              /* Storage for paper descriptors defined       */
  PPD3 desInpbins;           /* Storage for Input bin descriptors defined   */
  PPD4 desOutbins;           /* Storage for Output bin descriptors defined  */
  PPD5 desFonts;             /* Storage for Font names defined              */
  PPD6 desForms;             /* Form tables                                 */
} DESPPD, *PDESPPD;
/*
**  printer descriptor segments
*/

/*
** Directory entry data structure.  This structure contains
** printer driver names and it is used when searching for
** a given printer.
*/

typedef struct _DRENTRY
{
  CHAR szName[MAX_FNAMESIZE];
  LONG lResNum;
  CHAR free[4];
} DRENTRY, *PDRENTRY;
/*
**  directory table entry structure
*/

/*
**  PPB file Header structure . This structure contains PPB file identifier
**  Table size and no of entries in the PPB file .
*/

typedef struct _SIGNATURE
{
  CHAR szName[MAX_FNAMESIZE];
  SHORT iTblSize;
  SHORT cntEntries;
  CHAR free[4];
} SIGNATURE, *PSIGNATURE;

