/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************** Module Header ******************************\
*
* Module Name: OFM.H
*
* OS/2 Adobe Font Metrics File Binary format.
*
*
* This is a private header file which will be used by OS/2 ATM font driver
* and OS/2 PostScript printer driver for sharing ATM fonts.
*
* For the entries AFM files may not contain, they are initialized by NULL
* including offset pointers.
*
\***************************************************************************/

typedef struct _ATMSTR {   /* atmstr */
   USHORT   len;                             /* Length of string           */
   CHAR     str[1];                          /* Null terminate string      */
} ATMSTR;
typedef  ATMSTR *PATMSTR;

typedef struct _BBOX {  /* bbox */
   LONG     llx;                             /* Lower left x               */
   LONG     lly;                             /* Lower left y               */
   LONG     urx;                             /* Upper right x              */
   LONG     ury;                             /* Upper right y              */
} BBOX;
typedef  BBOX *PBBOX;

typedef struct _CHARWIDTH {   /* cw */
   USHORT   glyph;                           /* Glyph index (PM383)        */
   USHORT   wx;                              /* Character width            */
   SHORT    llx;                             /* Lower left x of char BBox  */
   SHORT    urx;                             /* Upper right x of char BBox */
} CHARWIDTH;
typedef  CHARWIDTH *PCHARWIDTH;

typedef struct _KERNPAIRS {    /* kp */
   USHORT   g1;                              /* First glyph index          */
   USHORT   g2;                              /* Second glyph index         */
   SHORT    KernUnits;                       /* Intercharacter spacing     */
} KERNPAIRS;
typedef  KERNPAIRS *PKERNPAIRS;

typedef struct _OFMMETRICS {  /* ofm */
   ULONG    Identity;                        /* Must be 1                  */
   ULONG    Size;                            /* Size of this OFM file      */
   ULONG    FontType;                        /* Font type (see below)      */
   LONG     MetricsSets;                     /* Writing Direction          */
   PATMSTR  FontName;                        /* Name of font program       */
   PATMSTR  FullName;                        /* Full text name of font     */
   PATMSTR  FamilyName;                      /* Font family name           */
   PATMSTR  Weight;                          /* Weight of font             */
   LONG     WeightClass;                     /* Weight value of font       */
   BBOX     FontBBox;                        /* Font bounding box          */
   PATMSTR  Version;                         /* Font program version       */
   PATMSTR  Notice;                          /* Trade mark or copyright    */
   PATMSTR  EncodingScheme;                  /* Default encoding vector    */
   LONG     MappingScheme;                   /* Mappint scheme             */
   LONG     EscChar;                         /* Escape character           */
   PATMSTR  CharacterSet;                    /* Character set description  */
   LONG     IsBaseFont;                      /* True if basefont           */
   POINTL   VVector;                         /* VVector                    */
   LONG     IsFixedV;                        /* Fixed VVector              */
   LONG     CapHeight;                       /* Top of capital H           */
   LONG     XHeight;                         /* Top of lower case x        */
   LONG     Ascender;                        /* Top of lower case d        */
   LONG     Descender;                       /* bottom of lower case p     */
   LONG     UnderlinePosition;               /* Underline distance         */
   LONG     UnderlineThickness;              /* Underline thickness        */
   FIXED    ItalicAngle;                     /* Italic angle               */
   POINTL   CharWidth;                       /* X,Y for width vector       */
   LONG     IsFixedPitch;                    /* True if fixedpitch font    */
   ULONG    Registry;                        /* IBM registration number    */
   ULONG    FontClass;                       /* IBM font classification    */
   ULONG    CapEmWidth;                      /* Width of an uppercase M    */
   LONG     CharacterCount;                  /* The number of characters   */
   PCHARWIDTH CharWidthsOffset;              /* Character width table offset */
   LONG     KerningPairsCount;               /* The number of pairs        */
   PKERNPAIRS KerningPairsOffset;            /* Kerning pairs offset       */
   PATMSTR  PFBfilename;                     /* PFB filename w/o file ext. */
   ULONG    Reserved[2];                     /* Reserved                   */
} OFMMETRICS;
typedef  OFMMETRICS *POFMMETRICS;

#define     OFM_TYPE_TYPE1          0x00000001
#define     OFM_TYPE_TYPE3          0x00000002
#define     OFM_TYPE_COMPOSITE      0x00000004
#define     OFM_TYPE_MULTIMASTER    0x00000008
#define     OFM_TYPE_FIXEDPITCH     0x00000010
#define     OFM_TYPE_TYPE1_ALIAS    0x00000020

#define ADDRFROMOFFSET(pofm, off)   (PVOID)((PBYTE)pofm + (ULONG)off)
#define STRINGFROMOFFSET(pofm, off) ((PATMSTR)((PBYTE)pofm + (ULONG)off))->str

/*-
The mapping rule from OFMMETRICS to IFIMETRICS

IFIMETRICS                           OFMMETRICS
-------------------------------      ------------------------------------

szFamilyname[FACESIZE]           <-  FamilyName[MAXSTRING]
szFacename[FACESIZE]             <-  FontName[MAXSTRING]
szGlyphlistName[GLYPHNAMESIZE]   <-  'PM383' if Roman font set
idRegistry                       <-  Registry
lCapEmHeight                     <-  CapHeight
lXHeight                         <-  XHeight
lMaxAscender                     <-  FontBBox.ury
lMaxDescender                    <-  - FontBBox.lly
lLowerCaseAscent                 <-  Ascender
lLowerCaseDescent                <-  Descender
lInternalLeading                 <-  FontBBox.ury - Ascender
lExternalLeading                 <-  0
lAveCharWidth                    <-  Average of CharWidths
lMaxCharInc                      <-  Maximum of CharWidths
lEmInc                           <-  CapEmWidth
lMaxBaselineExt                  <-  FontBBox.ury - FontBBox.lly
fxCharSlope                      <-  - ItalicAngle
fxInlineDir                      <-  0
fxCharRot                        <-  0 (May vary for writing direction)
usWeightClass                    <-  WeightClass
usWidthClass                     <-  5 (Only for non multiple master font)
lEmSquareSizeX                   <-  1000
lEmSquareSizeY                   <-  1000
giFirstChar                      <-  (1 : default)
giLastChar                       <-  (383 : default)
giDefaultChar                    <-  (32 : default)
giBreakChar                      <-  (32 : default)
usNominalPointSize               <-  120
usMinimumPointSize               <-  1
usMaximumPointSize               <-  10000
fsType                           <-  IsFixedPitch ? IFIMETRICS_FIXED : 0
                                     KerningPairsCount > 0 ? IFIMETRICS_KERNING : 0
                                     (May vary for DBCS/MBCS composite font)
fsDefn                           <-  IFIMETRICS_OUTLINE
fsSelection                      <-  ItalicAngle ? FATTR_SEL_ITALIC : 0
fsCapabilities                   <-  0
lSubscriptXSize                  <-  650
lSubscriptYSize                  <-  600
lSubscriptXOffset                <-  0
lSubscriptYOffset                <-  lSuperscriptYSize / 2
lSuperscriptXSize                <-  650
lSuperscriptYSize                <-  600
lSuperscriptXOffset              <-  0
lSuperscriptYOffset              <-  CapHeight * 4 / 10
lUnderscoreSize                  <-  UnderlineThickness
lUnderscorePosition              <-  UnderlinePosition
lStrikeoutSize                   <-  UnderlineThickness
lStrikeoutPosition               <-  Ascender / 2
cKerningPairs                    <-  kerningPairsCount
ulFontClass                      <-  FontClass


The mapping rule from OFMMETRICS to FOCAMETRICS

FOCAMETRICS                          OFMMETRICS
-------------------------------      ------------------------------------

ulIdentity                       <-
ulSize                           <-  sizeof(FOCAMETRICS)
szFamilyname[32]                 <-  FamilyName[MAXSTRING]
szFacename[32]                   <-  FontName[MAXSTRING]
usRegistryId                     <-  Registry
usCodePage                       <-  0 (UGL_FONT ?)
yEmHeight                        <-  yDeviceRes
yXHeight                         <-  XHeight
yMaxAscender                     <-  FontBBox.ury
yMaxDescender                    <-  - FontBBox.lly
yLowerCaseAscent                 <-  Ascender
yLowerCaseDescent                <-  Descender
yInternalLeading                 <-  FontBBox.ury - Ascender
yExternalLeading                 <-  0
xAveCharWidth                    <-  Average of CharWidths
xMaxCharInc                      <-  Maximum of CharWidths
xEmInc                           <-  xDeviceRes
yMaxBaselineExt                  <-  FontBBox.ury - FontBBox.lly
sCharSlope                       <-  - ItalicAngle
sInlineDir                       <-  0
sCharRot                         <-  0 (May vary for writing direction)
usWeightClass                    <-  WeightClass
usWidthClass                     <-  5 (Only for non multiple master font)
xDeviceRes                       <-  1000
yDeviceRes                       <-  1000
usFirstChar                      <-  (1 : default)
usLastChar                       <-  (382 : default) - usFirstChar
usDefaultChar                    <-  (31 : default) - usFirstChar
usBreakChar                      <-  (31 : default) - usFirstChar
usNominalPointSize               <-  120
usMinimumPointSize               <-  1
usMaximumPointSize               <-  10000
fsTypeFlags                      <-  IsFixedPitch ? IFIMETRICS_FIXED : 0
                                     KerningPairsCount > 0 ? IFIMETRICS_KERNING : 0
                                     (May vary for DBCS/MBCS composite font)
fsDefn                           <-  IFIMETRICS_OUTLINE
fsSelectionFlags                 <-  ItalicAngle ? FATTR_SEL_ITALIC : 0
fsCapabilities                   <-  0
ySubscriptXSize                  <-  650
ySubscriptYSize                  <-  600
ySubscriptXOffset                <-  0
ySubscriptYOffset                <-  lSuperscriptYSize / 2
ySuperscriptXSize                <-  650
ySuperscriptYSize                <-  600
ySuperscriptXOffset              <-  0
ySuperscriptYOffset              <-  CapHeight * 4 / 10
yUnderscoreSize                  <-  UnderlineThickness
yUnderscorePosition              <-  UnderlinePosition
yStrikeoutSize                   <-  UnderlineThickness
yStrikeoutPosition               <-  Ascender / 2
usKerningPairs                   <-  kerningPairsCount
sFamilyClass                     <-  FontClass
pszDeviceNameOffset              <-


The following adjustment is necessary for the FOCAMETRICS structure.

(1) Set MaxBaselineExt = MaxAscender + MaxDescender (allowing for baseline)

(ex.)
 yMaxBaselineExt = (yMaxAscender > 0 ? yMaxAscender : 0)
                   + (yMaxDescender > 0 ? yMaxDescender : 0);

(2) Set the InternalLeading to help         applications

(ex.)
 yInternalLeading = yMaxBaselineExt - yEmHeight;

(3) Make sure applications don't get fooled by tiny point sizes
    (Note a value of 10 is 1 point = 1/72 of an inch).

(ex.)
 if (sMinimumPointSize < 10)  sMinimumPointSize = 10;

-*/
