/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = MAPPING.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE        : 12/15/88
 *
 * DESCRIPTION : Mapping between Adobe character names, winthorn
 *               multi-codepage support code point values, and Adobe
 *               numeric values. Note that many different code points
 *               may map to the same Adobe character name.
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#ifndef NULL
#define NULL           0
#endif



/*
** Character code mapping table for use with fonts that have the
** Adobe standard encoding.  These fonts will provide Winthorn
** multi-codepage support.
**
**                       IBM Code      Code to output to Postscript
**                       page 850      printer in a show command. If
**                       word that     zero, then a font remap is needed
**                       this char     in order to show this character.
**                       represents    After font remap, output the char
**                         1-316       code used by the caller.
**                           |            |
**                           |            |
*/

#if AFM2BIN
CharData charmapAdobeStandard[] = {
      "space",             0 ,         32 ,
      "space",             1 ,         32 ,
      "space",             2 ,         32 ,
      "space",             3 ,         32 ,
      "space",             4 ,         32 ,
      "space",             5 ,         32 ,
      "space",             6 ,         32 ,
      "bullet",            7 ,         183,
      "space",             8 ,         32 ,
      "space",             9 ,         32 ,
      "space",            10 ,         32 ,
      "space",            11 ,         32 ,
      "space",            12 ,         32 ,
      "space",            13 ,         32 ,
      "space",            14 ,         32 ,
      "space",            15 ,         32 ,
      "space",            16 ,         32 ,
      "space",            17 ,         32 ,
      "space",            18 ,         32 ,
      "space",            19 ,         32 ,
      "paragraph",        20 ,         182,
      "section",          21 ,         167,
      "space",            22 ,         32 ,
      "space",            23 ,         32 ,
      "space",            24 ,         32 ,
      "space",            25 ,         32 ,
      "space",            26 ,         32 ,
      "space",            27 ,         32 ,
      "space",            28 ,         32 ,
      "space",            29 ,         32 ,
      "space",            30 ,         32 ,
      "space",            31 ,         32 ,
      "space",            32 ,         32 ,
      "exclam",           33 ,         33 ,
      "quotedbl",         34 ,         34 ,
      "numbersign",       35 ,         35 ,
      "dollar",           36 ,         36 ,
      "percent",          37 ,         37 ,
      "ampersand",        38 ,         38 ,
      "quotesingle",      39 ,         169,
      "parenleft",        40 ,         40 ,
      "parenright",       41 ,         41 ,
      "asterisk",         42 ,         42 ,
      "plus",             43 ,         43 ,
      "comma",            44 ,         44 ,
      "hyphen",           45 ,         45 ,
      "period",           46 ,         46 ,
      "slash",            47 ,         47 ,
      "zero",             48 ,         48 ,
      "one",              49 ,         49 ,
      "two",              50 ,         50 ,
      "three",            51 ,         51 ,
      "four",             52 ,         52 ,
      "five",             53 ,         53 ,
      "six",              54 ,         54 ,
      "seven",            55 ,         55 ,
      "eight",            56 ,         56 ,
      "nine",             57 ,         57 ,
      "colon",            58 ,         58 ,
      "semicolon",        59 ,         59 ,
      "less",             60 ,         60 ,
      "equal",            61 ,         61 ,
      "greater",          62 ,         62 ,
      "question",         63 ,         63 ,
      "at",               64 ,         64 ,
      "A",                65 ,         65 ,
      "B",                66 ,         66 ,
      "C",                67 ,         67 ,
      "D",                68 ,         68 ,
      "E",                69 ,         69 ,
      "F",                70 ,         70 ,
      "G",                71 ,         71 ,
      "H",                72 ,         72 ,
      "I",                73 ,         73 ,
      "J",                74 ,         74 ,
      "K",                75 ,         75 ,
      "L",                76 ,         76 ,
      "M",                77 ,         77 ,
      "N",                78 ,         78 ,
      "O",                79 ,         79 ,
      "P",                80 ,         80 ,
      "Q",                81 ,         81 ,
      "R",                82 ,         82 ,
      "S",                83 ,         83 ,
      "T",                84 ,         84 ,
      "U",                85 ,         85 ,
      "V",                86 ,         86 ,
      "W",                87 ,         87 ,
      "X",                88 ,         88 ,
      "Y",                89 ,         89 ,
      "Z",                90 ,         90 ,
      "bracketleft",      91 ,         91 ,
      "backslash",        92 ,         92 ,
      "bracketright",     93 ,         93 ,
      "circumflex",       94 ,         195,
      "underscore",       95 ,         95 ,
      "grave",            96 ,         193,
      "a",                97 ,         97 ,
      "b",                98 ,         98 ,
      "c",                99 ,         99 ,
      "d",                100,         100,
      "e",                101,         101,
      "f",                102,         102,
      "g",                103,         103,
      "h",                104,         104,
      "i",                105,         105,
      "j",                106,         106,
      "k",                107,         107,
      "l",                108,         108,
      "m",                109,         109,
      "n",                110,         110,
      "o",                111,         111,
      "p",                112,         112,
      "q",                113,         113,
      "r",                114,         114,
      "s",                115,         115,
      "t",                116,         116,
      "u",                117,         117,
      "v",                118,         118,
      "w",                119,         119,
      "x",                120,         120,
      "y",                121,         121,
      "z",                122,         122,
      "braceleft",        123,         123,
      "bar",              124,         124,
      "braceright",       125,         125,
      "tilde",            126,         196,
      "space",            127,         32 ,
      "Ccedilla",         128,         000,
      "udieresis",        129,         000,
      "eacute",           130,         000,
      "acircumflex",      131,         000,
      "adieresis",        132,         000,
      "agrave",           133,         000,
      "aring",            134,         000,
      "ccedilla",         135,         000,
      "ecircumflex",      136,         000,
      "edieresis",        137,         000,
      "egrave",           138,         000,
      "idieresis",        139,         000,
      "icircumflex",      140,         000,
      "igrave",           141,         000,
      "Adieresis",        142,         000,
      "Aring",            143,         000,
      "Eacute",           144,         000,
      "ae",               145,         241,
      "AE",               146,         225,
      "ocircumflex",      147,         000,
      "odieresis",        148,         000,
      "ograve",           149,         000,
      "ucircumflex",      150,         000,
      "ugrave",           151,         000,
      "ydieresis",        152,         000,
      "Odieresis",        153,         000,
      "Udieresis",        154,         000,
      "oslash",           155,         249,
      "sterling",         156,         163,
      "Oslash",           157,         233,
      "multiply",         158,         0  ,
      "florin",           159,         166,
      "aacute",           160,         000,
      "iacute",           161,         000,
      "oacute",           162,         000,
      "uacute",           163,         000,
      "ntilde",           164,         000,
      "Ntilde",           165,         000,
      "ordfeminine",      166,         227,
      "ordmasculine",     167,         235,
      "questiondown",     168,         191,
      "registered",       169,         0  ,
      "logicalnot",       170,         0  ,
      "onehalf",          171,         0  ,
      "onequarter",       172,         0  ,
      "exclamdown",       173,         161,
      "guillemotleft",    174,         171,
      "guillemotright",   175,         187,
      "space",            176,         32 ,
      "space",            177,         32 ,
      "space",            178,         32 ,
      "space",            179,         32 ,
      "space",            180,         32 ,
      "Aacute",           181,         000,
      "Acircumflex",      182,         000,
      "Agrave",           183,         000,
      "copyright",        184,         00 ,
      "space",            185,         32 ,
      "space",            186,         32 ,
      "space",            187,         32 ,
      "space",            188,         32 ,
      "cent",             189,         162,
      "yen",              190,         165,
      "space",            191,         32 ,
      "space",            192,         32 ,
      "space",            193,         32 ,
      "space",            194,         32 ,
      "space",            195,         32 ,
      "space",            196,         32 ,
      "space",            197,         32 ,
      "atilde",           198,         000,
      "Atilde",           199,         000,
      "space",            200,         32 ,
      "space",            201,         32 ,
      "space",            202,         32 ,
      "space",            203,         32 ,
      "space",            204,         32 ,
      "space",            205,         32 ,
      "space",            206,         32 ,
      "currency",         207,         168,
      "eth",              208,         00 ,
      "Eth",              209,         00 ,
      "Ecircumflex",      210,         000,
      "Edieresis",        211,         000,
      "Egrave",           212,         000,
      "dotlessi",         213,         245,
      "Iacute",           214,         000,
      "Icircumflex",      215,         000,
      "Idieresis",        216,         000,
      "space",            217,         32 ,
      "space",            218,         32 ,
      "space",            219,         32 ,
      "space",            220,         32 ,
      "brokenbar",        221,         00 ,
      "Igrave",           222,         000,
      "space",            223,         32 ,
      "Oacute",           224,         000,
      "germandbls",       225,         251,
      "Ocircumflex",      226,         000,
      "Ograve",           227,         000,
      "otilde",           228,         000,
      "Otilde",           229,         000,
      "mu",               230,         000,
      "thorn",            231,         000,
      "Thorn",            232,         000,
      "Uacute",           233,         000,
      "Ucircumflex",      234,         000,
      "Ugrave",           235,         000,
      "yacute",           236,         000,
      "Yacute",           237,         000,
      "macron",           238,         197,
      "acute",            239,         194,
      "hyphen",           240,         45 ,
      "plusminus",        241,         00 ,
      "space",            242,         32 ,
      "threequarters",    243,         00 ,
      "paragraph",        244,         182,
      "section",          245,         167,
      "divide",           246,         00 ,
      "cedilla",          247,         203,
      "ring",             248,         202,
      "dieresis",         249,         200,
      "periodcentered",   250,         180,
      "onesuperior",      251,         00 ,
      "threesuperior",    252,         00 ,
      "twosuperior",      253,         00 ,
      "space",            254,         32 ,
      "space",            255,         00 ,
      "space",            256,         32 ,
      "space",            257,         32 ,
      "space",            258,         32 ,
      "space",            259,         32 ,
      "space",            260,         32 ,
      "space",            261,         32 ,
      "space",            262,         32 ,
      "space",            263,         32 ,
      "space",            264,         32 ,
      "space",            265,         32 ,
      "space",            266,         32 ,
      "space",            267,         32 ,
      "space",            268,         32 ,
      "space",            269,         32 ,
      "space",            270,         32 ,
      "space",            271,         32 ,
      "space",            272,         32 ,
      "space",            273,         32 ,
      "space",            274,         32 ,
      "space",            275,         32 ,
      "space",            276,         32 ,
      "space",            277,         32 ,
      "space",            278,         32 ,
      "space",            279,         32 ,
      "space",            280,         32 ,
      "space",            281,         32 ,
      "space",            282,         32 ,
      "space",            283,         32 ,
      "space",            284,         32 ,
      "space",            285,         32 ,
      "space",            286,         32 ,
      "space",            287,         32 ,
      "space",            288,         32 ,
      "space",            289,         32 ,
      "space",            290,         32 ,
      "space",            291,         32 ,
      "space",            292,         32 ,
      "space",            293,         32 ,
      "space",            294,         32 ,
      "space",            295,         32 ,
      "space",            296,         32 ,
      "space",            297,         32 ,
      "bullet",           298,         183,
      "space",            299,         32 ,
      "space",            300,         32 ,
      "macron",           301,         197,
      "breve",            302,         198,
      "dotaccent",        303,         199,
      "ring",             304,         202,
      "hungarumlaut",     305,         205,
      "ogonek",           306,         206,
      "caron",            307,         207,
      "quoteleft",        308,         96 ,
      "quoteright",       309,         39 ,
      "quotedblleft",     310,         170,
      "quotedblright",    311,         186,
      "endash",           312,         177,
      "emdash",           313,         208,
      "asciicircum",      314,         94 ,
      "asciitilde",       315,         126,
      "quotesinglbase",   316,         000,
      "quotedblbase",     317,         000,
      "ellipsis",         318,         000,
      "dagger",           319,         000,
      "daggerdbl",        320,         000,
      "circumflex",       321,         000,
      "perthousand",      322,         000,
      "Scaron",           323,         000,
      "guilsinglleft",    324,         000,
      "OE",               325,         000,
      "tilde",            326,         000,
      "trademark",        327,         000,
      "scaron",           328,         000,
      "guilsinglright",   329,         000,
      "oe",               330,         000,
      "Ydierisis",        331,         000,
      NULL,               000,         000
} ;


/*
** Character code mapping table for use with fonts that have the
** Adobe font-specific encoding.  These fonts will not provide
** Winthorn multi-codepage support.
**
**                                     Code to output to Postscript
**                       Code point    printer in a show command. With
**                       application   font-specific encoding, this code
**                       provides to   is always the same as the code
**                       engine        point provided by the app, since
**                         1-255       the engine provides no remapping.
**                           |            |
**                           |            |
*/
CharData charmapFontSpecific[] = {
      "space",            32 ,         32 ,
      "exclam",           33 ,         33 ,
      "universal",        34 ,         34 ,
      "numbersign",       35 ,         35 ,
      "existential",      36 ,         36 ,
      "percent",          37 ,         37 ,
      "ampersand",        38 ,         38 ,
      "suchthat",         39 ,         39 ,
      "parenleft",        40 ,         40 ,
      "parenright",       41 ,         41 ,
      "asteriskmath",     42 ,         42 ,
      "plus",             43 ,         43 ,
      "comma",            44 ,         44 ,
      "minus",            45 ,         45 ,
      "period",           46 ,         46 ,
      "slash",            47 ,         47 ,
      "zero",             48 ,         48 ,
      "one",              49 ,         49 ,
      "two",              50 ,         50 ,
      "three",            51 ,         51 ,
      "four",             52 ,         52 ,
      "five",             53 ,         53 ,
      "six",              54 ,         54 ,
      "seven",            55 ,         55 ,
      "eight",            56 ,         56 ,
      "nine",             57 ,         57 ,
      "colon",            58 ,         58 ,
      "semicolon",        59 ,         59 ,
      "less",             60 ,         60 ,
      "equal",            61 ,         61 ,
      "greater",          62 ,         62 ,
      "question",         63 ,         63 ,
      "congruent",        64 ,         64 ,
      "Alpha",            65 ,         65 ,
      "Beta",             66 ,         66 ,
      "Chi",              67 ,         67 ,
      "Delta",            68 ,         68 ,
      "Epsilon",          69 ,         69 ,
      "Phi",              70 ,         70 ,
      "Gamma",            71 ,         71 ,
      "Eta",              72 ,         72 ,
      "Iota",             73 ,         73 ,
      "theta1",           74 ,         74 ,
      "Kappa",            75 ,         75 ,
      "Lambda",           76 ,         76 ,
      "Mu",               77 ,         77 ,
      "Nu",               78 ,         78 ,
      "Omicron",          79 ,         79 ,
      "Pi",               80 ,         80 ,
      "Theta",            81 ,         81 ,
      "Rho",              82 ,         82 ,
      "Sigma",            83 ,         83 ,
      "Tau",              84 ,         84 ,
      "Upsilon",          85 ,         85 ,
      "sigma1",           86 ,         86 ,
      "Omega",            87 ,         87 ,
      "Xi",               88 ,         88 ,
      "Psi",              89 ,         89 ,
      "Zeta",             90 ,         90 ,
      "bracketleft",      91 ,         91 ,
      "therefore",        92 ,         92 ,
      "bracketright",     93 ,         93 ,
      "perpendicular",    94 ,         94 ,
      "underscore",       95 ,         95 ,
      "radicalex",        96 ,         96 ,
      "alpha",            97 ,         97 ,
      "beta",             98 ,         98 ,
      "chi",              99 ,         99 ,
      "delta",           100,          100,
      "epsilon",         101,          101,
      "phi",             102,          102,
      "gamma",           103,          103,
      "eta",             104,          104,
      "iota",            105,          105,
      "phi1",            106,          106,
      "kappa",           107,          107,
      "lambda",          108,          108,
      "mu",              109,          109,
      "nu",              110,          110,
      "omicron",         111,          111,
      "pi",              112,          112,
      "theta",           113,          113,
      "rho",             114,          114,
      "sigma",           115,          115,
      "tau",             116,          116,
      "upsilon",         117,          117,
      "omega1",          118,          118,
      "omega",           119,          119,
      "xi",              120,          120,
      "psi",             121,          121,
      "zeta",            122,          122,
      "braceleft",       123,          123,
      "bar",             124,          124,
      "braceright",      125,          125,
      "similar",         126,          126,
      "Upsilon1",        161,          161,
      "minute",          162,          162,
      "lessequal",       163,          163,
      "fraction",        164,          164,
      "infinity",        165,          165,
      "florin",          166,          166,
      "club",            167,          167,
      "diamond",         168,          168,
      "heart",           169,          169,
      "spade",           170,          170,
      "arrowboth",       171,          171,
      "arrowleft",       172,          172,
      "arrowup",         173,          173,
      "arrowright",      174,          174,
      "arrowdown",       175,          175,
      "degree",          176,          176,
      "plusminus",       177,          177,
      "second",          178,          178,
      "greaterequal",    179,          179,
      "multiply",        180,          180,
      "proportional",    181,          181,
      "partialdiff",     182,          182,
      "bullet",          183,          183,
      "divide",          184,          184,
      "notequal",        185,          185,
      "equivalence",     186,          186,
      "approxequal",     187,          187,
      "ellipsis",        188,          188,
      "arrowvertex",     189,          189,
      "arrowhorizex",    190,          190,
      "carriagereturn",  191,          191,
      "aleph",           192,          192,
      "Ifraktur",        193,          193,
      "Rfraktur",        194,          194,
      "weierstrass",     195,          195,
      "circlemultiply",  196,          196,
      "circleplus",      197,          197,
      "emptyset",        198,          198,
      "intersection",    199,          199,
      "union",           200,          200,
      "propersuperset",  201,          201,
      "reflexsuperset",  202,          202,
      "notsubset",       203,          203,
      "propersubset",    204,          204,
      "reflexsubset",    205,          205,
      "element",         206,          206,
      "notelement",      207,          207,
      "angle",           208,          208,
      "gradient",        209,          209,
      "registerserif",   210,          210,
      "copyrightserif",  211,          211,
      "trademarkserif",  212,          212,
      "product",         213,          213,
      "radical",         214,          214,
      "dotmath",         215,          215,
      "logicalnot",      216,          216,
      "logicaland",      217,          217,
      "logicalor",       218,          218,
      "arrowdblboth",    219,          219,
      "arrowdblleft",    220,          220,
      "arrowdblup",      221,          221,
      "arrowdblright",   222,          222,
      "arrowdbldown",    223,          223,
      "lozenge",         224,          224,
      "angleleft",       225,          225,
      "registersans",    226,          226,
      "copyrightsans",   227,          227,
      "trademarksans",   228,          228,
      "summation",       229,          229,
      "parenlefttp",     230,          230,
      "parenleftex",     231,          231,
      "parenleftbt",     232,          232,
      "bracketlefttp",   233,          233,
      "bracketleftex",   234,          234,
      "bracketleftbt",   235,          235,
      "bracelefttp",     236,          236,
      "braceleftmid",    237,          237,
      "braceleftbt",     238,          238,
      "braceex",         239,          239,
      "angleright",      241,          241,
      "integral",        242,          242,
      "integraltp",      243,          243,
      "integralex",      244,          244,
      "integralbt",      245,          245,
      "parenrighttp",    246,          246,
      "parenrightex",    247,          247,
      "parenrightbt",    248,          248,
      "bracketrighttp",  249,          249,
      "bracketrightex",  250,          250,
      "bracketrightbt",  251,          251,
      "bracerighttp",    252,          252,
      "bracerightmid",   253,          253,
      "bracerightbt",    254,          254,
      "apple",           000,          000,
      "a1",               33,          33 ,
      "a2",               34,          34 ,
      "a202",             35,          35 ,
      "a3",               36,          36 ,
      "a4",               37,          37 ,
      "a5",               38,          38 ,
      "a119",             39,          39 ,
      "a118",             40,          40 ,
      "a117",             41,          41 ,
      "a11",              42,          42 ,
      "a12",              43,          43 ,
      "a13",              44,          44 ,
      "a14",              45,          45 ,
      "a15",              46,          46 ,
      "a16",              47,          47 ,
      "a105",             48,          48 ,
      "a17",              49,          49 ,
      "a18",              50,          50 ,
      "a19",              51,          51 ,
      "a20",              52,          52 ,
      "a21",              53,          53 ,
      "a22",              54,          54 ,
      "a23",              55,          55 ,
      "a24",              56,          56 ,
      "a25",              57,          57 ,
      "a26",              58,          58 ,
      "a27",              59,          59 ,
      "a28",              60,          60 ,
      "a6",               61,          61 ,
      "a7",               62,          62 ,
      "a8",               63,          63 ,
      "a9",               64,          64 ,
      "a10",              65,          65 ,
      "a29",              66,          66 ,
      "a30",              67,          67 ,
      "a31",              68,          68 ,
      "a32",              69,          69 ,
      "a33",              70,          70 ,
      "a34",              71,          71 ,
      "a35",              72,          72 ,
      "a36",              73,          73 ,
      "a37",              74,          74 ,
      "a38",              75,          75 ,
      "a39",              76,          76 ,
      "a40",              77,          77 ,
      "a41",              78,          78 ,
      "a42",              79,          79 ,
      "a43",              80,          80 ,
      "a44",              81,          81 ,
      "a45",              82,          82 ,
      "a46",              83,          83 ,
      "a47",              84,          84 ,
      "a48",              85,          85 ,
      "a49",              86,          86 ,
      "a50",              87,          87 ,
      "a51",              88,          88 ,
      "a52",              89,          89 ,
      "a53",              90,          90 ,
      "a54",              91,          91 ,
      "a55",              92,          92 ,
      "a56",              93,          93 ,
      "a57",              94,          94 ,
      "a58",              95,          95 ,
      "a59",              96,          96 ,
      "a60",              97,          97 ,
      "a61",              98,          98 ,
      "a62",              99,          99 ,
      "a63",             100,          100,
      "a64",             101,          101,
      "a65",             102,          102,
      "a66",             103,          103,
      "a67",             104,          104,
      "a68",             105,          105,
      "a69",             106,          106,
      "a70",             107,          107,
      "a71",             108,          108,
      "a72",             109,          109,
      "a73",             110,          110,
      "a74",             111,          111,
      "a203",            112,          112,
      "a75",             113,          113,
      "a204",            114,          114,
      "a76",             115,          115,
      "a77",             116,          116,
      "a78",             117,          117,
      "a79",             118,          118,
      "a81",             119,          119,
      "a82",             120,          120,
      "a83",             121,          121,
      "a84",             122,          122,
      "a97",             123,          123,
      "a98",             124,          124,
      "a99",             125,          125,
      "a100",            126,          126,
      "a101",            161,          161,
      "a102",            162,          162,
      "a103",            163,          163,
      "a104",            164,          164,
      "a106",            165,          165,
      "a107",            166,          166,
      "a108",            167,          167,
      "a112",            168,          168,
      "a111",            169,          169,
      "a110",            170,          170,
      "a109",            171,          171,
      "a120",            172,          172,
      "a121",            173,          173,
      "a122",            174,          174,
      "a123",            175,          175,
      "a124",            176,          176,
      "a125",            177,          177,
      "a126",            178,          178,
      "a127",            179,          179,
      "a128",            180,          180,
      "a129",            181,          181,
      "a130",            182,          182,
      "a131",            183,          183,
      "a132",            184,          184,
      "a133",            185,          185,
      "a134",            186,          186,
      "a135",            187,          187,
      "a136",            188,          188,
      "a137",            189,          189,
      "a138",            190,          190,
      "a139",            191,          191,
      "a140",            192,          192,
      "a141",            193,          193,
      "a142",            194,          194,
      "a143",            195,          195,
      "a144",            196,          196,
      "a145",            197,          197,
      "a146",            198,          198,
      "a147",            199,          199,
      "a148",            200,          200,
      "a149",            201,          201,
      "a150",            202,          202,
      "a151",            203,          203,
      "a152",            204,          204,
      "a153",            205,          205,
      "a154",            206,          206,
      "a155",            207,          207,
      "a156",            208,          208,
      "a157",            209,          209,
      "a158",            210,          210,
      "a159",            211,          211,
      "a160",            212,          212,
      "a161",            213,          213,
      "a163",            214,          214,
      "a164",            215,          215,
      "a196",            216,          216,
      "a165",            217,          217,
      "a192",            218,          218,
      "a166",            219,          219,
      "a167",            220,          220,
      "a168",            221,          221,
      "a169",            222,          222,
      "a170",            223,          223,
      "a171",            224,          224,
      "a172",            225,          225,
      "a173",            226,          226,
      "a162",            227,          227,
      "a174",            228,          228,
      "a175",            229,          229,
      "a176",            230,          230,
      "a177",            231,          231,
      "a178",            232,          232,
      "a179",            233,          233,
      "a193",            234,          234,
      "a180",            235,          235,
      "a199",            236,          236,
      "a181",            237,          237,
      "a200",            238,          238,
      "a182",            239,          239,
      "a201",            241,          241,
      "a183",            242,          242,
      "a184",            243,          243,
      "a197",            244,          244,
      "a185",            245,          245,
      "a194",            246,          246,
      "a198",            247,          247,
      "a186",            248,          248,
      "a195",            249,          249,
      "a187",            250,          250,
      "a188",            251,          251,
      "a189",            252,          252,
      "a190",            253,          253,
      "a191",            254,          254,
      "a205",            000,          000,
      "a206",            000,          000,
      "a85",             000,          000,
      "a86",             000,          000,
      "a87",             000,          000,
      "a88",             000,          000,
      "a89",             000,          000,
      "a90",             000,          000,
      "a91",             000,          000,
      "a92",             000,          000,
      "a93",             000,          000,
      "a94",             000,          000,
      "a95",             000,          000,
      "a96",             000,          000,
      NULL,              000,          000
} ;
#endif

/*****************************************************************************/
/*                                                                           */
/* |Name                  |PM Glyph number                                   */
/* |                      |    |Adobe encoding number                        */
/* |                      |    |  |Defined in Adobe red book appx E.5 Y/N    */
/*                        |    |  |                                          */
 char *PMGlyphName[] = {
  "     ",            /*  0,   0, 0, filler space                            */
  "SS000000",         /*  1,   0, 0, Smiling Face                            */
  "SS010000",         /*  2,   0, 0, Smiling Face, Reverse Image             */
  "heart",            /*  3,   0, 0, SS020000                                */
  "diamond",          /*  4,   0, 0, SS030000                                */
  "club",             /*  5,   0, 0, SS040000                                */
  "spade",            /*  6,   0, 0, SS050000                                */
  "bullet",           /*  7, 183, 1, SM570000                                */
  "SM570001",         /*  8,   0, 0, Bullet, Reverse Image                   */
  "SM750000",         /*  9,   0, 0, Open Circle (like SL08)                 */
  "SM750002",         /* 10,   0, 0, Open Circle, Reverse Image              */
  "male",             /* 11,   0, 0, SM280000                                */
  "female",           /* 12,   0, 0, SM290000                                */
  "musicalnote",      /* 13,   0, 0, SM930000                                */
  "musicalnotedbl",   /* 14,   0, 0, SM910000                                */
  "SM690000",         /* 15,   0, 0, Sun Symbol                              */
  "SM590000",         /* 16,   0, 0, Forward Arrow Indicator                 */
  "SM630000",         /* 17,   0, 0, Back Arrow Indicator                    */
  "SM760000",         /* 18,   0, 0, Up-Down Arrow                           */
  "exclamdbl",        /* 19,   0, 0, SP330000                                */
  "paragraph",        /* 20, 182, 1, SM250000                                */
  "section",          /* 21, 167, 1, SM240000                                */
  "SM700000",         /* 22,   0, 0, Solid Horizontal Rectangle              */
  "SM770000",         /* 23,   0, 0, Up-Down Arrow, Perpendicular            */
  "arrowup",          /* 24,   0, 0, SM320000                                */
  "arrowdown",        /* 25,   0, 0, SM330000                                */
  "arrowright",       /* 26,   0, 0, SM310000                                */
  "arrowleft",        /* 27,   0, 0, SM300000                                */
  "rightangle",       /* 28,   0, 0, SA420000                                */
  "arrowboth",        /* 29,   0, 0, SM780000                                */
  "SM600000",         /* 30,   0, 0, Solid Triangle                          */
  "SV040000",         /* 31,   0, 0, Solid Triangle, Inverted                */
  "space",            /* 32,  32, 1, SP010000                                */
  "exclam",           /* 33,  33, 1, SP020000                                */
  "quotedbl",         /* 34,  34, 1, SP040000                                */
  "numbersign",       /* 35,  35, 1, SM010000                                */
  "dollar",           /* 36,  36, 1, SC030000                                */
  "percent",          /* 37,  37, 1, SM020000                                */
  "ampersand",        /* 38,  38, 1, SM030000                                */
  "quotesingle",      /* 39, 169, 1, SP050000                                */
  "parenleft",        /* 40,  40, 1, SP060000                                */
  "parenright",       /* 41,  41, 1, SP070000                                */
  "asterisk",         /* 42,  42, 1, SM040000                                */
  "plus",             /* 43,  43, 1, SA010000                                */
  "comma",            /* 44,  44, 1, SP080000                                */
  "hyphen",           /* 45,  45, 1, SP100000                                */
  "period",           /* 46,  46, 1, SP110000                                */
  "slash",            /* 47,  47, 1, SP120000                                */
  "zero",             /* 48,  48, 1, ND100000                                */
  "one",              /* 49,  49, 1, ND010000                                */
  "two",              /* 50,  50, 1, ND020000                                */
  "three",            /* 51,  51, 1, ND030000                                */
  "four",             /* 52,  52, 1, ND040000                                */
  "five",             /* 53,  53, 1, ND050000                                */
  "six",              /* 54,  54, 1, ND060000                                */
  "seven",            /* 55,  55, 1, ND070000                                */
  "eight",            /* 56,  56, 1, ND080000                                */
  "nine",             /* 57,  57, 1, ND090000                                */
  "colon",            /* 58,  58, 1, SP130000                                */
  "semicolon",        /* 59,  59, 1, SP140000                                */
  "less",             /* 60,  60, 1, SA030000                                */
  "equal",            /* 61,  61, 1, SA040000                                */
  "greater",          /* 62,  62, 1, SA050000                                */
  "question",         /* 63,  63, 1, SP150000                                */
  "at",               /* 64,  64, 1, SM050000                                */
  "A",                /* 65,  65, 1, LA020000                                */
  "B",                /* 66,  66, 1, LB020000                                */
  "C",                /* 67,  67, 1, LC020000                                */
  "D",                /* 68,  68, 1, LD020000                                */
  "E",                /* 69,  69, 1, LE020000                                */
  "F",                /* 70,  70, 1, LF020000                                */
  "G",                /* 71,  71, 1, LG020000                                */
  "H",                /* 72,  72, 1, LH020000                                */
  "I",                /* 73,  73, 1, LI020000                                */
  "J",                /* 74,  74, 1, LJ020000                                */
  "K",                /* 75,  75, 1, LK020000                                */
  "L",                /* 76,  76, 1, LL020000                                */
  "M",                /* 77,  77, 1, LM020000                                */
  "N",                /* 78,  78, 1, LN020000                                */
  "O",                /* 79,  79, 1, LO020000                                */
  "P",                /* 80,  80, 1, LP020000                                */
  "Q",                /* 81,  81, 1, LQ020000                                */
  "R",                /* 82,  82, 1, LR020000                                */
  "S",                /* 83,  83, 1, LS020000                                */
  "T",                /* 84,  84, 1, LT020000                                */
  "U",                /* 85,  85, 1, LU020000                                */
  "V",                /* 86,  86, 1, LV020000                                */
  "W",                /* 87,  87, 1, LW020000                                */
  "X",                /* 88,  88, 1, LX020000                                */
  "Y",                /* 89,  89, 1, LY020000                                */
  "Z",                /* 90,  90, 1, LZ020000                                */
  "bracketleft",      /* 91,  91, 1, SM060000                                */
  "backslash",        /* 92,  92, 1, SM070000                                */
  "bracketright",     /* 93,  93, 1, SM080000                                */
  "asciicircum",      /* 94,  94, 1, SD150300                                */
  "underscore",       /* 95,  95, 1, SP090000                                */
  "grave",            /* 96, 193, 1, SD130000                                */
  "a",                /* 97,  97, 1, LA010000                                */
  "b",                /* 98,  98, 1, LB010000                                */
  "c",                /* 99,  99, 1, LC010000                                */
  "d",                /*100, 100, 1, LD010000                                */
  "e",                /*101, 101, 1, LE010000                                */
  "f",                /*102, 102, 1, LF010000                                */
  "g",                /*103, 103, 1, LG010000                                */
  "h",                /*104, 104, 1, LH010000                                */
  "i",                /*105, 105, 1, LI010000                                */
  "j",                /*106, 106, 1, LJ010000                                */
  "k",                /*107, 107, 1, LK010000                                */
  "l",                /*108, 108, 1, LL010000                                */
  "m",                /*109, 109, 1, LM010000                                */
  "n",                /*110, 110, 1, LN010000                                */
  "o",                /*111, 111, 1, LO010000                                */
  "p",                /*112, 112, 1, LP010000                                */
  "q",                /*113, 113, 1, LQ010000                                */
  "r",                /*114, 114, 1, LR010000                                */
  "s",                /*115, 115, 1, LS010000                                */
  "t",                /*116, 116, 1, LT010000                                */
  "u",                /*117, 117, 1, LU010000                                */
  "v",                /*118, 118, 1, LV010000                                */
  "w",                /*119, 119, 1, LW010000                                */
  "x",                /*120, 120, 1, LX010000                                */
  "y",                /*121, 121, 1, LY010000                                */
  "z",                /*122, 122, 1, LZ010000                                */
  "braceleft",        /*123, 123, 1, SM110000                                */
  "bar",              /*124, 124, 1, SM130000                                */
  "braceright",       /*125, 125, 1, SM140000                                */
  "asciitilde",       /*126, 126, 1, SD190300                                */
  "SM790000",         /*127,   0, 0, Small House                             */
  "Ccedilla",         /*128,   0, 1, LC420000                                */
  "udieresis",        /*129,   0, 1, LU170000                                */
  "eacute",           /*130,   0, 1, LE110000                                */
  "acircumflex",      /*131,   0, 1, LA150000                                */
  "adieresis",        /*132,   0, 1, LA170000                                */
  "agrave",           /*133,   0, 1, LA130000                                */
  "aring",            /*134,   0, 1, LA270000                                */
  "ccedilla",         /*135,   0, 1, LC410000                                */
  "ecircumflex",      /*136,   0, 1, LE150000                                */
  "edieresis",        /*137,   0, 1, LE170000                                */
  "egrave",           /*138,   0, 1, LE130000                                */
  "idieresis",        /*139,   0, 1, LI170000                                */
  "icircumflex",      /*140,   0, 1, LI150000                                */
  "igrave",           /*141,   0, 1, LI130000                                */
  "Adieresis",        /*142,   0, 1, LA180000                                */
  "Aring",            /*143,   0, 1, LA280000                                */
  "Eacute",           /*144,   0, 1, LE120000                                */
  "ae",               /*145, 241, 1, LA510000                                */
  "AE",               /*146, 225, 1, LA520000                                */
  "ocircumflex",      /*147,   0, 1, LO150000                                */
  "odieresis",        /*148,   0, 1, LO170000                                */
  "ograve",           /*149,   0, 1, LO130000                                */
  "ucircumflex",      /*150,   0, 1, LU150000                                */
  "ugrave",           /*151,   0, 1, LU130000                                */
  "ydieresis",        /*152,   0, 1, LY170000                                */
  "Odieresis",        /*153,   0, 1, LO180000                                */
  "Udieresis",        /*154,   0, 1, LU180000                                */
  "oslash",           /*155, 249, 1, LO610000                                */
  "sterling",         /*156, 163, 1, SC020000                                */
  "Oslash",           /*157, 233, 1, LO620000                                */
  "multiply",         /*158,   0, 1, SA070000                                */
  "florin",           /*159, 166, 1, SC070000                                */
  "aacute",           /*160,   0, 1, LA110000                                */
  "iacute",           /*161,   0, 1, LI110000                                */
  "oacute",           /*162,   0, 1, LO110000                                */
  "uacute",           /*163,   0, 1, LU110000                                */
  "ntilde",           /*164,   0, 1, LN190000                                */
  "Ntilde",           /*165,   0, 1, LN200000                                */
  "ordfeminine",      /*166, 227, 1, SM210000                                */
  "ordmasculine",     /*167, 235, 1, SM200000                                */
  "questiondown",     /*168, 191, 1, SP160000                                */
  "registered",       /*169,   0, 1, SM530000                                */
  "logicalnot",       /*170,   0, 1, SM660000                                */
  "onehalf",          /*171,   0, 1, NF010000                                */
  "onequarter",       /*172,   0, 1, NF040000                                */
  "exclamdown",       /*173, 161, 1, SP030000                                */
  "guillemotleft",    /*174, 171, 1, SP170000                                */
  "guillemotright",   /*175, 187, 1, SP180000                                */
  "SF140000",         /*176,   0, 0, Fill Character, Light                   */
  "SF150000",         /*177,   0, 0, Fill Character, Medium                  */
  "SF160000",         /*178,   0, 0, Fill Character, Heavy                   */
  "SF110000",         /*179,   0, 0, Center Box Bar Vertical                 */
  "SF090000",         /*180,   0, 0, Right Middle Box Side                   */
  "Aacute",           /*181,   0, 1, LA120000                                */
  "Acircumflex",      /*182,   0, 1, LA160000                                */
  "Agrave",           /*183,   0, 1, LA140000                                */
  "copyright",        /*184,   0, 1, SM520000                                */
  "SF230000",         /*185,   0, 0, Right Box Side Double                   */
  "SF240000",         /*186,   0, 0, Centre Box Bar Vertical Double          */
  "SF250000",         /*187,   0, 0, Upper Right Box Corner Double           */
  "SF260000",         /*188,   0, 0, Lower Right Box Corner Double           */
  "cent",             /*189, 162, 1, SC040000                                */
  "yen",              /*190, 165, 1, SC050000                                */
  "SF030000",         /*191,   0, 0, Upper Right Box Corner                  */
  "SF020000",         /*192,   0, 0, Lower Left Box Corner                   */
  "SF070000",         /*193,   0, 0, Middle Box Bottom                       */
  "SF060000",         /*194,   0, 0, Middle Box Top                          */
  "SF080000",         /*195,   0, 0, Left Middle Box Side                    */
  "SF100000",         /*196,   0, 0, Center Box Bar Horizontal               */
  "SF050000",         /*197,   0, 0, Box Intersection                        */
  "atilde",           /*198,   0, 1, LA190000                                */
  "Atilde",           /*199,   0, 1, LA200000                                */
  "SF380000",         /*200,   0, 0, Lower Left Box Corner Double            */
  "SF390000",         /*201,   0, 0, Upper Left Box Corner Double            */
  "SF400000",         /*202,   0, 0, Middle Box Bottom Double                */
  "SF410000",         /*203,   0, 0, Middle Box Top Double                   */
  "SF420000",         /*204,   0, 0, Left Box Side Double                    */
  "SF430000",         /*205,   0, 0, Center Box Bar Horizontal Double        */
  "SF440000",         /*206,   0, 0, Box Intersection Double                 */
  "currency",         /*207, 168, 1, SC010000                                */
  "eth",              /*208,   0, 1, LD630000                                */
  "Eth",              /*209,   0, 1, LD620000                                */
  "Ecircumflex",      /*210,   0, 1, LE160000                                */
  "Edieresis",        /*211,   0, 1, LE180000                                */
  "Egrave",           /*212,   0, 1, LE140000                                */
  "dotlessi",         /*213, 245, 1, LI610000                                */
  "Iacute",           /*214,   0, 1, LI120000                                */
  "Icircumflex",      /*215,   0, 1, LI160000                                */
  "Idieresis",        /*216,   0, 1, LI180000                                */
  "SF040000",         /*217,   0, 0, Lower right Box Corner                  */
  "SF010000",         /*218,   0, 0, Upper Left Box Corner                   */
  "SF610000",         /*219,   0, 0, Solid Fill Character                    */
  "SF570000",         /*220,   0, 0, Solid Fill Character, Bottom Half       */
  "brokenbar",        /*221,   0, 1, SM650000                                */
  "Igrave",           /*222,   0, 1, LI140000                                */
  "SF600000",         /*223,   0, 0, Solid Fill character, Top Half          */
  "Oacute",           /*224,   0, 1, LO120000                                */
  "germandbls",       /*225, 251, 1, LS610000                                */
  "Ocircumflex",      /*226,   0, 1, LO160000                                */
  "Ograve",           /*227,   0, 1, LO140000                                */
  "otilde",           /*228,   0, 1, LO190000                                */
  "Otilde",           /*229,   0, 1, LO200000                                */
  "micro",            /*230,   0, 0, SM170000                                */
  "thorn",            /*231,   0, 1, LT630000                                */
  "Thorn",            /*232,   0, 1, LT640000                                */
  "Uacute",           /*233,   0, 1, LU120000                                */
  "Ucircumflex",      /*234,   0, 1, LU160000                                */
  "Ugrave",           /*235,   0, 1, LU140000                                */
  "yacute",           /*236,   0, 1, LY110000                                */
  "Yacute",           /*237,   0, 1, LY120000                                */
  "overline",         /*238,   0, 0, SM150000                                */
  "acute",            /*239, 194, 1, SD110000                                */
  "hyphen",           /*240,  45, 1, SP100000 Hyphen --Copy--                */
  "plusminus",        /*241,   0, 1, SA020000                                */
  "underscoredbl",    /*242,   0, 0, SM100000                                */
  "threequarters",    /*243,   0, 1, NF050000                                */
  "paragraph",        /*244, 182, 1, SM250000   --Copy--                     */
  "section",          /*245, 167, 1, SM240000   --Copy--                     */
  "divide",           /*246,   0, 1, SA060000                                */
  "cedilla",          /*247, 203, 1, SD410000                                */
  "degree",           /*248,   0, 1, SM190000                                */
  "dieresis",         /*249, 200, 1, SD170000                                */
  "periodcentered",   /*250, 180, 1, SD630000                                */
  "onesuperior",      /*251,   0, 1, ND011000                                */
  "threesuperior",    /*252,   0, 1, ND031000                                */
  "twosuperior",      /*253,   0, 1, ND021000                                */
  "filledbox",        /*254,   0, 0, SM470000                                */
  "space",            /*255,   0, 0,            --Copy--                     */
  "Pts",              /*256,   0, 0, SC060000                                */
  "SM680000",         /*257,   0, 0, Start of Line Symbol                    */
  "SF190000",         /*258,   0, 0, Right Box Side Double to Single         */
  "SF200000",         /*259,   0, 0, Right Box Side Single to Double         */
  "SF210000",         /*260,   0, 0, Upper Right Box Corner Single to Double */
  "SF220000",         /*261,   0, 0, Upper Right Box Corner Double to Single */
  "SF270000",         /*262,   0, 0, Lower Right Box Corner Single to Double */
  "SF280000",         /*263,   0, 0, Lower Right Box Corner Double to Single */
  "SF360000",         /*264,   0, 0, Left Box Side Single to Double          */
  "SF370000",         /*265,   0, 0, Left Box Side Double to Single          */
  "SF450000",         /*266,   0, 0, Middle Box Bottom Single to Double      */
  "SF460000",         /*267,   0, 0, Middle Box Bottom Double to Single      */
  "SF470000",         /*268,   0, 0, Middle Box Top Double to Single         */
  "SF480000",         /*269,   0, 0, Middle Box Top Single to Double         */
  "SF490000",         /*270,   0, 0, Lower Left Box Corner Double to Single  */
  "SF500000",         /*271,   0, 0, Lower Left Box Corner Single to Double  */
  "SF510000",         /*272,   0, 0, Upper Left Box Corner Single to Double  */
  "SF520000",         /*273,   0, 0, Upper Left Box Corner Double to Single  */
  "SF530000",         /*274,   0, 0, Box Intersection Single to Double       */
  "SF540000",         /*275,   0, 0, Box Intersection Double to Single       */
  "SF580000",         /*276,   0, 0, Solid Fill Character, Left Half         */
  "SF590000",         /*277,   0, 0, Solid Fill Character, Right Half        */
  "alpha",            /*278,   0, 0, GA010000                                */
  "Gamma",            /*279,   0, 0, GG020000                                */
  "pi",               /*280,   0, 0, GP010000                                */
  "Sigma",            /*281,   0, 0, GS020000                                */
  "sigma",            /*282,   0, 0, GS010000                                */
  "tau",              /*283,   0, 0, GT010000                                */
  "Phi",              /*284,   0, 0, GF020000                                */
  "Theta",            /*285,   0, 0, GT620000                                */
  "Omega",            /*286,   0, 0, GO320000                                */
  "delta",            /*287,   0, 0, GD010000                                */
  "infinity",         /*288,   0, 0, SA450000                                */
  "phi",              /*289,   0, 0, GF010001                                */
  "epsilon",          /*290,   0, 0, GE010000                                */
  "intersection",     /*291,   0, 0, SA380000                                */
  "equivalence",      /*292,   0, 0, SA480000                                */
  "greaterequal",     /*293,   0, 0, SA530000                                */
  "lessequal",        /*294,   0, 0, SA520000                                */
  "SS260000",         /*295,   0, 0, Upper Integral Symbol Section           */
  "SS270000",         /*296,   0, 0, Lower Integral Symbol Section           */
  "approxequal",      /*297,   0, 0, SA700000                                */
  "productdot",       /*298,   0, 0, SA790000                                */
  "radical",          /*299,   0, 0, SA800000                                */
  "nsuperior",        /*300,   0, 0, LN011000                                */
  "macron",           /*301, 197, 1, SD310000                                */
  "breve",            /*302, 198, 1, SD230000                                */
  "dotaccent",        /*303, 199, 1, SD290000                                */
  "ring",             /*304, 202, 1, SD270000                                */
  "hungarumlaut",     /*305, 205, 1, SD250000                                */
  "ogonek",           /*306, 206, 1, SD430000                                */
  "caron",            /*307, 207, 1, SD210000                                */
  "quoteleft",        /*308,  96, 1, SP190000                                */
  "quoteright",       /*309,  39, 1, SP200000                                */
  "quotedblleft",     /*310, 170, 1, SP210000                                */
  "quotedblright",    /*311, 186, 1, SP220000                                */
  "endash",           /*312, 177, 1, SS680000                                */
  "emdash",           /*313, 208, 1, SM900000                                */
  "asciicircum",      /*314,  94, 1, SD150300   --Copy--                     */
  "asciitilde",       /*315, 126, 1, SD190300   --Copy--                     */
  "quotesinglbase",   /*316, 184, 1, SP260000                                */
  "quotedblbase",     /*317, 185, 1, SP230000                                */
  "ellipsis",         /*318, 188, 1, SV520000                                */
  "dagger",           /*319, 178, 1, SM340000                                */
  "daggerdbl",        /*320, 179, 1, SM350000                                */
  "circumflex",       /*321, 195, 1, SD150100                                */
  "perthousand",      /*322, 189, 1, SM560000                                */
  "Scaron",           /*323,   0, 1, LS220000                                */
  "guilsinglleft",    /*324, 172, 1, SP270000                                */
  "OE",               /*325, 234, 1, LO520000                                */
  "tilde",            /*326, 196, 1, SD190100                                */
  "trademark",        /*327,   0, 1, SM540000                                */
  "scaron",           /*328,   0, 1, LS210000                                */
  "guilsinglright",   /*329, 173, 1, SP280000                                */
  "oe",               /*330, 250, 1, LO510000                                */
  "Ydieresis",        /*331,   0, 1, LY180000                                */
  "gbreve",           /*332,   0, 0, LG230000 g Breve Small                  */
  "Gbreve",           /*333,   0, 0, LG240000 G Breve Capital                */
  "Idotaccent",       /*334,   0, 0, LI300000 I Overdot Capital              */
  "scedilla",         /*335,   0, 0, LS410000 s Cedilla Small                */
  "Scedilla",         /*336,   0, 0, LS420000 S Cedilla Capital              */
  "abreve",           /*337,   0, 0, LA230000 a Breve Small                  */
  "Abreve",           /*338,   0, 0, LA240000 A Breve Capital                */
  "aogonek",          /*339,   0, 0, LA430000 a Ogonek Small                 */
  "Aogonek",          /*340,   0, 0, LA440000 A Ogonek Capital               */
  "cacute",           /*341,   0, 0, LC110000 c Acute Small                  */
  "Cacute",           /*342,   0, 0, LC120000 C Acute Capital                */
  "ccaron",           /*343,   0, 0, LC210000 c Caron Small                  */
  "Ccaron",           /*344,   0, 0, LC220000 C Caron Capital                */
  "dcaron",           /*345,   0, 0, LD210000 c Caron Small                  */
  "Dcaron",           /*346,   0, 0, LD220000 D Caron Capital                */
  "dbar",             /*347,   0, 0, LD610000 d Stroke Small                 */
  "ecaron",           /*348,   0, 0, LE210000 e Caron Small                  */
  "Ecaron",           /*349,   0, 0, LE220000 E Caron Capital                */
  "eogonek",          /*350,   0, 0, LE430000 e Ogonek Small                 */
  "Eogonek",          /*351,   0, 0, LE440000 E Ogonek Capital               */
  "lacute",           /*352,   0, 0, LL110000 l Acute Small                  */
  "Lacute",           /*353,   0, 0, LL120000 L Acute Capital                */
  "lcaron",           /*354,   0, 0, LL210000 l Caron Small                  */
  "Lcaron",           /*355,   0, 0, LL220000 L Caron Capital                */
  "lslash",           /*356,   0, 1, LL610000 l Storoke Small                */
  "Lslash",           /*357,   0, 1, LL620000 L Stroke Capital               */
  "nacute",           /*358,   0, 0, LN110000 n Acute Small                  */
  "Nacute",           /*359,   0, 0, LN120000 N Acute Capital                */
  "ncaron",           /*360,   0, 0, LN210000 n Caron Small                  */
  "Ncaron",           /*361,   0, 0, LN220000 N Caron Capital                */
  "ohungarumlaut",    /*362,   0, 0, LO250000 o Double Acute Small           */
  "Ohungarumlaut",    /*363,   0, 0, LO260000 O Double Acute Capital         */
  "racute",           /*364,   0, 0, LR110000 r Acute Small                  */
  "Racute",           /*365,   0, 0, LR120000 R Acute Capital                */
  "rcaron",           /*366,   0, 0, LR210000 r Caron Small                  */
  "Rcaron",           /*367,   0, 0, LR220000 R Caron Capital                */
  "sacute",           /*368,   0, 0, LS110000 s Acute Small                  */
  "Sacute",           /*369,   0, 0, LS120000 S Acute Capital                */
  "tcaron",           /*370,   0, 0, LT210000 t Caron Small                  */
  "Tcaron",           /*371,   0, 0, LT220000 T Caron Capital                */
  "tcedilla",         /*372,   0, 0, LT410000 t Cedilla Small                */
  "Tcedilla",         /*373,   0, 0, LT420000 T Cedilla Capital              */
  "uhungarumlaut",    /*374,   0, 0, LU250000 u Double Acute Small           */
  "Uhungarumlaut",    /*375,   0, 0, LU260000 U Double Acute Capital         */
  "uring",            /*376,   0, 0, LU270000 u Overcircle Small             */
  "Uring",            /*377,   0, 0, LU280000 U Overcircle Capital           */
  "zacute",           /*378,   0, 0, LZ110000 z Acute Small                  */
  "Zacute",           /*379,   0, 0, LZ120000 Z Acute Capital                */
  "zcaron",           /*380,   0, 1, LZ210000 z Caron Small                  */
  "Zcaron",           /*381,   0, 1, LZ220000 Z Caron Capital                */
  "zdotaccent",       /*382,   0, 0, LZ290000 z Overdot Small                */
  "Zdotaccent",       /*383,   0, 0, LZ300000 Z Overdot Capital              */
  NULL };
