;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DCSTRUC.INC
;*
;* DESCRIPTIVE NAME =
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR      CHANGE DESCRIPTION
;*   --------  ----------  -----     --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx     xxxxxxx
;*
;*****************************************************************************/


DC_IDENTIFIER           equ     'CD'            ; 'DC'
SAVED_DC_IDENTIFIER     equ     'DS'            ; 'SD'
LDEV_IDENTIFIER         equ     'DL'            ; 'LD'
PDEV_IDENTIFIER         equ     'DP'            ; 'PD'
XFORM_IDENTIFIER        equ     'FX'            ; 'XF'
LCID_IDENTIFIER         equ     'CL'            ; 'LC'

;/*
;**  maximum number of stored handles in DC
;*/

DC_MAX_HANDLES          equ     4

;/*
;**  common structure header for allocated fixed structures
;*/

generic_block   struc
generic_ident   dw      0
generic_size    dw      0
generic_start   dd      0,0
generic_next    dw      0
generic_block   ends

;/*
;**  Device Context structure definition
;*/

device_context  struc

;/*
;**  Fields that have to be initialized by OpenDC explicitly
;*/

dc_ident                dw      0       ; object identifier (for debugging)
dc_size                 dw      0
dc_magic                dd      0       ; used by device driver
dc_ldevice              dd      0       ; handle to logical device
dc_next                 dw      0       ; linked list of all DCs
dc_pidOwner             dw      0       ; PID that owns this DC
dc_pidLock              dw      0       ; PID that has the DC locked
dc_tidLock              dw      0       ; TID that has the DC locked
dc_cLock                dw      0       ; lock depth, -1 means unlocked
dc_pidUser              dw      0       ; User PID that owns this DC
dc_tidUser              dw      0       ; User TID that has the DC locked
dc_cLockUser            dw      0       ; User lock depth, -1 means unlocked
;dc_fs                   dw      0       ; flags (unused so far)
dc_pdevice              dd      0       ; handle to physical device
dc_the_type             dw      0       ; type when created
dc_mode                 dw      0       ; mode as set by ProcessControl

;/*
;**  -----------Fields above not affected by ResetDC ------------------------
;*/
dc_hjournalfile         dw      0       ; stuffed by StartJournalFile
dc_sizl                 dd      (SIZE SIZEL)/4 dup(0)

;/*
;**  Handles (as set by SetHandle)
;*/

dc_handles              dd      DC_MAX_HANDLES dup(0)

;/*
;**  Associated objects
;*/

dc_bitmap               dw      0       ; bitmap handle
dc_LCID_table           dw      0       ; LCID list pointer

;/*
;**  SaveDC info
;*/

dc_save_level           dw      0       ; depth in SaveDC
dc_save_pointer         dw      0       ; pointer to saved DC

;/*
;**  random attributes
;*/

dc_ptlOrigin            dd      (SIZE POINTL)/4 dup(0)
dc_ptsOrigin            dw      (SIZE POINTS)/2 dup(0)
                                        ; short version of DC origin for regions
dc_xform_flags          dw      0       ; the flags from NotifyXformChange
dc_lWDxform_x           dd      0       ; X translation from WORLD to DEVICE
dc_lWDxform_y           dd      0       ; Y translation from WORLD to DEVICE
dc_dirty_flags          dw      0       ; to optimize ResetDC
dc_flags                dw      0       ; random flags

;/*
;**  Attribute Bundles
;*/

dc_line_bundle          db      (SIZE DLINEBUNDLE + 2) dup (0)
dc_pat_bundle           db      (SIZE DAREABUNDLE) dup (0)
dc_char_bundle          db      (SIZE DCHARBUNDLE) dup (0)
dc_image_bundle         db      (SIZE DIMAGEBUNDLE) dup (0)
dc_marker_bundle        db      (SIZE DMARKERBUNDLE) dup (0)

dc_line_default         dd      0       ; line defaults mask
dc_char_default         dd      0       ; char defaults mask
dc_marker_default       dd      0       ; marker defaults mask
dc_pat_default          dd      0       ; pat  defaults mask
dc_image_default        dd      0       ; image defaults mask

;/*
;**  *** Arcs Component Data ***
;*/

dc_arc_parameters       dd      (SIZE ARCPARAMS)/4 dup(0)
dc_arc_matrix           dd      8 dup(0)
dc_inv_arc_matrix       dd      8 dup(0)
dc_norm                 dw      0
dc_direction            dw      0

;/*
;**  *** Paths Component Data ***
;*/

dc_area_area            dw      0
dc_clip_area            dw      0
dc_path_id_one          dw      0

;/*
;**  *** Regions Component Data ***
;*/

dc_clip_region          dw      0       ; clip region handle
dc_xform_region         dw      0       ; transform rectangular region
dc_visible_region       dw      0       ; visible region handle
dc_path_region          dw      0       ; region that represents the path
dc_rao_region           dw      0       ; rao region handle
dc_cliprgn_clone        dw      0       ; for use by SaveDC and RestoreDC

;/*
;**  *** Transforms Component Data ***
;*/

dc_xform_block          dw      0       ; for non-trivial transforms
dc_page_units           dd      0
dc_sizlPage             dd      (SIZE SIZEL)/4 dup(0)
dc_sizlUnits            dd      (SIZE SIZEL)/4 dup(0)
dc_rclViewingLimits     dd      (SIZE RECTL)/4 dup(0)
dc_rclGraphicsField     dd      (SIZE RECTL)/4 dup(0)
dc_rclPageViewport      dd      (SIZE RECTL)/4 dup(0)

device_context  ends

;/*
;**  Make sure we're happy with the DC                                     ;
;*/

;/*
;**  check generic fields
;*/

.errnz (dc_next - generic_next)
.errnz (dc_size - generic_size)

;/*
;**  check DWORD alignment
;*/

;/*
;*.errnz dc_line_bundle    AND 3
;*.errnz dc_pat_bundle     AND 3
;*.errnz dc_char_bundle    AND 3
;*.errnz dc_image_bundle   AND 3
;*.errnz dc_marker_bundle  AND 3
;*.errnz dc_line_default   AND 3
;*.errnz dc_arc_parameters AND 3
;*.errnz dc_page_units     AND 3
;*/

;/*
;**  check MATRIX sizes for Arcs Component
;*/

ifdef MATRIX
.errnz  SIZE dc_arc_matrix     - SIZE MATRIX
.errnz  SIZE dc_inv_arc_matrix - SIZE MATRIX
endif

;/*
;**  Beginning of fields that are initialized (i.e. smashed) by init_dc.
;*/

DC_INIT_START   equ     (dc_sizl + SIZE dc_sizl)
.errnz  (dc_handles - dc_sizl - SIZE dc_sizl)

;/*
;**  the logical device and phyical device block structures                ;
;*/

ldev_header     struc
ldev_ident      dw      0               ; 'LD'
ldev_size       dw      0
ldev_flags      dw      0
ldev_hmod       dw      0               ; module handle
ldev_npfEnabled dw      0               ; Offset of Enabled flag
ldev_mskEnabled dw      0               ; Mask for the Enabled flag
ldev_npldev     dw      0               ; next lDevice block
ldev_nppdev     dw      0               ; beginning of chain of pdevs
ldev_enable     dd      0               ; enable thunk
ldev_header     ends

ldev_block      struc
ldev_hdr        db      SIZE ldev_header dup(?)
ldev_table      dd      ?               ; the jump table
ldev_block      ends

.errnz (ldev_npldev - generic_next)
.errnz (ldev_size - generic_size)

deffont_info   struc
deffont_sel   dw      0       ; selector to device's default raster font
deffont_atom  dw      0       ; facename atom for default raster font
deffont_match dd      0       ; lmatch for default raster font
deffont_info   ends

pdev_block          struc
pdev_ident          dw      0       ; 'PD'
pdev_size           dw      0
pdev_length         dw      0       ; length in bytes of pdev block structure
pdev_flags          dw      0
pdev_count          dw      0       ; reference count
pdev_atomDevice     dw      0       ; atom for name of physical device
pdev_nppdev         dw      0       ; next pDevice
pdev_atomFile       dw      0       ; atom for file name of port
pdev_info           dd      0       ; pointer or handle of state information
pdev_sizl           dd      (SIZE SIZEL)/4 dup(0)
pdev_vert_res       dd      0
pdev_horz_res       dd      0
pdev_planes         dw      0
pdev_bitcount       dw      0
pdev_fore_mixes     dw      0
pdev_back_mixes     dw      0
pdev_raster_caps    dw      0
pdev_defrfont       dw      (SIZE deffont_info)/2 dup(0)      ; raster default
pdev_defvfont       dw      (SIZE deffont_info)/2 dup(0)      ; vector default
pdev_block          ends
.errnz (pdev_nppdev - generic_next)
.errnz (pdev_size - generic_size)

;/*
;**  flags for cleanup_dc
;*/

CDC_RESTOREDC   equ     01h

;/*
;**  These are the flags for storage inside cdef_fFlags and elffFlags
;**  they are derived from fat_fsSelection flags.
;*/



;/*
;**   values of fsSelection field of FATTRS structure
;*/

FATTR_SEL_BOLD  equ     00020h                  ;* !!! move this to pmgpi.h
                                                ;* once the dcr goes through.
