/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ALLFONTS.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : This file contains a list of all of the fonts included in
 *		 the 1.1 release for all of the supported printers.  It also
 *		 contains several other tables.  Users can select the Bold or
 *		 Italic attribute when creating a logical font.  When this is
 *		 the case, these tables are used to map to the correct font.
 *
 *		 IF YOU CHANGE THIS FILE, be sure to update any constants,
 *		 and to update all tables!!!
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/



char  *AllFonts[] =
   {
    "ITC Avant Garde Gothic Book",
    "ITC Avant Garde Gothic Book Obl",
    "ITC Avant Garde Gothic Demi",
    "ITC Avant Garde Gothic Demi Obl",
    "ITC Bookman Demi",
    "ITC Bookman Demi Italic",
    "ITC Bookman Light",
    "ITC Bookman Light Italic",
    "Courier Bold",
    "Courier Bold Oblique",
    "Courier Oblique",
    "Courier",
    "ITC Garamond Bold",
    "ITC Garamond Bold Italic",
    "ITC Garamond Light",
    "ITC Garamond Light Italic",
    "Helvetica Black",
    "Helvetica Black Oblique",
    "Helvetica Bold",
    "Helvetica Bold Oblique",
    "Helvetica Condensed Bold",
    "Helvetica Condensed Bold Obliqu",
    "Helvetica Condensed Oblique",
    "Helvetica Condensed Medium",
    "Helvetica Light",
    "Helvetica Light Oblique",
    "Helvetica Narrow Bold",
    "Helvetica Narrow Bold Oblique",
    "Helvetica Narrow Oblique",
    "Helvetica Narrow",
    "Helvetica Oblique",
    "Helvetica",
    "ITC Korinna Bold",
    "ITC Korinna Kursiv Bold",
    "ITC Korinna Kursiv Regular",
    "ITC Korinna Regular",
    "ITC Lubalin Graph Book",
    "ITC Lubalin Graph Book Oblique",
    "ITC Lubalin Graph Demi",
    "ITC LubalinGraph Demi Oblique",
    "New Century Schoolbook Bold",
    "New Century Schoolbook Bold Ita",
    "New Century Schoolbook Italic",
    "New Century Schoolbook Roman",
    "Palatino Bold",
    "Palatino Bold Italic",
    "Palatino Italic",
    "Palatino Roman",
    "ITC Souvenir Demi",
    "ITC Souvenir Demi Italic",
    "ITC Souvenir Light",
    "ITC Souvenir Light Italic",
    "Symbol",
    "Times Bold",
    "Times Bold Italic",
    "Times Italic",
    "Times Roman",
    "Times Bold",
    "Times Bold Italic",
    "Times Italic",
    "Times Roman",
    "ITC Zapf Chancery Medium Italic",
    "ITC Zapf Dingbats",
    0
   };

#define AVANTGARDE_BOOK 	      0
#define AVANTGARDE_BOOKOBLIQUE	      1
#define AVANTGARDE_DEMI 	      2
#define AVANTGARDE_DEMIOBLIQUE	      3
#define BOOKMAN_DEMI		      4
#define BOOKMAN_DEMIITALIC	      5
#define BOOKMAN_LIGHT		      6
#define BOOKMAN_LIGHTITALIC	      7
#define COURIER_BOLD		      8
#define COURIER_BOLDOBLIQUE	      9
#define COURIER_OBLIQUE 	      10
#define COURIER 		      11
#define GARAMOND_BOLD		      12
#define GARAMOND_BOLDITALIC	      13
#define GARAMOND_LIGHT		      14
#define GARAMOND_LIGHTITALIC	      15
#define HELVETICA_BLACK 	      16
#define HELVETICA_BLACKOBLIQUE	      17
#define HELVETICA_BOLD		      18
#define HELVETICA_BOLDOBLIQUE	      19
#define HELVETICA_CONDENSED_BOLD      20
#define HELVETICA_CONDENSED_BOLDOBL   21
#define HELVETICA_CONDENSED_OBLIQUE   22
#define HELVETICA_CONDENSED	      23
#define HELVETICA_LIGHT 	      24
#define HELVETICA_LIGHTOBLIQUE	      25
#define HELVETICA_NARROW_BOLD	      26
#define HELVETICA_NARROW_BOLDOBLIQUE  27
#define HELVETICA_NARROW_OBLIQUE      28
#define HELVETICA_NARROW	      29
#define HELVETICA_OBLIQUE	      30
#define HELVETICA		      31
#define KORINNA_BOLD		      32
#define KORINNA_KURSIVBOLD	      33
#define KORINNA_KURSIVREGULAR	      34
#define KORINNA_REGULAR 	      35
#define LUBALINGRAPH_BOOK	      36
#define LUBALINGRAPH_BOOKOBLIQUE      37
#define LUBALINGRAPH_DEMI	      38
#define LUBALINGRAPH_DEMIOBLIQUE      39
#define NEWCENTURYSCHLBK_BOLD	      40
#define NEWCENTURYSCHLBK_BOLDITALIC   41
#define NEWCENTURYSCHLBK_ITALIC       42
#define NEWCENTURYSCHLBK_ROMAN	      43
#define PALATINO_BOLD		      44
#define PALATINO_BOLDITALIC	      45
#define PALATINO_ITALIC 	      46
#define PALATINO_ROMAN		      47
#define SOUVENIR_DEMI		      48
#define SOUVENIR_DEMIITALIC	      49
#define SOUVENIR_LIGHT		      50
#define SOUVENIR_LIGHTITALIC	      51
#define SYMBOL			      52
#define TIMES_BOLD		      53
#define TIMES_BOLDITALIC	      54
#define TIMES_ITALIC		      55
#define TIMES_ROMAN		      56
#define VARITIMES_BOLD		      57
#define VARITIMES_BOLDITALIC	      58
#define VARITIMES_ITALIC	      59
#define VARITIMES_ROMAN 	      60
#define ZAPFCHANCERY_MEDIUMITALIC     61
#define ZAPFDINGBATS		      62

#define TOTAL_FONTS_SUPPORTED	      63

static USHORT BoldFonts[TOTAL_FONTS_SUPPORTED] =
{
    AVANTGARDE_DEMI,
    AVANTGARDE_DEMIOBLIQUE,
    AVANTGARDE_DEMI,
    AVANTGARDE_DEMIOBLIQUE,
    BOOKMAN_DEMI,
    BOOKMAN_DEMIITALIC,
    BOOKMAN_DEMI,
    BOOKMAN_DEMIITALIC,
    COURIER_BOLD,
    COURIER_BOLDOBLIQUE,
    COURIER_BOLDOBLIQUE,
    COURIER_BOLD,
    GARAMOND_BOLD,
    GARAMOND_BOLDITALIC,
    GARAMOND_BOLD,
    GARAMOND_BOLDITALIC,
    HELVETICA_BLACK,
    HELVETICA_BLACKOBLIQUE,
    HELVETICA_BOLD,
    HELVETICA_BOLDOBLIQUE,
    HELVETICA_CONDENSED_BOLD,
    HELVETICA_CONDENSED_BOLDOBL,
    HELVETICA_CONDENSED_BOLDOBL,
    HELVETICA_CONDENSED_BOLD,
    HELVETICA_BOLD,
    HELVETICA_BOLDOBLIQUE,
    HELVETICA_NARROW_BOLD,
    HELVETICA_NARROW_BOLDOBLIQUE,
    HELVETICA_NARROW_BOLDOBLIQUE,
    HELVETICA_NARROW_BOLD,
    HELVETICA_BOLDOBLIQUE,
    HELVETICA_BOLD,
    KORINNA_BOLD,
    KORINNA_KURSIVBOLD,
    KORINNA_KURSIVBOLD,
    KORINNA_BOLD,
    LUBALINGRAPH_DEMI,
    LUBALINGRAPH_DEMIOBLIQUE,
    LUBALINGRAPH_DEMI,
    LUBALINGRAPH_DEMIOBLIQUE,
    NEWCENTURYSCHLBK_BOLD,
    NEWCENTURYSCHLBK_BOLDITALIC,
    NEWCENTURYSCHLBK_BOLDITALIC,
    NEWCENTURYSCHLBK_BOLD,
    PALATINO_BOLD,
    PALATINO_BOLDITALIC,
    PALATINO_BOLDITALIC,
    PALATINO_BOLD,
    SOUVENIR_DEMI,
    SOUVENIR_DEMIITALIC,
    SOUVENIR_DEMI,
    SOUVENIR_DEMIITALIC,
    SYMBOL,
    TIMES_BOLD,
    TIMES_BOLDITALIC,
    TIMES_BOLDITALIC,
    TIMES_BOLD,
    VARITIMES_BOLD,
    VARITIMES_BOLDITALIC,
    VARITIMES_BOLDITALIC,
    VARITIMES_BOLD,
    ZAPFCHANCERY_MEDIUMITALIC,
    ZAPFDINGBATS
};


static USHORT ItalicFonts[TOTAL_FONTS_SUPPORTED] =
{
    AVANTGARDE_BOOKOBLIQUE,
    AVANTGARDE_BOOKOBLIQUE,
    AVANTGARDE_DEMIOBLIQUE,
    AVANTGARDE_DEMIOBLIQUE,
    BOOKMAN_DEMIITALIC,
    BOOKMAN_DEMIITALIC,
    BOOKMAN_LIGHTITALIC,
    BOOKMAN_LIGHTITALIC,
    COURIER_BOLDOBLIQUE,
    COURIER_BOLDOBLIQUE,
    COURIER_OBLIQUE,
    COURIER_OBLIQUE,
    GARAMOND_BOLDITALIC,
    GARAMOND_BOLDITALIC,
    GARAMOND_LIGHTITALIC,
    GARAMOND_LIGHTITALIC,
    HELVETICA_BLACKOBLIQUE,
    HELVETICA_BLACKOBLIQUE,
    HELVETICA_BOLDOBLIQUE,
    HELVETICA_BOLDOBLIQUE,
    HELVETICA_CONDENSED_BOLDOBL,
    HELVETICA_CONDENSED_BOLDOBL,
    HELVETICA_CONDENSED_OBLIQUE,
    HELVETICA_CONDENSED_OBLIQUE,
    HELVETICA_LIGHTOBLIQUE,
    HELVETICA_LIGHTOBLIQUE,
    HELVETICA_NARROW_BOLDOBLIQUE,
    HELVETICA_NARROW_BOLDOBLIQUE,
    HELVETICA_NARROW_OBLIQUE,
    HELVETICA_NARROW_OBLIQUE,
    HELVETICA_OBLIQUE,
    HELVETICA_OBLIQUE,
    KORINNA_KURSIVBOLD,
    KORINNA_KURSIVBOLD,
    KORINNA_KURSIVREGULAR,
    KORINNA_KURSIVREGULAR,
    LUBALINGRAPH_BOOKOBLIQUE,
    LUBALINGRAPH_BOOKOBLIQUE,
    LUBALINGRAPH_DEMIOBLIQUE,
    LUBALINGRAPH_DEMIOBLIQUE,
    NEWCENTURYSCHLBK_BOLDITALIC,
    NEWCENTURYSCHLBK_BOLDITALIC,
    NEWCENTURYSCHLBK_ITALIC,
    NEWCENTURYSCHLBK_ITALIC,
    PALATINO_BOLDITALIC,
    PALATINO_BOLDITALIC,
    PALATINO_ITALIC,
    PALATINO_ITALIC,
    SOUVENIR_DEMIITALIC,
    SOUVENIR_DEMIITALIC,
    SOUVENIR_LIGHTITALIC,
    SOUVENIR_LIGHTITALIC,
    SYMBOL,
    TIMES_BOLDITALIC,
    TIMES_BOLDITALIC,
    TIMES_ITALIC,
    TIMES_ITALIC,
    VARITIMES_BOLDITALIC,
    VARITIMES_BOLDITALIC,
    VARITIMES_ITALIC,
    VARITIMES_ITALIC,
    ZAPFCHANCERY_MEDIUMITALIC,
    ZAPFDINGBATS
};


static USHORT BoldItalicFonts[TOTAL_FONTS_SUPPORTED] =
{
    AVANTGARDE_DEMIOBLIQUE,
    AVANTGARDE_DEMIOBLIQUE,
    AVANTGARDE_DEMIOBLIQUE,
    AVANTGARDE_DEMIOBLIQUE,
    BOOKMAN_DEMIITALIC,
    BOOKMAN_DEMIITALIC,
    BOOKMAN_DEMIITALIC,
    BOOKMAN_DEMIITALIC,
    COURIER_BOLDOBLIQUE,
    COURIER_BOLDOBLIQUE,
    COURIER_BOLDOBLIQUE,
    COURIER_BOLDOBLIQUE,
    GARAMOND_BOLDITALIC,
    GARAMOND_BOLDITALIC,
    GARAMOND_BOLDITALIC,
    GARAMOND_BOLDITALIC,
    HELVETICA_BLACKOBLIQUE,
    HELVETICA_BLACKOBLIQUE,
    HELVETICA_BOLDOBLIQUE,
    HELVETICA_BOLDOBLIQUE,
    HELVETICA_CONDENSED_BOLDOBL,
    HELVETICA_CONDENSED_BOLDOBL,
    HELVETICA_CONDENSED_BOLDOBL,
    HELVETICA_CONDENSED_BOLDOBL,
    HELVETICA_BOLDOBLIQUE,
    HELVETICA_BOLDOBLIQUE,
    HELVETICA_NARROW_BOLDOBLIQUE,
    HELVETICA_NARROW_BOLDOBLIQUE,
    HELVETICA_NARROW_BOLDOBLIQUE,
    HELVETICA_NARROW_BOLDOBLIQUE,
    HELVETICA_BOLDOBLIQUE,
    HELVETICA_BOLDOBLIQUE,
    KORINNA_KURSIVBOLD,
    KORINNA_KURSIVBOLD,
    KORINNA_KURSIVBOLD,
    KORINNA_KURSIVBOLD,
    LUBALINGRAPH_DEMIOBLIQUE,
    LUBALINGRAPH_DEMIOBLIQUE,
    LUBALINGRAPH_DEMIOBLIQUE,
    LUBALINGRAPH_DEMIOBLIQUE,
    NEWCENTURYSCHLBK_BOLDITALIC,
    NEWCENTURYSCHLBK_BOLDITALIC,
    NEWCENTURYSCHLBK_BOLDITALIC,
    NEWCENTURYSCHLBK_BOLDITALIC,
    PALATINO_BOLDITALIC,
    PALATINO_BOLDITALIC,
    PALATINO_BOLDITALIC,
    PALATINO_BOLDITALIC,
    SOUVENIR_DEMIITALIC,
    SOUVENIR_DEMIITALIC,
    SOUVENIR_DEMIITALIC,
    SOUVENIR_DEMIITALIC,
    SYMBOL,
    TIMES_BOLDITALIC,
    TIMES_BOLDITALIC,
    TIMES_BOLDITALIC,
    TIMES_BOLDITALIC,
    VARITIMES_BOLDITALIC,
    VARITIMES_BOLDITALIC,
    VARITIMES_BOLDITALIC,
    VARITIMES_BOLDITALIC,
    ZAPFCHANCERY_MEDIUMITALIC,
    ZAPFDINGBATS
};
