;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = ERROR.ASM (in engine code)
;*
;* DESCRIPTIVE NAME = Imported to PostScript driver as ERRORCHK.ASM
;*
;*
;* VERSION	V2.0
;*
;* DATE 	05/26/87
;*
;* DESCRIPTION	Contains the engine error declarations.
;*		Also contains the code to process a rip,  assembled only if
;*		FIREWALL is defined.
;*
;*
;*
;* FUNCTIONS	   perform_rip
;*
;*
;* NOTES	NONE
;*
;* STRUCTURES	NONE
;*
;* EXTERNAL REFERENCES
;*
;*		NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*		NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*   05/26/87            	  Created:
;*				  Hock Lee [hockl]
;*
;*   09/13/88            	  perform_rip
;*				  Tue 13-Sep-1988 15:52:53 -by- Lee A.	Newberg
;*				  [leen]
;*				  Preserves all registers.
;*
;*   01/17/87            	  perform_rip
;*				  Sun 17-Jan-1988 17:19:07 -by- Walt Moore
;*				  [waltm]
;*				  Wrote it.
;*
;*
;*****************************************************************************/

	.386p
	.xlist
INCL_GPIERRORS	equ	1
	include 32cmacro.inc
?PLM = CC_SYSCALL
	include .\inc\error.inc
	include .\inc\pmgre.inc
	.list
ifdef FIREWALLS
	externP        <WinSetErrorInfo>,C
endif

	public	PMERR_OK
	public	PMERR_ALREADY_IN_AREA
	public	PMERR_ALREADY_IN_ELEMENT
	public	PMERR_ALREADY_IN_PATH
	public	PMERR_AREA_INCOMPLETE
	public	PMERR_BASE_ERROR
	public	PMERR_BITBLT_LENGTH_EXCEEDED
	public	PMERR_BITMAP_IN_USE
	public	PMERR_BITMAP_IS_SELECTED
	public	PMERR_BITMAP_NOT_FOUND
	public	PMERR_BITMAP_NOT_SELECTED
	public	PMERR_CALLED_SEG_IS_CURRENT
	public	PMERR_CALLED_SEG_NOT_FOUND
	public	PMERR_CANNOT_DELETE_ALL_DATA
	public	PMERR_CANNOT_REPLACE_ELEMENT_0
	public	PMERR_COL_TABLE_NOT_REALIZABLE
	public	PMERR_COL_TABLE_NOT_REALIZED
	public	PMERR_COORDINATE_OVERFLOW
	public	PMERR_CORR_FORMAT_MISMATCH
	public	PMERR_DATA_TOO_LONG
	public	PMERR_DC_IS_ASSOCIATED
	public	PMERR_DEVICE_DRIVER_ERROR_1
	public	PMERR_DEVICE_DRIVER_ERROR_2
	public	PMERR_DEVICE_DRIVER_ERROR_3
	public	PMERR_DEVICE_DRIVER_ERROR_4
	public	PMERR_DEVICE_DRIVER_ERROR_5
	public	PMERR_DEVICE_DRIVER_ERROR_6
	public	PMERR_DEVICE_DRIVER_ERROR_7
	public	PMERR_DEVICE_DRIVER_ERROR_8
	public	PMERR_DEVICE_DRIVER_ERROR_9
	public	PMERR_DEVICE_DRIVER_ERROR_10
	public	PMERR_DOSOPEN_FAILURE
	public	PMERR_DOSREAD_FAILURE
	public	PMERR_DRIVER_NOT_FOUND
	public	PMERR_DUP_SEG
	public	PMERR_DYNAMIC_SEG_SEQ_ERROR
	public	PMERR_DYNAMIC_SEG_ZERO_INV
	public	PMERR_ELEMENT_INCOMPLETE
	public	PMERR_ESC_CODE_NOT_SUPPORTED
	public	PMERR_EXCEEDS_MAX_SEG_LENGTH
	public	PMERR_FONT_AND_MODE_MISMATCH
	public	PMERR_FONT_FILE_NOT_LOADED
	public	PMERR_FONT_NOT_LOADED
	public	PMERR_IMAGE_INCOMPLETE
	public	PMERR_INCOMPAT_COLOR_FORMAT
	public	PMERR_INCOMPAT_COLOR_OPTIONS
	public	PMERR_INCOMPATIBLE_BITMAP
	public	PMERR_INCOMPATIBLE_METAFILE
	public	PMERR_INCORRECT_DC_TYPE
	public	PMERR_INSUFFICIENT_DISK_SPACE
	public	PMERR_INSUFFICIENT_MEMORY
	public	PMERR_INV_ANGLE_PARM
	public	PMERR_INV_ARC_CONTROL
	public	PMERR_INV_AREA_CONTROL
	public	PMERR_INV_ATTR_MODE
	public	PMERR_INV_BACKGROUND_COL_ATTR
	public	PMERR_INV_BACKGROUND_MIX_ATTR
	public	PMERR_INV_BITBLT_MIX
	public	PMERR_INV_BITBLT_STYLE
	public	PMERR_INV_BITMAP_DIMENSION
	public	PMERR_INV_BOX_CONTROL
	public	PMERR_INV_BOX_ROUNDING_PARM
	public	PMERR_INV_CHAR_ANGLE_ATTR
	public	PMERR_INV_CHAR_DIRECTION_ATTR
	public	PMERR_INV_CHAR_MODE_ATTR
	public	PMERR_INV_CHAR_POS_OPTIONS
	public	PMERR_INV_CHAR_SET_ATTR
	public	PMERR_INV_CHAR_SHEAR_ATTR
	public	PMERR_INV_CLIP_PATH_OPTIONS
	public	PMERR_INV_CODEPAGE
	public	PMERR_INV_COLOR_ATTR
	public	PMERR_INV_COLOR_DATA
	public	PMERR_INV_COLOR_FORMAT
	public	PMERR_INV_COLOR_INDEX
	public	PMERR_INV_COLOR_OPTIONS
	public	PMERR_INV_COLOR_START_INDEX
	public	PMERR_INV_COORD_OFFSET
	public	PMERR_INV_COORD_SPACE
	public	PMERR_INV_COORDINATE
	public	PMERR_INV_CORRELATE_DEPTH
	public	PMERR_INV_CORRELATE_TYPE
	public	PMERR_INV_DC_DATA
	public	PMERR_INV_DC_TYPE
	public	PMERR_INV_DEVICE_NAME
	public	PMERR_INV_DRAW_CONTROL
	public	PMERR_INV_DRAW_VALUE
	public	PMERR_INV_DRAWING_MODE
	public	PMERR_INV_DRIVER_DATA
	public	PMERR_INV_EDIT_MODE
	public	PMERR_INV_ELEMENT_POINTER
	public	PMERR_INV_ESCAPE_DATA
	public	PMERR_INV_FILL_PATH_OPTIONS
	public	PMERR_INV_FIRST_CHAR
	public	PMERR_INV_FONT_ATTRS
	public	PMERR_INV_FONT_FILE_DATA
	public	PMERR_INV_FOR_THIS_DC_TYPE
	public	PMERR_INV_FORMAT_CONTROL
	public	PMERR_INV_FORMS_CODE
	public	PMERR_INV_GEOM_LINE_WIDTH_ATTR
	public	PMERR_INV_GETDATA_CONTROL
	public	PMERR_INV_GRAPHICS_FIELD
	public	PMERR_INV_HBITMAP
	public	PMERR_INV_HDC
	public	PMERR_INV_HMF
	public	PMERR_INV_HPS
	public	PMERR_INV_HRGN
	public	PMERR_INV_ID
	public	PMERR_INV_IMAGE_DATA_LENGTH
	public	PMERR_INV_IMAGE_DIMENSION
	public	PMERR_INV_IMAGE_FORMAT
	public	PMERR_INV_IN_AREA
	public	PMERR_INV_IN_CURRENT_EDIT_MODE
	public	PMERR_INV_IN_DRAW_MODE
	public	PMERR_INV_IN_ELEMENT
	public	PMERR_INV_IN_IMAGE
	public	PMERR_INV_IN_PATH
	public	PMERR_INV_IN_RETAIN_MODE
	public	PMERR_INV_IN_SEG
	public	PMERR_INV_INFO_TABLE
	public	PMERR_INV_KERNING_FLAGS
	public	PMERR_INV_LENGTH_OR_COUNT
	public	PMERR_INV_LINE_END_ATTR
	public	PMERR_INV_LINE_JOIN_ATTR
	public	PMERR_INV_LINE_TYPE_ATTR
	public	PMERR_INV_LINE_WIDTH_ATTR
	public	PMERR_INV_LOGICAL_ADDRESS
	public	PMERR_INV_MARKER_BOX_ATTR
	public	PMERR_INV_MARKER_SET_ATTR
	public	PMERR_INV_MARKER_SYMBOL_ATTR
	public	PMERR_INV_MATRIX_ELEMENT
	public	PMERR_INV_MAX_HITS
	public	PMERR_INV_METAFILE
	public	PMERR_INV_METAFILE_LENGTH
	public	PMERR_INV_METAFILE_OFFSET
	public	PMERR_INV_MICROPS_FUNCTION
	public	PMERR_INV_MICROPS_ORDER
	public	PMERR_INV_MIX_ATTR
	public	PMERR_INV_MODE_FOR_OPEN_DYN
	public	PMERR_INV_MODE_FOR_REOPEN_SEG
	public	PMERR_INV_MODIFY_PATH_MODE
	public	PMERR_INV_MULTIPLIER
	public	PMERR_INV_OR_INCOMPAT_OPTIONS
	public	PMERR_INV_ORDER_LENGTH
	public	PMERR_INV_ORDERING_PARM
	public	PMERR_INV_OUTSIDE_DRAW_MODE
	public	PMERR_INV_PAGE_VIEWPORT
	public	PMERR_INV_PATH_ID
	public	PMERR_INV_PATH_MODE
	public	PMERR_INV_PATTERN_ATTR
	public	PMERR_INV_PATTERN_REF_PT_ATTR
	public	PMERR_INV_PATTERN_SET_ATTR
	public	PMERR_INV_PATTERN_SET_FONT
	public	PMERR_INV_PICK_APERTURE_OPTION
	public	PMERR_INV_PICK_APERTURE_POSN
	public	PMERR_INV_PICK_APERTURE_SIZE
	public	PMERR_INV_PICK_NUMBER
	public	PMERR_INV_PLAY_METAFILE_OPTION
	public	PMERR_INV_PRIMITIVE_TYPE
	public	PMERR_INV_PS_SIZE
	public	PMERR_INV_QUERY_ELEMENT_NO
	public	PMERR_INV_RECT
	public	PMERR_INV_REGION_CONTROL
	public	PMERR_INV_REGION_MIX_MODE
	public	PMERR_INV_REPLACE_MODE_FUNC
	public	PMERR_INV_RESERVED_FIELD
	public	PMERR_INV_RESET_OPTIONS
	public	PMERR_INV_RGBCOLOR
	public	PMERR_INV_SCAN_START
	public	PMERR_INV_SEG_ATTR
	public	PMERR_INV_SEG_ATTR_VALUE
	public	PMERR_INV_SEG_CH_LENGTH
	public	PMERR_INV_SEG_NAME
	public	PMERR_INV_SEG_OFFSET
	public	PMERR_INV_SETID
	public	PMERR_INV_SHARPNESS_PARM
	public	PMERR_INV_SOURCE_OFFSET
	public	PMERR_INV_STOP_DRAW_VALUE
	public	PMERR_INV_TRANSFORM_TYPE
	public	PMERR_INV_USAGE_PARM
	public	PMERR_INV_VIEWING_LIMITS
	public	PMERR_KERNING_NOT_SUPPORTED
	public	PMERR_LABEL_NOT_FOUND
	public	PMERR_MATRIX_OVERFLOW
	public	PMERR_METAFILE_LIMIT_EXCEEDED
	public	PMERR_NO_BITMAP_SELECTED
	public	PMERR_NO_CURRENT_ELEMENT
	public	PMERR_NO_CURRENT_SEG
	public	PMERR_NO_METAFILE_RECORD_HANDLE
	public	PMERR_NOT_CREATED_BY_DEVOPENDC
	public	PMERR_NOT_IN_AREA
	public	PMERR_NOT_IN_DRAW_MODE
	public	PMERR_NOT_IN_ELEMENT
	public	PMERR_NOT_IN_IMAGE
	public	PMERR_NOT_IN_PATH
	public	PMERR_NOT_IN_RETAIN_MODE
	public	PMERR_NOT_IN_SEG
	public	PMERR_OTHER_SET_ID_REFS
	public	PMERR_OVERRAN_SEG
	public	PMERR_OWN_SET_ID_REFS
	public	PMERR_PATH_INCOMPLETE
	public	PMERR_PATH_LIMIT_EXCEEDED
	public	PMERR_PATH_UNKNOWN
	public	PMERR_PRIMITIVE_STACK_EMPTY
	public	PMERR_PROLOG_ERROR
	public	PMERR_PROLOG_SEG_ATTR_NOT_SET
	public	PMERR_PS_BUSY
	public	PMERR_PS_IS_ASSOCIATED
	public	PMERR_REALIZE_NOT_SUPPORTED
	public	PMERR_REGION_IS_CLIP_REGION
	public	PMERR_RESOURCE_DEPLETION
	public	PMERR_SEG_AND_REFSEG_ARE_SAME
	public	PMERR_SEG_CALL_RECURSIVE
	public	PMERR_SEG_CALL_STACK_EMPTY
	public	PMERR_SEG_CALL_STACK_FULL
	public	PMERR_SEG_IS_CURRENT
	public	PMERR_SEG_NOT_CHAINED
	public	PMERR_SEG_NOT_FOUND
	public	PMERR_SETID_IN_USE
	public	PMERR_SETID_NOT_FOUND
	public	PMERR_STARTDOC_NOT_ISSUED
	public	PMERR_STOP_DRAW_OCCURRED
	public	PMERR_TRUNCATED_ORDER
	public	PMERR_UNCHAINED_SEG_ZERO_INV
	public	PMERR_UNSUPPORTED_ATTR
	public	PMERR_UNSUPPORTED_ATTR_VALUE
	public	PMERR_INV_NESTED_FIGURES

	public	PMERR_INV_END_PATH_OPTIONS
	public	PMERR_INV_DRIVER_NAME
	public	PMERR_INV_SETID_TYPE
	public	PMERR_RAM_JNL_FILE_TOO_SMALL
	public	PMERR_JNL_FUNCTION_DATA_TOO_LONG
	public	PMERR_DEV_FUNC_NOT_INSTALLED
	public	PMERR_INV_SET_VIEWPORT_OPTION
	public	PMERR_INV_JOURNAL_OPTION
	public	PMERR_INV_HJOURNAL
	public	PMERR_INV_DRAW_BORDER_OPTION
	public	PMERR_INV_CURSOR_BITMAP
	public	PMERR_HUGE_FONTS_NOT_SUPPORTED
	public	PMERR_INV_ARC_POINTS
	public	PMERR_HDC_BUSY
	public	PMERR_HRGN_BUSY
	public	PMERR_HBITMAP_BUSY
	public	PMERR_JFILE_BUSY
	public	PMERR_INV_DEV_MODES_OPTIONS




PMERR_JNL_FUNCTION_DATA_TOO_LONG      equ     1


;/***************************************************************************
;*
;* MACRO NAME	 = ErrorMsg
;*
;* DESCRIPTION	 = ErrorMsg is the macro which will define each errro message.
;*		   Each error message can be accessed by an extrn declaration.
;*
;*		   Usage:
;*			 errmsg lbl,msg
;*
;*		   Where:
;*			 lbl - the name it will be referenced by
;*			 msg - the contents of the error message
;*
;*
;**************************************************************************/

ErrorMsg    MACRO   lbl,msg
ifdef FIREWALLS
  public lbl
  lbl	LABEL	WORD
	DB	'&msg',0
endif
ENDM
TEMP STRUC
 LO  DW ?
 HI  DW ?
TEMP ENDS


ifdef FIREWALLS

CODE32		segment DWORD USE32 PUBLIC 'code'
		ASSUME CS:FLAT, DS:FLAT, ES:FLAT, SS:FLAT
ErrorMsg	msg_BadBitmap,<Bad bitmap>
ErrorMsg	msg_BadDC,<Invalid DC>
ErrorMsg	msg_BadEngineSegment,<Bad engine segment>
ErrorMsg	msg_BadFreeCount,<Illegal number of blocks to free>
ErrorMsg	msg_BadLDEV,<Bad LDEV>
ErrorMsg	msg_BadPath,<Bad Path Header>
ErrorMsg	msg_BadPDEV,<Bad PDEV>
ErrorMsg	msg_BadRegionHeap,<Illegal Region Heap offset>
ErrorMsg	msg_BadXform,<Invalid Xform Block>
ErrorMsg	msg_Carry,<Carry flag should not be set>
ErrorMsg	msg_CodePathError,<Path error>
ErrorMsg	msg_DOSMemoryFailed,<DOS Alloc, Free, or ReAlloc failed>
ErrorMsg	msg_JnlBadEngineSegment,<Bad engine data segment>
ErrorMsg	msg_LcidBadDC,<Invalid DC>
ErrorMsg	msg_LcidBadEngineSegment,<Bad engine segment>
ErrorMsg	msg_LcidBadLCIDTable,<Missing LCID table identifier>
ErrorMsg	msg_NullExpected,<Null Pointer Expected>
ErrorMsg	msg_Overflow,<Overflow flag should not be set>
ErrorMsg	msg_PathBadDC,<Invalid DC>
ErrorMsg	msg_PathBadEngineSegment,<Bad engine segment>
ErrorMsg	msg_PathError,<Path error>
ErrorMsg	msg_PathPathError,<Path error>
ErrorMsg	msg_phs_cReferences,<AreaSegment reference count unreasonable>
ErrorMsg	msg_BadRegionSegment,<Bad Region segment>
ErrorMsg	msg_RegBadEngineSegment,<Bad engine segment>
ErrorMsg	msg_RegBadRegion,<Bad region>
ErrorMsg	msg_RegEngineError,<Engine error>
ErrorMsg	msg_Rgn_ScanTopBelowScanBottom,<Region: scan top and bottom crossed>
ErrorMsg	msg_SemNotEntered,<Routine not protected by semaphore>
ErrorMsg	msg_ShortlineWrongHeight,<Shortline rasterized to wrong height>
ErrorMsg	msg_UnlinkDoesntHaveSem,<unlink not protected by semaphore>
ErrorMsg	msg_WinFreeMemError,<WinFreeMem>
ErrorMsg	msg_XformBadDC,<Invalid DC>
ErrorMsg	msg_XformBadEngineSegment,<Bad engine segment>
ErrorMsg	msg_BadXsaveData,<Bad Xsave Data>
ErrorMsg	msg_XformBlockMoved,<Xsaved XformBlock moved>
ErrorMsg	msg_Rgn_bad_bbox,<Region: bad BBox>
ErrorMsg	msg_Rgn_not_infinity,<Region: lacking infinity>
ErrorMsg	msg_Rgn_pntcnt_not_even,<Region: PntCnt is not even>
ErrorMsg	msg_Rgn_scans_dont_touch,<Region: scans fail to touch>
ErrorMsg	msg_Rgn_scnptcnttoo_wrong,<Region: ScnPtCntToo is wrong>
ErrorMsg	msg_Rgn_top_bottom_wrong,<Region: scan top not gt bottom>
ErrorMsg	msg_Rgn_wrong_maxscan,<Region: wrong MaxScan>
ErrorMsg	msg_Rgn_wrong_null_size,<Region: wrong null size>
ErrorMsg	msg_Rgn_wrong_rgnsize,<Region: wrong rgnSize>
ErrorMsg	msg_Rgn_x_overlap,<Region: rectagles h-overlap>
ErrorMsg	msg_Rgn_y_redundancy,<Region: y redundancy>
ErrorMsg	msg_JNL_seek_too_big,<Journal: seek distance too big>

;/*
;** Public-Routine
;*/

;/***************************************************************************
;*
;* FUNCTION NAME = perform_rip
;*
;* DESCRIPTION	 = The given error message is passed to WinSetErrorInfo with the
;*		   abort flag set
;*
;*		   Registers Preserved:
;*			 all
;*		   Registers Destroyed:
;*			 none
;*
;*
;* INPUT	 = NONE
;*
;* OUTPUT	 = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

SEIOptions = SEI_REGISTERS+SEI_STACKTRACE

cProc	perform_rip,<PUBLIC,NODATA>
	parmD	npError
	localV	errorid,%(TEMP)
cBegin
	pushfD
	pushaD
	push	es
	mov	word ptr errorid.lo, 1
	mov	word ptr errorid.hi, SEVERITY_SEVERE
	cCall	WinSetErrorInfo,<errorid,SEIOptions,npError>,<C>
	pop	es
	popaD
	popfD
cEnd

CODE32	      ends

endif
end
