/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#define PLOT_OPTCALL      _Optlink
#define PLOT_ASMCALL      _System
#define PLOT_OVERFLOW          4
#define PLOT_NUM_IS_ZERO       1
#define PLOT_NUM_IS_NEGATIVE   2

typedef LONG LFLAG;       // This is a reverse-BOOL: 0 means NO ERROR
                          // Positive values are those #defined above.

typedef struct _FXQUAD {
   USHORT uspad;
   USHORT usFrac;
   ULONG  ulInt;
} FXQUAD;
typedef FXQUAD *PFXQUAD;

#pragma linkage(FXToFXQuad, optlink)
VOID  PLOT_OPTCALL FXToFXQuad(FXQUAD *pFXQ, LONG   lVal);


LONG  PLOT_ASMCALL L_LDivFX(LONG  lNumerator,
                           FIXED fxDenominator);

#pragma linkage(FX_FXMulFX, optlink)
FIXED PLOT_OPTCALL FX_FXMulFX(FIXED fx1,
                             FIXED fx2);

#pragma linkage(AddFXQuad, optlink)
LFLAG PLOT_OPTCALL AddFXQuad(FXQUAD *pFXQ1, FXQUAD *pFXQ2, FXQUAD *pFXQ3);
                 // return GRE_OVERFLOW, or 0.


LONG  PLOT_ASMCALL quad_square_root(QUAD *pQuad);        // In: EDX:EAX
                                            // Return: EAX

FIXED PLOT_ASMCALL fxmultiply(QUAD *pQuad,
                             LONG x,
                             LONG y,
                             LONG *pOFlag);

FIXED PLOT_ASMCALL iq_div(QUAD  *pQuad,                   // In: EDX:EAX
                         ULONG ulDenominator,            // In: EBX
                         ULONG *pRemainder,              // Out: EDX
                         LONG  *pOFlag);                 // Out: OF
                                            // Return: EAX
