/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#pragma  pagesize(55)

/**************************************************************************
 *
 * SOURCE FILE NAME =  CHARGEN.C
 *
 * DESCRIPTIVE NAME =
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE        09/18/88
 *
 * DESCRIPTION File contains device font character output functions
 *
 *
 * FUNCTIONS   construct_char()    Generate sequence of commands
 *
 *
 *
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define  INCL_32

#include "plotters.h"
#include "chargen.h"
#include "dosio.h"
#include "utils.h"

/*
** The following table provides a mapping for the byte values from
** 127 to 315 into character set 7 on the plotter.  Character set 7
** is not always available, so the second table is provided.  This
** generates the same pattern by overdrawing, using standard
** characters and the special (and always available) backup &
** overdraw characters.
**
*/

/*
** .. above: umlaat,  ` is acute,  ' is grave:  for the record
*/

LOCAL BYTE CharSetSeven[] =
{
  EMPTY,                               /* 127: A little house               */
  52,                                  /* 128: C cedilla (with ,            */
                                       /* underneath)                       */
  79,                                  /* 129: u with umlaat                */
  69,                                  /* 130: e with grave                 */
  64,                                  /* 131: a circumflex                 */
  76,                                  /* 132: a umlaat                     */
  72,                                  /* 133: a with acute                 */
  84,                                  /* 134: a with circle above          */
  53,                                  /* 135: c cedilla                    */
  65,                                  /* 136: e circumflex                 */
  77,                                  /* 137: e umlaat                     */
  73,                                  /* 138: e acute                      */
  93,                                  /* 139: i umlasat                    */
  81,                                  /* 140: i circumflex                 */
  89,                                  /* 141: i acute                      */
  88,                                  /* 142: A umlaat                     */
  80,                                  /* 143: A with circle above          */
  92,                                  /* 144: E grave                      */
  87,                                  /* 145: ae as a single symbol        */
  83,                                  /* 146: AE as a single symbol        */
  66,                                  /* 147: o circumflex                 */
  78,                                  /* 148: o umlaat                     */
  74,                                  /* 149: o acute                      */
  67,                                  /* 150: u circumflex                 */
  75,                                  /* 151: u acute                      */
  111,                                 /* 152: y umlaat                     */
  90,                                  /* 153: O umlaat                     */
  91,                                  /* 154: U umlaat                     */
  86,                                  /* 155: o with a slash               */
  59,                                  /* 156: currency pound sign          */
  82,                                  /* 157: O with a slash               */
  EMPTY,                               /* 158: multiply sign -              */
                                       /* approximation here                */
  62,                                  /* 159: script f                     */
  68,                                  /* 160: a grave                      */
  85,                                  /* 161: i grave                      */
  70,                                  /* 162: o grave                      */
  71,                                  /* 163: u grave                      */
  55,                                  /* 164: n cedilla                    */
  54,                                  /* 165: N cedilla                    */
  121,                                 /* 166: superscript, underlined a    */
  122,                                 /* 167: superscript, underlined o    */
  57,                                  /* 168: upside down ?                */
  EMPTY,                               /* 169: small R with circle around   */
                                       /* it                                */
  118,                                 /* 170: minus sign with vertical bar */
                                       /* RHS                               */
  120,                                 /* 171: 1/2                          */
  119,                                 /* 172: 1/4                          */
  EMPTY,                               /* 173: NOT READILY DESCRIBABLE      */
  123,                                 /* 174: <<                           */
  125,                                 /* 175: >>                           */
  EMPTY,                               /* 176: checkerboard pattern         */
  EMPTY,                               /* 177: different chckerboard        */
                                       /* pattern                           */
  EMPTY,                               /* 178: ditto                        */
  EMPTY,                               /* 179: small vertical line          */
  EMPTY,                               /* 180: T on its side - simulate?    */
  96,                                  /* 181: A grave                      */
  34,                                  /* 182: A circumflex                 */
  33,                                  /* 183: A acute                      */
  EMPTY,                               /* 184: copyright sign: C in a       */
                                       /* circle                            */
  EMPTY,                               /* 185: hollow T on side - simulate? */
  EMPTY,                               /* 186: drawing primitive            */
  EMPTY,                               /* 187: drawing primitive            */
  EMPTY,                               /* 188: drawing primitive            */
  63,                                  /* 189: cent symbol                  */
  60,                                  /* 190: Yen symbol                   */
  EMPTY,                               /* 191: drawing primitive            */
  EMPTY,                               /* 192: drawing primitive            */
  EMPTY,                               /* 193: drawing primitive            */
  EMPTY,                               /* 194: drawing primitive            */
  EMPTY,                               /* 195: drawing primitive            */
  EMPTY,                               /* 196: drawing primitive            */
  EMPTY,                               /* 197: drawing primitive            */
  98,                                  /* 198: a cedilla                    */
  97,                                  /* 199: A cedilla                    */
  EMPTY,                               /* 200: drawing primitive            */
  EMPTY,                               /* 201: drawing primitive            */
  EMPTY,                               /* 202: drawing primitive            */
  EMPTY,                               /* 203: drawing primitive            */
  EMPTY,                               /* 204: drawing primitive            */
  EMPTY,                               /* 205: drawing primitive            */
  EMPTY,                               /* 206: drawing primitive            */
  58,                                  /* 207: circle with spikes           */
  EMPTY,                               /* 208: mirror image 6 with crossed  */
                                       /* top                               */
  99,                                  /* 209: D with stroke through left   */
                                       /* vertical                          */
  36,                                  /* 210: E circumflex                 */
  37,                                  /* 211: E umlaat                     */
  35,                                  /* 212: E acute                      */
  56,                                  /* 213: small 1 or l                 */
  101,                                 /* 214: I grave                      */
  38,                                  /* 215: I circumflex                 */
  39,                                  /* 216: I umlaat                     */
  EMPTY,                               /* 217: drawing primitive            */
  EMPTY,                               /* 218: drawing primitive            */
  EMPTY,                               /* 219: a blob                       */
  EMPTY,                               /* 220: a half size blob             */
  EMPTY,                               /* 221: vertical line with gap in    */
                                       /* middle                            */
  102,                                 /* 222: I acute                      */
  EMPTY,                               /* 223: top half of 220              */
  103,                                 /* 224: O grave                      */
  94,                                  /* 225: like Greek beta              */
  95,                                  /* 226: O circumflex                 */
  104,                                 /* 227: O acute                      */
  106,                                 /* 228: o with a ~                   */
  105,                                 /* 229: O with ~                     */
  EMPTY,                               /* 230: mu                           */
  113,                                 /* 231: like a p                     */
  112,                                 /* 232: ditto                        */
  109,                                 /* 233: U grave                      */
  46,                                  /* 234: U circumflex                 */
  45,                                  /* 235: U acute                      */
  EMPTY,                               /* 236: y grave                      */
  EMPTY,                               /* 237: Y grave                      */
  48,                                  /* 238: superscript horizontal line  */
  40,                                  /* 239: grave accent                 */
  118,                                 /* 240: minus sign?                  */
  126,                                 /* 241: plus or minus sign           */
  EMPTY,                               /* 242: strange underline            */
  EMPTY,                               /* 243: 3/4                          */
  EMPTY,                               /* 244: sort of mirror image p       */
  61,                                  /* 245: paragraph sign               */
  EMPTY,                               /* 246: divide by sign               */
  EMPTY,                               /* 247: cedilla                      */
  51,                                  /* 248: small circle - accent mark?  */
  43,                                  /* 249: umlaat                       */
  EMPTY,                               /* 250: dot about middle of          */
                                       /* character                         */
  EMPTY,                               /* 251: superscript 1                */
  EMPTY,                               /* 252: superscript 3                */
  EMPTY,                               /* 253: superscript 2                */
  EMPTY,                               /* 254: blob in middle of line       */
  EMPTY,                               /* 255: a narrow space ?             */
  EMPTY,                               /* 256: Pts as a single character    */
  EMPTY,                               /* 257: drawing primitive            */
  EMPTY,                               /* 258: drawing primitive            */
  EMPTY,                               /* 259: drawing primitive            */
  EMPTY,                               /* 260: drawing primitive            */
  EMPTY,                               /* 261: drawing primitive            */
  EMPTY,                               /* 262: drawing primitive            */
  EMPTY,                               /* 263: drawing primitive            */
  EMPTY,                               /* 264: drawing primitive            */
  EMPTY,                               /* 265: drawing primitive            */
  EMPTY,                               /* 266: drawing primitive            */
  EMPTY,                               /* 267: drawing primitive            */
  EMPTY,                               /* 268: drawing primitive            */
  EMPTY,                               /* 269: drawing primitive            */
  EMPTY,                               /* 270: drawing primitive            */
  EMPTY,                               /* 271: drawing primitive            */
  EMPTY,                               /* 272: drawing primitive            */
  EMPTY,                               /* 273: drawing primitive            */
  EMPTY,                               /* 274: drawing primitive            */
  EMPTY,                               /* 275: drawing primitive            */
  EMPTY,                               /* 276: drawing primitive            */
  EMPTY,                               /* 277: drawing primitive            */
  EMPTY,                               /* 278: alpha                        */
  EMPTY,                               /* 279: greek letter                 */
  EMPTY,                               /* 280: pi                           */
  EMPTY,                               /* 281: capital sigma                */
  EMPTY,                               /* 282: greek letter                 */
  EMPTY,                               /* 283: greek letter                 */
  EMPTY,                               /* 284: greek letter                 */
  EMPTY,                               /* 285: greek letter                 */
  EMPTY,                               /* 286: greek letter                 */
  EMPTY,                               /* 287: greek letter                 */
  EMPTY,                               /* 288: infinity symbol              */
  EMPTY,                               /* 289: greek letter                 */
  EMPTY,                               /* 290: lower case sigma             */
  EMPTY,                               /* 291: intersection symbol          */
  EMPTY,                               /* 292: mathematical symbol: 3 lines *
                                       /* =                                 */
  EMPTY,                               /* 293: >= as one symbol             */
  EMPTY,                               /* 294: <= as one symbol             */
  EMPTY,                               /* 295: Top of integral sign         */
  EMPTY,                               /* 296: Bottom of integral sign      */
  EMPTY,                               /* 297: approximately equal          */
  EMPTY,                               /* 298: period in middle of          *
                                       /* character                         */
  EMPTY,                               /* 299: square root                  */
  EMPTY,                               /* 300: small n in middle of M       *
                                       /* square                            */
  48,                                  /* 301: line across top of M square  */
  EMPTY,                               /* 302: bowed version of above       */
  51,                                  /* 303: dot at top of M square       */
  51,                                  /* 304: as above, only a circle      */
  EMPTY,                               /* 305: double grave accent marks    */
  EMPTY,                               /* 306: mirror image cedilla         */
  EMPTY,                               /* 307: very small v at top of M     *
                                       /* square                            */
  EMPTY,                               /* 308: like a '                     */
  EMPTY,                               /* 309: like a `                     */
  EMPTY,                               /* 310: opening "                    */
  EMPTY,                               /* 311: closing "                    */
  EMPTY,                               /* 312: drawing primitive?           */
  EMPTY,                               /* 313: longer version of above      */
  42,                                  /* 314: circumflex                   */
  44,                                  /* 315: tilde                        */
} ;

#define  CHARSET7_COUNT (sizeof( CharSetSeven )/sizeof( CharSetSeven[ 0 ] ))

/*
** Second (of two) extended character tables.  The values in this
** table come in pairs.  The first byte indicates the character set to
** use for this operation, the second indicates the character from
** that set to use.  The second pair looks the same, but.....  If the
** first value (character set) is 0xff, no value is required.
** Otherwise, it is another character set/character value pair.  NOTE:
** THE CODE ASSUMES THAT THE CHARACTER SET IS THE SAME FOR BOTH PAIRS.
*/

#define  NONE          (BYTE)0xff      /* No value available                */
LOCAL BYTE MixedCharSet[][4] =
{
  {
    NONE
  } ,                                  /* 127: A little house               */
  {
    NONE
  } ,                                  /* 128: C cedilla (with ,
                                          underneath)                       */
  {
    2,              'u',            2,              123
  } ,                                  /* 129: u with umlaat                */
  {
    2,              'e',            2,              39
  } ,                                  /* 130: e with grave                 */
  {
    2,              'a',            2,              94
  } ,                                  /* 131: a circumflex                 */
  {
    2,              'a',            2,              123
  } ,                                  /* 132: a umlaat                     */
  {
    2,              'a',            2,              96
  } ,                                  /* 133: a with acute                 */
  {
    2,              'a',            2,              124
  } ,                                  /* 134: a with circle above          */
  {
    2,              92,             NONE
  } ,                                  /* 135: c cedilla                    */
  {
    2,              'e',            2,              94
  } ,                                  /* 136: e circumflex                 */
  {
    2,              'e',            2,              123
  } ,                                  /* 137: e umlaat                     */
  {
    2,              'e',            2,              96
  } ,                                  /* 138: e acute                      */
  {
    2,              'i',            2,              123
  } ,                                  /* 139: i umlaat                     */
  {
    2,              'i',            2,              94
  } ,                                  /* 140: i circumflex                 */
  {
    2,              'i',            2,              96
  } ,                                  /* 141: i acute                      */
  {
    2,              'A',            2,              123
  } ,                                  /* 142: A umlaat                     */
  {
    2,              'A',            2,              124
  } ,                                  /* 143: A with circle above          */
  {
    2,              'E',            2,              39
  } ,                                  /* 144: E grave                      */
  {
    3,              94,             NONE
  } ,                                  /* 145: ae as a single symbol        */
  {
    3,              92,             NONE
  } ,                                  /* 146: AE as a single symbol        */
  {
    2,              'o',            2,              94
  } ,                                  /* 147: o circumflex                 */
  {
    2,              'o',            2,              123
  } ,                                  /* 148: o umlaat                     */
  {
    2,              'o',            2,              96
  } ,                                  /* 149: o acute                      */
  {
    2,              'u',            2,              94
  } ,                                  /* 150: u circumflex                 */
  {
    2,              'u',            2,              96
  } ,                                  /* 151: u acute                      */
  {
    2,              'y',            2,              123
  } ,                                  /* 152: y umlaat                     */
  {
    2,              'O',            2,              123
  } ,                                  /* 153: O umlaat                     */
  {
    2,              'U',            2,              123
  } ,                                  /* 154: U umlaat                     */
  {
    3,              93,             NONE
  } ,                                  /* 155: o with a slash               */
  {
    2,              35,             NONE
  } ,                                  /* 156: currency pound sign          */
  {
    3,              91,             NONE
  } ,                                  /* 157: O with a slash               */
  {
    NONE
  } ,                                  /* 158: multiply sign -
                                          approximation here                */
  {
    NONE
  } ,                                  /* 159: script f                     */
  {
    2,              'a',            2,              39
  } ,                                  /* 160: a grave                      */
  {
    2,              'i',            2,              39
  } ,                                  /* 161: i grave                      */
  {
    2,              'o',            2,              39
  } ,                                  /* 162: o grave                      */
  {
    2,              'u',            2,              39
  } ,                                  /* 163: u grave                      */
  {
    1,              'n',            1,              126
  } ,                                  /* 164: n cedilla                    */
  {
    1,              'N',            1,              126
  } ,                                  /* 165: N cedilla                    */
  {
    NONE
  } ,                                  /* 166: superscript, underlined a    */
  {
    NONE
  } ,                                  /* 167: superscript, underlined o    */
  {
    4,              35,             NONE
  } ,                                  /* 168: upside down ?                */
  {
    NONE
  } ,                                  /* 169: small R with circle around
                                          it                                */
  {
    NONE
  } ,                                  /* 170: minus sign with vertical bar
                                          RHS                               */
  {
    NONE
  } ,                                  /* 171: 1/2                          */
  {
    NONE
  } ,                                  /* 172: 1/4                          */
  {
    NONE
  } ,                                  /* 173: NOT READILY DESCRIBABLE      */
  {
    NONE
  } ,                                  /* 174: <<                           */
  {
    NONE
  } ,                                  /* 175: >>                           */
  {
    NONE
  } ,                                  /* 176: checkerboard pattern         */
  {
    NONE
  } ,                                  /* 177: different chckerboard
                                          pattern                           */
  {
    NONE
  } ,                                  /* 178: ditto                        */
  {
    NONE
  } ,                                  /* 179: small vertical line          */
  {
    NONE
  } ,                                  /* 180: T on its side - simulate?    */
  {
    2,              'A',            2,              39
  } ,                                  /* 181: A grave                      */
  {
    2,              'A',            2,              94
  } ,                                  /* 182: A circumflex                 */
  {
    2,              'A',            2,              96
  } ,                                  /* 183: A acute                      */
  {
    NONE
  } ,                                  /* 184: copyright sign: C in a
                                          circle                            */
  {
    NONE
  } ,                                  /* 185: hollow T on side - simulate? */
  {
    NONE
  } ,                                  /* 186: drawing primitive            */
  {
    NONE
  } ,                                  /* 187: drawing primitive            */
  {
    NONE
  } ,                                  /* 188: drawing primitive            */
  {
    NONE
  } ,                                  /* 189: cent symbol                  */
  {
    NONE
  } ,                                  /* 190: Yen symbol                   */
  {
    NONE
  } ,                                  /* 191: drawing primitive            */
  {
    NONE
  } ,                                  /* 192: drawing primitive            */
  {
    NONE
  } ,                                  /* 193: drawing primitive            */
  {
    NONE
  } ,                                  /* 194: drawing primitive            */
  {
    NONE
  } ,                                  /* 195: drawing primitive            */
  {
    NONE
  } ,                                  /* 196: drawing primitive            */
  {
    NONE
  } ,                                  /* 197: drawing primitive            */
  {
    1,              'a',            1,              126
  } ,                                  /* 198: a cedilla                    */
  {
    1,              'A',            1,              126
  } ,                                  /* 199: A cedilla                    */
  {
    NONE
  } ,                                  /* 200: drawing primitive            */
  {
    NONE
  } ,                                  /* 201: drawing primitive            */
  {
    NONE
  } ,                                  /* 202: drawing primitive            */
  {
    NONE
  } ,                                  /* 203: drawing primitive            */
  {
    NONE
  } ,                                  /* 204: drawing primitive            */
  {
    NONE
  } ,                                  /* 205: drawing primitive            */
  {
    NONE
  } ,                                  /* 206: drawing primitive            */
  {
    NONE
  } ,                                  /* 207: circle with spikes           */
  {
    NONE
  } ,                                  /* 208: mirror image 6 with crossed
                                          top                               */
  {
    NONE
  } ,                                  /* 209: D with stroke through left
                                          vertical                          */
  {
    2,              'E',            2,              94
  } ,                                  /* 210: E circumflex                 */
  {
    2,              'E',            2,              123
  } ,                                  /* 211: E umlaat                     */
  {
    2,              'E',            2,              96
  } ,                                  /* 212: E acute                      */
  {
    NONE
  } ,                                  /* 213: small 1 or l                 */
  {
    2,              'I',            2,              39
  } ,                                  /* 214: I grave                      */
  {
    2,              'I',            2,              94
  } ,                                  /* 215: I circumflex                 */
  {
    2,              'I',            2,              123
  } ,                                  /* 216: I umlaat                     */
  {
    NONE
  } ,                                  /* 217: drawing primitive            */
  {
    NONE
  } ,                                  /* 218: drawing primitive            */
  {
    NONE
  } ,                                  /* 219: a blob                       */
  {
    NONE
  } ,                                  /* 220: a half size blob             */
  {
    NONE
  } ,                                  /* 221: vertical line with gap in
                                          middle                            */
  {
    2,              'I',            2,              96
  } ,                                  /* 222: I acute                      */
  {
    NONE
  } ,                                  /* 223: top half of 220              */
  {
    2,              'O',            2,              39
  } ,                                  /* 224: O grave                      */
  {
    NONE
  } ,                                  /* 225: like Greek beta              */
  {
    2,              'O',            2,              94
  } ,                                  /* 226: O circumflex                 */
  {
    2,              'O',            2,              96
  } ,                                  /* 227: O acute                      */
  {
    1,              'o',            1,              126
  } ,                                  /* 228: o with ~                     */
  {
    1,              'O',            1,              126
  } ,                                  /* 229: O with ~                     */
  {
    NONE
  } ,                                  /* 230: mu                           */
  {
    NONE
  } ,                                  /* 231: like a p                     */
  {
    NONE
  } ,                                  /* 232: ditto                        */
  {
    2,              'U',            2,              39
  } ,                                  /* 233: U grave                      */
  {
    2,              'U',            2,              94
  } ,                                  /* 234: U circumflex                 */
  {
    2,              'U',            2,              96
  } ,                                  /* 235: U acute                      */
  {
    2,              'y',            2,              39
  } ,                                  /* 236: y grave                      */
  {
    2,              'Y',            2,              39
  } ,                                  /* 237: Y grave                      */
  {
    NONE
  } ,                                  /* 238: superscript horizontal line  */
  {
    2,              39,             NONE
  } ,                                  /* 239: grave accent                 */
  {
    2,              '-'
  } ,                                  /* 240: minus sign?                  */
  {
    NONE
  } ,                                  /* 241: plus or minus sign           */
  {
    NONE
  } ,                                  /* 242: strange underline            */
  {
    NONE
  } ,                                  /* 243: 3/4                          */
  {
    NONE
  } ,                                  /* 244: sort of mirror image p       */
  {
    NONE
  } ,                                  /* 245: paragraph sign               */
  {
    NONE
  } ,                                  /* 246: divide by sign               */
  {
    NONE
  } ,                                  /* 247: cedilla                      */
  {
    2,              ' ',            2,              124
  } ,                                  /* 248: small circle - accent mark?  */
  {
    2,              ' ',            2,              123
  } ,                                  /* 249: umlaat                       */
  {
    NONE
  } ,                                  /* 250: dot about middle of
                                          character                         */
  {
    NONE
  } ,                                  /* 251: superscript 1                */
  {
    NONE
  } ,                                  /* 252: superscript 3                */
  {
    NONE
  } ,                                  /* 253: superscript 2                */
  {
    NONE
  } ,                                  /* 254: blob in middle of line       */
  {
    NONE
  } ,                                  /* 255: a narrow space ?             */
  {
    NONE
  } ,                                  /* 256: Pts as a single character    */
  {
    NONE
  } ,                                  /* 257: drawing primitive            */
  {
    NONE
  } ,                                  /* 258: drawing primitive            */
  {
    NONE
  } ,                                  /* 259: drawing primitive            */
  {
    NONE
  } ,                                  /* 260: drawing primitive            */
  {
    NONE
  } ,                                  /* 261: drawing primitive            */
  {
    NONE
  } ,                                  /* 262: drawing primitive            */
  {
    NONE
  } ,                                  /* 263: drawing primitive            */
  {
    NONE
  } ,                                  /* 264: drawing primitive            */
  {
    NONE
  } ,                                  /* 265: drawing primitive            */
  {
    NONE
  } ,                                  /* 266: drawing primitive            */
  {
    NONE
  } ,                                  /* 267: drawing primitive            */
  {
    NONE
  } ,                                  /* 268: drawing primitive            */
  {
    NONE
  } ,                                  /* 269: drawing primitive            */
  {
    NONE
  } ,                                  /* 270: drawing primitive            */
  {
    NONE
  } ,                                  /* 271: drawing primitive            */
  {
    NONE
  } ,                                  /* 272: drawing primitive            */
  {
    NONE
  } ,                                  /* 273: drawing primitive            */
  {
    NONE
  } ,                                  /* 274: drawing primitive            */
  {
    NONE
  } ,                                  /* 275: drawing primitive            */
  {
    NONE
  } ,                                  /* 276: drawing primitive            */
  {
    NONE
  } ,                                  /* 277: drawing primitive            */
  {
    NONE
  } ,                                  /* 278: alpha                        */
  {
    NONE
  } ,                                  /* 279: greek letter                 */
  {
    1,              123,            NONE
  } ,                                  /* 280: pi                           */
  {
    NONE
  } ,                                  /* 281: capital sigma                */
  {
    NONE
  } ,                                  /* 282: greek letter                 */
  {
    NONE
  } ,                                  /* 283: greek letter                 */
  {
    NONE
  } ,                                  /* 284: greek letter                 */
  {
    NONE
  } ,                                  /* 285: greek letter                 */
  {
    NONE
  } ,                                  /* 286: greek letter                 */
  {
    NONE
  } ,                                  /* 287: greek letter                 */
  {
    NONE
  } ,                                  /* 288: infinity symbol              */
  {
    NONE
  } ,                                  /* 289: greek letter                 */
  {
    NONE
  } ,                                  /* 290: lower case sigma             */
  {
    NONE
  } ,                                  /* 291: intersection symbol          */
  {
    NONE
  } ,                                  /* 292: mathematical symbol: 3 lines
                                          =                                 */
  {
    NONE
  } ,                                  /* 293: >= as one symbol             */
  {
    NONE
  } ,                                  /* 294: <= as one symbol             */
  {
    NONE
  } ,                                  /* 295: Top of integral sign         */
  {
    NONE
  } ,                                  /* 296: Bottom of integral sign      */
  {
    NONE
  } ,                                  /* 297: approximately equal          */
  {
    NONE
  } ,                                  /* 298: period in middle of
                                          character                         */
  {
    1,              92,             NONE
  } ,                                  /* 299: square root                  */
  {
    NONE
  } ,                                  /* 300: small n in middle of M
                                          square                            */
  {
    NONE
  } ,                                  /* 301: line across top of M square  */
  {
    NONE
  } ,                                  /* 302: bowed version of above       */
  {
    3,              ' ',            3,              126
  } ,                                  /* 303: dot at top of M square       */
  {
    2,              ' ',            2,              124
  } ,                                  /* 304: as above, only a circle      */
  {
    NONE
  } ,                                  /* 305: double grave accent marks    */
  {
    NONE
  } ,                                  /* 306: mirror image cedilla         */
  {
    NONE
  } ,                                  /* 307: very small v at top of M
                                          square                            */
  {
    NONE
  } ,                                  /* 308: like a '                     */
  {
    NONE
  } ,                                  /* 309: like a `                     */
  {
    NONE
  } ,                                  /* 310: opening "                    */
  {
    NONE
  } ,                                  /* 311: closing "                    */
  {
    NONE
  } ,                                  /* 312: drawing primitive?           */
  {
    NONE
  } ,                                  /* 313: longer version of above      */
  {
    2,              ' ',            2,              94
  } ,                                  /* 314: circumflex                   */
  {
    1,              ' ',            1,              126
  } ,                                  /* 315: tilde                        */
} ;

#define  MIXED_CHARSET_COUNT (sizeof( MixedCharSet )/sizeof( MixedCharSet[ 0])\
)

/***************************************************************************
 *
 * FUNCTION NAME = construct_char()
 *
 *
 * DESCRIPTION   = Generate sequence of commands
 *                 Generate the sequence of commands to produce the
 *                 desired character.  Whatever manipulation is
 *                 required is performed, and this may mean switching
 *                 to another character set.
 *
 *
 *
 * INPUT         = PDDC     pDDC;
 *                 UCHAR    uchChar;
 *                 USHORT   usMode;
 *
 *
 *
 * OUTPUT        = NONE
 *
 *
 * RETURN-NORMAL = TRUE  - a drawing character was output
 *
 *
 *
 * RETURN-ERROR  = FALSE - a blank character was output
 *
 *
 *
 **************************************************************************/

BOOL construct_char( PDDC pDDC, UCHAR uchChar, USHORT usMode )

/*  UCHAR uchChar;                        The character to be generated     */
/*  USHORT usMode;                        Controls various operations       */
{

  /*
  **   Generate the symbol on the plotter.  pDDC is the DDC for which this
  ** this service is required,  and Char is the character to be produced.
  */


  USHORT usChar;                       /* Local version, after possible
                                          code page                         */
  PPDEVICE pPDevice = pDDC->pPDevice;
  BOOL  bStandardCharSetActive = pPDevice->bStandardCharSetActive;
  BOOL  bStringInConstruction = pPDevice->bStringInConstruction;
  SHORT AltCharSet = (SHORT)pPDevice->AltCharSet;
  SHORT CurStringLength = 0;
  CHAR  OutChar;                       /* Mapped output character           */
  CHAR  CurString[32];

  OutChar = EMPTY;                     /* Default case                      */
  FNTDBGMSG("\n\r\n\rPLOTTERS:  enter construct_char");

  if (pDDC->pCPVector)
  {
  /*
  ** Code page mapping is in effect
  */
    usChar = *(pDDC->pCPVector + uchChar);
  }
  else
    usChar = uchChar;                  /* Character as is                   */

  if (!bStringInConstruction)
  {
    /*
    ** Will start to need string,  so start it now,  for convenience
    */
    check_line_construction(pDDC);
    CurString[0] = 'L';
    CurString[1] = 'B';
    CurStringLength = 2;
    bStringInConstruction = TRUE;      /* Is now                            */
  }

  if (usChar < ASCII_MAX)
  {
    /*
    ** Standard ASCII - note: HP do not define a pattern for
    ** ascii value ASCII_MAX,  so the above test is correct.
    */
    if (usChar < ASCII_MIN)
      usChar = EMPTY;                  /* Lower chars blanked out           */

    if (!bStandardCharSetActive && usChar != EMPTY)
    {
      /*
      ** Not in standard character set,  so switch to it.
      */
      CurString[CurStringLength++] = SET_STANDARD_CHAR_SET;
      bStandardCharSetActive = TRUE;
    }

    if (usMode & CC_BACKSPACE)
      CurString[CurStringLength++] = '\b';
    OutChar = CurString[CurStringLength++] = (CHAR)usChar;
  }
  else
  {
    /*
    **  Need to use one of the extended character sets.  If available,
    **  use character set 7, as this can draw the character with one
    **  byte sent to the plotter.  Otherwise,  need to select the
    **  alternate character set to use,  then send the one or two
    **  bytes required.
    */
    usChar -= ASCII_MAX;               /* Tables are zero based             */

    if (pPDevice->AltCharSet == 7)
    {
      /*
      **  Character set 7 is available - just switch to it
      */
      if (usChar >= CHARSET7_COUNT)
        usChar = EMPTY;                /* A blank                           */

      if (bStandardCharSetActive && usChar != EMPTY)
      {
        /*
        ** Need to switch to alternative set
        */
        CurString[CurStringLength++] = SET_ALTERNATE_CHAR_SET;
        bStandardCharSetActive = FALSE;
      }

      if (usMode&CC_BACKSPACE)
        CurString[CurStringLength++] = '\b';
      OutChar = CurString[CurStringLength++] = CharSetSeven[usChar];
    }
    else
    {
      /*
      **      Use the slower second table - slower because it involves
      **  building up the character from primitives.  But only do so
      **  if this is possible - there may be no representation at all.
      */
      if (usChar < MIXED_CHARSET_COUNT && MixedCharSet[usChar][0] != NONE)
      {
        /*
        ** Must use the slower alternative table.
        */
        BYTE AltSet;

        AltSet = MixedCharSet[usChar][0];

        if (AltCharSet != AltSet)
        {
          /*
          ** Need to switch to a different alternate set.
          ** Which set is specified in the second table above.
          */
          if (CurStringLength == 2)
          {
            /*
            ** Just about to start a string,  so zap what is there
            */
            CurStringLength = 0;
          }
          else
            if (bStringInConstruction)
            {
              /*
              ** String under way,  need to terminate it!
              */
              CurString[CurStringLength++] = ETX;
            }
          bStringInConstruction = FALSE;

          /*
          ** Need to tell the plotter which set to use
          */
          CurString[CurStringLength++] = 'C';
          CurString[CurStringLength++] = 'A';
          CurStringLength += int_to_str((LONG)AltSet,
                                        (PSZ)&CurString[CurStringLength],
                                        1);
          AltCharSet = AltSet;
        }

        if (!bStringInConstruction)
        {
          /*
          ** Need to start the string!
          */
          CurString[CurStringLength++] = 'L';
          CurString[CurStringLength++] = 'B';
          bStringInConstruction = TRUE;
        }

        if (bStandardCharSetActive)
        {
          CurString[CurStringLength++] = SET_ALTERNATE_CHAR_SET;
          bStandardCharSetActive = FALSE;
        }
        /*
        **    Have string in construction,  correct character set
        **  selected and active,  so output the special characters.
        */
        if (usMode & CC_BACKSPACE)
          CurString[CurStringLength++] = '\b';
        OutChar = CurString[CurStringLength++] = MixedCharSet[usChar][1];

        if (MixedCharSet[usChar][2] != NONE)
          CurString[CurStringLength++] = MixedCharSet[usChar][3];
      }
      else
        if (!(usMode&CC_BACKSPACE))
          CurString[CurStringLength++] = EMPTY;/* No mapping                */
    }
  }

  pPDevice->bStandardCharSetActive = bStandardCharSetActive;
  pPDevice->AltCharSet = AltCharSet;
  pPDevice->bStringInConstruction = bStringInConstruction;

  /*
  ** should check here that something is actually going out
  */
  CurString[CurStringLength] = 0;      /* 0-terminated */
  output_bytes(pDDC, CurString);

  FNTDBGMSG("\n\rPLOTTERS:  exit construct_char\n\r");
  return  OutChar != EMPTY;
}

