/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#pragma  pagesize(55)
/**************************************************************************
 *
 * SOURCE FILE NAME = Band.C
 *
 * DESCRIPTIVE NAME = RASTER BANDING CODE for HPGL2/PCL PLOTTER DRIVER
 *
 *
 *
 * VERSION =   V1.0
 *
 * DATE        1/25/95
 *
 * DESCRIPTION BITMAP PLOTTER DRIVER SOURCE FILE-File contains raster bitmap
 *                         banding related functions
 *
 * FUNCTIONS   band()  Transfer band bitmaps to device
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define  INCL_GPIBITMAPS               /* Include bitmap defs in PMDDI      */
#define INCL_GENPLIB_COMPRESS          /* include genplib compression       */
#include "plotters.h"
#include "bitmap.h"
#include "bounds.h"
#include "clip.h"
#include "color.h"
#include "error.h"
#include "output.h"
#include "attribs.h"
#include "dispatch.h"
#include "utils.h"
#include "compress.h"

//typedef struct _BITBLTINFO {      /* bitbltinfo */
//   ULONG        ulLength;
//   ULONG        ulBltFlags;
//   ULONG        cBlits;
//   ULONG        ulROP;
//   ULONG        ulMonoBackROP;
//   ULONG        ulSrcFGColor;
//   ULONG        ulSrcBGColor;
//   ULONG        ulPatFGColor;
//   ULONG        ulPatBGColor;
//   PBYTE        abColors;
//   PBMAPINFO    pSrcBmapInfo;
//   PBMAPINFO    pDstBmapInfo;
//   PBMAPINFO    pPatBmapInfo;
//   PPOINTL      aptlSrcOrg;
//   PPOINTL      aptlPatOrg;
//   PBLTRECT     abrDst;
//   PRECTL       prclSrcBounds;    // incl/excl bounds.
//   PRECTL       prclDstBounds;    // incl/excl bounds.
//} BITBLTINFO;
//typedef BITBLTINFO *PBITBLTINFO;

//typedef struct _BMAPINFO {        /* bmapinfo */
//   ULONG  ulLength;
//   ULONG  ulType;
//   ULONG  ulWidth;
//   ULONG  ulHeight;
//   ULONG  ulBpp;
//   ULONG  ulBytesPerLine;
//   PBYTE  pBits;
//} BMAPINFO;
//typedef BMAPINFO  *PBMAPINFO;

//typedef struct _BLTRECT {         /* bltrect */
//   ULONG  ulXOrg;
//   ULONG  ulYOrg;
//   ULONG  ulXExt;
//   ULONG  ulYExt;
//} BLTRECT;
//

// make sure new defines are defined
#ifndef BF_LAST_BLT
  #define BF_LAST_BLT               0x00002000
#endif
#ifndef  DS_BITBLT_RIGHTLEFT_TOPBOTTOM
 #define  DS_BITBLT_RIGHTLEFT_TOPBOTTOM  0x02000000
#endif
BOOL _System band (PDDC pDDC, PRECTL prectlBandLocation)
{
  APIRET               lrc = TRUE;
  PDEVICESURFACE       pDS = pDDC->pDeviceSurface;
  ULONG                ulDSFlgs = pDS->ulDSFlgs;
  BITBLTINFO           BitBltInfo;
  BMAPINFO             BmapInfoSrc;
  BMAPINFO             BmapInfoDst;
  POINTL               ptlSrcOrg;
  BLTRECT              bltrectDest;

  setmem ((PBYTE)&BitBltInfo, 0, sizeof(BitBltInfo));
  setmem ((PBYTE)&BmapInfoSrc, 0, sizeof(BmapInfoSrc));


  /*
  ** fill out src BmapInfo for BitBltInfo passed to sdBitBlt
  */
  BmapInfoSrc = pDS->SurfaceBmapInfo;

  /*
  ** fill out bitbltinfo for sdBitBlt
  */
  BitBltInfo.ulLength      = sizeof(BITBLTINFO);
  BitBltInfo.ulBltFlags    = BF_LAST_BLT;
  BitBltInfo.ulBltFlags    |= pDS->ulDSFlgs & DS_BOTTOMTOP ?
                                     BF_DIR_BOTTOM_TOP : 0;
  BitBltInfo.cBlits        = 1;                       /* 1 blt       */
  BitBltInfo.ulROP         = 0xCC;                    /* source copy */
  BitBltInfo.ulMonoBackROP = 0;
  switch (pDS->SurfaceBmapInfo.ulBpp)
  {
     case  CAPS_COLOR_BITCOUNT_24:
       BitBltInfo.ulSrcFGColor = 0x0;
       BitBltInfo.ulSrcBGColor = 0x00FFFFFF;
       break;
     case  CAPS_COLOR_BITCOUNT_1:
       BitBltInfo.ulSrcFGColor = 0;
       BitBltInfo.ulSrcBGColor = 1;
       break;
     case CAPS_COLOR_BITCOUNT_4:
       BitBltInfo.ulSrcFGColor = 0;
       BitBltInfo.ulSrcBGColor = 16;
       break;
     case CAPS_COLOR_BITCOUNT_8:
     default:
       BitBltInfo.ulSrcFGColor = 0;
       BitBltInfo.ulSrcBGColor = 255;
       break;
  }
  //BitBltInfo.ulPatFGColor = 0;
  //BitBltInfo.ulPatBGColor = 0;
  //BitBltInfo.abColors     = 0;

  BitBltInfo.pSrcBmapInfo = &BmapInfoSrc;

  BmapInfoDst.pBits = (PBYTE)pDDC;
  BitBltInfo.pDstBmapInfo = &BmapInfoDst;

  //BitBltInfo.pPatBmapInfo = 0;

  ptlSrcOrg.x = 0;
  ptlSrcOrg.y = 0;
  BitBltInfo.aptlSrcOrg = &ptlSrcOrg;
  //BitBltInfo.aptlPatOrg = 0;

  // The Band location rectanlgle values are absolute and the origin is
  // always at the bottom of the page irrespective of whether we play
  // PLAY_TOP_BOTTOM or PLAY_BOTTOM_TOP. So setup the bltrectDest accordingly.

  if (ulDSFlgs & DS_BOTTOMTOP)
  {
    bltrectDest.ulXOrg = prectlBandLocation->xLeft;
    bltrectDest.ulYOrg = prectlBandLocation->yBottom;
  }
  else
  {
    bltrectDest.ulXOrg = prectlBandLocation->xLeft;
    bltrectDest.ulYOrg = pDDC->pPDevice->lCapsHeight - prectlBandLocation->yTop;
  }

  bltrectDest.ulXExt = prectlBandLocation->xRight - prectlBandLocation->xLeft+1;
  bltrectDest.ulYExt = prectlBandLocation->yTop - prectlBandLocation->yBottom+1;
  if (ulDSFlgs & DS_BITBLT_RIGHTLEFT_TOPBOTTOM)
  {
    ULONG ulTemp;
    ulTemp = bltrectDest.ulXOrg;
    bltrectDest.ulXOrg = bltrectDest.ulYOrg;
    bltrectDest.ulYOrg = ulTemp;
    ulTemp = bltrectDest.ulXExt;
    bltrectDest.ulXExt = bltrectDest.ulYExt;
    bltrectDest.ulYExt = ulTemp;
  }
  BitBltInfo.abrDst  = &bltrectDest;

  //BitBltInfo.prclSrcBounds = 0;
  //BitBltInfo.prclDstBounds = 0;
  return (sdBitBlt(&BitBltInfo));

} /* end function band() */
