/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// funcs.h
// function headers throughout the driver
// include this after os2.h

// --------------------------------------------------------------------------------------------------------------------
// assert.c
void APIENTRY SetErrorInfo( ULONG ulSeverity, ULONG ulErrorNumber );
void APIENTRY _assert( BOOL bool, ULONG ulLine, PSZ pszFilename, PSZ pszExpression );

// -------------------------------------------------------------------------------------------------------------------------
// caps.c
LONG APIENTRY QueryHardcopyCaps( HDC, LONG, LONG, PHCINFO, PDDC, ULONG );
LONG DRVENTRY SetCapabilities( PDDC pddc );
LONG APIENTRY DevicePalette( HDC hdc, PHWPALETTEINFO pHWPaletteInfo, PDDC pddc, ULONG ulFunction );

// -------------------------------------------------------------------------------------------------------------------------
// dlg.c
MRESULT EXPENTRY JobPropertiesDlgProc( HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY PrinterPropertiesDlgProc( HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2 );

// --------------------------------------------------------------------------------------------------------------------
// enable.c
ULONG APIENTRY OS2_PM_DRV_ENABLE( ULONG ulSubFunc, ULONG ulParam1, ULONG ulParam2  );
LONG APIENTRY OS2_PM_DRV_DEVMODE(  PDRIVDATA, PSZ, PSZ, PSZ, ULONG );
LONG APIENTRY OS2_PM_DRV_DEVICENAMES (  PSZ, PLONG, PSZ, PSZ, PLONG, PSZ, ULONG, ULONG );

// -------------------------------------------------------------------------------------------------------------------------
// escape.c
LONG APIENTRY Escape( HDC, LONG, LONG, PBYTE, PLONG, PBYTE, PDDC, ULONG );

// --------------------------------------------------------------------------------------------------------------------
// handler.c
ULONG APIENTRY Handler( PEXCEPTIONREPORTRECORD p1, PEXCEPTIONREGISTRATIONRECORD p2, PCONTEXTRECORD p3, PVOID pv );
LONG  DRVENTRY CheckForTermination( PREGREC pregrec, ULONG ulException, PDDC pddc );

// --------------------------------------------------------------------------------------------------------------------
// helper.c
BOOL DRVENTRY BuildAppName( PSZ pszAppname, ULONG ulAppnameSize, PSZ pszPrintername, PSZ pszDrivername, PSZ pszDevicename );
BOOL DRVENTRY SetDriverDataDefaults( PDRIVERDATA pdd, ULONG ulLength, PSZ pszDeviceName );
PSUPPORTEDDEVICE DRVENTRY PSDFromDeviceName( PSZ pszDeviceName );
PFORMINFO DRVENTRY FormInfoFromFormName( PSUPPORTEDDEVICE pSupportedDevice, PSZ pszFormName );
PSZ DRVENTRY Strip( PSZ psz, PSZ pszOption, PSZ pszStripSet );
LONG APIENTRY LockDevice( VOID );
ULONG DRVENTRY InitPrinter( PDDC );
ULONG DRVENTRY InitDocument( PDDC );
ULONG DRVENTRY InitPage( PDDC );
ULONG DRVENTRY WriteOutput( PDDC pddc, PCHAR pch, ULONG cb );
BOOL DRVENTRY prtput( PDDC pddc, PCHAR pch, ULONG n );
BOOL DRVENTRY prtputs( PDDC pddc, PCHAR pch );
BOOL DRVENTRY prtprintf( PDDC pddc, PSZ pszFormat, ...);

// --------------------------------------------------------------------------------------------------------------------
// initterm.c
ULONG APIENTRY  _DLL_InitTerm( ULONG hThisModule, ULONG ulFlag );

// --------------------------------------------------------------------------------------------------------------------
// pmwin.dll; this function exists in PMWIN.DLL and is imported via the driver def file
int APIENTRY DebugOutput( PSZ );

// -------------------------------------------------------------------------------------------------------------------------
// newframe.c
BOOL DRVENTRY NewFrame( PDDC  );
LONG APIENTRY SendMonoBits( PDDC pddc, PRECTL prectl );
