/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// dlg.c  - dialog procs

// os2 includes
#define INCL_DOS
#define INCL_PM
#include <os2.h>

#define INCL_32
#define INCL_VMANDDI
#include <ddi.h>

#define INCL_GRE_DEVICESURFACE
#define INCL_GREALL
#include <pmddi.h>


// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>


#define INCL_GENPLIB_JOURNAL
#define INCL_GENPLIB_MEMORY
#include <genplib.h>




#include "def.h"
#include "driver.h"
#include "funcs.h"


// ----------------------------------------------------------------------
// job properties dialog


MRESULT EXPENTRY JobPropertiesDlgProc( HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2 )
{

  PDLGINSTANCE  pdi;
  ULONG         ul;
  PFORMINFO     pfi;
  HWND          hwndWork;
  LONG          i;
  BOOL          fOK;
  CHAR          szWork[ 20 ];
  SHORT         sWork;


  switch( msg ) {
  case WM_INITDLG:
    pdi = (PDLGINSTANCE)mp2;

    // store the pointer to instance data
    WinSetWindowULong( hwnd, QWL_USER, (ULONG)pdi );

    // punch current setting for data bits
    switch( pdi->ddScratch.ulOrientation ) {
    case ORIENTATION_PORTRAIT:
      ul = IDC_PORTRAIT;
      break;
    case ORIENTATION_LANDSCAPE:
      ul = IDC_LANDSCAPE;
      break;
    default:
      assert( FALSE );
    }
    WinSendDlgItemMsg( hwnd, ul, BM_SETCHECK, (MPARAM)1, 0 );

    // insert all the forms supported for this device; user will pick one to print on
    hwndWork = WinWindowFromID( hwnd, IDC_FORM );
    assert( hwndWork );
    fOK = FALSE;
    for( pfi = pdi->pSupportedDevice->paFormInfo, ul = 0; ul < pdi->pSupportedDevice->cForms; ul++, pfi++ ) {
      i = (LONG)WinSendMsg( hwndWork, LM_INSERTITEM, (MPARAM)LIT_END, (MPARAM)pfi->hcinfo.szFormname );
      assert( i != LIT_ERROR );
      if( 0 == strcmp( pdi->ddScratch.szFormName, pfi->hcinfo.szFormname )) {
        // hilite this one
        fOK = (BOOL)WinSetWindowText( hwndWork, pfi->hcinfo.szFormname );
        assert( fOK );
      }
    }
    assert( fOK );

    // set the count of uncollated copies in the edit (could be a spin button)
    assert( pdi->pddSupplied->cCopies < 100000 );
    pdi->pddSupplied->cCopies = max( 1, pdi->pddSupplied->cCopies );

    hwndWork = WinWindowFromID( hwnd, IDC_COPYCOUNT );
    assert( hwndWork );
    fOK = FALSE;
    for( i = 1; i <= MAX_UNCOLLATEDCOPIES; i++ ) {
      sprintf( szWork, "%d", i );
      sWork = (SHORT)WinSendMsg( hwndWork, LM_INSERTITEM, (MPARAM)LIT_END, (MPARAM)szWork );
      if( i == pdi->pddSupplied->cCopies ) {
        // hilite this one
        fOK = (BOOL)WinSetWindowText( hwndWork, szWork );
        assert( fOK );
      }
    }
    assert( fOK );


    return 0;





  case WM_COMMAND:
    // get instance data
    pdi = (PDLGINSTANCE) WinQueryWindowULong( hwnd, QWL_USER );

    switch( SHORT1FROMMP( mp1 )) {
    case DID_OK:
      if( WinSendDlgItemMsg( hwnd, IDC_PORTRAIT,  BM_QUERYCHECK, 0, 0 )) pdi->ddScratch.ulOrientation = ORIENTATION_PORTRAIT;
      if( WinSendDlgItemMsg( hwnd, IDC_LANDSCAPE, BM_QUERYCHECK, 0, 0 )) pdi->ddScratch.ulOrientation = ORIENTATION_LANDSCAPE;

      // query the formname that the user picked
      hwndWork = WinWindowFromID( hwnd, IDC_FORM );
      assert( hwndWork );

      memset( pdi->ddScratch.szFormName, 0, sizeof( pdi->ddScratch.szFormName ));
      ul = (ULONG)  WinQueryWindowText( hwndWork, sizeof( pdi->ddScratch.szFormName ), pdi->ddScratch.szFormName );
      assert( ul );

      // get the count of copies; false means unsigned number expected
      fOK = WinQueryDlgItemShort( hwnd, IDC_COPYCOUNT, &sWork, FALSE );
      assert( fOK );
      pdi->ddScratch.cCopies = sWork;

      pdi->ulDismissalCode = DID_OK;
      WinDismissDlg( hwnd, DID_OK   );
      break;

    case DID_CANCEL:
      pdi->ulDismissalCode = DID_CANCEL;
      WinDismissDlg( hwnd, DID_CANCEL );
      break;
    }
    return 0;
  }

  // default for most cases
  return WinDefDlgProc( hwnd, msg, mp1, mp2 );
}




// ----------------------------------------------------------------------
// printer properties dialog


MRESULT EXPENTRY PrinterPropertiesDlgProc( HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2 )
{

  PDLGINSTANCE  pdi;
  ULONG         ul;
  HWND          hwndListbox;
  PFORMINFO     pfi;
  PCHAR         pch;
  LONG          i;
  ULONG         rc;


  switch( msg ) {
  case WM_INITDLG:
    pdi = (PDLGINSTANCE)mp2;

    // store the pointer to instance data
    WinSetWindowULong( hwnd, QWL_USER, (ULONG)pdi );


    hwndListbox = WinWindowFromID( hwnd, IDC_LISTBOX );
    assert( hwndListbox );

    // insert all the forms supported for this device
    for( pfi = pdi->pSupportedDevice->paFormInfo, ul = 0; ul < pdi->pSupportedDevice->cForms; ul++, pfi++ ) {
      i = (LONG)WinSendMsg( hwndListbox, LM_INSERTITEM, (MPARAM)LIT_END, (MPARAM)pfi->hcinfo.szFormname );
      // hilite selectable forms
      pch = pdi->achSelectableForms;
      while( pch ) {
        if( ';' == *pch ) pch++;
        if( *pch && 0 == strncmp( pfi->hcinfo.szFormname, pch, strlen( pfi->hcinfo.szFormname ))) {
          // yup; index in i from LM_INSERTITEM above
          WinSendMsg( hwndListbox, LM_SELECTITEM, (MPARAM)i, (MPARAM)TRUE );
        }
        pch = strchr( pch, ';' );
      }
    }

    // done initializing dlg box
    return 0;





  case WM_COMMAND:
    // get instance data
    pdi = (PDLGINSTANCE) WinQueryWindowULong( hwnd, QWL_USER );

    switch( SHORT1FROMMP( mp1 )) {
    case DID_OK:

      // collect selectable forms from the listbox
      hwndListbox = WinWindowFromID( hwnd, IDC_LISTBOX );
      assert( hwndListbox );

      memset( pdi->achSelectableForms, 0, sizeof( pdi->achSelectableForms ));
      pch = pdi->achSelectableForms;
      i = (LONG) WinSendMsg( hwndListbox, LM_QUERYSELECTION, (MPARAM)LIT_FIRST, 0 );
      while( LIT_NONE != i ) {
        assert( pch - pdi->achSelectableForms  <  sizeof( pdi->achSelectableForms )-32 );
        WinSendMsg( hwndListbox, LM_QUERYITEMTEXT, MPFROM2SHORT( i, 32 ), (MPARAM)pch );
        strcat( pch, ";" );
        pch += strlen( pch );
        i = (LONG)WinSendMsg( hwndListbox, LM_QUERYSELECTION, (MPARAM)i, 0 );
      }

      pdi->ulDismissalCode = DID_OK;
      WinDismissDlg( hwnd, DID_OK   );
      break;

    case DID_CANCEL:
      pdi->ulDismissalCode = DID_CANCEL;
      WinDismissDlg( hwnd, DID_CANCEL );
      break;

    case IDC_DEVICEDEFAULTS:
      rc = WinDlgBox( HWND_DESKTOP, hwnd, (PFNWP)JobPropertiesDlgProc, globals.hModule, IDD_JOB_PROPERTIES, (PVOID)pdi );
      assert( rc != DID_ERROR );
      if( DID_OK == rc  ) {

        // NB: there is a compatibility question whether this assignment should be unconditional

        *(PDRIVERDATA)pdi->pddSupplied = pdi->ddScratch;
      }
      break;
    }
    return 0L;
  }

  // default for most cases
  return WinDefDlgProc( hwnd, msg, mp1, mp2 );
}
