/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// text.c

#define INCL_DOS
#define INCL_PM
#include <os2.h>

#define INCL_GRE_STRINGS
#define INCL_DDIMISC
#define INCL_DDICOMFLAGS
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <builtin.h>

#define INCL_INNER_GRE
#include "def.h"
#include "driver.h"
#include "funcs.h"
#include "assert.h"




//---------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY CharString(               HDC            hdc,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER( regrec );
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assert( FALSE );
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = GPI_ERROR;
    goto depart;
  }

  ENTERDDC( pddc );

  // pass charstring on to charstringpos
  // keep COM_ flags, but change function number
  lrc = CharStringPos( hdc, NULL, NULL, 0, cChars, pchString, NULL, NULL, pddc, NGreCharStringPos|(0xFFFF0000 & ulFunction ));

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}




//---------------------------------------------------------------------------------------------------------------------

LONG ENGENTRY CharStringPos(            HDC            hdc,
                                        PPOINTL        pptlStart,
                                        PRECTL         prclRect,
                                        ULONG          flOptions,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        PLONG          paDX,
                                        PCSP_INFO      pAttrs,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;
  PFN         pfnCharStringPos;


  REGISTERHANDLER( regrec );
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assert( FALSE );
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = GPI_ERROR;
    goto depart;
  }
  ENTERDDC( pddc );


  if( ulFunction & COM_DEVICE ) {

    // give to shadow DC at device level
    lrc = InnerGreCharStringPos( pddc->hdcShadow, pptlStart, prclRect, flOptions, cChars, pchString, paDX, pAttrs, ulFunction );
    assert( lrc != GPI_ERROR );

  } else {

    // invoke engine simulation function
    pfnCharStringPos = globals.ppfnDispatchTableCopy[ NGreCharStringPos & 0x00FF ];
    assert( pfnCharStringPos );
    lrc = (LONG)( *pfnCharStringPos )( hdc, pptlStart, prclRect, flOptions, cChars, pchString, paDX, pAttrs, pddc, ulFunction );
    assert( lrc != GPI_ERROR );
  }


depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}




//---------------------------------------------------------------------------------------------------------------------

LONG ENGENTRY QueryCharPositions(       HDC            hdc,
                                        PPOINTL        pptlStart,
                                        ULONG          flOptions,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        PLONG          paDX,
                                        PPOINTL        paptlXY,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;
  PFN         pfn;


  REGISTERHANDLER( regrec );
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assert( FALSE );
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );

  // call the engine simulation function for this case
  pfn = globals.ppfnDispatchTableCopy[ NGreQueryCharPositions & 0x00FF ];
  assert( pfn );
  lrc = (*pfn)( hdc, pptlStart, flOptions, cChars, pchString, paDX, paptlXY, pddc, ulFunction );
  assert( lrc );


depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}




//---------------------------------------------------------------------------------------------------------------------

LONG ENGENTRY QueryTextBox(             HDC            hdc,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        LONG           cptPosition,
                                        PPOINTL        paptlPosition,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;
  PFN         pfn;


  REGISTERHANDLER( regrec );
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assert( FALSE );
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  // call the engine simulation function for this case
  pfn = globals.ppfnDispatchTableCopy[ NGreQueryTextBox & 0x00FF ];
  assert( pfn );
  lrc = (*pfn)( hdc, cChars, pchString, cptPosition, paptlPosition, pddc, ulFunction );
  assert( lrc );


depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}




//---------------------------------------------------------------------------------------------------------------------

LONG ENGENTRY QueryWidthTable(          HDC            hdc,
                                        LONG           lFirstChar,
                                        LONG           cWidthTable,
                                        PLONG          paWidthTable,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;
  PFN         pfn;


  REGISTERHANDLER( regrec );
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assert( FALSE );
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );


  // call the engine simulation function for this case
  pfn = globals.ppfnDispatchTableCopy[ NGreQueryWidthTable & 0x00FF ];
  assert( pfn );
  lrc = (*pfn)( hdc, lFirstChar, cWidthTable, paWidthTable, pddc, ulFunction );
  assert( lrc );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}


