/* setea.cmd: sets extended attributes on the DRV file */

parse arg szBaseName .

if length( szBaseName ) = 0 then do
  say 'Expected driver path and file name on command line but'
  say 'without the extension.'
  exit 3
end

if 0 < pos( '.', szBaseName ) then do
  say 'Give driver path and name, but do not give extension.'
  exit 3
end

szDriver = right( szBaseName, length( szBaseName ) - lastpos('\', szBaseName ))

szDRVName = szBaseName'.DRV'

'ea -e .version=21.000' szDRVName
'ea -e VENDORNAME='szDriver szDRVName
'ea -e REQUIREDDRIVERFILES='szDriver'.DRV' szDRVName
'ea -e OPTIONALDRIVERFILES='szDriver'.SYM' szDRVName

'devnames -e'szDRVName
if rc > 0 then do
  say 'RC' rc 'from DEVNAMES utility.'
  exit 3
end

exit 0
