/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// marker.c

#define INCL_DOS
#define INCL_PM
#include <os2.h>

#define INCL_GRE_MARKERS
#define INCL_DDICOMFLAGS
#define INCL_DDIMISC
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <builtin.h>

#define INCL_INNER_GRE
#include "def.h"
#include "driver.h"
#include "funcs.h"
#include "assert.h"


//----------------------------------------------------------------------------------------
LONG ENGENTRY PolyMarker(               HDC            hdc,
                                        PPOINTL        paptlPoint,
                                        LONG           cPoints,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER( regrec );
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assert( FALSE );
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = GPI_ERROR;
    goto depart;
  }
  ENTERDDC( pddc );


  lrc = InnerGrePolyMarker( pddc->hdcShadow, paptlPoint, cPoints, ulFunction );
  assert( lrc != GPI_ERROR );


  lrc = TRUE;
depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}



