/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// helper.c  helper functions including INI file access helpers

#define INCL_DEV
#define INCL_DOS
#define INCL_SPL
#define INCL_PM
#include <os2.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <ctype.h>
#include <builtin.h>

#include "def.h"
#include "driver.h"
#include "funcs.h"
#include "assert.h"



//---------------------------------------------------------------------------------------------------------------------
// build the application name used in INI file access

BOOL DRVENTRY BuildAppName( PSZ pszAppname, ULONG ulAppnameSize, PSZ pszPrintername, PSZ pszDrivername, PSZ pszDevicename)
{

  assert( pszPrintername );
  assert( strlen( pszPrintername ));

  assert( pszDrivername );
  assert( strlen( pszDrivername ));

  assert( pszDevicename );
  assert( strlen( pszDevicename ));

  assert( ulAppnameSize > 8 + strlen( pszDevicename ) + strlen( pszPrintername ) + strlen( pszDrivername ));

  sprintf( pszAppname, "PM_DD_%s,%s.%s", pszPrintername, pszDrivername, pszDevicename );

  return TRUE;
}







//---------------------------------------------------------------------------------------------------------------------
// try to make the supplied driver data into something that this version of the driver can use
// do not modify any data past ulLength


BOOL DRVENTRY SetDriverDataDefaults( PDRIVERDATA pdd, ULONG ulLength, PSZ pszDeviceName )
{

  BOOL  fRet;


  assert( pdd );
  assert( pdd->cb ? pdd->cb == sizeof( DRIVERDATA ) : TRUE );
  assert( pdd->cb ? pdd->lVersion == DRIVERDATA_VERSION : TRUE );
  assert( pszDeviceName );
  assert( strlen( pszDeviceName ));



  if( pdd->cb == 0 ) {
    // use this version's values for defaults
    assert( ulLength == sizeof( DRIVERDATA ));
    pdd->cb          = sizeof( DRIVERDATA );
    pdd->lVersion    = DRIVERDATA_VERSION;
    strcpy( pdd->szDeviceName, pszDeviceName );
  }


  switch( pdd->lVersion ) {
  // room to add cases for other versions...
  case DRIVERDATA_VERSION:
  default:
    pdd->ulOrientation = ORIENTATION_PORTRAIT;
    strcpy( pdd->szFormName, "Letter" );
    pdd->cCopies = 1;
    fRet = TRUE;
    break;
  }

  return fRet;
}





//---------------------------------------------------------------------------------------------------------------------
// return the pointer to the global structure PSUPPORTEDDEVICE given a device name

PSUPPORTEDDEVICE DRVENTRY PSDFromDeviceName( PSZ pszDeviceName )
{
  PSUPPORTEDDEVICE     psd;
  PSUPPORTEDDEVICE     psdDesired;
  ULONG                ul;



  assert( pszDeviceName );
  assert( *pszDeviceName );


  // find the pointer to the supporteddevice struct given the pszDeviceName supplied
  psdDesired = NULL;
  for( psd = globals.paDevice, ul = 0;   ul < globals.ulDeviceCount;  psd++, ul++ ) {
    if( 0 == strcmp( psd->szDeviceName, pszDeviceName )) {
      // this is it
      psdDesired = psd;
      break;
    }
  }

  return psdDesired;
}


//---------------------------------------------------------------------------------------------------------------------
// return the pointer to FORMINFO given the ASCIIZ representation of the form name and a pointer to the supported device info

PFORMINFO DRVENTRY FormInfoFromFormName( PSUPPORTEDDEVICE pSupportedDevice, PSZ pszFormName )
{
  PFORMINFO pfi;
  LONG      i;


  for( pfi = pSupportedDevice->paFormInfo, i = 0; i < pSupportedDevice->cForms; i++, pfi++ ) {
    if( 0 == strcmp( pfi->hcinfo.szFormname, pszFormName )) {
      // found it
      return pfi;
    }
  }
  return NULL;
}


//---------------------------------------------------------------------------------------------------------------------
// strip from the ends of string given in parameter 1 all characters in string in parameter 2
// strip left, right, or both according to pszOption which can be "LEFT", "RIGHT", or "BOTH"
// similar in syntax and function to Rexx strip(), except this function modifies the string at psz
// where rexx returns a new string and leaves the one passed as an argument intact.

PSZ DRVENTRY Strip( PSZ psz, PSZ pszOption, PSZ pszStripSet )
{


  assert( psz );
  assert( pszOption );
  assert( strchr( "LRBlrb", *pszOption ));
  assert( pszStripSet );
  assert( strlen( pszStripSet ));


  if( strchr( "LlBb", *pszOption )) {
    // strip on left
    while(  *psz && strchr( pszStripSet, *psz )) {
      strcpy( psz, psz+1 );
    }
  }

  if( strchr( "RrBb", *pszOption )) {
    // strip on right
    while(  *psz &&  strchr( pszStripSet, *(psz+strlen( psz )-1))  ) {
      *(psz+strlen(psz)-1) = 0;
    }
  }

  return psz;
}



// --------------------------------------------------------------------------------------------------------------------
// a function to call WinSetErrorInfo.  The advantage of having this wrapper is the ability to set a
// debug kernel breakpoint on this function.
void APIENTRY SetErrorInfo( ULONG ulSeverity, ULONG ulErrorNumber )
{
  WinSetErrorInfo( MAKEULONG( (USHORT)ulErrorNumber, (USHORT)ulSeverity ), SEI_NOBEEP | SEI_NOPROMPT  );
}

