/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// funcs.h
// function headers throughout the driver
// include this after os2.h


// --------------------------------------------------------------------------------------------------------------------
// handler.c and exception handler stuff

ULONG _System Handler( PEXCEPTIONREPORTRECORD p1, PEXCEPTIONREGISTRATIONRECORD p2, PCONTEXTRECORD p3, PVOID pv );
LONG DRVENTRY CheckForTermination( PREGREC pregrec, ULONG ulException, PDDC pddc );


// --------------------------------------------------------------------------------------------------------------------
// helper.c helper functions

BOOL DRVENTRY BuildAppName( PSZ pszAppname, ULONG ulAppnameSize, PSZ pszPrintername, PSZ pszDrivername, PSZ pszDevicename );
BOOL DRVENTRY SetDriverDataDefaults( PDRIVERDATA pdd, ULONG ulLength, PSZ pszDeviceName );
PSUPPORTEDDEVICE DRVENTRY PSDFromDeviceName( PSZ pszDeviceName );
PFORMINFO DRVENTRY FormInfoFromFormName( PSUPPORTEDDEVICE pSupportedDevice, PSZ pszFormName );
PSZ DRVENTRY Strip( PSZ psz, PSZ pszOption, PSZ pszStripSet );
void APIENTRY SetErrorInfo( ULONG ulSeverity, ULONG ulErrorNumber );



// --------------------------------------------------------------------------------------------------------------------
// enter.c: routines to serialize thread access to ddc

VOID DRVENTRY EnterDriver( PDDC );
VOID DRVENTRY ExitDriver( PDDC );



// --------------------------------------------------------------------------------------------------------------------
// pmwin.dll; this function exists in PMWIN.DLL and is imported via the driver def file
int APIENTRY DebugOutput( PSZ );



// --------------------------------------------------------------------------------------------------------------------
// enable.c

ULONG APIENTRY OS2_PM_DRV_ENABLE( ULONG ulSubFunc, ULONG ulParam1, ULONG ulParam2  );

LONG APIENTRY OS2_PM_DRV_DEVMODE(  PDRIVDATA pdriv,
                                   PSZ       pszDrivername,
                                   PSZ       pszDevicename,
                                   PSZ       pszPrintername,
                                   ULONG     ulOptions );

LONG APIENTRY OS2_PM_DRV_DEVICENAMES (  PSZ       pszDriverName,
                                        PLONG     pcNames,
                                        PSZ       pstr32DeviceNames,
                                        PSZ       pstr64DeviceDescriptions,
                                        PLONG     pcDataTypes,
                                        PSZ       pstr16DataTypes,
                                        ULONG     ulReserved1,
                                        ULONG     ulReserved2 );


VOID APIENTRY DrvInstall( void );


// -------------------------------------------------------------------------------------------------------------------------
// dlg.c


MRESULT EXPENTRY JobPropertiesDlgProc( HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY PrinterPropertiesDlgProc( HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2 );

// -------------------------------------------------------------------------------------------------------------------------
// memory.c

PVOID DRVENTRY AllocMem( PVOID pvHeapBase, ULONG ulSize );
PVOID DRVENTRY AllocSharedMem( ULONG ulSize );
BOOL  DRVENTRY FreeMem( PVOID pvHeapBase );

// -------------------------------------------------------------------------------------------------------------------------
// util.asm

#ifndef NDEBUG
  // debug version: use IBM C Set/2 interrupt(3) cute int 3 (opcode 0xCC)
  #define INT3 _interrupt(3)
#else
  // retail version: nop it
  #define INT3
#endif





// -------------------------------------------------------------------------------------------------------------------------
// attrib.c

#ifdef INCL_GRE_DEVMISC1

LONG ENGENTRY DeviceSetAttributes(      HDC            hdc,
                                        ULONG          ulBType,
                                        ULONG          ulDefsMask,
                                        ULONG          flAttrsMask,
                                        PBUNDLE        pAttrs,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY DeviceGetAttributes(      HDC            hdc,
                                        LONG           lPrimType,
                                        ULONG          ulAttrsMask,
                                        PBUNDLE        pAttrs,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY DeviceSetGlobalAttribute( HDC            hdc,
                                        LONG           lAttrType,
                                        LONG           lAttribute,
                                        ULONG          flOptions,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY GetPairKerningTable(      HDC            hdc,
                                        LONG           cKernPairs,
                                        PKERNINGPAIRS  pKerningPairs,
                                        PDDC           pddc,
                                        ULONG          ulFunction );
#endif



// -------------------------------------------------------------------------------------------------------------------------
// bitmap.c

#ifdef INCL_GRE_BITMAPS

LONG ENGENTRY Bitblt(                   HDC            hdc,
                                        HDC            hdcSource,
                                        LONG           cPoints,
                                        PPOINTL        paPoints,
                                        LONG           lRop,
                                        ULONG          flOptions,
                                        PBITBLTATTRS   pAttrs,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY DeviceCreateBitmap(       HDC            hdc,
                                        PBITMAPINFOHEADER pInfoHeader,
                                        ULONG          flUsage,
                                        PBYTE          pBitmapBits,
                                        PBITMAPINFO    pInfo,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY DeviceDeleteBitmap(       HDC            hdc,
                                        ULONG          hbm,
                                        PDELETERETURN  pdr,
                                        ULONG          flOptions,
                                        PDDC           pddc,
                                        ULONG          ulFunction );



LONG ENGENTRY DeviceSelectBitmap(       HDC            hdc,
                                        ULONG          hbm,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY DrawBits(                 HDC            hdc,
                                        PBYTE          pBitmapBits,
                                        PBITMAPINFO    pInfo,
                                        LONG           cPoints,
                                        PPOINTL        paPoints,
                                        LONG           lRop,
                                        ULONG          flOptions,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY DrawBorder(               HDC            hdc,
                                        PRECTL         prectl,
                                        ULONG          cxBorder,
                                        ULONG          cyBorder,
                                        LONG           clrBorder,
                                        LONG           clrInterior,
                                        ULONG          flCmd,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY GetBitmapBits(            HDC            hdc,
                                        ULONG          hbm,
                                        LONG           lScanStart,
                                        LONG           lScanCount,
                                        PBYTE          pBitmapBits,
                                        PBITMAPINFO    pInfo,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY GetPel(                   HDC            hdc,
                                        PPOINTL        pPel,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY ImageData(                HDC            hdc,
                                        PBYTE          pData,
                                        LONG           cBits,
                                        ULONG          ulRowOffset,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY SetBitmapBits(            HDC            hdc,
                                        ULONG          hbm,
                                        LONG           lScanStart,
                                        LONG           lScanCount,
                                        PBYTE          pBitmapBits,
                                        PBITMAPINFO    pInfo,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY SetPel(                   HDC            hdc,
                                        PPOINTL        pPel,
                                        PDDC           pddc,
                                        ULONG          ulFunction );
#endif


// -------------------------------------------------------------------------------------------------------------------------
// clrtable.c

#ifdef INCL_GRE_COLORTABLE

LONG ENGENTRY CreateLogColorTable(      HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           lFormat,
                                        LONG           lStart,
                                        LONG           cCount,
                                        PLONG          pData,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY QueryColorData(           HDC            hdc,
                                        LONG           cArray,
                                        PLONG          pArray,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY QueryColorIndex(          HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           rgbColor,
                                        PDDC           pddc,
                                        ULONG          ulFunction );


LONG ENGENTRY QueryLogColorTable(       HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           lStart,
                                        LONG           cArray,
                                        PLONG          pArray,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY QueryNearestColor(        HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           rgbColorin,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY QueryRealColors(          HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           lStart,
                                        LONG           cArray,
                                        PLONG          pArray,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY QueryRGBColor(            HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           lColor,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY RealizeColorTable(        HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY UnrealizeColorTable(      HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

#endif



// -------------------------------------------------------------------------------------------------------------------------
// devfunc2.c

#ifdef INCL_GRE_DEVMISC2

LONG ENGENTRY DeviceQueryFontAttributes(HDC            hdc,
                                        ULONG          cMetrics,
                                        PFONTMETRICS   pfm,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY DeviceQueryFonts(         HDC            hdc,
                                        ULONG          flOptions,
                                        PSZ            pszFacename,
                                        PFONTMETRICS   pfm,
                                        ULONG          cMetrics,
                                        PLONG          pcFonts,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY ErasePS(                  HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY NotifyClipChange(         HDC            hdc,
                                        PRECTL         prclBound,
                                        ULONG          cRect,
                                        ULONG          idClipPath,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY NotifyTransformChange(    HDC            hdc,
                                        ULONG          flFlags,
                                        PNOTIFYTRANSFORMDATA pXformdata,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY RealizeFont(              HDC            hdc,
                                        ULONG          cmdCommand,
                                        PFATTRS        pLogFont,
                                        PULONG         pFont,
                                        PDDC           pddc,
                                        ULONG          ulFunction );


LONG ENGENTRY RealizeFont(              HDC            hdc,
                                        ULONG          cmdCommand,
                                        PFATTRS        pLogFont,
                                        PULONG         pFont,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

#endif




// -------------------------------------------------------------------------------------------------------------------------
// devfunc3.c

#ifdef INCL_GRE_DEVMISC3

LONG ENGENTRY AccumulateBounds(         HDC            hdc,
                                        PRECTL         prclRect,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY DeviceSetDCOrigin(        HDC            hdc,
                                        PPOINTL        pptlDC,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY GetBoundsData(            HDC            hdc,
                                        ULONG          flOptions,
                                        PRECTL         pBoundsData,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY GetCodePage(              HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction );


LONG ENGENTRY GetDCOrigin(              HDC            hdc,
                                        PPOINTL        pptlOrigin,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY GetLineOrigin(            HDC            hdc,
                                        PPOINTL        pptlXY,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY LockDevice(               HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY ResetBounds(              HDC            hdc,
                                        ULONG          flOptions,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY SetCodePage(              HDC            hdc,
                                        LONG           lCodePage,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY SetLineOrigin(            HDC            hdc,
                                        PPOINTL        pptlXY,
                                        ULONG          lStyle,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY UnlockDevice(             HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

#endif


// -------------------------------------------------------------------------------------------------------------------------
// escape.c

#ifdef INCL_GRE_DEVICE


LONG ENGENTRY Escape(                   HDC            hdc,
                                        LONG           lEscape,
                                        LONG           cInCount,
                                        PBYTE          pInData,
                                        PLONG          pcOutCount,
                                        PBYTE          pOutData,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

#endif



// -------------------------------------------------------------------------------------------------------------------------
// line.c

#ifdef INCL_GRE_LINES


LONG ENGENTRY DisjointLines(            HDC            hdc,
                                        PPOINTL        paptlPoint,
                                        LONG           cPoints,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY DrawLinesInPath(          HDC            hdc,
                                        PRECTL         prclBound,
                                        PCURVE         pLine,
                                        ULONG          cLines,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY GetCurrentPosition(       HDC            hdc,
                                        PPOINTL        paptlPosition,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY PolyLine(                 HDC            hdc,
                                        PPOINTL        paptlPoint,
                                        LONG           cPoints,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY PolyScanline(             HDC            hdc,
                                        PSCANDATA      pScanData,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY PolyShortLine(            HDC            hdc,
                                        PSHORTLINE     pShortLine,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY SetCurrentPosition(       HDC            hdc,
                                        PPOINTL        pptlPosition,
                                        PDDC           pddc,
                                        ULONG          ulFunction );


#endif

// -------------------------------------------------------------------------------------------------------------------------
// marker.c
#ifdef INCL_GRE_MARKERS


LONG ENGENTRY PolyMarker(               HDC            hdc,
                                        PPOINTL        paptlPoint,
                                        LONG           cPoints,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

#endif

// -------------------------------------------------------------------------------------------------------------------------
// query.c
#ifdef INCL_GRE_DEVICE

LONG ENGENTRY QueryDeviceBitmaps(       HDC            hdc,
                                        PLONG          paOutData,
                                        LONG           cOutData,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY QueryDeviceCaps(          HDC            hdc,
                                        LONG           lIndex,
                                        PLONG          paOutData,
                                        LONG           cOutData,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY QueryDevResource2(        HDC            hdc,
                                        ULONG          lType,
                                        ULONG          id,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY QueryHardcopyCaps(        HDC            hdc,
                                        LONG           lStart,
                                        LONG           cCount,
                                        PHCINFO        pInfo,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

#endif



// -------------------------------------------------------------------------------------------------------------------------
// newframe.c

BOOL NewFrame( PDDC pddc );


// -------------------------------------------------------------------------------------------------------------------------
// text.c
#ifdef INCL_GRE_STRINGS

LONG ENGENTRY CharString(               HDC            hdc,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY CharStringPos(            HDC            hdc,
                                        PPOINTL        pptlStart,
                                        PRECTL         prclRect,
                                        ULONG          flOptions,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        PLONG          paDX,
                                        PCSP_INFO      pAttrs,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY QueryCharPositions(       HDC            hdc,
                                        PPOINTL        pptlStart,
                                        ULONG          flOptions,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        PLONG          paDX,
                                        PPOINTL        paptlXY,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY QueryTextBox(             HDC            hdc,
                                        LONG           cChars,
                                        PCHAR          pchString,
                                        LONG           cptPosition,
                                        PPOINTL        paptlPosition,
                                        PDDC           pddc,
                                        ULONG          ulFunction );

LONG ENGENTRY QueryWidthTable(          HDC            hdc,
                                        LONG           lFirstChar,
                                        LONG           cWidthTable,
                                        PLONG          paWidthTable,
                                        PDDC           pddc,
                                        ULONG          ulFunction );
#endif



// --------------------------------------------------------------------------------------------------------------------
// Inner GRE graphics engine calls
// Inner GRE entries let printer drivers enter the graphics engine without transform mod's that occur at normal GRE entry.

#ifdef INCL_INNER_GRE
#include "innergre.h"
#endif
