/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// driver.c

// among other things, the declaration of global data


#define INCL_DOS
#define INCL_PM
#include <os2.h>


// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <builtin.h>


#include "def.h"
#include "driver.h"
#include "funcs.h"
#include "assert.h"



// only one copy of these data items in a running system
#pragma data_seg( Global )




// a set of forms supported by a printer
// DEVICE_SPECIFIC: the actual size of the form, and the forms supported
// DEVICE_SPECIFIC: the escape sequences to select a form

FORMINFO aforminfo100[] = {
 // formname       cx,  cy, xl, yb,   yr,   yt,  xpels  ypels flattributes                         escape to select it
 {{ "Letter",     216, 279,  6,  5,  210,  274,  2400,  3180, HCAPS_SELECTABLE | HCAPS_CURRENT  }, "\033A"  },
 {{ "Legal",      216, 356,  6,  5,  210,  351,  2400,  4080, HCAPS_SELECTABLE                  }, "\033B"  }
};

#define COUNT_FORMS100  sizeof(aforminfo100)/sizeof(FORMINFO)





// supported devices
// declare and initialize the array of SUPPORTEDDEVICE structs
// see driver.h for definition of this structure

SUPPORTEDDEVICE aDevice[] =
{
   { "Generic Raster Printer",                              // szDeviceName
     COUNT_FORMS100,                                        // cForms
     aforminfo100,                                          // paFormInfo
     300,                                                   // ulXResolution
     300                                                    // ulYResolution
   },

   { "Similar Raster Printer",                              // szDeviceName
     COUNT_FORMS100,                                        // cForms
     aforminfo100,                                          // paFormInfo
     300,                                                   // ulXResolution
     300                                                    // ulYResolution
   }
};


// compiler can compute the number of supported devices
#define SUPPORTEDDEVICECOUNT   sizeof( aDevice ) / sizeof( SUPPORTEDDEVICE )




// global information; need one copy only
// null and zero values are assigned at run time


GLOBALS  globals = {
  (HMODULE) 0,                       // module handle
  0,                                 // gre version
  0,                                 // count of entries in dispatch table
  NULL,                              // pointer to a copy of the dispatch table alloced from SS shared space
  "\\SEM32\\GDRIVE\\GLOBAL\\SEM",    // global sem name
  SUPPORTEDDEVICECOUNT,              // count of supported devices
  aDevice,                           // array of information about the devices supported
  NULL,                              // pointer to shared heap
  0                                  // count of instances
};




// these data items private to any given process
#pragma data_seg( PerProcess )

PROCDATA         procdata;

