/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// assert.h
// headers for functions in assert.c


#ifndef NDEBUG
  // build debug version by default unless symbol NDEBUG is defined

  // for the assert( expression ) macro
  void _System _assert( BOOL bool, ULONG ulLine, PSZ pszFilename, PSZ pszExpression );
  #define assert(exp)  _assert((BOOL)(exp),__LINE__,__FILE__,(PSZ)#exp)


  // for the DBPRINTF((pszFormat, ... )) macro
  VOID _Optlink dbprintf (PSZ pszFormat, ...);
  #define DBPRINTF(str) dbprintf str


#else
  // retail version
  #define assert(exp)
  #define DBPRINTF(str)
#endif

