;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)profile.inc	6.1 90/11/16
;      SCCSID = @(#)profile.inc 13.1 88/12/08
	page	,132
;-----------------------------Module-Header-----------------------------;
; Module Name:	PROFILE.INC
;
; This file contains external and macro definitions for using the
; Presentation Manager Attributed Profiler.
;
; Created: 23-Sep-1987
; Author:  Walt Moore [waltm]
;
;
;-----------------------------------------------------------------------;

ifdef ATTRPROF
        externFP        AProfCall
        externFP        AProfCallAlt
        externFP        AProfRet
endif

;---------------------------------Macro---------------------------------;
; profile
;
; profile is a macro used within the source to interface with the
; profiler, under conditional control of the ATTRPROF flag.
;
; usage
;
;	profile func_type,opt_cs,opt_ip
;
; where
;
;	func_type   The type of operation to be performed:
;
;		    entered - a procedure has just been entered
;			      if opt_cs and opt_ip is given, it will
;			      be used instead of the current CS:IP
;		    exiting - a procedure is about to be exited
;		    replace - a previous procedure has jumped to us
;			      (same as exit followed by enter)
;
; All registers and flags are preserved by the macro
;-----------------------------------------------------------------------;

profile macro	func_type,opt_cs,opt_ip
ifdef ATTRPROF                          ;;Only if Attributed profiling enabled
  ifidn <func_type>,<entered>		;;If a procedure was just entered
    ifb <opt_cs>			;;  If no explicit CS:IP
      call AProfCall                    ;;    use return address as CS:IP
    else				;;  else
	push	opt_cs			;;    use the given values for CS
	push	opt_ip			;;    and IP.  calling convention
        call    AProfCallAlt            ;;    is PL/M
    endif				;;  endif
  else					;;else
    ifidn <func_type>,<exiting> 	;;  if procedure is exiting
        call    AProfRet                ;;    remove return address
    else				;;  else
      ifidn <func_type>,<replace>	;;    if procedure is exiting
	profile exiting
	profile entered,<opt_cs>,<opt_ip>
      else
	%out profile - unknown keyword
      endif
    endif
  endif
endif
endm
