/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*      SCCSID = @(#)bsetib.h   6.9 92/03/15 */
/***************************************************************************\
*
* Module Name: BSETIB.H
*
* OS/2 Thread Information Block Include File
*
*
*****************************************************************************/

#ifdef __IBMC__
#pragma checkout( suspend )
   #ifndef __CHKHDR__
      #pragma checkout( suspend )
   #endif
#pragma checkout( resume )
#endif

#ifndef __BSETIB__
#define __BSETIB__

/*
 *      Thread Information Block (TIB)
 */

struct tib2_s
       {
       ULONG   tib2_ultid;             /* Thread I.D. */
       ULONG   tib2_ulpri;             /* Thread priority */
       ULONG   tib2_version;           /* Version number for this structure */
       USHORT  tib2_usMCCount;         /* Must Complete count */
       USHORT  tib2_fMCForceFlag;      /* Must Complete force flag */
       };

typedef struct tib2_s TIB2;
typedef struct tib2_s *PTIB2;

struct tib_s                           /* TIB Thread Information Block */
       {
        PVOID   tib_pexchain;           /* Head of exception handler chain */
        PVOID   tib_pstack;             /* Pointer to base of stack */
        PVOID   tib_pstacklimit;        /* Pointer to end of stack */
        PTIB2   tib_ptib2;              /* Pointer to system specific TIB */
        ULONG   tib_version;            /* Version number for this TIB structure */
        ULONG   tib_ordinal;            /* Thread ordinal number        */
       };

typedef struct tib_s    tib_t;
typedef struct tib_s    TIB;
typedef struct tib_s    *PTIB;


/*
 *      Process Information Block (PIB)
 */


struct pib_s {                         /* PIB Process Information Block */
       ULONG   pib_ulpid;              /* Process I.D. */
       ULONG   pib_ulppid;             /* Parent process I.D. */
       ULONG   pib_hmte;               /* Program (.EXE) module handle */
       PCHAR   pib_pchcmd;             /* Command line pointer */
       PCHAR   pib_pchenv;             /* Environment pointer */
       ULONG   pib_flstatus;           /* Process' status bits */
       ULONG   pib_ultype;             /* Process' type code */
       };

/*The following defines are the possible values for pib_ultype*/

#define PROCTYPE_FULLSCRN  0
#define PROCTYPE_VDM       1
#define PROCTYPE_REALMODE  PROCTYPE_VDM
#define PROCTYPE_VIOWIN    2
#define PROCTYPE_PRESMGR   3
#define PROCTYPE_DETACHED  4

/*The following defines are the possible values for the pib_flstatus status bits*/

#define PROCSTATUS_XITLST     0x01
#define PROCSTATUS_XITTH1     0x02
#define PROCSTATUS_XITALL     0x04
#define PROCSTATUS_SYNCPARENT 0x10
#define PROCSTATUS_WAITPARENT 0x20
#define PROCSTATUS_DYING      0x40
#define PROCSTATUS_EMBRYO     0x80

typedef struct pib_s    pib_t;
typedef struct pib_s    PIB;
typedef struct pib_s    *PPIB;

#endif /* __BSETIB__ */

#ifdef __IBMC__
#pragma checkout( suspend )
   #ifndef __CHKHDR__
      #pragma checkout( resume )
   #endif
#pragma checkout( resume )
#endif
