/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = DDI.H
 *
 * DESCRIPTIVE NAME = Video and Printer DDI Structures and defines
 *
 *
 * ==========================================================================
 *
 * The folowing symbols are used in this file for conditional sections.
 *
 *   #define:                To include:
 *
 *   INCL_VMANDDI            Include all VMI interface definitions
 *   INCL_VMANWIN            Include VMAN to VDD interface definitions
 *   INCL_VMANHELP           Include VMAN Helper definitions and prototypes
 *
 * ==========================================================================
 *
 * VERSION = V2.1
 *
 * DESCRIPTION
 *      This file contains all of the defines and
 *      data structures that are shared between the
 *      video manager and the translation layers.
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#ifdef INCL_VMANDDI

/* NOINC */
#ifndef VMANDDI_INCLUDED

  #define VMANDDI_INCLUDED
/* INC */

  /*
  **  Prototype declarations for low level driver function call table.
  */

  typedef ULONG CID;             /* Chain ID */
  typedef ULONG GID;             /* Gradd ID */

  typedef ULONG  (EXPENTRY FNHWCMD)(PVOID, PVOID);
  typedef ULONG  (EXPENTRY FNHWIOPL)(FNHWCMD *, PVOID, PVOID);
  typedef ULONG  (EXPENTRY FNHWENTRY)(GID, ULONG, PVOID, PVOID);
  typedef ULONG  (EXPENTRY FNSDBITBLT)(PVOID);
  typedef ULONG  (EXPENTRY FNSDLINE)(PVOID);
  typedef ULONG  (EXPENTRY FNVDDENTRY)(ULONG, PVOID, PVOID);

  typedef FNHWENTRY *  PFNHWENTRY;

  typedef struct _GDDMODEINFO {     /* gddmodeinfo */
     ULONG  ulLength;
     ULONG  ulModeId;               /* used to make SETMODE request     */
     ULONG  ulBpp;                  /* no of colors (bpp)               */
     ULONG  ulHorizResolution;      /* horizontal pels                  */
     ULONG  ulVertResolution;       /* vertical scan lines              */
     ULONG  ulRefreshRate;          /* in Hz (0 if not available)       */
  } GDDMODEINFO;
  typedef GDDMODEINFO *PGDDMODEINFO;



  /*
  **  Structure for HWEntry router, see gdddata.c for array.
  */

  typedef struct _HWCMD {           /* hwcmd */
          FNHWCMD         *pfnHWCmd;
          ULONG           fRing2Call;
          ULONG           ulRc;
  } HWCMD;
  typedef HWCMD *PHWCMD;

  /*
  **  Flags for HWCMD (fRing2Call)
  */

  #define RING3                  (FALSE)
  #define RING2                  (TRUE)

  /*
  **  Possible return codes from the individual DDI's
  */
  #define RC_SUCCESS              0
  #define RC_SIMULATE             1
  #define RC_UNSUPPORTED          2
  #define RC_ERROR                3


  /*
  ** Place holder for data fields which don't apply
  */
  #define DONTCARE                0

  /*
  **  Prototype declarations for low level driver routines
  */

  FNHWIOPL  HWCallIOPL;
  FNHWENTRY HWEntry;

  /*
  **  Graphics Hardware Interface (GHI) commands
  */
  #define GHI_CMD_INIT           0
  #define GHI_CMD_TERM           1
  #define GHI_CMD_QUERYCAPS      2
  #define GHI_CMD_QUERYMODES     3
  #define GHI_CMD_SETMODE        4
  #define GHI_CMD_PALETTE        5
  #define GHI_CMD_BITBLT         6
  #define GHI_CMD_LINE           7
  #define GHI_CMD_MOVEPTR        8
  #define GHI_CMD_SETPTR         9
  #define GHI_CMD_SHOWPTR        10
  #define GHI_CMD_VRAMALLOC      11
  #define GHI_CMD_REQUESTHW      12
  #define GHI_CMD_BANK           13
  #define GHI_CMD_EXTENSION      14
  #define GHI_CMD_MAX            15

  /*
  **  Defines and structures for the GHI_CMD_INIT DDI
  */

  typedef struct _GDDINITIN {         /* gddinitin */
     ULONG        ulLength;
     PFNHWENTRY   pfnChainedHWEntry;
  } GDDINITIN;
  typedef GDDINITIN  *PGDDINITIN;

  typedef struct _GDDINITOUT {        /* gddinitout */
     ULONG        ulLength;
     ULONG        cFunctionClasses;
  } GDDINITOUT;
  typedef GDDINITOUT  *PGDDINITOUT;


  /*
  **  Defines and structures for the GHI_CMD_QUERYCAPS DDI
  */

  typedef struct _CAPSINFO {          /* capsinfo */
     ULONG        ulLength;           /* sizeof CAPSINFO structure      */
     PSZ          pszFunctionClassID; /* Name describing function set   */
     PVOID        pCaps;              /* Function set specific caps     */
  } CAPSINFO;
  typedef CAPSINFO  *PCAPSINFO;

  typedef struct _BASECAPS {          /* basecaps */
     ULONG        ulLength;           /* sizeof BASECAPS structure      */
     ULONG        ulHWFlags;          /* Base caps flags                */
  } BASECAPS;
  typedef BASECAPS  *PBASECAPS;

  /*
  ** Flag definitions for the ulHWFlags field of of BASECAPS
  ** data structure.
  */

  /*
  ** Setting this bit ON allows VRAM access to be shared between
  ** the GRADD and SOFTDRAW WITHOUT semaphore protection.  If the
  ** graphics coprocessor allows direct writing to VRAM while it
  ** is busy, you should set this bit because performance will be improved.
  */
  #define HWF_SHARE_VRAM_ACCESS         0x0001

  /*
  ** Set this bit if no linear frame buffer is available.
  */
  #define HWF_NOFRAMEBUFFER             0x0002

  /*
  ** Set this bit if your GRADD needs to see bitblts which do not
  ** involve VRAM.
  */
  #define HWF_SEND_MEM_TO_MEM           0x0004

  /*
  ** Set this bit if your GRADD needs bank switching.
  */
  #define HWF_BANK_DEVICE               0x0008


  /*
  **  Defines and structures for the GHI_CMD_QUERYMODES and GHI_CMD_SETMODE
  */

  typedef struct _GDDMODERETURN {   /* gddmodereturn */
     ULONG  ulLength;
     PBYTE  pbVRAMVirt;
     PBYTE  pbVRAMPhys;
     ULONG  ulApertureSize;
     ULONG  ulScanLineSize;
     ULONG  ulBankSize;
  } GDDMODERETURN;
  typedef GDDMODERETURN *PGDDMODERETURN;

  #define QUERYMODE_NUM_MODES     0x0001
  #define QUERYMODE_MODE_DATA     0x0002
  #define QUERYMODE_VALID         (QUERYMODE_NUM_MODES|QUERYMODE_MODE_DATA)


  /*
  **  Defines and structures for the GHI_CMD_BITBLT DDI
  */

  typedef struct _BMAPINFO {        /* bmapinfo */
     ULONG  ulLength;
     ULONG  ulType;
     ULONG  ulWidth;
     ULONG  ulHeight;
     ULONG  ulBpp;
     ULONG  ulBytesPerLine;
     PBYTE  pBits;
  } BMAPINFO;
  typedef BMAPINFO  *PBMAPINFO;

  typedef struct _BLTRECT {         /* bltrect */
     ULONG  ulXOrg;
     ULONG  ulYOrg;
     ULONG  ulXExt;
     ULONG  ulYExt;
  } BLTRECT;
  typedef BLTRECT  *PBLTRECT;

  /*
  **  Defines for the ulType field of the BMAPINFO data structure
  */

  #define BMAP_VRAM    0x00000000
  #define BMAP_MEMORY  0x00000001

  typedef struct _BITBLTINFO {      /* bitbltinfo */
     ULONG        ulLength;
     ULONG        ulBltFlags;
     ULONG        cBlits;
     ULONG        ulROP;
     ULONG        ulMonoBackROP;
     ULONG        ulSrcFGColor;
     ULONG        ulSrcBGColor;
     ULONG        ulPatFGColor;
     ULONG        ulPatBGColor;
     PBYTE        abColors;
     PBMAPINFO    pSrcBmapInfo;
     PBMAPINFO    pDstBmapInfo;
     PBMAPINFO    pPatBmapInfo;
     PPOINTL      aptlSrcOrg;
     PPOINTL      aptlPatOrg;
     PBLTRECT     abrDst;
     PRECTL       prclSrcBounds;    // incl/excl bounds.
     PRECTL       prclDstBounds;    // incl/excl bounds.
  } BITBLTINFO;
  typedef BITBLTINFO *PBITBLTINFO;

  /*
  ** Defines for ulBltFlags field of the BITBLTINFO data structure
  **
  ** The default state of the flags are as follows:
  **
  ** DIRECTION      = Left to right - top to bottom
  ** TRANSPARENCY   = NONE
  ** PATTERN STYLE  = UNKNOWN
  ** BACKGROUND ROP = INVALID
  */

  #define BF_DEFAULT_STATE          0x00000000

  #define BF_DIR_RIGHT_LEFT         0x00000001
  #define BF_DIR_BOTTOM_TOP         0x00000002

  #define BF_ROP_INCL_SRC           0x00000004
  #define BF_ROP_INCL_PAT           0x00000008

  #define BF_SRC_TRANSPARENT        0x00000010
  #define BF_DST_TRANSPARENT        0x00000020
  #define BF_PAT_TRANSPARENT        0x00000040

  #define BF_PAT_SOLID              0x00000080
  #define BF_PAT_HOLLOW             0x00000100

  #define BF_APPLY_BACK_ROP         0x00000200

  #define BF_SRC_MONOINVERT         0x00000400
  #define BF_PAT_MONOINVERT         0x00000800


  /*
  **  Defines and structures for the GHI_CMD_LINE DDI
  */

  typedef struct _LINEPACK {           /* linepack */
     ULONG            ulStyleStep;
     ULONG            ulStyleValue;
     ULONG            ulFlags;
     struct _LINEPACK * plpkNext;
     ULONG            ulAbsDeltaX;
     ULONG            ulAbsDeltaY;
     POINTL           ptlClipStart;
     POINTL           ptlClipEnd;
     POINTL           ptlStart;
     POINTL           ptlEnd;
     LONG             lClipStartError; // Bresenham error at the clip start.
                                       // not valid for horizontal or
                                       // vertical lines.
  } LINEPACK;    /* lpk */
  typedef LINEPACK  *PLINEPACK;   /* plpk */


  /*
  **  Defines for the ulFlags field of the LINEPACK data structure
  */
  #define LINE_DO_FIRST_PEL      0x00000002
  #define LINE_DIR_Y_POSITIVE    0x00000004
  #define LINE_HORIZONTAL        0x00000008
  #define LINE_X_MAJOR           0x00000010
  #define LINE_DIR_X_POSITIVE    0x00000020
  #define LINE_VERTICAL          0x00001000
  #define LINE_STYLE_X_MAJOR     0x00002000
  #define LINE_DO_LAST_PEL       0x00004000

  /*  Line drawing
  **
  **    The line starts from ptlStart and ends at ptlEnd(inclusive).
  **    The device can do the Bresenham either from ptlStart or
  **    from the ptlClipStart using the lClipStartError and
  **    will only set the pels from ptlClipStart to ptlClipEnd(inclusive).
  **
  **  ulAbsDeltaX :
  **    absolute (ptlStart.x - ptlEnd.x)
  **
  **  ulAbsDeltaY :
  **    absolute (ptlStart.y - ptlEnd.y)
  **
  **  lClipStartError:
  **
  **    This is the standard Bresenham error at the clipped start point.
  **    This is calculated from the initial error at the start point and
  **    the error increments for major step and diagonal step.
  **
  **    The initial error and the error increments are:
  **
  **    MAX           = maximum (ulAbsDeltaX, ulAbsDeltaY)
  **    MIN           = minimum (ulAbsDeltaX, ulAbsDeltaY)
  **    Major Inc.    = Increment to the error for
  **                    stepping along the major axis.
  **                  = 2 * MIN
  **    Diagonal Inc. = Increment to the error for
  **                    stepping along the major and minor axis.
  **                  = 2 * MIN - 2 * MAX
  **    Initial error = Error at the start point.
  **                  = 2 * MIN - MAX  if LINE_DIR_X_POSITIVE is on
  **                  = 2 * MIN - MAX - 1 if LINE_DIR_X_POSITIVE is off.
  **
  **   Horizontal and vertical lines.
  **      The line is drawn from the clipped start to clipped end.
  **      The lClipStartError will not be given.
  **
  **   First pel consideration.
  **      Set the the first pel at the ptlStart (not ptlClipStart) only
  **      if LINE_DO_FIRST_PEL is set and the first pel is not clipped out.
  **
  **   Last pel consideration.
  **      Set the the last pel at the ptlEnd (not ptlClipEnd) only
  **      if LINE_DO_LAST_PEL is set and the last pel is not clipped out.
  **
  **
  **   Styling.
  **      Lines are styled using the ulStyleMask, ulStyleStep and ulStyleValue.
  **
  **      ulStyleMask:
  **         A 32 bit style mask.
  **
  **      ulStyleStep:
  **         The value to be added to ulStyleValue
  **         on each pel stepped along the style major direction.
  **
  **      ulStyleValue:
  **         The style value at the current pel.
  **         it is composed of an error value and a mask position as :
  **
  **         Ŀ
  **             high word     3 bits    5 bits     8 bits    
  **         
  **             not used     not used  mask pos  error value 
  **
  **      Error Value :
  **         Error value at the current pel.
  **
  **      Mask Position :
  **         Bit position of the ulStyleMask.
  **         if this bit is on,
  **            set the current pel to the ulFGColor through usForeROP,
  **         otherwise
  **            set the current pel to the ulBGColor through usBackRop
  **
  */

  typedef struct _LINEINFO {        /* linfo */
     ULONG          ulLength;
     ULONG          ulType;
     ULONG          ulStyleMask;
     ULONG          cLines;
     ULONG          ulFGColor;
     ULONG          ulBGColor;
     USHORT         usForeROP;
     USHORT         usBackROP;
     PBMAPINFO      pDstBmapInfo;
     PLINEPACK      alpkLinePack;
     PRECTL         prclBounds;     // incl/incl bounds.
  } LINEINFO;      /* linfo */
  typedef  LINEINFO *PLINEINFO;     /* plinfo */


  /*
  **  Defines for the ulType field of the LINEINFO data structure
  */
  #define LINE_SOLID       0x01
  #define LINE_INVISIBLE   0x02
  #define LINE_ALTERNATE   0x03


  /*
  ** Defines for 2 way Line ROPS
  */
                                    // PATTERN = 0xC and DEST = 0xA
  #define LR_ZERO               0   // 0x0
  #define LR_INVERTMERGEPAT     1   // ~(LR_DEST | LR_PATTERN)
  #define LR_MASKINVERTPAT      2   // (~LR_PATTERN) & LR_DEST
  #define LR_INVERTCOPYPAT      3   // ~LR_PATTERN
  #define LR_MASKPATINVERT      4   // (~LR_DEST) & LR_PATTERN
  #define LR_INVERT             5   // ~LR_DEST
  #define LR_XORPAT             6   // LR_DEST ^ LR_PATTERN
  #define LR_INVERTMASKPAT      7   // ~(LR_DEST & LR_PATTERN)
  #define LR_MASKPAT            8   // LR_DEST & LR_PATTERN
  #define LR_INVERTXORPAT       9   // ~(LR_DEST ^ LR_PATTERN)
  #define LR_LEAVEALONE        10   // LR_DEST
  #define LR_MERGEINVERTPAT    11   // (~LR_PATTERN) | LR_DEST
  #define LR_PATCOPY           12   // LR_PATTERN
  #define LR_MERGEPATINVERT    13   // (~LR_DEST) | LR_PATTERN
  #define LR_MERGEPAT          14   // LR_PATTERN | LR_DEST
  #define LR_ONE               15   // 0x0F

  /*
  **  Defines and structures for the GHI_CMD_PALETTE
  */

  typedef struct _HWPALETTEINFO { /* hwpaletteinfo */
     ULONG  ulLength;
     ULONG  fFlags;               /* Get/Set palette                      */
     ULONG  ulStartIndex;         /*                                      */
     ULONG  ulNumEntries;         /*                                      */
     PRGB2  pRGBs;                /*                                      */
  } HWPALETTEINFO;
  typedef HWPALETTEINFO *PHWPALETTEINFO;

  #define PALETTE_GET             0x0001
  #define PALETTE_SET             0x0002

  /*
  **  Defines and structures for the GHI_CMD_MOVEPTR DDI
  */

  typedef struct _HWMOVEPTRIN {     /* hwmoveptrin */
     ULONG  ulLength;
     POINTL ptlPos;
  } HWMOVEPTRIN;
  typedef HWMOVEPTRIN *PHWMOVEPTRIN;


  /*
  **  Defines and structures for the GHI_CMD_SETPTR DDI
  */

  typedef struct _HWSETPTRIN {      /* hwsetptrin */
     ULONG  ulLength;
     PBYTE  pbANDMask;
     PBYTE  pbXORMask;
     PBYTE  pbBits;
     ULONG  ulBpp;
     ULONG  ulWidth;
     ULONG  ulHeight;
     POINTL ptlHotspot;
  } HWSETPTRIN;
  typedef HWSETPTRIN *PHWSETPTRIN;

  typedef struct _HWSETPTROUT {      /* hwsetptrout */
     ULONG ulLength;
     ULONG ulStatus;
  } HWSETPTROUT;
  typedef HWSETPTROUT *PHWSETPTROUT;

  /*
  ** Defines for the ulStatus field of the HWSETPTROUT structure
  */

  #define POINTER_VISIBLE       0x0001
  #define POINTER_COLOR         0x0002
  #define POINTER_SOFTWARE      0x0004

  /*
  **  Defines and structures for the GHI_CMD_SHOWPTR DDI
  */

  typedef struct _HWSHOWPTRIN {     /* hwshowptrin */
     ULONG ulLength;
     BOOL  fShow;
  } HWSHOWPTRIN;
  typedef HWSHOWPTRIN *PHWSHOWPTRIN;


  /*
  **  Defines and structures for the GHI_CMD_VRAMALLOC
  */

  typedef struct _HWVRAMALLOCIN {    /* hwvramallocin */
     ULONG ulLength;
     ULONG ulAllocType;
     ULONG ulStart;
     ULONG ulSize;
  } HWVRAMALLOCIN;
  typedef HWVRAMALLOCIN *PHWVRAMALLOCIN;

  typedef struct _HWVRAMALLOCOUT {     /* hwvramallocout */
     ULONG ulLength;
     ULONG ulStart;
     ULONG ulSize;
  } HWVRAMALLOCOUT;
  typedef HWVRAMALLOCOUT *PHWVRAMALLOCOUT;

  /*
  **  Defines for the ulAllocType field of the HWVRAMALLOCIN
  **  data structure.
  */

  #define VRAM_ALLOC               0
  #define VRAM_DEALLOC             1
  #define VRAM_QUERY               2

  /*
  **  Defines and structures for the GHI_CMD_REQUESTHW command
  */

  typedef struct _HWREQIN {        /* hwreqin */
     ULONG  ulLength;
     BOOL   fRequest;              /* TRUE == Request - FALSE == Release */
     ULONG  cScrChangeRects;
     PRECTL arectlScreen;
  } HWREQIN;
  typedef HWREQIN *PHWREQIN;

  /*
  **  Defines and structures for the GHI_CMD_BANK command
  */

  typedef struct _HWBANKIN {       /* hwbankin  */
     ULONG  ulLength;
     ULONG  fFlags;                /* Get/Set bank */
     ULONG  ulBank;                /* Bank number  */
  } HWBANKIN;
  typedef HWBANKIN *PHWBANKIN;

  #define BANK_GET             0x0001
  #define BANK_SET             0x0002

  typedef struct _HWBANKOUT {      /* hwbankout */
     ULONG  ulLength;
     ULONG  ulBank;                /* Bank number  */
  } HWBANKOUT;
  typedef HWBANKOUT *PHWBANKOUT;


  /*
  **  Defines and structures for the GHI_CMD_EXTENSION command
  */

  typedef struct _HWEXTENSION {          /* hwextension */
     ULONG  ulLength;
     ULONG  cScrChangeRects;
     PRECTL arectlScreen;
     ULONG  ulXFlags;
     PVOID  pXP1;
  } HWEXTENSION;
  typedef HWEXTENSION *PHWEXTENSION;

  /*
  **  Defines for the ulXFlags field of the HWEXTENSION data structure.
  */

  #define X_REQUESTHW  1

  /*
  **  Prototype declarations for Video Manager Interface (VMI)
  */

  typedef ULONG (EXPENTRY FNVMIENTRY)(GID, ULONG, PVOID, PVOID);

  /*
  **  VMI commands which map directly to GRADD commands
  */
  #define VMI_CMD_INIT             GHI_CMD_INIT
  #define VMI_CMD_TERM             GHI_CMD_TERM
  #define VMI_CMD_QUERYCAPS        GHI_CMD_QUERYCAPS
  #define VMI_CMD_QUERYMODES       GHI_CMD_QUERYMODES
  #define VMI_CMD_SETMODE          GHI_CMD_SETMODE
  #define VMI_CMD_PALETTE          GHI_CMD_PALETTE
  #define VMI_CMD_BITBLT           GHI_CMD_BITBLT
  #define VMI_CMD_LINE             GHI_CMD_LINE
  #define VMI_CMD_MOVEPTR          GHI_CMD_MOVEPTR
  #define VMI_CMD_SETPTR           GHI_CMD_SETPTR
  #define VMI_CMD_SHOWPTR          GHI_CMD_SHOWPTR
  #define VMI_CMD_VRAMALLOC        GHI_CMD_VRAMALLOC
  #define VMI_CMD_REQUESTHW        GHI_CMD_REQUESTHW
  #define VMI_CMD_BANK             GHI_CMD_BANK
  #define VMI_CMD_EXTENSION        GHI_CMD_EXTENSION

  /*
  **  VMI commands unique to the video manager
  */
  #define VMI_CMD_QUERYCHAININFO   GHI_CMD_MAX
  #define VMI_CMD_INITPROCESS      GHI_CMD_MAX + 1
  #define VMI_CMD_TERMPROCESS      GHI_CMD_MAX + 2
  #define VMI_CMD_MAX              GHI_CMD_MAX + 3

  /*
  **  Defines and structures for VMI_QUERYCHAININFO
  */

  typedef struct _GRADDINFO {       /* graddinfo */
          GID                   gid;
          PSZ                   pszGraddName;
          PFNHWENTRY            pGraddEntry;
          PFNHWENTRY            pChainEntry;
          ULONG                 cModes;
          GDDMODERETURN         ModeRet;
          struct _GDDMODEINFO * pModeInfo;
          struct _CAPSINFO *    pCapsInfo;
          struct _GRADDINFO *   pNextGraddInfo;
  } GRADDINFO ;
  typedef GRADDINFO *PGRADDINFO;

  typedef struct _CHAININFO {       /* chaininfo */
          CID                   cid;
          PSZ                   pszChainName;
          PFNHWENTRY            pChainHWEntry;
          PGRADDINFO            pGraddList;
          struct _CHAININFO *   pNextChainInfo;
  } CHAININFO ;
  typedef CHAININFO *PCHAININFO;


  typedef struct _VMIQCI {          /* vmiqci */
     ULONG        ulLength;
     PCHAININFO   pciHead;                /* Head of the GRADD chain      */
  } VMIQCI;
  typedef VMIQCI  *PVMIQCI;


  /* NOINC */
  #endif /* VMANDDI_INCLUDED */
  /* INC */

#endif  /* INCL_VMANDDI */

#ifdef INCL_VMANWIN

  /* NOINC */
  #ifndef VMANWIN_INCLUDED

  #define VMANWIN_INCLUDED
  /* INC */

  /*
  **  Structures for communication with VMANWIN VDD.
  */

  #define       VMWNAME                 "VMANWIN"
  #define       VMWSYSREQ_WAITDATA      1

  typedef struct _VMANWINVMAN {             /* vmanwinvman */
    ULONG       gid;
    ULONG       ulFn;
    PVOID       pIn;
    PVOID       pOut;
  } VMANWINVMAN;
  typedef VMANWINVMAN *PVMANWINVMAN;

  typedef struct _VMANWINALLOCMEMORY {      /* vmanwinallocmemory */
    ULONG       ulSize;
    PVOID       pAddress16;
    PVOID       pAddress32;
  } VMANWINALLOCMEMORY;
  typedef VMANWINALLOCMEMORY *PVMANWINALLOCMEMORY;

  typedef struct _VMANWINFREEMEMORY {       /* vmanwinfreememory */
    PVOID       pAddress32;
  } VMANWINFREEMEMORY;
  typedef VMANWINFREEMEMORY *PVMANWINFREEMEMORY;

  typedef struct _VMANWINCONVERTPTR {       /* vmanwinconvertptr */
    PVOID       pAddress16;
    PVOID       pAddress32;
  } VMANWINCONVERTPTR;
  typedef VMANWINCONVERTPTR *PVMANWINCONVERTPTR;

  typedef struct _VMANWINPARMS {            /* vmanwinparms */
    PVOID       pOut;
    PVOID       pIn;
    ULONG       ulFn;
  } VMANWINPARMS;
  typedef VMANWINPARMS *PVMANWINPARMS;

  /*
  ** Defines for ulFn in struct VMANWINPARMS
  */
  #define       VMWCMD_VMAN          0  /* Call VMAN                     */
  #define       VMWCMD_ALLOC         1  /* Allocate Global Shared memory */
  #define       VMWCMD_FREE          2  /* Free Global Shared memory     */
  #define       VMWCMD_CONVERTPTR    3  /* Convert 16:16 or 0:32 pointer */

  /* NOINC */
  #endif  /* VMANWIN_INCLUDED */
  /* INC */

#endif  /* INCL_VMANWIN */


#ifdef INCL_VMANHELP

  /* NOINC */
  #ifndef VMANHELP_INCLUDED

  #define VMANHELP_INCLUDED
  /* INC */

  typedef struct _MEMINFO    {   /* meminfo */
    ULONG       ulPhysAddr;
    ULONG       ulMemLen;
    ULONG       ulVirtAddr;
    PVOID       pNextMI;
  } MEMINFO;
  typedef MEMINFO *PMEMINFO;

  PVOID VHAllocMem( ULONG );
  ULONG VHFreeMem( PVOID );
  ULONG VHPhysToVirt( PMEMINFO );
  int _Optlink VHPrintf(const char *, ...);

  /* NOINC */
  #endif  /* VMANHELP_INCLUDED */
  /* INC */

#endif  /* INCL_VMANHELP */

#ifdef INCL_GRADDIO

  /* NOINC */
  #ifndef GRADDIO_INCLUDED

  #define GRADDIO_INCLUDED
  /* INC */

  /*
  **  General port IO routines
  */

  typedef unsigned long   DWORD;
  typedef unsigned short  WORD;
  typedef unsigned short  IOPORT;

  BYTE  EXPENTRY HWInpByte(IOPORT);
  WORD  EXPENTRY HWInpWord(IOPORT);
  DWORD EXPENTRY HWInpDWord(IOPORT);
  VOID  EXPENTRY HWOutpByte(IOPORT, BYTE);
  VOID  EXPENTRY HWOutpWord(IOPORT, WORD);
  VOID  EXPENTRY HWOutpDWord(IOPORT, DWORD);
  VOID  EXPENTRY HWOutpString(IOPORT, DWORD, PBYTE);
  VOID  EXPENTRY HWOutpRect(IOPORT, DWORD, DWORD, PBYTE, DWORD);
  VOID  EXPENTRY HWOutpBitRect(IOPORT, DWORD, DWORD, PBYTE, DWORD);
  VOID  EXPENTRY HWOutpTransRect(IOPORT, DWORD, DWORD, PBYTE, DWORD, PBYTE);
  VOID  EXPENTRY HWInpString(IOPORT, DWORD, PBYTE);

  /* NOINC */
  #endif /* GRADDIO_INCLUDED */
  /* INC */

#endif  /* INCL_GRADDIO */

