/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// exception handling definitions and macros

// FNEH is a typedef for an exception handler function
typedef ULONG _System FNEH( PEXCEPTIONREPORTRECORD, PEXCEPTIONREGISTRATIONRECORD, PCONTEXTRECORD, PVOID );
typedef FNEH *PFNEH;

// typedef for a handler registration record; a link in a list
struct _regrec {
  PEXCEPTIONREGISTRATIONRECORD pnext;       // req'd by os2
  PFNEH                        pfn;         // req'd by os2
  jmp_buf                      jmp;         // additional field for C runtime longjmp support
  HMODULE                      hModule;     // additional field
};
typedef struct _regrec REGREC, *PREGREC;

#define REGISTERHANDLER(regrec, hmod)                               \
  regrec.pfn = GplpHandler;                                         \
  regrec.hModule = hmod;                                            \
  DosSetExceptionHandler ((PEXCEPTIONREGISTRATIONRECORD) &regrec);

#define UNREGISTERHANDLER(regrec)  DosUnsetExceptionHandler ((PEXCEPTIONREGISTRATIONRECORD)&regrec);

#define XCPT_USER         0xC0C00ABC

#define RAISEEXCEPTION(exnum) {\
  EXCEPTIONREPORTRECORD err;\
  err.ExceptionNum = exnum;\
  memset (&err, 0, sizeof (err));\
  DosRaiseException (&err);\
}

extern ULONG _System GplpHandler (PEXCEPTIONREPORTRECORD p1,
                                  PEXCEPTIONREGISTRATIONRECORD p2,
                                  PCONTEXTRECORD p3,
                                  PVOID pv);
