/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*  DISCLAIMER OF WARRANTIES.  The following [enclosed] code is             */
/*  sample code created by IBM Corporation. This sample code is not         */
/*  part of any standard or IBM product and is provided to you solely       */
/*  for  the purpose of assisting you in the development of your            */
/*  presentation drivers.  The code is provided "AS IS", without            */
/*  warranty of any kind.  IBM shall not be liable for any damages          */
/*  arising out of your use of the sample code, even if they have been      */
/*  advised of the possibility of such damages.                             */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/* FILENAME       : GPLSORT.H                                               */
/* AUTHOR         : Matthew F. Rutkowski                                    */
/* DATE WRITTEN   : 09-04-93                                                */
/* DESCRIPTION    : This module contains all public MACROS, IDs,            */
/*                  constants and data type definitions used by             */
/*                  the Generic Print Library String Sorter package.        */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* Modification/Change log                                                  */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/****************************************************************************/

// Region comparison flags
#define STR_INCL_TOPLEFT_IN_BAND 0x0001
#define STR_INCL_ALL_IN_BAND     0x0004
#define STR_INCL_PART_IN_BAND    0x0008

// Heap management/allocation values (to be nice kept a multiple of 8)
// so mem mgmt won't need to round up
#define SORTER_HEAP_SIZE         524288L
#define SORTER_HEAP_SUBSET       524288L
#define SORTER_MIN_HEAP_SIZE      65536L

// Internal Allocation flags
#define ALLOC_NORMAL     0x0000
#define ALLOC_INIT_NULL  0x0001

// String Sorter - String Entry structure
struct _SORTENTRY
{
  struct _SORTENTRY *pNext;
  RECTL              rectlString;
  PVOID              pUserDefined;
  PSZ                pszString;
};

typedef struct _SORTENTRY SORTENTRY, *PSORTENTRY, **PPSORTENTRY;

struct _SORTER
{
  ULONG      ulNumEntries;
  PSORTENTRY pFirstEntry;
  PSORTENTRY pLastEntry;
  ULONG      ulRemoveOption;
  RECTL      rectlBand;
  PSORTENTRY pNextEntry;
  HMCB       hmcb;
};

typedef struct _SORTER SORTER, *PSORTER, **PPSORTER;
typedef struct _SORTER *HSORTER, **PHSORTER;

/*--------------------------------------------------------------------------*/
/* PROTOTYPES                                                               */
/*--------------------------------------------------------------------------*/

// String sorting functions
APIRET APIENTRY GplStringSorterCreateInstance  ( HDC, PHSORTER, ULONG, ULONG );
APIRET APIENTRY GplStringSorterInsertString    ( HSORTER, PSZ, RECTL, PVOID, PVOID );
APIRET APIENTRY GplStringSorterQueryNumStrings ( HSORTER, PULONG );
APIRET APIENTRY GplStringSorterGetFirstString  ( HSORTER, ULONG, RECTL, PSZ *, PRECTL, PPVOID );
APIRET APIENTRY GplStringSorterGetNextString   ( HSORTER, PSZ *, PRECTL, PPVOID );
APIRET APIENTRY GplStringSorterRemoveStrings   ( HSORTER, ULONG, RECTL );
APIRET APIENTRY GplStringSorterReset           ( HSORTER );
APIRET APIENTRY GplStringSorterDeleteInstance  ( HSORTER );


