/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// gplsemp.h
// private sem declarations and functions and macros


// the asm code incs or decs by 1
#define INCREMENT( p )  GplpBumpMemoryUp( p )
#define DECREMENT( p )  GplpBumpMemoryDown( p )


// extended exception registration record
typedef struct _regrec {
  PVOID     pNext;
  PFN       pfnHandler;
  jmp_buf   jmpWorker;
} REGREC;
typedef REGREC *PREGREC;


ULONG  APIENTRY GplpSemHandler( PEXCEPTIONREPORTRECORD, PREGREC, PCONTEXTRECORD, PVOID );
ULONG  APIENTRY GplpBumpMemoryUp( PLONG );
ULONG  APIENTRY GplpBumpMemoryDown( PLONG );
ULONG  APIENTRY Gplp_intel_cmpxchg( PULONG, ULONG );
BOOL   APIENTRY GplpQuery486( VOID );
ULONG  APIENTRY GplpCallersRet( VOID );

#define FLAGS_SHARED         1
#define FLAGS_486            4

