/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// gplsem.h
// defines the MTXSEM structure and the Gpl semaphore function prototypes


// this file has a dependency on OS/2 semaphore definitions
#ifndef INCL_DOSSEMAPHORES
#error Please define INCL_DOSSEMAPHORES and try again.
#endif


typedef struct _MTXSEM {
   ULONG      id;                 // "MTX\0" eyecatcher
   ULONG      ulProcessThread;    // owner process and thread id (PTid)
   LONG       lNestedUseCount;    // # of times same PTid has accessed sem
   LONG       lWaitingCount;      // # of PTids waiting on semaphore
   LONG       lUseCount;          // # of processes using this sem
   HEV        hev;                // kernel sem to block on when sem is owned
   HMTX       hmtx;               // kernel mutex sem for 386 clients
   ULONG      ulFlags;            // 486, shared
   ULONG      ulOwnersRetAddress; // caller's return address
} MTXSEM;
typedef MTXSEM *PMTXSEM;


APIRET APIENTRY GplSemCreateMutexSem( PMTXSEM pmtxsem, ULONG flAttr  );
APIRET APIENTRY GplSemOpenMutexSem( PMTXSEM pmtxsem );
APIRET APIENTRY GplSemRequestMutexSem( PMTXSEM pmtxsem, LONG lTime  );
APIRET APIENTRY GplSemReleaseMutexSem( PMTXSEM );
APIRET APIENTRY GplSemCloseMutexSem( PMTXSEM );
APIRET APIENTRY GplSemQueryMutexSem( PMTXSEM pmtxsem, PID *ppid, TID *ptid, PULONG pulCount );

