/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
typedef void  (* APIENTRY pfnFlushBuffer) (PVOID, PBYTE, ULONG);

INT  APIENTRY  GplFaxG4EndBlock     (PVOID, PBYTE, ULONG, PULONG, pfnFlushBuffer );
INT  APIENTRY  GplFaxG4EncodeBlock  (PVOID, PBYTE, ULONG, PULONG, PBYTE, ULONG, ULONG, pfnFlushBuffer, PULONG, PULONG, PULONG, PULONG, ULONG);

VOID APIENTRY  GplFaxG3StartDoc    (PBYTE, PULONG);
INT  APIENTRY  GplFaxG3NewFrame    (PVOID, PBYTE, ULONG, PULONG, pfnFlushBuffer );
INT  APIENTRY  GplFaxG3EndDoc      (PVOID, PBYTE, ULONG, PULONG, pfnFlushBuffer );
INT  APIENTRY  GplFaxG3EncodeBlock (PVOID, PBYTE, ULONG, PULONG, PBYTE, ULONG, ULONG, pfnFlushBuffer );

VOID APIENTRY  GplFaxTIFF2StartBlock    (PULONG);
INT  APIENTRY  GplFaxTIFF2EncodeBlock   (PVOID, PBYTE, ULONG, PULONG, PBYTE, ULONG, ULONG, pfnFlushBuffer );
VOID APIENTRY  GplFaxTIFF2EndBlock      (PVOID, PBYTE, PULONG, pfnFlushBuffer );


#if 0


The following is more descriptions of the present fax compression
algorthims:

Note:  To use MRR Group 4:
(1) First allocate memory for the pbOutput, pulBitposition, pulwstartc,
pulbstartc, pulwstartp, pulbstartp.  Note I do this at one time
then set the pointers into this memory appropriated to the usBitwide
parameter.  Note that this memory must be zero on the first invocation
of GplFaxG4EncodeBlock().   pulBitposition records the bitposition
into the output buffer.


      (a) Allocate memory
      (b) Set pointers up to point into this memory
      (c) Call GplFaxG4EncodeBlock() one or more times
      (d) Call GplFaxG4EndBlock() once.
      (e) Free memory

(1) To use the fax functions in source files:

      #define INCL_GENPLIB_FAX
      #include <genplib.h>

      Place this in the files where you will be using the 
      fax functions.


/************************************************************************
 *         M R R    G R O U P  4     A  L  G  O  R  I  T  H  M  S
 ************************************************************************/

/************************************************************************
 *                                                                      *
 * Function:      GplFaxG4EncodeBlock                                   *
 *                                                                      *
 * Description: Modified Read (MRR) Group 4 compression for a block     *
 *              of raster data with K = infinity.                       *
 *                                                                      *
 * Inputs: pddc              = PVOID - Used as first parameter to the   *
 *                             pfnFlushBuffer function.  This is        *
 *                             generally the pddc or HTHREAD.           *
 *         pbOutput          = Output Buffer to fill                    *
 *         ulOutputSize      = Size in bytes of Output Buffer           *
 *                             Must be a multiple of 32 bits            *
 *         pulBitpostion     = Bitpostion count in the Output Buffer    *
 *         pbInput           = Input pointer to upper left corner of    *
 *                             raster image to compress                 *
 *         ulBitWide         = The width of the raster image in bits    *
 *         ulBitheight       = The height of the raster image in bits   *
 *         pfnFlushBuffer    = Flush Buffer function.  Note the         *
 *                             prototype for this function must be:     *
 *                                                                      *
 *          void  pfnFlushBuffer ( PVOID, PBYTE, ULONG );               *
 *           PVOID   this will be the necessary parameter for           *
 *                   separateing printout - generally pddc or           *
 *                   HTHREAD                                            *
 *           PBYTE   unsigned char * to Output buffer.  The same as     *
 *                   pbOutput.                                          *
 *           ULONG   unsigned long. The size of pbOutput buffer.        *
 *                   The same as ulOutputSize.                          *
 *                                                                      *
 *        pfnFlushBuffer can be either NULL or point to the function    *
 *        you supply that will write the compressed bytes out.  If      *
 *        pfnFlushBuffer is not NULL this function will be called when  *
 *        output buffer is full.  If pfnFlushBuffer is NULL you must    *
 *        write the bytes out yourself.                                 *
 *                                                                      *
 *         pulwstartc       =  pointer to array of ULONGS its length    *
 *                             must be (ulBitWide + 31 ) / 32 + 2.      *
 *                             The 2 extra ULONGS are needed.  So for   *
 *                             Say your image is 371 bits in width      *
 *                             then the length of this array is         *
 *                             ( 371 + 31 ) / 32 = 12 plus 2 more       *
 *                             which is 14 unsigned longs.  This array  *
 *                             is used to store the start bits of the   *
 *                             begining of consecutive 0 bits for the   *
 *                             current scan line.                       *
 *                                                                      *
 *        pulbstartc       =   Size is the same calculation as above.   *
 *                             This array is used to store the start    *
 *                             bits of the begining of consecutive 1    *
 *                             bits for the current scan line.          *
 *                                                                      *
 *        pulwstartp       =   Size is the same calculation as above.   *
 *                             This array is used to store the start    *
 *                             bits of the begining of consecutive 0    *
 *                             bits for the previous scan line this     *
 *                             must be zero filled on the first         *
 *                             invocation of this function.             *
 *                                                                      *
 *        pulbstartp       =   Size is the same calculation as above.   *
 *                             This array is used to store the start    *
 *                             bits of the begining of consecutive 1    *
 *                             bits for the previous scan line this     *
 *                             must be zero filled on the first         *
 *                             invocation of this function.             *
 *        skipcount        =   number of bytes to skip to get to next   *
 *                             row of input data to compress            *
 *                                                                      *
 *                                                                      *
 * Note (1) *pulBitposition gets updated and must unique to each        *
 *           print job.  Note that *pulBitposition must be zero         *
 *           on the first invocation of this function for a block       *
 * Note (2) The raster image must be have in rows on a 32 bit boundary  *
 *          with 0 bits padding the right.                              *
 * Note (3) ulOutputSize must be divisable by 4                         *
 * Note (4) ulBitWide must be less than or equal to 2560 + 63 = 2623    *
 * Note (5) All other counts can be 2^^32 - 1 == 4,294,967,295          *
 * Note (6) If pfnFlushBuffer() = NULL this function will compress the  *
 *          and place into pbOutput.  If the output buffer size is      *
 *          not large enough for all the compressed data the function   *
 *          will return with -1 = error.                                *
 *          Now if pfnFlushBuffer() is not NULL everytime  pbOutput     *
 *          is full pfnFlushBuffer() is called to write the compressed  *
 *          bytes out.  Note that the return value will the total       *
 *          number of bytes written even though the buffer was filled   *
 *          multiple times.
 *                                                                      *
 * Returns: -1 for error that output buffer is not large enough         *
 *           to hold the compressed this is only returned if            *
 *           pfnFlushBuffer() = NULL.                                   *
 *          or                                                          *
 *          postion count of compressed bytes in pbOutput that you      *
 *          must write out if pfnFlushBuffer() = NULL                   *
 *                                                                      *
 *                                                                      *
 ************************************************************************/



/************************************************************************
 *                                                                      *
 * Function:      GplFaxG4EndBlock                                      *
 *                                                                      *
 * Description: Modified Read (MRR) Group 4 compression with K =        *
 *              infinity for sending end-of-facsimile block (EOFB).     *
 *                                                                      *
 * Inputs: pddc              = PVOID - Used as first parameter to the   *
 *                             pfnFlushBuffer function.  This is        *
 *                             generally the pddc or HTHREAD.           *
 *         pbOutput          = Output Buffer to fill                    *
 *         ulOutputSize      = Size in bytes of Output Buffer           *
 *                             Must be a multiple of 32 bits            *
 *         pulBitpostion     = Bitpostion count in the Output Buffer    *
 *         pbInput           = Input pointer to upper left corner of    *
 *                             raster image to compress                 *
 *         ulBitWide         = The width of the raster image in bits    *
 *         ulBitheight       = The height of the raster image in bits   *
 *         pfnFlushBuffer    = Flush Buffer function.  Note the         *
 *                             prototype for this function must be:     *
 *                                                                      *
 *          void  pfnFlushBuffer ( PVOID, PBYTE, ULONG );               *
 *           PVOID   this will be the necessary parameter for           *
 *                   separateing printout - generally pddc or           *
 *                   HTHREAD                                            *
 *           PBYTE   unsigned char * to Output buffer.  The same as     *
 *                   pbOutput.                                          *
 *           ULONG   unsigned long. The size of pbOutput buffer.        *
 *                   The same as ulOutputSize.                          *
 *                                                                      *
 *        pfnFlushBuffer can be either NULL or point to the function    *
 *        you supply that will write the compressed bytes out.  If      *
 *        pfnFlushBuffer is not NULL this function will be called when  *
 *        output buffer is full.  If pfnFlushBuffer is NULL you must    *
 *        write the bytes out yourself.                                 *
 *                                                                      *
 *                                                                      *
 * Note that *pulBitposition gets updated and must be unique to each    *
 * print job.                                                           *       *
 *                                                                      *
 * Note that ulOutputSize must be divisable by 4                        *
 *                                                                      *
 * Returns: -1 for error that output buffer is not large enough         *
 *           to hold the compressed this is only returned if            *
 *           pfnFlushBuffer() = NULL.                                   *
 *          or                                                          *
 *          postion count of compressed bytes in pbOutput that you      *
 *          must write out if pfnFlushBuffer() = NULL                   *
 *                                                                      *
 *                                                                      *
 ************************************************************************/

/************************************************************************
 *         M  H    G R O U P  3     A  L  G  O  R  I  T  H  M  S
 ************************************************************************/

/************************************************************************
 *                                                                      *
 * Function:      GplFaxG3StartDoc                                      *
 *                                                                      *
 * Description: Modified Huffman (MH) Group 3 EOL ( End of Line)        *
 *              sent at the beginning of the first page.                *
 *                                                                      *
 * Inputs: pbOutput          = Output buffer to fill                    *
 *         pulBitpostion     = Bit Position count in the Output buffer  *
 *                                                                      *
 * Returns: void                                                        *
 *                                                                      *
 * Note: This function just outputs the EOL to pbOutput and initializes *
 *       *pulBitposition to 12.                                         *
 *                                                                      *
 *                                                                      *
 ************************************************************************/

/************************************************************************
 *                                                                      *
 * Function:      GplFaxG3EncodeBlock                                   *
 *                                                                      *
 * Description: Modified Huffman (MH) Group 3 compression for a block   *
 *              of raster data.                                         *
 *                                                                      *
 * Inputs: hThread           = HTHREAD                                  *
 *         pbOutput          = Output Buffer to fill                    *
 *         ulOutputSize      = Size in bytes of Output Buffer           *
 *                             Must be a multiple of 32 bits            *
 *         pulBitpostion     = Bitpostion count in the Output Buffer    *
 *         pbInput           = Input pointer to upper left corner of    *
 *                             raster image to compress                 *
 *         ulBitWide         = The width of the raster image in bits    *
 *         ulBitheight       = The height of the raster image in bits   *
 *         pfnFlushBuffer    = Flush Buffer function.  Note the         *
 *                             prototype for this funciton must be:     *
 *                                                                      *
 *         void   pfnFlushBuffer ( PVOID, PBYTE, ULONG );               *
 *           PVOID   use is the same as G4                              *
 *           PBYTE   unsigned char * to Output buffer.  The same as     *
 *                   pbOutput.                                          *
 *           ULONG   unsigned long. The size of pbOutput buffer.        *
 *                   The same as ulOutputSize.                          *
 *                                                                      *
 *           Note that the BOOL return value is TRUE (1) for ok and     *
 *           FALSE (0) for error.                                       *
 *                                                                      *
 * Note (1) *pulBitposition gets updated and must be stored  off        *
 *           the pddc.                                                  *
 * Note (2) The raster image must be have in rows on a 32 bit boundary  *
 *          with 0 bits padding the right.                              *
 * Note (3) ulOutputSize must be divisable by 4                         *
 * Note (4) ulBitWide must be less than or equal to 2560 + 63 = 2623    *
 * Note (5) All other counts can be 2^^32 - 1 == 4,294,967,295          *
 *                                                                      *
 * Returns: Same as GplFaxG4EncodeBlock()                               *
 *                                                                      *
 *                                                                      *
 ************************************************************************/

/************************************************************************
 *                                                                      *
 * Function:      GplFaxG3EndDoc                                        *
 *                                                                      *
 * Description: Modified Huffman (MH) Group 3 RTC ( Return to Control)  *
 *              sent at the End of Document                             *
 *                                                                      *
 * Inputs: hThread           = PVOID                                    *
 *         pbOutput          = Output Buffer to fill                    *
 *         ulOutputSize      = Size in bytes of Output Buffer           *
 *                             Must be a multiple of 32 bits            *
 *         pulBitpostion     = Bitpostion count in the Output Buffer    *
 *         pfnFlushBuffer    = Flush Buffer function.  Note the         *
 *                             prototype for this funciton must be:     *
 *                                                                      *
 *         void   pfnFlushBuffer (PVOID, PBYTE, ULONG );                *
 *           PVOID   use is the same as above                           *
 *           PBYTE   unsigned char * to Output buffer.  The same as     *
 *                   pbOutput.                                          *
 *           ULONG   unsigned long. The size of pbOutput buffer.        *
 *                   The same as ulOutputSize.                          *
 *                                                                      *
 *           Note that the BOOL return value is TRUE (1) for ok and     *
 *           FALSE (0) for error.                                       *
 *                                                                      *
 * Note that *pulBitposition gets updated and must be stored  off the   *
 * pddc.                                                                *
 *                                                                      *
 * Note that ulOutputSize must be divisable by 4                        *
 *                                                                      *
 *  Returns:  The same as GplFaxG4EncodeBlock()                         *
 *                                                                      *
 ************************************************************************/

/************************************************************************
 *                                                                      *
 * Function:      GplFaxG3NewFrame                                      *
 *                                                                      *
 * Description: Modified Huffman (MH) Group 3 EOL ( End of Line)        *
 *              sent at the beginning of each new page.                 *
 *                                                                      *
 * Inputs: hThread           = HTHREAD                                  *
 *         pbOutput          = Output Buffer to fill                    *
 *         ulOutputSize      = Size in bytes of Output Buffer           *
 *                             Must be a multiple of 32 bits            *
 *         pulBitpostion     = Bitpostion count in the Output Buffer    *
 *         pfnFlushBuffer    = Flush Buffer function.  Note the         *
 *                             prototype for this funciton must be:     *
 *                                                                      *
 *         pvoid   pfnFlushBuffer ( PVOID, PBYTE, ULONG );              *
 *           PVOID   use is the same as above                           *
 *           PBYTE   unsigned char * to Output buffer.  The same as     *
 *                   pbOutput.                                          *
 *           ULONG   unsigned long. The size of pbOutput buffer.        *
 *                   The same as ulOutputSize.                          *
 *                                                                      *
 *           Note that the BOOL return value is TRUE (1) for ok and     *
 *           FALSE (0) for error.                                       *
 *                                                                      *
 * Note that *pulBitposition gets updated and must be stored  off the   *
 * pddc.                                                                *
 *                                                                      *
 *    Instead of GplFaxG3NewFrame() if you use pfnFlushBuffer() = NULL  *
 *    to see if the buffer for GplFaxG3EncodeBlock() is large enough.   *
 *    You output the bytes after GplFaxG3EncodeBlock() returns ok.      *
 *    You can then call GplFaxG3StartDoc().  This function places       *
 *    an EOL in the output buffer and sets the ulBitpostion to 12.      *
 *                                                                      *
 * Returns: The same as GplFaxG4EncodeBlock()                           *
 *                                                                      *
 ************************************************************************/

/************************************************************************
 *         T  I  F  F     2      A  L  G  O  R  I  T  H  M  S
 ************************************************************************/

/************************************************************************
 *                                                                      *
 * Function:      GplFaxTIFF2StartBlock                                 *
 *                                                                      *
 * Description: TIFF Algorithm 2 compression Start of Document          *
 *              function.                                               *
 *                                                                      *
 * Inputs:      pulBitpostion  Bit postion count in the Output Buffer.  *
 *                                                                      *
 *                                                                      *
 * Note (1) *pulBitposition gets updated and must be stored  off        *
 *           the pddc.  This function justs set *pulBitpostion to 0.    *
 *           You can do this yourself.                                  *
 *                                                                      *
 * Returns: void                                                        *
 *                                                                      *
 ************************************************************************/

/************************************************************************
 *                                                                      *
 * Function:      GplFaxTIFF2EncodeBlock                                *
 *                                                                      *
 * Description: TIFF Algorithm 2 compression                            *
 *                                                                      *
 * Inputs: PVOID             = Used to call pfnFlushBuffer              *
 *         pbOutput          = Output Buffer to fill                    *
 *         ulOutputSize      = Size in bytes of Output Buffer           *
 *                             Must be a multiple of 32 bits            *
 *         pulBitpostion     = Bitpostion count in the Output Buffer    *
 *         pbInput           = Input pointer to upper left corner of    *
 *                             raster image to compress                 *
 *         ulBitWide         = The width of the raster image in bits    *
 *         ulBitheight       = The height of the raster image in bits   *
 *         pfnFlushBuffer    = Flush Buffer function.  Note the         *
 *                             prototype for this funciton must be:     *
 *                                                                      *
 *         All count parameters have a limit of 2^^32 - 1 =             *
 *         4,294,967,295                                                *
 *                                                                      *
 *         VOID   pfnFlushBuffer (PVOID, PBYTE, ULONG );                *
 *           PVOID   Same as GplFaxG4EncodeBlock()                      *
 *           PBYTE   unsigned char * to Output buffer.  The same as     *
 *                   pbOutput.                                          *
 *           ULONG   unsigned long. The size of pbOutput buffer.        *
 *                   The same as ulOutputSize.                          *
 *                                                                      *
 *           Note that the BOOL return value is TRUE (1) for ok and     *
 *           FALSE (0) for error.                                       *
 *                                                                      *
 *                                                                      *
 * Note (1) *pulBitposition gets updated and must be stored  off        *
 *           the pddc.                                                  *
 * Note (2) The raster image must be have in rows on a 32 bit boundary  *
 *          with 0 bits padding the right.                              *
 * Note (3) ulOutputSize must be divisable by 4                         *
 *                                                                      *
 * Returns:  The same as GplFaxG4EncodeBlock()                          *
 *                                                                      *
 ************************************************************************/

/************************************************************************
 *                                                                      *
 * Function:      GplFaxTIFF2EndBlock                                   *
 *                                                                      *
 * Description: TIFF Algorithm 2 compression to flush output buffer     *
 *                                                                      *
 * Inputs: hThread           = HTHREAD                                  *
 *         pbOutput          = Output Buffer to fill                    *
 *         ulOutputSize      = Size in bytes of Output Buffer           *
 *         pulBitpostion     = Bitpostion count in the Output Buffer    *
 *                             Must be a multiple of 32 bits            *
 *         pbInput           = Input pointer to upper left corner of    *
 *                             raster image to compress                 *
 *         ulBitWide         = The width of the raster image in bits    *
 *         ulBitheight       = The height of the raster image in bits   *
 *         pfnFlushBuffer    = Flush Buffer function.  Note the         *
 *                             prototype for this funciton must be:     *
 *                                                                      *
 *         int   pfnFlushBuffer ( HTHREAD, PBYTE, ULONG );              *
 *           HTHREAD is gotten from GplThreadCreateInstance().          *
 *           PBYTE   unsigned char * to Output buffer.  The same as     *
 *                   pbOutput.                                          *
 *           ULONG   unsigned long. The size of pbOutput buffer.        *
 *                   The same as ulOutputSize.                          *
 *                                                                      *
 *           Note that the BOOL return value is TRUE (1) for ok and     *
 *           FALSE (0) for error.                                       *
 *                                                                      *
 * Note (1) *pulBitposition gets updated and must be stored  off        *
 *           the pddc.                                                  *
 * Note (2) The raster image must be have in rows on a 32 bit boundary  *
 *          with 0 bits padding the right.                              *
 * Note (3) ulOutputSize must be divisable by 4                         *
 *                                                                      *
 * Returns: TRUE if ok                                                  *
 *          FALSE if error                                              *
 *                                                                      *
 ************************************************************************/

#endif
