/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/* FILENAME       : GPLDITH.H                                               */
/* AUTHOR         : Tom Spurrier                                            */
/* DATE WRITTEN   : 11-28-94                                                */
/* DESCRIPTION    : gpldith.h contains typedefs, defines, and function      */
/*                    definitions for gpldith.c and routines that use the   */
/*                    dither API's:                                         */
/*                                                                          */
/****************************************************************************/
/* The purpose of a Dither function is to convert picture pels in sizes     */
/* 2, 4, 8, 16, 24, or 32 bits of RGB/K color to a 3 or 4 bitpel consisting */
/* of Cyan Magenta Yellow and optionally K(Black).  The best dither         */
/* functions diffuse or spread out colors and also acting as a low pass     */
/* filter to changes in color.  This diffusion of color causes              */
/* a proper density of Cyan Magenta and Yellow such that the eye percieves  */
/* the correct color at a distance, for example orange or light pink.       */
/*                                                                          */
/* Percievable print spectrum is less than a display device, and in the     */
/* future, printers will use 7 inks, CMYKRGB in order to widen the spectrum.*/
/* For this reason and in order to ease enhanceability, parameters          */
/* have been put in structures rather than enumerated in the function       */
/* interface.                                                               */
/*                                                                          */
/* In order to optomize throughput, a dither handle                         */
/* is initialized when GplDitherCreateInstance is invoked.                  */
/* This includes allocation                                                 */
/* and initialization of transform tables and parameters.                   */
/*                                                                          */
/*   GplDitherCreateInstance(PHDITHER       ppdh,                           */
/*                 HMCB           hmcb,                                     */
/*                 PDITHEREQUEST  pReq );                                   */
/*            "ppdh" is a pointer to a pointer to the dither handler        */
/*                    that created by GplDitherCreateInstance.              */
/*            "hmcb" if not zero is a handler pointer to the API heap.      */
/*            "pReq" is a pointer to the API's pre-stuffed request          */
/*                      structure                                           */
/*                   The following fields MUST be set by the API:           */
/*                       bReq                                               */
/*                       lDitherType                                        */
/*                       snap                                               */
/*                       pbmi                                               */
/*                          REQUIRES :                                      */
/*                              cx                                          */
/*                              cy                                          */
/*                       ulColorTech                                        */
/*                       ulBufferWidth                                      */
/*                       ulGamma                                            */
/*                       lBias                                              */
/*                                                                          */
/*                  The following optional elements are used if not zero:   */
/*                       When lDitherType == HT_ERR_DIFFUSION               */
/*                          Set SrcOptions using the macro                  */
/*                              GPL_SETUP_DITHER( Req, ulLevel)             */
/*                  If lDitherType == MAGIC_SQUARES                         */
/*                       lHue;                                              */
/*                       lSaturation;                                       */
/*                       lValue;                                            */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/* Dithering is actually performed by GplDitherRGBtoCMYK.                   */
/*                                                                          */
/*   GplDitherRGBtoCMYK( PHDITHER        ppdh,                              */
/*                       PDITHEREQUEST   pReq);                             */
/*                                                                          */
/*                   The following fields MUST be set by the API:           */
/*                      fNewColors    MUST be been set TRUE at beginning    */
/*                                     of page!!                            */
/*                               This element is set to FALSE on return.    */
/*                    if fNewColors == TRUE:                                */
/*                       ulGamma                                            */
/*                       lBias                                              */
/*                                                                          */
/*                                                                          */
/*                   if a diffusion dither algorithm is selected,           */
/*                       use the macro:                                     */
/*                       GPL_SETUP_DITHER( Req, ulLevel)                    */
/*                               to setup the SrcOptions structure          */
/*                   else if Magic Squares or Ordered Squares is selected   */
/*                       the following 3 fields must be setup:              */
/*                       lHue                                               */
/*                       lSaturation                                        */
/*                       lValue                                             */
/*                                                                          */
/*                                                                          */
/*                       pbmi Must have the following two fields set        */
/*                            cx                                            */
/*                            cy                                            */
/*                    if BitsPerPel < 16 and                                */
/*                       fNewColors == TRUE  then                           */
/*                       the the pbmi array, argbColor[256] must be         */ 
/*                            initialized                                   */
/*                                                                          */
/*                                                                          */
/*                       pbSrc  pointer to the surface bitmap               */
/*                       pbDest pointer to a destination buffer wherein     */
/*                              each output color is separated into a block */
/*                              beginning with Black, Cyan, Magenta, Yellow */
/*                              If Black is not requested, Cyan is at the   */
/*                              beginning of the buffer.                    */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*  GplDitherRGBtoRGB is simply a shell for GplDitherRGBtoCMYK.  It simply  */
/*  inverts the CMY pDest buffer to RGB for a printer that requires RGB.    */
/*                                                                          */
/*   GplDitherRGBtoRGB(  PHDITHER      ppdh,                                */
/*                       PDITHEREQUEST   pReq);                             */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*  GplDitherDeleteInstance must be called at the end of a document so      */
/*  that memory that was allocated in GplDitherCreateInstance may be freed. */
/*                                                                          */
/*   GplDitherDeleteInstance(     HDITHER   pdh,                            */
/*                       PDITHEREQUEST);                                    */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*  Sepcific printer paper, ink, resolution, and other characteristics cause*/
/*  the actual color printed to be skewed relative to the actual color      */
/*  desired.  This skew occurs over the entire color gamut in a non-linear  */
/*  fashion.  In order to approximate for the non-linear skew, a gamma      */
/*  compensation curve is used for each color.  Since colors behave         */
/*  differently because of their different reflected frequencies, the       */
/*  user is allowed to modify each colors gamma.                            */
/*                                                                          */
/*  Increasing gamma's will lighten the image which would look too dark     */
/*  without it.                                                             */
/*                                                                          */
/*  The following two functions are call in the above dither functions but  */
/*  are made available to interested users and for completeness             */
/*                                                                          */
/*   GplGammaCreateTable ( PBYTE pbGamma,                                   */
/*                                 LONG  lRgamma,                           */
/*                                 LONG  lGgamma,                           */
/*                                 LONG  lBgamma,                           */
/*                                 LONG  lbias );                           */
/*                                                                          */
/* GplGammaColorTableToGamma2 simply for 8bit pels or less, gamma replaces  */
/* the RGB values in the PBITMAPINFO2 argbColor[0..256] structure.          */
/*                                                                          */
/*   GplGammaColorTableToGamma2 ( PBYTE pbGamma,                            */
/*                                   PBITMAPINFO2 pbmi );                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* Modification/Change log                                                  */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/****************************************************************************/
#define A_BIG_NUMBER  4000000.0
#define A_SEED        1618033.0
//#define A_BIG_NUMBER  100000000
//#define A_SEED        16180339

#define ERR_EXP 19

#define INVALID_BITMAP          -1L

/* ---------------------from device.h --------------------- */
// The following are defines for the different Haltoning Algorithms.
// These are values for JobProperties.usAlgorithm
//

#define COLOR_TECH_MONO           0
#define COLOR_TECH_COLOR          1
#define COLOR_TECH_K              2
#define COLOR_TECH_CMY            3
#define COLOR_TECH_CMYK           4
#define COLOR_TECH_KCMY           5

#define HT_LEVEL                  0
#define HT_SNAP                   1
#define HT_DITHER_4x4             2
#define HT_DITHER_8x8             3
#define HT_ERR_DIFFUSION          4
#define HT_MAGIC_SQUARES          5
#define HT_ORDERED_SQUARES        6
#define HT_ADAPTIVE_DIFFUSION     7
#define HT_FAST_DIFFUSION         8
#define HT_STEINBERG_DIFFUSION    9
#define HT_SMOOTH_DIFFUSION      10

#define HT_PARAMETER            0x00
#define HT_MIN_COLOR            0x10
#define HT_PERCENT              0x20
#define HT_FUNCTION             0x30

//
#define COLOR_BLACK                0
#define COLOR_BLUE                 1
#define COLOR_GREEN                2
#define COLOR_CYAN                 3
#define COLOR_RED                  4
#define COLOR_PINK                 5
#define COLOR_YELLOW               6
#define COLOR_WHITE                7
#define COLOR_BROWN                8
#define COLOR_DARK_GRAY            9
#define COLOR_DARK_BLUE           10
#define COLOR_DARK_RED            11
#define COLOR_DARK_GREEN          12
#define COLOR_DARK_CYAN           13
#define COLOR_DARK_PINK           14
#define COLOR_PALE_GRAY           15

//
//    bReq  -  color request type
//
#define CMYK_SIZE                 16
#define CMYK_CYAN                 0
#define CMYK_MAGENTA              1
#define CMYK_YELLOW               2
#define CMYK_BLACK                3
#define CMY_ALL                   4
#define CMYK_ALL                  5
#define KYMC_ALL                  6
#define YMC_ALL                   7
#define KCMY_ALL                  8

#define CMYK_FILTER_OVERFLOW      8

// 4rows * 4colors(RGBK) * 4bytesPerlong * (numberOfSourcePels + boundaryPels)
#define ERROR_FILTER_BUFFER_SIZE( x )     (4 * 4 * 4 * ( x + CMYK_FILTER_OVERFLOW ))

// 8rows * 3colors(RGB) * 4bytesPerlong * (numberOfSourcePels + boundaryPels)
#define ADAPTIVE_FILTER_BUFFER_SIZE( x )  (8 * 3 * 4 * ( x + CMYK_FILTER_OVERFLOW ))

#define BUMP_TO_NEXT_MODULUS(n,m) ((((n)+(m)-1)/(m))*(m))

#define MAX3( a, b, c )  (a > b ? (a > c ? a : c) : b > c ? b : c)

#define MIN3( a, b, c )  (a < b ? (a < c ? a : c) : b < c ? b : c)

#define INVALID_PARAMETER INVALID_BITMAP

#define SET_VALUE_IN_ERR_BUFFS    0
#define COPY_1ST_ROW_TO_ERR_BUFFS 1
#define DON_T_TOUCH_ERR_BUFFS     2

#define DITHER_SIG    0x48544944    // DITH

// retrieve color technology  
// (i.e. COLOR_TECH_MONO, COLOR_TECH_COLOR, COLOR_TECH_K,
//       COLOR_TECH_CMY, COLOR_TECH_CMYK, COLOR_TECH_KCMY )
// Set number of planes based on device technology

#define GPL_SET_NUMBER_PLANES( color, planes )   \
  switch( color )             \
  {                           \
    case COLOR_TECH_CMYK:     \
    case COLOR_TECH_COLOR:    \
    case COLOR_TECH_KCMY:     \
    {                         \
      planes = 4;             \
    }                         \
    break;                    \
                              \
    case COLOR_TECH_CMY:      \
    {                         \
      planes = 3;             \
    }                         \
    break;                    \
                              \
    case COLOR_TECH_K:        \
    default:                  \
    {                         \
      planes = 1;             \
    }                         \
    break;                    \
  }           

    // Select appropriate dither

#define GPL_SETUP_DITHER( Req, ulLevel)               \
      switch( Req.lDitherType )                       \
      {                                               \
        case HT_LEVEL :                               \
        {                                             \
          Req.snap.ulParm = ulLevel & 0xff;           \
        }                                             \
        break;                                        \
        case HT_ERR_DIFFUSION :                       \
        case HT_FAST_DIFFUSION :                      \
        case HT_ADAPTIVE_DIFFUSION :                  \
        case HT_STEINBERG_DIFFUSION :                 \
        {                                             \
          Req.SrcOptions.fResetErrBuf = TRUE;         \
          Req.SrcOptions.ulResetErrBufs = SET_VALUE_IN_ERR_BUFFS;  \
          Req.SrcOptions.ulValue = 0;                 \
        }                                             \
        break;                                        \
        case HT_DITHER_4x4 :                          \
        case HT_DITHER_8x8 :                          \
        case HT_MAGIC_SQUARES :                       \
        case HT_ORDERED_SQUARES :                     \
        default:                                      \
          break;                                      \
      }                                               

#define GPL_RESET_BUFFER( Req )                    \
  if( Req.lDitherType == HT_ERR_DIFFUSION ||       \
      Req.lDitherType == HT_FAST_DIFFUSION ||      \
      Req.lDitherType == HT_STEINBERG_DIFFUSION ||      \
      Req.lDitherType == HT_ADAPTIVE_DIFFUSION )   \
      Req.SrcOptions.fResetErrBuf = TRUE;


/*-------------------------- typedefs ------------------------*/

typedef struct { RGB2 is[1];} COLR, *PCOLR;

typedef struct { BYTE is[16][16];} *P2ABYTE;

typedef struct _DELTACOLORstruct {
      LONG        lHue;
      LONG        lSaturation;
      LONG        lValue;
      } DELTACOLOR, *PDELTACOLOR;

typedef  union {
      PBYTE       pFunction;
      PRGB2       pHalftone;
      ULONG       ulParm;
      PBYTE       pArray;
      }  SNAPIT;

typedef struct _EMPTYstruct{
      BYTE        bCyan;
      BYTE        bMagenta;
      BYTE        bYellow;
      BYTE        bBlack;
      } CMYK, *PCMYK;

typedef struct _HSVstruct {
      ULONG       ulHue;
      ULONG       ulSaturation;
      ULONG       ulValue;
      BOOL        fIsNotWhite;
      ULONG       ulBlack;
      ULONG       ulBlackWhite;
      BOOL        fValueSat;
      BOOL        fIsGreaterThan0x80;
      ULONG       ulGT80;
      ULONG       ulcolor1;
      ULONG       ulcolor;
      ULONG       ulLE80;
      }  HSV, *PHSV;

typedef struct _SRCMODSstruct {
      BOOL        fNewColors;      // ifSet, reset on return and pbmi is used,
      BOOL        fModify;         // Set if pSrc may be modified for K (Black) when CMY set
      BOOL        fResetErrBuf;    // Set between pages or when Err Buffers must be reset
      ULONG       ulResetErrBufs;  // 1=set to iValue, 2=duplicate 1st row, 3=don't touch
      ULONG       ulValue;         //    value to set each pel if ulResetErrBufs=1
      } SRCMODS;  
                  
typedef struct aHSV { HSV is[1];} HSVARRAY, *PHSVARRAY;


typedef struct _DITHERHANDLEstruct {
     BYTE          bReq;
     SRCMODS       SrcOptions;
     CMYK          fEmpty;        // TRUE when no pels of a color on the row are set for printing or black
     LONG          lDitherType;
     SNAPIT        snap;
     LONG          iNumColors;    // 2, 4, 16, 256, 64k, 16meg
     ULONG         ulNumPlanes;
     PBITMAPINFO2  pSrcInfo;      // if new colors, deallocate old
     ULONG         ulColorTech;
     DELTACOLOR    delta;
     INT           iSrcRowPels;   //  Number of Pels in a source row 
     INT           iNumBandRows;  //  Number of rows in a band
     PLONG         plRowCount;    //  Next row location relative to the 1st
     ULONG         ulRGamma;      //  .1..9.9 true gamma value
     LONG          ulRBias;       //  0..255 gamma table minimum value
     ULONG         ulGGamma;      //  .1..9.9 true gamma value
     LONG          ulGBias;       //  0..255 gamma table minimum value
     ULONG         ulBGamma;      //  .1..9.9 true gamma value
     LONG          ulBBias;       //  0..255 gamma table minimum value
     PBYTE         pbSrc;         //  ptr to 32bit row aligned input bitmap
     PBYTE         pbDest;        //  ptr to 8bit row aligned output bitmap
     } DITHEREQUEST, *PDITHEREQUEST;

typedef struct _MidColor {
     LONG       bRed;
     LONG       bGreen;
     LONG       bBlue;
     LONG       bBlack;
     } MID_COLOR, *PMID_COLOR;

typedef struct _PrivateDitherHandle {
     ULONG        cb;
     ULONG        ulSig;
     LONG         iWhiteIndex;
     LONG         iBlackIndex;
     LONG         lHalftoneSize;        // required for HALFTONE 4 or 8
     DELTACOLOR   delta;
     LONG         lidx1;
     LONG         lidx2;
     long         lBig;
     long         lSeed;
     long         lMix[57];
     MID_COLOR    lMidPt;
     PBYTE        pbGGamma;
     PBYTE        pbBGamma;
     // Pointers to dynamically allocated memory
     PBYTE        pbRGamma;
     PBITMAPINFO2 pGammaBmi;
     PHSVARRAY    phsv;
     PLONG        piErrRow;
     PBYTE        pbSharpRow;
     } DITHERHANDLE,*PDITHERHANDLE, **PPDITHERHANDLE, *HDITHER, **PHDITHER;

/*------------------------ API prototypes ---------------------------*/


APIRET APIENTRY GplDitherCreateInstance ( PHDITHER        ppdh,
                                          HMCB            hmcb,
                                          PDITHEREQUEST   pReq );

APIRET APIENTRY GplDitherRGBtoCMYK ( PHDITHER         ppdh,
                                     PDITHEREQUEST    pReq );

APIRET APIENTRY GplDitherRGBtoRGB  ( PHDITHER         ppdh,
                                     PDITHEREQUEST    pReq );

APIRET APIENTRY GplDitherDeleteInstance ( HDITHER      pdh );

APIRET APIENTRY GplGammaCreateTable ( PBYTE pbGamma,
                                      LONG  lRgamma,
                                      LONG  lGgamma,
                                      LONG  lBgamma,
                                      LONG  lbias );

APIRET APIENTRY GplGammaColorTableToGamma2 ( PBYTE pbGamma,
                                        PBITMAPINFO2 pbmi );

/*----------------------- Private prototypes -------------------------*/

/*----------------------------------------------*/
/* GplGammaBuildTable Must be called prior to   */
/* calling GplDitherGammizeColorTable           */
/*----------------------------------------------*/

LONG GplGammaBuildTable    ( PDITHERHANDLE pdh,
                             PDITHEREQUEST pReq );

LONG GplGammizeColorTable  ( PDITHERHANDLE pdh,
                             PDITHEREQUEST pReq ) ;

/***************************************************************
pReq     DITHEREQUEST Structure Element Description :
****************************************************************

bReq           BYTE 

         CMYK_SIZE      Simply returns the byte aligned x times y size.
                        ( Probably not used and should be deleted ).

         CMYK_BLACK     ( For use with CMYK_LEVEL only )
         CMYK_CYAN      ( CMYK_LEVEL only )
         CMYK_MAGENTA   ( CMYK_LEVEL only )
         CMYK_YELLOW    ( CMYK_LEVEL only )
                        This request allows color separation
                        based on color value.  This is useful when
                        trying to determine color content and
                        saturation of a bitmap.
                        A bit is set in pDest for each pSrc pel that
                        exceeds a Level value.
                        If no bits are then fEmpty (below) returns TRUE for
                        the color requested.

         CMY_ALL        Used for 3 color rendering. Output buffers are 
                        consecutive byte aligned.

         CMYK_ALL       Render 3 colors and black.

                        e.g. :
                        pReq->bReq = CMYK_ALL;

         --------------------------------------------------------------------

SrcOptions     SRCMODS Structure

        fNewColors      Set to TRUE by caller when a new color table has been 
                        selected. Reset to FALSE by this program.

                        e.g. :
                        pReq->SrcOptions.fNewColors        = TRUE;

        fModify
                        TRUE if pSrc may be modified during conversion,
                        otherwise, if FALSE or zero, pels in pSrc will NOT 
                        be modified.

        fResetErrBuf    Set between pages or when Err Buffers must be reset

        ulResetErrBufs  =0 reset ErrorDiffusion buffers to zero
                        =1 set ErrorDiffusion buffers to ..SrcOptions.iValue
(to be implemented)     =2 duplicate the corresponding values from row one as
                           initial values for the last row. i.e. start at one
                           row before the first row which looks like the first
                           row
                        =3 don't touch
        ulValue         (0..256) << 20. A BYTE value shifted 20 places left.

         --------------------------------------------------------------------

fEmpty         CMYK Structure

        bCyan           Initialized to TRUE on entry and stays TRUE when pSrc
        bMagenta        has been set to all white. Set to FALSE if more pel
        bYellow         processing is required. If "SrcOptions.fModify" is TRUE,
        bBlack          fEmpty can only be set to FALSE if all "pSrc" pels
                        are black and/or white.

         --------------------------------------------------------------------

lDitherType    LONG 

        HT_LEVEL        if 0 then snap.ulParm contains a value 1..254 that
                        separates 0 & 1
            HT_PERCENT     if OR'd 0x80 then snap.ulParm is a percentage 1..100 that
                           separates 0 & 1
            HT_FUNCTION    if OR'd 0x40 then snap.pFunction will be executed to get a
                           midpoint with the following parameters:
                                pSrc
                                pbmi
                                pdest
                                pdestInfo

        HT_DITHER_4x4   Use's a 4x4  halftone pattern for 16 levels of
                        percieved intensity.  Also "snap.pHalftone" must be a
                        pointer to a 16x4x4 byte array of dither patterns.

        HT_DITHER_8x8   Use's 8x8  halftone pattern for 64 levels of
                        percieved intensity.Also "snap.pHalftone" must be a
                        pointer to a 16x8x8 byte array of dither patterns.

        HT_STUCKI_DIFFUSION Use's Stucki Error Diffusion, Low Pass filter diffusion
                        This operates as a lag-filter and has a slow response
                        to sharp color changes, such as from white to any
                        dark color.

        HT_STEINBERG_DIFFUSION Use's Steinberg Error Diffusion, Similar to Stucki
                        but has a alightly better response to sharp color
                        changes but slightly less overall quality.

        HT_FAST_DIFFUSION Uses Spurrier and Cooper Error Diffusion, High Pass filter
                        diffusion and works well with low gamma values and
                        sharp color changes but sometimes washed-out.

        HT_MAGIC_SQUARES Use Magic Squares HSV transform for nearest
                        color and dithering.

        HT_ORDERED_SQUARES Uses Recursive Tesselated Tiles of Rectangular Threshold
                        Arrays; i.e. Ordered squares. Uses the same function as
                        HT_MAGIC_SQUARES but a different dither table/pattern.

        OTHER Dither functions will be added from time to time.
 
         --------------------------------------------------------------------

snap           SNAPIT    
               
                        This is effectively a LONG but has 4 possible representations
                        as described in the iDitherType above parameter.

                        union {
                           PBYTE       pFunction;
                           PRGB2       pHalftone;
                           ULONG       ulParm;
                           PBYTE       pArray;
                        }  SNAPIT;

         --------------------------------------------------------------------

iNumColors     LONG 

                        This parameter must contain one of the following:

                        2, 4, 8, 16, 256, 64k, 16meg

         --------------------------------------------------------------------

ulNumPlanes    ULONG
                        1 or 3
         --------------------------------------------------------------------
 
pSrcInfo       PBITMAPINFO2 Structure

                        Pointer to a BITMAPINFO2 Structure
    
         --------------------------------------------------------------------
ulColorTech     ULONG 

                        Use the MACRO:
                          GPL_SET_NUMBER_PLANES( color, planes )
                          to set the color technology to  3, 4, 1

          --------------------------------------------------------------------

delta          DELTACOLOR Structure     

                        This parameter NEED ONLY BE initialized for only Magic 
                        and Ordered Squares.

        lHue            Number of degrees to rotate increase/decrease all hue 
                        values. -255E8 < lHue < 255E8   
                        ( 255 * DialogHue * E8 /360 )

        iSaturation     Percentage increase/decrease of purity of lHue. 
                        i.e. the absence of White is when Saturation = 100% or 
                        pure Color. Conversely when there is an absence of a 
                        hue, Saturation = 0% or White when black is absent; 
                        i.e. Value is 100%.  -255 <= iSaturation <= 255
                        ( 255 * DialogSaturation/100 )

        iValue          Percentage increase\decrease of black. Value is the
                        absence of black. If not absent of any black, its 
                        Value is 0%.
                        -255 <= iValue <= 255. ( 255 * DialogValue/100 )

                        e.g. :
                        pReq->delta.iValue  = pddc->pdb->pJobProperties->lValue;
                        pReq->delta.iSaturation = 
                              (255 * pReq->delta.iSaturation)  / 100;
                        pReq->delta.iValue = (255 * pReq->delta.iValue) / 100;

         --------------------------------------------------------------------

iSrcRowPels    INT           

                        Number of Pels in a source row.

         --------------------------------------------------------------------

iNumBandRows   INT

                        Number of rows in a band

         --------------------------------------------------------------------

plRowCount     PLONG  

                        Pointer o a job resident parameters that receives and keeps
                        the next row location relative to the 1st when the dither 
                        function completes the current band.  This will be used for 
                        alignment by the dither function at the beginning of the 
                        next band.

         --------------------------------------------------------------------

ulRGamma       ULONG    Red   Gamma  1 to 199 ( actually 10 times true gamma )
ulRBias                 Red   Bias usually 0
ulGGamma                Green Gamma  1 to 199 ( actually 10 times true gamma )
ulGBias                 Green Bias usually 0                                  
ulBGamma                Blue  Gamma  1 to 199 ( actually 10 times true gamma )
ulBBias                 Blue  Bias usually 0 

                        Gamma is increased to reduce the color density, or 
                        to lighten the picture.  When Gamma is increased, the
                        system generates a corresponding Bias.  Users
                        via the Printer Color Dialog, have the option to increase
                        or decrease whatever the system has determined is the
                        general estimated settings for the particular printer and
                        print configuration.  

                        These values are actually 10 times the actual value used
                        A value of 10 therefore yields a gamma of 1 and therefore
                        the gamma function will have no effect: x(exp(1/gamma))=x
                 
                        Any non-zero values supplied by these parameters will
                        override the system estimated baseline values, and user
                        modifications via the Dialog will increase or decrease
                        these values.
                                 
         --------------------------------------------------------------------

pSrc            PBYTE

                        Pointer to source RGB2 bitmap which must be 32bit aligned
                        such that each row begins on a 32bit boundry.  
                        
                        NOTE:    The user must have preserved this pointer

         --------------------------------------------------------------------

pDest           PBYTE
                        Pointer to the beginning of the first color output 
                        KCMY bitmap, where each row begins on a byte boundry.
                        The buffer order is Black, Cyan, Magenta and Yellow.

---------------------End of pReq--------------------

----------------------------------------------------
                 EXAMPLE SETUPS
----------------------------------------------------

------------------- End of Examples ------------------
*/
