/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = GPLCOMP.H
 *
 * DESCRIPTION = Public header information for compress functions(GPLCOMP.C)
 *
 *
 * VERSION = V1.0
 * DATE    = 05/05/94
 * AUTHOR  = MikeJ
 *
 *
 * FUNCTIONS
 *
 *
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/



// compression routines return -1 in event of error
#define GPLCOMPRESS_ERROR      -1

// lMaxCapable/return values for GplCompressWhich()
#define GPLCOMPRESS_INVALID      -1  // @newmode
#define GPLCOMPRESS_NONE          0
#define GPLCOMPRESS_RLL           1
#define GPLCOMPRESS_TIFF          2
#define GPLCOMPRESS_DELTAROW      4
#define GPLCOMPRESS_RLLDELTAROW   8

INT  APIENTRY GplCompressChooseMode ( PBYTE pbCurrent, PBYTE pbPrevious, INT RowCount, ULONG CompressModes, PUSHORT pDelta );

LONG APIENTRY GplCompressRLL ( PBYTE pbDataIn, LONG cbDataIn, PBYTE pbDataOut, LONG cbDataOut );

LONG APIENTRY GplCompressTIFF ( PBYTE pbDataIn, LONG cbDataIn, PBYTE pbDataOut, LONG cbDataOut );

INT  APIENTRY  GplCompressDeltaRow ( INT usTotalBytes,  // bytes in the scan line
                  PBYTE  pbData,         // raster data to compress
                  PBYTE  pbLastLine,     // previous scanline's raster data
                  INT    usMaxReturn,    // length of output buffer
                  PBYTE  pbReturn  ,     // compressed data will be written
                  PUSHORT pDeltas );     // differences indexes - (Start, End) pairs

INT APIENTRY GplCompressRLLDeltaRow ( INT usTotalBytes,  // bytes in the scan line
                  PBYTE  pbData,         // raster data to compress
                  PBYTE  pbLastLine,     // previous scanline's raster data
                  INT    usMaxReturn,    // length of output buffer
                  PBYTE  pbReturn  ,     // compressed data will be written
                  PUSHORT pDeltas );     // differences indexes - (Start, End) pairs

