/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// assert.h
// headers for functions in assert.c

extern BOOL   Assert;
extern BOOL   AssertBeep;
extern BOOL   AssertWarp;

#ifdef DEBUG
  // build debug version

  // for the assert( expression ) macro
  void _System GplpReportFailedAssertion( BOOL bool, ULONG ulLine, PSZ pszFilename, PSZ pszExpression );

  #define assertT(exp)  {if (exp)    GplpReportFailedAssertion((BOOL)(exp),__LINE__,__FILE__,(PSZ)#exp);}
  #define assertF(exp)  {if (!(exp)) GplpReportFailedAssertion((BOOL)(exp),__LINE__,__FILE__,(PSZ)#exp);}
  #define assert(exp)   {if (!(exp)) GplpReportFailedAssertion((BOOL)(exp),__LINE__,__FILE__,(PSZ)#exp);}
  #define assertstring(str) {GplpReportFailedAssertion(TRUE, __LINE__, __FILE__, (PSZ)str);}

  #define ASSERTT(exp)  {if (exp)    GplpReportFailedAssertion((BOOL)(exp),__LINE__,__FILE__,(PSZ)#exp);}
  #define ASSERTF(exp)  {if (!(exp)) GplpReportFailedAssertion((BOOL)(exp),__LINE__,__FILE__,(PSZ)#exp);}
  #define ASSERT(exp)   {if (!(exp)) GplpReportFailedAssertion((BOOL)(exp),__LINE__,__FILE__,(PSZ)#exp);}
  #define ASSERTSTRING(str) {GplpReportFailedAssertion(TRUE, __LINE__, __FILE__, (PSZ)str);}

  // NOTE: The following *must* appear in your .def file!
  //
  // IMPORTS
  //     Debug32Output         = PMWIN.955

  INT  APIENTRY Debug32Output (PCH);

  // for the DBPRINTF((pszFormat, ... )) macro
  VOID _Optlink Gplpdbprintf (PSZ pszFormat, ...);
  #define DBPRINTF(str) Gplpdbprintf str

  VOID _Optlink dbprintif (BOOL Doit, PSZ pszFormat, ...);
  #define DBPRINTIF(str) dbprintif str

  // Produces output as follows:
  //   PRINT_VAR(ulWidth);
  //
  //   ulWidth = 10
  //
  #define PRINT_VAR(x)        DBPRINTF  ((#x##" = %d\n", x))
  #define PRINT_VARIF(b,x)    DBPRINTIF ((b, #x##" = %d\n", x))

  #define PRINT_VARt(x,t)     DBPRINTF  ((#x##" = %"#t"\n", x))
  #define PRINT_VARtIF(b,x,t) DBPRINTIF ((b, #x##" = %"#t"\n", x))

#else
  // retail version
  #define assertT(exp)        ;
  #define assertF(exp)        ;
  #define assert(exp)         ;
  #define assertstring(str)   ;
  #define ASSERTT(exp)        ;
  #define ASSERTF(exp)        ;
  #define ASSERT(exp)         ;
  #define ASSERTSTRING(str)   ;
  #define DBPRINTF(str)
  #define DBPRINTIF(str)
  #define PRINT_VAR(x)        ;
  #define PRINT_VARIF(b,x)    ;
  #define PRINT_VARt(x,t)     ;
  #define PRINT_VARtIF(b,x,t) ;
#endif


BOOL APIENTRY PMAssert( BOOL, HAB, PSZ );
BOOL APIENTRY BaseAssert( ULONG, PSZ );
