/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/* FILENAME       : GENPLIB.H                                               */
/* AUTHOR         : Mark Hamzy,Mark VanderWiele                             */
/* DATE WRITTEN   : 10-07-93                                                */
/* DESCRIPTION    : This module contains all MACROS, IDs, constants and     */
/*                  data type definitions used by the library of functions  */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* Modification/Change log                                                  */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/****************************************************************************/
#ifdef INCL_GENPLIB_THREAD
#define INCL_GENPLIB_MEMORY    // thread mod has dependencies on memory mod
#endif

#ifdef INCL_GENPLIB_PATTERNS
#define INCL_GENPLIB_MEMORY    // pattern mod has dependencies on memory mod
#endif

#ifdef INCL_GENPLIB_GAMMA      // Gamma is a subset of dithering
#define INCL_GENPLIB_DITHER
#endif

#ifdef INCL_GENPLIB_ALL
#define INCL_GENPLIB_STRINGSORT
#define INCL_GENPLIB_JOURNAL
#define INCL_GENPLIB_THREAD
#define INCL_GENPLIB_ERROR
#define INCL_GENPLIB_ASSERT
#define INCL_GENPLIB_MEMORY
#define INCL_GENPLIB_HANDLER
#define INCL_GENPLIB_UTIL
#define INCL_GENPLIB_SEMAPHORES
#define INCL_GENPLIB_COMPRESS
#define INCL_GENPLIB_PATTERNS
#define INCL_GENPLIB_DITHER
#define INCL_GENPLIB_FAX
#endif

#ifdef INCL_GENPLIB_MEMORY
   #ifndef __genplib_h_memory
   #define __genplib_h_memory
      #include <gplmem.h>
   #endif
#endif

#ifdef INCL_GENPLIB_STRINGSORT
   #ifndef __genplib_h_strsort
   #define __genplib_h_strsort
      #include <gplsort.h>
   #endif
#endif

#ifdef INCL_GENPLIB_JOURNAL
   #ifndef __genplib_h_journal
   #define __genplib_h_journal
      #include <gpljrnl.h>
   #endif
#endif

#ifdef INCL_GENPLIB_THREAD
   #ifndef __genplib_h_thread
   #define __genplib_h_thread
      #include <gplthrd.h>
   #endif
#endif

#ifdef INCL_GENPLIB_ERROR
   #ifndef __genplib_h_error
   #define __genplib_h_error
      #include <gplerr.h>
   #endif
#endif

#ifdef INCL_GENPLIB_ASSERT
   #ifndef __genplib_h_assert
   #define __genplib_h_assert
      #include <gplassrt.h>         // Conflicts with assert.h in C include
   #endif
#endif

#ifdef INCL_GENPLIB_HANDLER
   #ifndef __genplib_h_handler
   #define __genplib_h_handler
      #include <setjmp.h>             // handler has a dependency on C runtime
      #include <handler.h>
   #endif
#endif

#ifdef INCL_GENPLIB_UTIL
   #ifndef __genplib_h_util
   #define __genplib_h_util
      #include <util.h>
   #endif
#endif

#ifdef INCL_GENPLIB_UTIL
   #ifndef __genplib_h_semaphores
      #define __genplib_h_semaphores
      #include <gplsem.h>
   #endif
#endif

#ifdef INCL_GENPLIB_COMPRESS
   #ifndef __genplib_h_compress
      #define __genplib_h_compress
      #include <gplcomp.h>
   #endif
#endif

#ifdef INCL_GENPLIB_PATTERNS
   #ifndef __genplib_h_patterns
      #define __genplib_h_patterns
      #include <gplpat.h>
   #endif
#endif

#ifdef INCL_GENPLIB_DITHER
  #ifndef __genplib_h_dither
    #define __genplib_h_dither
    #include <gpldith.h>
  #endif
#endif

#ifdef INCL_GENPLIB_FAX
  #ifndef __genplib_h_fax
    #define __genplib_h_fax
    #include <gplfax.h>
  #endif
#endif
