/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDZDRIV
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION   Printer Device Driver Entry and Exit
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                   /* CON3201 */
#define INCL_DOSPROCESS           /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS            /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#define INCL_GPIERRORS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#define INCL_WINP_MISC
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_WINP_MISC
#undef INCL_32                    /* CON3201 */

#include <prdconse.h>
#include <prddcone.h>

#define NO_SYS
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS

#include <prdyextf.h>

/* CON3201
USHORT prdz_EnterDriver(DCIData)

lpDCI DCIData;
*/

USHORT prdz_EnterDriver(lpDCI DCIData)

{
/*  TID     tidCurrent;                                      CON3201 */
    ULONG   tidCurrent;
    PTIB    ptibTemp;
    PPIB    ppibTemp;

/*  tidCurrent = DCIData->LIS->tidCurrent;                   CON3201 */
    DosGetInfoBlocks(&ptibTemp, &ppibTemp);
    tidCurrent = ptibTemp->tib_ptib2->tib2_ultid;
/*    StartCrit();  */
      DosEnterCritSec();
    if ( DCIData->LockDCInfo.tidLock )
    {
        if (DCIData->LockDCInfo.tidLock != tidCurrent)
        {
         //   EndCrit();
              DosExitCritSec();
            LOGERR("EnterDriver", "DC locked", FNULL, 0, PMERR_HDC_BUSY);
            return(ERROR_ZERO);
        }
    }
    else
    {
        DCIData->LockDCInfo.tidLock = tidCurrent;
    }

    DCIData->LockDCInfo.LockCount++;
 //   EndCrit();
      DosExitCritSec();
    return(OK);
}


/* CON3201
VOID prdz_LeaveDriver(DCIData)

lpDCI DCIData;
*/

VOID prdz_LeaveDriver(lpDCI DCIData)
{
//    StartCrit();
      DosEnterCritSec();

#ifdef PRD_DEBUG
    if ( !(DCIData->LockDCInfo.LockCount) )
    {
  //      EndCrit();
          DosExitCritSec();
        DebugOutput("LeaveDriver: LockCountError\n\r");
        haltproc();
  //      StartCrit();
          DosEnterCritSec();
        DCIData->LockDCInfo.tidLock = 0;
    }
    else
#endif /* PRD_DEBUG */
    {
        if ( !(--(DCIData->LockDCInfo.LockCount)) )
            DCIData->LockDCInfo.tidLock = 0;
    }

//    EndCrit();
      DosExitCritSec();
}

