/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDSSUBR
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prds_FastScanLine
 *             prds_WriteRow     (cf with prdu_writerow)
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define INCL_32                        /* CON3201 */
#define INCL_DOSPROCESS                /* CON3201 */
#define INCL_DOSSEMAPHORES             /* CON3201 */
#define INCL_GPIBITMAPS
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_FONTFILEFORMAT
#include <os2.h>
#undef INCL_DOSPROCESS                 /* CON3201 */
#undef INCL_DOSSEMAPHORES              /* CON3201 */
#undef INCL_FONTFILEFORMAT
#undef INCL_WINHEAP
#undef INCL_GPIPRIMITIVES
#undef INCL_GPIBITMAPS

#define INCL_DDIMISC
#define INCL_DDIBUNDLES
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIMISC

#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef INCL_32                         /* CON3201 */

#include <prdconse.h>
#include <prdbcone.h>

#include <prdupatt.h>
#include <prdbtyp4.h>
#include <prdstypt.h>

#include <prdgextf.h>
#include <prdsextf.h>
#include <prdiextf.h>
#include <prduextf.h>
#include <prdyextf.h>

/**********************************************************************/
/* Macros used in this module                                         */
/**********************************************************************/

#define  PRDM_PATDWORD(M, D, R)                                       \
{                                                                     \
    switch ( M )                                                      \
    {                                                                 \
        case SRC_INVERT_BITS:R = ~D;         break;                   \
        case SRC_COPY_BITS  :R =  D;         break;                   \
        case SRC_ZEROS      :R = 0x00000000; break;                   \
        case SRC_ONES       :R = 0xFFFFFFFF; break;                   \
    }                                                                 \
}

/**********************************************************************/
/* External data fields.                                              */
/**********************************************************************/
extern ULONG        alDwordMask[];
extern ULONG        prdd_HugeInc;
extern USHORT       usCurrentScan;

/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prds_FastScanLine                                      */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   PBYTE         lpPatData;                                         */
/*   hanDC         DcH;                                               */
/*   PSCANDATA     lpPSLS;                                            */
/*   lpDCI         DCIData;                                           */
/*   ULONG         FunN;                                              */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function implements the fast path polyscanline code         */
/*                                                                    */
/**********************************************************************/
/*CON3201
USHORT prds_FastScanLine ( DcH,
                           lpPSLS,
                           DCIData,
                           NoClipping,
                           FunN )

hanDC         DcH;
PSCANDATA     lpPSLS;
lpDCI         DCIData;
BOOL          NoClipping;
ULONG         FunN;
                   */

USHORT prds_FastScanLine (hanDC         DcH,
                          PSCANDATA     lpPSLS,
                          lpDCI         DCIData,
                          BOOL          NoClipping,
                          ULONG         Funn)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    USHORT           usResult;    /* Result of function               */
    USHORT           jj, ii;      /* loop variable                    */
    USHORT           usBottom;    /* first scan line to process       */
    USHORT           usTop;       /* last  scan line to process       */
    USHORT           usIndex;     /* index into steps array           */
    USHORT           usCount;     /* number of shortlines             */
    USHORT           usRow;       /* offset to current pattern row    */
    USHORT           usStartIx;   /* start index into mask table      */
    USHORT           usEndIx;     /* end index into mask table        */
    ULONG            ulStart;     /* starting offset in bitmap        */
    ULONG            ulPatDword;  /* final pattern DWORD              */
    ULONG            ulMidMask;   /* mask for BG = LEAVEALONE         */
    PBYTE            lpStart;     /* starting address in bitmap       */
    PBYTE            lpPatRow;    /* address of current pattern row   */
    PBYTE            lpTopRow;    /* address of top pattern row       */
    RECTL            rclBounds;   /* long version of bounds           */
    POINTS           ptsClip[2];  /* current clip rectangle           */
    /***************CON3201*************/
/*    PSHORT          pusStepsR;    array of right x steps           */
/*    PSHORT          pusStepsL;    array of left x steps            */
    /***********************************
     CHANGE IN DATA STRUCTURE */
    PLONG            pusStepsR;   /* array of right x steps           */
    PLONG            pusStepsL;   /* array of left x steps            */
    PSHORTLINE       ShortLineL;  /* left shortline                   */
    PSHORTLINE       ShortLineR;  /* right shortline                  */
    ScanType         sScan;       /* scan data (for performance)      */
    PatType          sPatt;       /* pattern data (for performance)   */
    pBMListEntry     lpLE;        /* current list entry               */

    /******************************************************************/
    /* Set up local variables first of all.                           */
    /******************************************************************/
    usResult = OK;

    /******************************************************************/
    /* Get some items from the List Entry into the scan data          */
    /******************************************************************/
    lpLE = (pBMListEntry)DCIData->DCISelBitmap;
    sScan.usTrgInc     = LOUSHORT(lpLE->Parms.BytesPerRow);
/*  sScan.usBMSelector = SELECTOROF(lpLE->Bitmap); replace with line below    */
/*                                                  CON3201                   */
    sScan.pBMBaseAddr  = lpLE->Bitmap;
    sScan.usXOrigin    = lpLE->XOrigin;
    sScan.usYOrigin    = lpLE->YOrigin;

    /******************************************************************/
    /* Get some items from the Pattern Data into the scan data        */
    /******************************************************************/
    sPatt = *(pPatType)DCIData->lpPD;

    /**************************************************************************/
    /*  P500080 : If COM_PRECLIP has been set, then we don't need to do       */
    /*  any checking or looping through the clip rectangles.                  */
    /**************************************************************************/
    if (NoClipping)
    {
        /**************************************************************/
        /* Loop for each pair of polyscanlines                        */
        /**************************************************************/
        for ( ShortLineL = lpPSLS->pslFirstLeft,
              ShortLineR = lpPSLS->pslFirstRight,
              usIndex    = 0,
              usCount    = LOUSHORT(lpPSLS->c),
              ii = 0;
              ii < usCount;
              ii++,
              ShortLineL = (PSHORTLINE)ShortLineL->slh.pslhNext,
              ShortLineR = (PSHORTLINE)ShortLineR->slh.pslhNext )
        {
            /******************************************************************/
            /*  Set bottom and top.                                           */
            /******************************************************************/
            usBottom = ShortLineR->slh.ptlStart.y;
            usTop    = ShortLineR->slh.ptlStop.y;

            /**********************************************************/
            /* Local pointer to the array of x values for this short  */
            /* line.  Note: inclusive of the start but exclusive of   */
            /* the end of the scanline.                               */
            /**********************************************************/
            pusStepsR = (PLONG)&ShortLineR->ax[usIndex];
            sScan.ptsEnd.x = *pusStepsR;

            pusStepsL = (PLONG)&ShortLineL->ax[usIndex];
            sScan.ptsStart.x = *pusStepsL;

            /**********************************************************/
            /* Get the starting address into the target bitmap        */
            /**********************************************************/
            sScan.ulTrgRow  = usBottom + sScan.usYOrigin;
            sScan.ulTrgRow *= sScan.usTrgInc;

            /**********************************************************/
            /* Get the offset to the starting pattern row             */
            /**********************************************************/
            usRow     = usBottom % sPatt.usPatHeight;
            usRow    *= sPatt.usPatBytesPerRow;

            /**********************************************************/
            /* Get the address of the starting pattern row and the    */
            /* top pattern row.                                       */
            /**********************************************************/
            lpTopRow  = lpPatRow = sPatt.lpPatBM;
            lpTopRow += sPatt.usTopOffset;
            lpPatRow += usRow;

            /**********************************************************/
            /* Loop through only those scanlines that are within the  */
            /* clip rectangle.                                        */
            /**********************************************************/
            for ( sScan.ptsStart.y = usBottom;
                  sScan.ptsStart.y < usTop;
                  sScan.ptsStart.y++)
            {
                /******************************************************/
                /* BANDING : AK 5/21/91 adjust for DCOrigin.          */
                /******************************************************/
                sScan.ptsStart.x += sScan.usXOrigin;
                sScan.ptsEnd.x   += sScan.usXOrigin;

                /******************************************************/
                /* Only draw if the left co-ordinate is to the left   */
                /* of the right co-ordinate.                          */
                /******************************************************/
                if   (sScan.ptsStart.x >= sScan.ptsEnd.x)
                    goto NEXT_SCAN_1;

                /******************************************************/
                /* Currently the end of the line is exclusive.  Make  */
                /* it inclusive                                       */
                /******************************************************/
                sScan.ptsEnd.x--;

                /******************************************************/
                /* Get the indices into the pattern table.            */
                /******************************************************/
                usStartIx = sScan.ptsStart.x & 31;
                usEndIx   = sScan.ptsEnd.x   & 31;

                /******************************************************/
                /* Get the offset of the first and last DWORD in this */
                /* row.                                               */
                /******************************************************/
                sScan.ptsStart.x >>= 5;
                sScan.ptsEnd.x   >>= 5;

                /******************************************************/
                /* Get the starting address in the target bitmap.     */
                /******************************************************/
                ulStart = sScan.ulTrgRow + (sScan.ptsStart.x << 2);
                lpStart = sScan.pBMBaseAddr + ulStart;

/* CON3201 ********************************************************************/
/* The above line does the selector/offset to pointer conversion              */
/*              SELECTOROF(lpStart) =sScan.usBMSelector +                     */
/*                        (SELECTOROF(ulStart) * LOUSHORT(prdd_HugeInc));     */
/*              OFFSETOF(  lpStart) = LOUSHORT(ulStart);                      */
/******************************************************************************/

                /******************************************************/
                /* Apply the color translation to this                */
                /******************************************************/
                PRDM_PATDWORD(sPatt.usPatMode, *(PULONG)lpPatRow, ulPatDword)

                /******************************************************/
                /* Overpaint is easy.                                 */
                /******************************************************/
                if (sPatt.usBGMix == BM_OVERPAINT)
                {
                    (void)prdu_writerow (
                              (PULONG)lpStart,
                              ulPatDword,
                              alDwordMask[ usStartIx ],
                             ~alDwordMask[ usEndIx + 1 ],
                              0xFFFFFFF,
                              sScan.ptsEnd.x - sScan.ptsStart.x + 1,
                              sPatt.usBGMix);
                }
                else
                {
                    /**************************************************/
                    /* Backgorund leavealone need an extra copy of    */
                    /* the original pattern bytes to act as a mask.   */
                    /**************************************************/
                    ulMidMask = *(PULONG)lpPatRow;

                    (void)prdu_writerow (
                              (PULONG)lpStart,
                              ulPatDword,
                              alDwordMask[ usStartIx   ] & ulMidMask,
                             ~alDwordMask[ usEndIx + 1 ] & ulMidMask,
                              ulMidMask,
                              sScan.ptsEnd.x - sScan.ptsStart.x + 1,
                              sPatt.usBGMix);
                }

   NEXT_SCAN_1: /******************************************************/
                /* Get the next set of x coordinates                  */
                /******************************************************/
                sScan.ptsStart.x = *(++pusStepsL);
                sScan.ptsEnd.x   = *(++pusStepsR);

                /******************************************************/
                /* Get the next offset of the next row                */
                /******************************************************/
                sScan.ulTrgRow += sScan.usTrgInc;

                /******************************************************/
                /* Get the offset of the next pattern row             */
                /******************************************************/
/*              if (OFFSETOF(lpPatRow) == OFFSETOF(lpTopRow))        CON3201 */
                if (lpPatRow == lpTopRow)
                {
                    lpPatRow = sPatt.lpPatBM;
                }
                else
                {
/*                  OFFSETOF(lpPatRow) += sPatt.usPatBytesPerRow;    CON3201 */
                    lpPatRow += sPatt.usPatBytesPerRow;
                }
            }
        }
    }
    else
    {
        /******************************************************************/
        /* Get a local copy of the bounds. Adding two pels on to ensure   */
        /* that we get the correct size.                                  */
        /******************************************************************/
        rclBounds = lpPSLS->rclBound;

        /******************************************************************/
        /* Give a little bit of slack                                     */
        /******************************************************************/
        rclBounds.xRight += 2;
        rclBounds.yTop   += 2;

        /******************************************************************/
        /* Loop through each clip rectangle.  This loop exits when prdi_  */
        /* GetNextClip returns FALSE.  This may ignore the bounds         */
        /* altogether...                                                   */
        /******************************************************************/
        for (jj = 1;
             prdi_GetNextClip(DCIData,
                              jj++,
                              (DevRect  *)ptsClip,
                              &rclBounds); )
        {
            /**************************************************************/
            /* ... so do the test here to reject a clip rectangle as      */
            /* fast as possible.                                          */
            /**************************************************************/
            if ( ( rclBounds.xLeft   > ptsClip[1].x ) ||
                 ( rclBounds.xRight  < ptsClip[0].x ) ||
                 ( rclBounds.yTop    < ptsClip[0].y ) ||
                 ( rclBounds.yBottom > ptsClip[1].y ) )
            {
                continue;
            }

            /**************************************************************/
            /* Loop for each pair of polyscanlines                        */
            /**************************************************************/
            for ( ShortLineL = lpPSLS->pslFirstLeft,
                  ShortLineR = lpPSLS->pslFirstRight,
                  usIndex    = 0,
                  usCount    = LOUSHORT(lpPSLS->c),
                  ii = 0;
                  ii < usCount;
                  ii++,
                  ShortLineL = (PSHORTLINE)ShortLineL->slh.pslhNext,
                  ShortLineR = (PSHORTLINE)ShortLineR->slh.pslhNext )
            {
                /**********************************************************/
                /* Reject if the scanline is completely out of range in   */
                /* the Y direction.                                       */
                /**********************************************************/
                if ( ( (usBottom = ShortLineR->slh.ptlStart.y) > ptsClip[1].y ) ||
                     ( (usTop    = ShortLineR->slh.ptlStop.y ) < ptsClip[0].y ) )
                {
                    continue;
                }

                /**********************************************************/
                /* Adjust the bottom bounds to the clip retangle.         */
                /**********************************************************/
                if (usBottom < ptsClip[0].y)
                {
                    usIndex  = ptsClip[0].y - usBottom;
                    usBottom = ptsClip[0].y;
                }

                /**********************************************************/
                /* Adjust the top bounds to the clip rectangle.           */
                /**********************************************************/
                if (usTop > ptsClip[1].y)
                {
                    usTop = ptsClip[1].y;
                }

                /**********************************************************/
                /* Local pointer to the array of x values for this short  */
                /* line.  Note: inclusive of the start but exclusive of   */
                /* the end of the scanline.                               */
                /**********************************************************/
                pusStepsR = (PLONG)&ShortLineR->ax[usIndex];
                sScan.ptsEnd.x = *pusStepsR;

                pusStepsL = (PLONG)&ShortLineL->ax[usIndex];
                sScan.ptsStart.x = *pusStepsL;

                /**********************************************************/
                /* Get the starting address into the target bitmap        */
                /**********************************************************/
                sScan.ulTrgRow  = usBottom + sScan.usYOrigin;
                sScan.ulTrgRow *= sScan.usTrgInc;

                /**********************************************************/
                /* Get the offset to the starting pattern row             */
                /**********************************************************/
                usRow     = usBottom % sPatt.usPatHeight;
                usRow    *= sPatt.usPatBytesPerRow;

                /**********************************************************/
                /* Get the address of the starting pattern row and the    */
                /* top pattern row.                                       */
                /**********************************************************/
                lpTopRow  = lpPatRow = sPatt.lpPatBM;
                lpTopRow += sPatt.usTopOffset;
                lpPatRow += usRow;

                /**********************************************************/
                /* Loop through only those scanlines that are within the  */
                /* clip rectangle.                                        */
                /**********************************************************/
                for ( sScan.ptsStart.y = usBottom;
                      sScan.ptsStart.y < usTop;
                      sScan.ptsStart.y++)
                {
                    /******************************************************/
                    /* Only draw if the left co-ordinate is to the left   */
                    /* of the right co-ordinate and the scanline lies     */
                    /* within the clips.                                  */
                    /******************************************************/
                    if ( (sScan.ptsStart.x >= sScan.ptsEnd.x) ||
                         (sScan.ptsStart.x >= ptsClip[1].x)   ||
                         (sScan.ptsEnd.x   <= ptsClip[0].x)   )
                        goto NEXT_SCAN;

                    /******************************************************/
                    /* Clip the left co-ordinate to the clip limit.       */
                    /******************************************************/
                    if ( ptsClip[0].x > sScan.ptsStart.x )
                        sScan.ptsStart.x = ptsClip[0].x;

                    /******************************************************/
                    /* Clip the right co-ordinate to the clip limit.      */
                    /******************************************************/
                    if ( ptsClip[1].x < sScan.ptsEnd.x )
                        sScan.ptsEnd.x = ptsClip[1].x;

                    /******************************************************/
                    /* BANDING : AK 5/21/91 adjust for DCOrigin.          */
                    /******************************************************/
                    sScan.ptsStart.x += sScan.usXOrigin;
                    sScan.ptsEnd.x   += sScan.usXOrigin;

                    /******************************************************/
                    /* Currently the end of the line is exclusive.  Make  */
                    /* it inclusive                                       */
                    /******************************************************/
                    sScan.ptsEnd.x--;

                    /******************************************************/
                    /* Get the indices into the pattern table.            */
                    /******************************************************/
                    usStartIx = sScan.ptsStart.x & 31;
                    usEndIx   = sScan.ptsEnd.x   & 31;

                    /******************************************************/
                    /* Get the offset of the first and last DWORD in this */
                    /* row.                                               */
                    /******************************************************/
                    sScan.ptsStart.x >>= 5;
                    sScan.ptsEnd.x   >>= 5;

                    /******************************************************/
                    /* Get the starting address in the target bitmap.     */
                    /******************************************************/
                    ulStart = sScan.ulTrgRow + (sScan.ptsStart.x << 2);
                    lpStart = sScan.pBMBaseAddr + ulStart;

/* CON3201 ********************************************************************/
/* The above line does the selector/offset to pointer conversion              */
/*              SELECTOROF(lpStart) =sScan.usBMSelector +                     */
/*                        (SELECTOROF(ulStart) * LOUSHORT(prdd_HugeInc));     */
/*              OFFSETOF(  lpStart) = LOUSHORT(ulStart);                      */
/******************************************************************************/

                    /******************************************************/
                    /* Apply the color translation to this                */
                    /******************************************************/
                    PRDM_PATDWORD(sPatt.usPatMode, *(PULONG)lpPatRow, ulPatDword)

                    /******************************************************/
                    /* Overpaint is easy.                                 */
                    /******************************************************/
                    if (sPatt.usBGMix == BM_OVERPAINT)
                    {
                        (void)prdu_writerow (
                                  (PULONG)lpStart,
                                  ulPatDword,
                                  alDwordMask[ usStartIx ],
                                 ~alDwordMask[ usEndIx + 1 ],
                                  0xFFFFFFF,
                                  sScan.ptsEnd.x - sScan.ptsStart.x + 1,
                                  sPatt.usBGMix);
                    }
                    else
                    {
                        /**************************************************/
                        /* Backgorund leavealone need an extra copy of    */
                        /* the original pattern bytes to act as a mask.   */
                        /**************************************************/
                        ulMidMask = *(PULONG)lpPatRow;

                        (void)prdu_writerow (
                                  (PULONG)lpStart,
                                  ulPatDword,
                                  alDwordMask[ usStartIx   ] & ulMidMask,
                                 ~alDwordMask[ usEndIx + 1 ] & ulMidMask,
                                  ulMidMask,
                                  sScan.ptsEnd.x - sScan.ptsStart.x + 1,
                                  sPatt.usBGMix);
                    }

        NEXT_SCAN:  /******************************************************/
                    /* Get the next set of x coordinates                  */
                    /******************************************************/
                    sScan.ptsStart.x = *(++pusStepsL);
                    sScan.ptsEnd.x   = *(++pusStepsR);

                    /******************************************************/
                    /* Get the next offset of the next row                */
                    /******************************************************/
                    sScan.ulTrgRow += sScan.usTrgInc;

                    /******************************************************/
                    /* Get the offset of the next pattern row             */
                    /******************************************************/

                    if (lpPatRow == lpTopRow)             /*  CON3201 */
                    {                                     /*  CON3201 */
                       lpPatRow = sPatt.lpPatBM;          /*  CON3201 */
                    }                                     /*  CON3201 */
                    else                                  /*  CON3201 */
                    {                                     /*  CON3201 */
                       lpPatRow += sPatt.usPatBytesPerRow;/*  CON3201 */
                    }                                     /*  CON3201 */
                 /* CON3201 ***********************************************/
                 /* Just check if the pointers are equal and then do      */
                 /* the incrementing as necessary.  The code above        */
                 /* replaces this code                                    */
                 /* if (OFFSETOF(lpPatRow) == OFFSETOF(lpTopRow))         */
                 /* {                                                     */
                 /*     lpPatRow = sPatt.lpPatBM;                         */
                 /* }                                                     */
                 /* else                                                  */
                 /* {                                                     */
                 /*     OFFSETOF(lpPatRow) += sPatt.usPatBytesPerRow;     */
                 /* }                                                     */
                 /*********************************************************/
                }
            }
        } /* .. for j = 1; prdi_getNextClip ..............................*/
    }

    /******************************************************************/
    /* And finished.                                                  */
    /******************************************************************/
EXIT_FUNC:
    return( usResult );
}

#ifdef OMIT
/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prds_WriteRow                                          */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   pScanType     lpDS;                                              */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function writes the final row into the bitmap taking into   */
/*   account the start and end masks.                                 */
/*                                                                    */
/**********************************************************************/
/*CON3201
USHORT prds_WriteRow ( lpStart,
                       ulPatDword,
                       ulStartMask,
                       ulEndMask,
                       ulMidMask,
                       usCount,
                       usBackMix)

PULONG        lpStart;
ULONG         ulPatDword;
ULONG         ulStartMask;
ULONG         ulEndMask;
ULONG         ulMidMask;
USHORT        usCount;
USHORT        usBackMix;
                      */

USHORT prds_WriteRow (PULONG        lpStart,
                      ULONG         ulPatDword,
                      ULONG         ulStartMask,
                      ULONG         ulEndMask,
                      ULONG         ulMidMask,
                      USHORT        usCount,
                      USHORT        usBackMix)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    USHORT              usResult;  /* function result                 */
    ULONG               ulDword;   /* current DWORD in target         */
    ULONG               ulMask;    /* mask for single DWORD           */

    /******************************************************************/
    /* Set up local variables                                         */
    /******************************************************************/
    usResult = OK;

    if (usCount == 1)
    {
        /**************************************************************/
        /* Only one DWORD to copy                                     */
        /**************************************************************/
        ulMask   = ulStartMask & ulEndMask;
        ulDword  = *lpStart;
        *lpStart = (ulDword & ~ulMask) | (ulPatDword & ulMask);
    }
    else
    {
        /**************************************************************/
        /* Multiple DWORDs to copy. Do the first ....                 */
        /**************************************************************/
        ulDword  = *lpStart;
        *lpStart = (ulDword & ~ulStartMask) | (ulPatDword & ulStartMask);

        /**************************************************************/
        /* usBytes now becomes the number of DWORDs                   */
        /**************************************************************/
        usCount--;
        usCount--;

        /**************************************************************/
        /* Need to proceed carefully here.                            */
        /**************************************************************/
        while (TRUE)
        {
            /**********************************************************/
            /* Move to the next DWORD                                 */
            /**********************************************************/
            lpStart++;
//CON3201
//CON3201
//CON3201   if ( !OFFSETOF(lpStart) )
//CON3201   {
//CON3201       /******************************************************/
//CON3201       /* This has wrapped, so move to the next segment      */
//CON3201       /******************************************************/
//CON3201       SELECTOROF(lpStart) += LOUSHORT(prdd_HugeInc);
//CON3201   }
//CON3201
            /**********************************************************/
            /* Now check if we have finished yet                      */
            /**********************************************************/
            if ( usCount-- )
            {
                /******************************************************/
                /* This is a middle DWORD, so we have no need to      */
                /* worry about the mask at all if the mix is OVERPAINT*/
                /******************************************************/
                if (usBackMix != BM_OVERPAINT)
                {
                    ulDword  = *lpStart;
                    *lpStart = (ulDword & ~ulMidMask) | (ulPatDword & ulMidMask);
                }
                else
                {
                    *lpStart = ulPatDword;
                }
            }
            else
            {
                /******************************************************/
                /* Have finished here.                                */
                /******************************************************/
                break;
            }
        }
        /*.... while (TRUE) ..........................................*/

        /**************************************************************/
        /* .... and the last                                          */
        /**************************************************************/
        ulDword  = *lpStart;
        *lpStart = (ulDword & ~ulEndMask) | (ulPatDword & ulEndMask);
    }

    /******************************************************************/
    /* And finished                                                   */
    /******************************************************************/
    return( usResult );
}
#endif
