/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDQNAME
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   OS2_PM_DRV_DEVICENAMES
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                     /* CON3201 */
#define INCL_DOSPROCESS             /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_DEV
#include <os2.h>
#undef INCL_DOSPROCESS              /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_DEV

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                            /* CON3201 */

#include <prdconse.h>
#include <prdmcone.h>
#include <prdqcone.h>

#define NO_SYS
#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef PRDMTYPE_INCL
#undef NO_SYS

#include <prdqextf.h>
#include <prdgextf.h>
#include <prdyextf.h>
#include <prdeextf.h>
#include <prduextf.h>

extern DVTDevDescriptionType  DVTDevDescription;
extern USHORT                 NO_OF_PRINTERS;
extern HMODULE                prdd_ModHandle;
extern USHORT                 PrinterOrder[];



/**********************************************************************/
/*                                                                    */
/*   FUNCTION: OS2_PM_DRV_DEVICENAMES                                 */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*                                                                    */
/*   PCHAR           ArgDriverName;                                   */
/*   PULONG          ArgDn;                                           */
/*   PVHAR           ArgDeviceName;                                   */
/*   PCHAR           ArgDeviceDesc;                                   */
/*   ULONG           ArgDt;                                           */
/*   PCHAR           ArgDataType;                                     */
/*   hanDC           DcH;                                             */
/*   ULONG           FunN;                                            */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function is one of the exported entry points into the       */
/*   driver.  It can return either the number of devices and/or data  */
/*   types supported (if ArgDn and/or ArgDt = 0) or the names of the  */
/*   devices and/or data types supported (if ArgDn and/or ArgDt > 0). */
/*                                                                    */
/**********************************************************************/
/* CON3201
ULONG _loadds OS2_PM_DRV_DEVICENAMES (ArgDriverName,
                                                 ArgDn,
                                                 ArgDeviceName,
                                                 ArgDeviceDesc,
                                                 ArgDt,
                                                 ArgDataType,
                                                 DcH,
                                                 FunN)

PCHAR           ArgDriverName;
PULONG          ArgDn;
PCHAR           ArgDeviceName;
PCHAR           ArgDeviceDesc;
PULONG          ArgDt;
PCHAR           ArgDataType;
hanDC           DcH;
ULONG           FunN;
                   */

ULONG  OS2_PM_DRV_DEVICENAMES (PCHAR           ArgDriverName,
                               PULONG          ArgDn,
                               PCHAR           ArgDeviceName,
                               PCHAR           ArgDeviceDesc,
                               PULONG          ArgDt,
                               PCHAR           ArgDataType,
                               hanDC           DcH,
                               ULONG           FunN)

{
#define TFUNC "OS2_PM_DRV_DEVICENAMES"

    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    USHORT        i;               /* Loop control variable           */
    PBYTE         pDriverName;     /* start of driver name            */
    PBYTE         pDotExtension;   /* position to replace '.'         */
    CHAR          Prntr_Name_Buf[MAX_PRNTR_NAME];
    USHORT        temp_printer_count;     /* PD00752 */
    /******************************************************************/
    /* Trace the parameters                                           */
    /******************************************************************/
    TRACE8(TFUNC, "Driver Name", ArgDriverName, 2);
    TRACE8(TFUNC, "Dn", ArgDn, 1);
    TRACE8(TFUNC, "Device Name", &ArgDeviceName, 1);
    TRACE8(TFUNC, "Device Desc", &ArgDeviceDesc, 1);
    TRACE8(TFUNC, "Dt", ArgDt, 1);
    TRACE8(TFUNC, "Data Type", &ArgDataType, 1);
    TRACE8(TFUNC, "DcH", &DcH, 1);
    TRACE8(TFUNC, "FunN", &FunN, 1);

    pDotExtension = FNULL;

    /******************************************************************/
    /* Note: NO_OF_PRINTERS supported by the driver is now a variable */
    /* (since 42xx/4019 merge), so cannot be written into             */
    /* DVTDevDescription in the data files. We write it in now.       */
    /*                                             ( MJB  13/11/90 )  */
    /******************************************************************/
//  DVTDevDescription.NoOfDescriptions = NO_OF_PRINTERS;

    /******************************************************************/
    /* If Dn is zero then it should be updated with the number of     */
    /* device names and descriptions supported.                       */
    /*                                                                */
    /* If Dn is non-zero it is updated to the number actually         */
    /* returned and the names and descriptions returned               */
    /******************************************************************/
    if ( *ArgDn == 0 )
    {
        /**************************************************************/
        /* Return the number of devices.                              */
        /**************************************************************/
        *ArgDn = NO_OF_PRINTERS;
        TRACE4(TFUNC, "Supported Devs", ArgDn, 1);
    }
    else
    {
        /**************************************************************/
        /* Because HPFS is case sensitive, we cannot return the name  */
        /* in the Device Description Table because this is always     */
        /* Instead we must use the driver name from ArgDriverName     */
        /* This is typically a string of type of the form:            */
        /*             "c:\os2\dll\ibm42xx.drv".                      */
        /* We strip this string down to the "ibm42xx" bit, which      */
        /* will be in the correct case. Note that this is by no means */
        /* foolproof.                                                 */
        /**************************************************************/

        /**************************************************************/
        /* First scan for the first occurrence of a "."               */
        /**************************************************************/
        for ( pDriverName = (PBYTE)ArgDriverName;
             *pDriverName != '\0';
              pDriverName++ )
        {
            if (*pDriverName == '.')
            {
                /******************************************************/
                /* Having found it replace it with a null character   */
                /* and remember the position to replace the dot       */
                /******************************************************/
                pDotExtension = pDriverName;
                *pDriverName = '\0';
                break;
            }
        }

        /**************************************************************/
        /* Now scan back to find a backslash which indicates the      */
        /* start of the driver name.                                  */
        /**************************************************************/
        for ( ; (pDriverName != (PBYTE)ArgDriverName) ; pDriverName-- )
        {
            if ( *pDriverName == '\\' )
            {
                pDriverName++;
                break;
            }
        }

        /**************************************************************/
        /* Return upto *ArgDn device names and descriptions.          */
        /**************************************************************/
        if ( *ArgDn > NO_OF_PRINTERS )
        {
            *ArgDn = NO_OF_PRINTERS;
        }

        /**************************************************************/
        /* PD00516 : Change the printer order.                        */
        /**************************************************************/

        temp_printer_count = 0;
        for ( i = 0; i < (USHORT)*ArgDn; i++ )
        {
           /*******************************************************************/
           /*  INKJET : Added check for a negative one, if there is then that */
           /*  printer is not available for installing at this time.          */
           /*******************************************************************/
           if (PrinterOrder[i] != 0xFF)                    /* PD00752 */
           {
              /********************************************************/
              /* PD00752: return name only if in .RC file             */
              /********************************************************/
              if (WinLoadString( hab,
                             prdd_ModHandle,
                             IDS_FIRST_PRINTER + PrinterOrder[i],
                             MAX_PRNTR_NAME,
                             (PSZ)Prntr_Name_Buf ))
              {
                 *ArgDeviceName = (CHAR)NULL;
                 *ArgDeviceDesc = (CHAR)NULL;
                 prdu_strcat ( (PBYTE)ArgDeviceName,
                               (PBYTE)Prntr_Name_Buf );
                 prdu_strcat ( (PBYTE)ArgDeviceDesc,
                               (PBYTE)Prntr_Name_Buf );


                 ArgDeviceName += ARG_DEVICE_NAME_LENGTH;
                 ArgDeviceDesc += ARG_DEVICE_DESC_LENGTH;
                 temp_printer_count++;                     /* PD00752 */
              }
           }
        }
        *ArgDn = temp_printer_count;                       /* PD00752 */
    }
    /*.. else ! (*ArgDn == 0) ........................................*/

    /******************************************************************/
    /* If Dt is zero then it should be updated with the number of     */
    /* datatypes supported.                                           */
    /* If Dt is non-zero it is updated to the number actually         */
    /* returned and the data types returned                           */
    /******************************************************************/
    if ( *ArgDt == 0 )
    {
        /**************************************************************/
        /* Return the number of datatypes supported.                  */
        /**************************************************************/
        *ArgDt = DVTDevDescription.NoOfDataTypes;
        TRACE4(TFUNC, "Supported Types", ArgDt, 1);
    }
    else
    {
        /**************************************************************/
        /* Return up to *ArgDt datatypes.                             */
        /*                                                            */
        /* Temporary Usage:                                           */
        /* The order in which we return the two data types is         */
        /* flipped in order to work-around a spooler     which shows  */
        /* up when running PageMaker.  ( SMP 18/2/90 )                */
        /**************************************************************/
        if ( *ArgDt > DVTDevDescription.NoOfDataTypes )
        {
             *ArgDt = DVTDevDescription.NoOfDataTypes;
        }

        for ( i = 0; i < (USHORT)*ArgDt; i++ )
        {
            *ArgDataType = (CHAR)NULL;

            prdu_strcat ( (PBYTE) ArgDataType,
                          DVTDevDescription.DataTypes[1-i].Name );

            ArgDataType += ARG_DATA_TYPE_LENGTH;
        }
    }
    /*.. else ! (*ArgDt == 0) ........................................*/

    /******************************************************************/
    /* Now restore the ArgDriverName that was passed in by replacing  */
    /* the '.' - only do this if a '.' was found (it may not be at    */
    /* 1.1.                                                           */
    /******************************************************************/
    if (pDotExtension)
    {
        *pDotExtension = '.';
    }

    /******************************************************************/
    /* Different return codes for 1.1 and 1.2                         */
    /******************************************************************/
/*  CON3201 we do not care about 1.1 or 1.2 anymore
**  if (prde_GetOSVersionNumber() == 1)
**  {
**      return( (ULONG)!ENG_OK );
**  }
**  else
**  {
**      return(OK);
**  }
*/
    return (OK);
}

#undef TFUNC

