/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDODC
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdo_SetDCOrigin
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                           /* CON3201 */
#define INCL_DOSPROCESS                   /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS                     /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                            /* CON3201 */

#define NO_SYS
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS

#include <prdaextf.h>
#include <prdiextf.h>
#include <prdgextf.h>
#include <prdoextf.h>

/******************************************************************************/
/*  FUNCTION: prdo_SetDCOrigin                                                */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*  See "OS/2 Technical Reference: I/O Subsytems and Device Drivers"          */
/*                                                                            */
/*  hanDC   DcH;                                                              */
/*  PULONG  lpOrigin;                                                         */
/*  lpDCI   DCIData;                                                          */
/*  ULONG   FunN;                                                             */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function sets the DC origin and gets the set of clip rectangles      */
/*  appropriate to it.                                                        */
/******************************************************************************/
/* CON3201
ULONG pascal far _loadds prdo_SetDCOrigin(DcH, lpOrigin, DCIData, FunN)

hanDC   DcH;
PULONG  lpOrigin;
lpDCI   DCIData;
ULONG   FunN;
           */

ULONG  prdo_SetDCOrigin(hanDC   DcH,
                                   PULONG  lpOrigin,
                                   lpDCI   DCIData,
                                   ULONG   FunN)

{
#define TFUNC "prdo_SetDCOrign"

    /**************************************************************************/
    /*  Local variables                                                       */
    /**************************************************************************/
    pBMListEntry         ListEntry;    /* Pointer to bitmap list entry        */

    /**************************************************************************/
    /*  Trace the parameters to this call                                     */
    /**************************************************************************/
    TRACE8(TFUNC, "DCInstance addr", &DCIData, 1);
    TRACE8(TFUNC, "FunN", &FunN, 1);
    TRACE8(TFUNC, "DcH", &DcH, 1);
    TRACE8(TFUNC, "Origin", lpOrigin, 2);
    prdm_EnterDriver(DCIData);

    /**************************************************************************/
    /*  Make sure there is a bitmap selected for this DC                      */
    /**************************************************************************/
    if (!(ListEntry = (pBMListEntry)DCIData->DCISelBitmap))/* CON3201 */
/*    if (!((PBYTE)ListEntry = DCIData->DCISelBitmap))                CON3201 */
    {
        prdm_LeaveDriver(DCIData);
        return (ERROR_ZERO);
    }

    /**************************************************************************/
    /*  Set the origin in the bit map list entry allowing for banding.        */
    /**************************************************************************/
    ListEntry->XOrigin = (signed)((lpOrigin)[0]) - ListEntry->BandXOrigin;
    ListEntry->YOrigin = (signed)((lpOrigin)[1]) - ListEntry->BandYOrigin;
    TRACE4(TFUNC, "Bitmap X origin", &ListEntry->XOrigin, 1);
    TRACE4(TFUNC, "Bitmap Y origin", &ListEntry->YOrigin, 1);

    /**************************************************************************/
    /*  Set the new DC origin                                                 */
    /**************************************************************************/
    DCIData->DCIOrigin.X = (signed)((lpOrigin)[0]);
    DCIData->DCIOrigin.Y = (signed)((lpOrigin)[1]);
    TRACE4(TFUNC, "New DC origin", &DCIData->DCIOrigin, 1);

    /**************************************************************************/
    /*  Call GetClipRects to get a new set of clip rectangles for the new DC  */
    /*  origin allowing for the default clip rectangle being selected.        */
    /*                                                                        */
    /*  PD00018 : Call prdi_DefaultClip() directly if requesting the default  */
    /*  clips rather than calling prdi_GetClipRects() with ArgComplexity of 0.*/
    /*  Also, changed parm list for prdi_GetClipRects().                      */
    /*                                                                        */
    /*  PD00305 : No longer need to call prdi_GetClipRects() since we cache   */
    /*  the clips and process on the fly.                                     */
    /**************************************************************************/
    if (DCIData->DCIClipNum == 0)      /* PD00305 : No clips - use defaults   */
    {
        (VOID)prdi_DefaultClip(DCIData);
    }

    /**************************************************************************/
    /*  Exit OK                                                               */
    /**************************************************************************/
    TRACE4(TFUNC, "Exit OK", FNULL, 0);
    prdm_LeaveDriver(DCIData);
    return(OK);
}
#undef TFUNC
