/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDMDSUB
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdm_ResidentFonts
 *             prdm_CodePageFonts
 *             prdm_CardFonts
 *             prdm_ExpandFaceName
 *             prdm_LoadMatchParameters
 *             prdm_CheckMatchParameters
 *             prdm_CheckDefaultFont
 *             prdm_DisplayPointSzLst         PD00137
 *             prdm_GetPointSzIndex           PD00137
 *             prdm_EnterFontPointSz          PD00137
 *             prdm_DfltFontPSzControlProc    PD00137
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSRESOURCES
#define INCL_DOSSEMAPHORES
#define INCL_GPIERRORS
#define INCL_SHLERRORS
#define INCL_DOSERRORS
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_DOSMODULEMGR
#define INCL_WINFRAMEMGR
#define INCL_WINLISTBOXES
#define INCL_WINBUTTONS
#define INCL_WINERRORS
#define INCL_WINDIALOGS
#define INCL_WINSHELLDATA
#define INCL_WINENTRYFIELDS
#define INCL_WINMESSAGEMGR
#define INCL_WININPUT
#define INCL_WINMENUS
#define INCL_WINPOINTERS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSRESOURCES
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIERRORS
#undef INCL_DOSERRORS
#undef INCL_SHLERRORS
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_DOSMODULEMGR
#undef INCL_WINFRAMEMGR
#undef INCL_WINLISTBOXES
#undef INCL_WINBUTTONS
#undef INCL_WINERRORS
#undef INCL_WINDIALOGS
#undef INCL_WINSHELLDATA
#undef INCL_WINENTRYFIELDS
#undef INCL_WINMESSAGEMGR
#undef INCL_WININPUT
#undef INCL_WINMENUS
#undef INCL_WINPOINTERS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELSERVER
#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELSERVER
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI

#define INCL_WINSHELLDATA
/* #include <pmshlp.h>                                              DLM01 */
#define INCL_WINSHELLDATA
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>
#include <prddcone.h>
#include <prdecone.h>
#include <prdmcone.h>
#include <prdtcone.h>

#define NO_SYS
#define INCL_HELP
#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS
#undef INCL_HELP
#undef PRDMTYPE_INCL

#include <prdgextf.h>
#include <prdmextf.h>
#include <prduextf.h>



extern HMODULE              prdd_ModHandle;
extern DModeDataType        DMData;
extern pDMDriverStruc       pDMDrivData;
extern lpDMSettings         pDMSettings;
extern CHAR                 szCaption[40];
extern CHAR                 szMessage[SLEN_BOX_MESSAGE];
extern BYTE                 SrcDirBuffer[80];
extern char                 szQualityString1[];
extern char                 szQualityString2[];
extern char                 szQualityString3[];
extern char                 szQualityString2a[];           /* PD00731 */
extern CPTUseTableEntry     CPTUseTable[];

extern DMIniEntryType       DMIniEntry[LARGEST_NO_OF_PRINTERS];
extern lplpFontCPListType   DVTFontCPList [];
extern lpDVTCPSource        DVTCodePageCaps [];
extern DVTCPListType        DVTCodePageList [];
extern lpDDTType            DDT [];
extern USHORT               DRIVER_TYPE;
extern lpFontListType       DVTFontList9Wire [];
extern lpFontListType       DVTFontList9WireNLS [];
extern lpFontListType       DVTFontList24Wire [];
extern lpFontListType       DVTFontList24WireNLS [];
extern PCHAR                DfltFontPSzTable[];



/**********************************************************************/
/*                                                                    */
/*   Function        = prdm_ResidentFonts                             */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function gets the FMF for each resident font, adds the      */
/*   match entry to the match parameters and the description to the   */
/*   description parameters of the current default font list entry,   */
/*   then checks whether this font has already appeared.              */
/*                                                                    */
/**********************************************************************/

lpFMFFontList prdm_ResidentFonts( )

{
#define TFUNC "prdm_ResidentFonts"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    lpFMFFontList       ResFontList;     /* List of addresses for     */
                                         /* resident FMFs             */
    lpDDTType           pDDT;            /* Pointer to DDT            */
    USHORT              PrinterType;
    USHORT              CurrentEntry;
    lpDfltFontTable     DefaultFontTable;
    lpDfltFontList      DefaultFontList;
    lplpFontListType    FontList;
    lpFMFFileStruc      pFMFData;
    USHORT              NoOfResidentFonts;
    SHORT               i,j;
    USHORT              Result;
    FOCAMETRICS         Metrics;
    USHORT              AveCharWidth;                       /* INKJET */
    USHORT              Pitch;                              /* INKJET */
    CHAR                PitchStr[4];                        /* INKJET */
    CHAR                FaceName[32];                       /* INKJET */
    PBYTE               pDest;                              /* INKJET */
    PBYTE               pQuality;                           /* INKJET */


    /******************************************************************/
    /* Set up local pointers.                                         */
    /******************************************************************/
    PrinterType = pDMSettings->PrinterType;
    pDDT = DDT[PrinterType];
    DefaultFontList = &(DMData.DefaultFontList);
    DefaultFontTable = DefaultFontList->DefaultFontTable;

    NoOfResidentFonts = pDDT->DDTNoOfResidentFonts;

    FontList = pDDT->DDTFontList;

    /******************************************************************/
    /* DIAL/NILE : If its a nile/tiber # of resident fonts and the    */
    /* resident font list are not set up in globlal DDTs.             */
    /******************************************************************/
    if (pDDT->DDTFontFlags & DDT_NLS_FONTS_OPTIONAL)
    {
        if ( (PrinterType == IBM_NILE_9) ||
             (PrinterType == IBM_TIBER_9) )
        {
            if (pDMSettings->MachineType == NLS_MACHINE)
            {
                NoOfResidentFonts = NLS_9WIRE;
                FontList = DVTFontList9WireNLS;
            }
            else
            {
                NoOfResidentFonts = US_9WIRE;
                FontList = DVTFontList9Wire;

            }
        }
        else /* its a 24-wire */
        {
            if (pDMSettings->MachineType == NLS_MACHINE)
            {
                NoOfResidentFonts = NLS_24WIRE;
                FontList = DVTFontList24WireNLS;
            }
            else
            {
                NoOfResidentFonts = US_24WIRE;
                FontList = DVTFontList24Wire;

            }
        }
    }

    /******************************************************************/
    /* Allocate memory for a list of FMF info for the resident fonts. */
    /* Each entry contains the address of the FMF data and a          */
    /* flag indicating if the resource id pointed to a real or dummy  */
    /* FMF - this is needed when de-allocating memory.                */
    /******************************************************************/
 /* CON3201 ***********************************************************/
 /* Result = SSALLOCSEG( NoOfResidentFonts * sizeof(FMFFontList),     */
 /*                      &SELECTOROF(ResFontList),                    */
 /*                      0 );                                         */
 /*********************************************************************/

    Result = SafeSSALLOCMEM( &ResFontList,
                             (NoOfResidentFonts * sizeof(FMFFontList)),
                         0 );

    if ( Result != DOS_OK )
    {
        TRACE8(TFUNC, "SSALLOCMEM Error", FNULL, 0);
        DefaultFontList->FontError = FATAL_MEMORY_ALLOCATION_ERROR;
        return(FNULL);
    }

/*  OFFSETOF(ResFontList) = 0;                                        CON3201 */

    /******************************************************************/
    /* Add the resident fonts to the table.                           */
    /******************************************************************/
    for ( i = 0; i < NoOfResidentFonts; i++ )
    {
        /**************************************************************/
        /* First load the FMF file for the resident fonts             */
        /* from resources - this could be a dummy or a real FMF file. */
        /* The routine also copes with 4019 FMFs.                     */
        /**************************************************************/
     /* if (prdm_ReadFontResource( (lpFMFFileStruc far *) */
        if (prdm_ReadFontResource( (lpFMFFileStruc *)      /* CON3201 */
                                        &ResFontList[i].FMFAddress,
                               (USHORT)FontList[i]->ResourceId,
                               (PBOOL)&ResFontList[i].SegmentAllocFlag,
                               i,
                               ResFontList,
                               pDDT ) != OK )
        {
            DefaultFontList->FontError = SOME_FONTS_NOT_LOCATED;
            continue;

        }

        /**************************************************************/
        /* PD00220 : Pass in a copy of the font metrics instead of    */
        /* the whole FMF resource so we can change the code page      */
        /* field.                                                     */
        /**************************************************************/
        pFMFData = (lpFMFFileStruc)  ResFontList[i].FMFAddress;
        Metrics  = pFMFData->Metrics;

        /**************************************************************/
        /* PD00220 : Grab the code page from the font structure, not  */
        /* the metrics for Nile/Tiber/4226.                           */
        /*                                                            */
        /* PD00290 : grab it for the X24E & XL24E as well             */
        /**************************************************************/
        if ( (pDDT->DDTDriverType == DDT_IBM42XX_DRV) &&
             ( (PrinterType > IBM_4224_MONO) ||
               (PrinterType == IBM_PRO_PRINTER_X24E) ||
               (PrinterType == IBM_PRO_PRINTER_XL24E) ) )
        {
            pFMFData = (lpFMFFileStruc)  ResFontList[i].FMFAddress;
            Metrics  = pFMFData->Metrics;
            Metrics.usCodePage == FontList[i]->CodePage;
        }

        /**************************************************************/
        /* Get the parameters that we use to match against the        */
        /* default font from INI/DriverData                           */
        /**************************************************************/
        prdm_LoadMatchParameters( &Metrics,
                                  0 );

        /******************************************************************/
        /*  INKJET:Copy new larger fontlist into DMData.                  */
        /******************************************************************/
        DefaultFontTable = DefaultFontList->DefaultFontTable;

        /**************************************************************/
        /* Fill in FontType and FontIndex fields in FontDescription  */
        /* structure for the current entry.                           */
        /**************************************************************/
        CurrentEntry = DefaultFontList->CurrentEntry;
        DefaultFontTable[CurrentEntry].FontDescription.FontType =
                                                         FT_RESIDENT;
        DefaultFontTable[CurrentEntry].FontDescription.FontIndex = i;

        /**************************************************************/
        /* Check to see if this font has already appeared.            */
        /**************************************************************/
        prdm_CheckMatchParameters( );

    } /* end for ( ...i < NoOfResidentFonts... ) */

    return(ResFontList);
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   Function        = prdm_CardFonts                                 */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   USHORT            SlotNumber                                     */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function is called to process all the card fonts.           */
/*   It gets the FMF for each font in the code page, adds             */
/*   the match entry to the match parameters and the description to   */
/*   the description parameters of the current default font list      */
/*   entry, the checks whether this font has already appeared.        */
/*                                                                    */
/**********************************************************************/
#if 0
VOID prdm_CardFonts( SlotNumber )

USHORT            SlotNumber;
#endif

VOID prdm_CardFonts( USHORT SlotNumber )                   /* CON3201 */

{
#define TFUNC "prdm_CardFnts"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    lpFMFFileStruc      pFMFData;
    lpFMFFileStruc      pFMF;
    USHORT              Result;          /* Function call return      */
    lpDDTType           pDDT;            /* Pointer to DDT            */
    USHORT              i, j, k;         /* Loop control variables    */
    USHORT              Index;           /* index into card  PD00340  */
    PBYTE               pSource, pDest;  /* Working pointers          */
    lpCDFFileStruc      pCDFData = FNULL;
    SHORT               OwnedIndex;      /* Index of card in slot     */
                                         /* into list of owned cards  */
    USHORT              CardIndex;
    PBYTE               pCardPath;
    PBYTE               pCardPathEnd;
    USHORT              FileSize;
    USHORT              NoOfFonts;
    USHORT              NoOfFMFs;
    BYTE                FMFNameBuffer[13];
    USHORT              CurEnt;
    USHORT              Iterations;
    BOOL                OldCDFStruc;
    lpDfltFontTable     FontTable;
    lpDfltFontList      DefaultFontList;

    USHORT              iTemp;           /* PD00722                   */

    /******************************************************************/
    /* First set up local pointers.                                   */
    /******************************************************************/
    pDDT = DDT[pDMSettings->PrinterType];
    DefaultFontList = &(DMData.DefaultFontList);
    FontTable = DefaultFontList->DefaultFontTable;

    /******************************************************************/
    /* Get the card index.                                           */
    /******************************************************************/
    OwnedIndex = DMData.Slot[SlotNumber].Index;
    CardIndex =  DMData.OwnedIndexList[OwnedIndex];
    TRACE6(TFUNC, "Card index", &CardIndex, 1);

    /**************************************************************/
    /* Get the path and copy the card name into the slot info.    */
    /**************************************************************/
    if ( CardIndex < pDMSettings->ShippedCardCount )
    {
        TRACE6(TFUNC, "Shipped card", FNULL, 0);

        /**********************************************************/
        /* Initial metrics must have been installed.              */
        /**********************************************************/
        pCardPath = DMData.pMetricsPath;
        prdu_strcpy ( (PBYTE) DMData.Slot[SlotNumber].CardName,
                      (PBYTE) DMData.pShippedCards[CardIndex] );
    }
    else
    {
        TRACE6(TFUNC, "Added card", FNULL, 0);

        /**********************************************************/
        /* This is an added card - skip to the start of the data  */
        /* for the required card.                                 */
        /**********************************************************/
        pSource = DMData.pCardData;

        for ( j = CardIndex - pDMSettings->ShippedCardCount;
              j > 0;
              j-- )
            while ( *pSource++ != '\0' );

        /**********************************************************/
        /* Copy the path across to the source directory buffer    */
        /* and copy the card name into the slot info structure.   */
        /**********************************************************/
        pDest = SrcDirBuffer;
        pCardPath = SrcDirBuffer;

        while ( *pSource != '.' )
        {
            if ( (*pSource == '\\') || (*pSource == ':') )
                pCardPathEnd = pDest;

            *pDest++ = *pSource++;
        }

        *pCardPathEnd = '\0';             /* end of path          */
        *pDest = '\0';                    /* end of card name     */

        prdu_strcpy ( (PBYTE)DMData.Slot[SlotNumber].CardName,
                      (PBYTE)(pCardPathEnd + 1) );
    }

    TRACE6(TFUNC, "Card name", DMData.Slot[SlotNumber].CardName, 2);

    /**************************************************************/
    /* Read in the CDF file data.                                 */
    /**************************************************************/
    Result = prdm_ReadFileContents( pCardPath,
                                       DMData.Slot[SlotNumber].CardName,
                                       CDF_EXTENSION,
                                       &FileSize,
                                    /* (PBYTE far *)&pCDFData ); */
                                       (PBYTE *)&pCDFData ); /* CON3201 */
    if ( Result != DOS_OK )
    {
        TRACE8(TFUNC, "Read file failed", FNULL, 0);
        DefaultFontList->FontError =
                      SOME_FONTS_NOT_LOCATED;
        return;
    }

    NoOfFMFs = pCDFData->FMFCount & CDF_NO_OF_FMFS_MASK;

    OldCDFStruc =
          !(pCDFData->FMFCount & FILE_NOT_OLD_STYLE_CARSON);


    /**************************************************************/
    /* Cycle through each FMF in the CDF.                         */
    /**************************************************************/
    for ( j = 0, Index = 0; j < NoOfFMFs; j++ )
    {
        /**********************************************************/
        /* Copy across the FMF file name and whack a '\0' on the  */
        /* end.                                                   */
        /**********************************************************/
        if ( OldCDFStruc )
            pSource = ((lpOldCDFFileStruc)pCDFData)->
                                           FMFEntryArray[j].FMFName;
        else
            pSource = pCDFData->FMFEntryArray[j].FMFName;

        for ( k = 0;
              (k < FILENAME_SIZE) && (*pSource != ' ');
              k++, pSource++ )
        {
             FMFNameBuffer[k] = *pSource;
        }

        FMFNameBuffer[k] = '\0';

        /**********************************************************/
        /* Get the FMF file contents.                             */
        /**********************************************************/
        Result = prdm_ReadFileContents( pCardPath,
                                        FMFNameBuffer,
                                        FNULL,
                                        &FileSize,
                                     /* (PBYTE far *)&pFMFData ); */
                                        (PBYTE *)&pFMFData ); /* CON3201 */
        if ( Result != DOS_OK )
        {
            TRACE8(TFUNC, "Read file failed", FNULL, 0);
            DefaultFontList->FontError =
                      SOME_FONTS_NOT_LOCATED;
            continue;
        }

        /**********************************************************/
        /* If this is a MultiCp FMF we need to skip the first     */
        /* three bytes to point to the start of the FMF name      */
        /* to pass to DisplayDfltFontEntry routine.               */
        /**********************************************************/
        if ( pFMFData->FMFName[0] == MULTICP_FMF_VALUE )
            pFMF = (lpFMFFileStruc)((PBYTE)pFMFData + 3);
        else
            pFMF = pFMFData;

        /**********************************************************/
        /* Some printers (e.g. the QuietWriter III) support       */
        /* multiple quality levels per FMF; these fonts need to   */
        /* be distinguished by adding a description of the        */
        /* quality level to the facename.                         */
        /**********************************************************/
        if ( pDDT->DDTFontFlags & DDT_ADD_QUALITY_TO_FACE )
        {
            if (pDDT->DDTDriverType == DDT_IBM42XX_DRV)
            {
                Iterations = 2;
            }
            else
            {
                Iterations = QUALITY_LEVELS;
            }
        }
        else
            Iterations = 1;

        /**********************************************************/
        /* For each quality level, expand the facename if needed, */
        /* load the match and description parameters into the     */
        /* current entry, then check to see if the font has       */
        /* already appeared.                                      */
        /**********************************************************/
        for (i = Iterations; i > 0 ; i-- , Index++)
        {
            /**********************************************************/
            /* PD00722:                                               */
            /* Switch Quality/Draft order if 42XX driver (4072)       */
            /**********************************************************/
            iTemp = i;
            if (DRIVER_TYPE == DDT_IBM42XX_DRV)
            {
               iTemp = (i == 2) ? 1 : 2;
            }
            prdm_LoadMatchParameters( &pFMF->Metrics,
                                      iTemp );

            /******************************************************************/
            /*  INKJET:Copy new larger fontlist into DMData.                  */
            /******************************************************************/
            FontTable = DefaultFontList->DefaultFontTable;

            /******************************************************/
            /* Fill in FontType, FontIndex, FontCardName fields   */
            /* in FontDescription for the current entry.          */
            /******************************************************/
            CurEnt = DefaultFontList->CurrentEntry;
            FontTable[CurEnt].FontDescription.FontType = FT_CARD;
            /* PD00340                                            */
            FontTable[CurEnt].FontDescription.FontIndex = Index;


            /******************************************************/
            /* Copy card name                                     */
            /******************************************************/
            for (k = 0; k < 10; k++)
            {
                /**************************************************/
                /* Check to see if we've gotten to the last char. */
                /**************************************************/
                if ( DMData.Slot[SlotNumber].CardName[k] == '\0' )
                    break;

                /**************************************************/
                /* if not copy the char over                      */
                /**************************************************/
                FontTable[CurEnt].FontDescription.FontCardName[k] =
                                 DMData.Slot[SlotNumber].CardName[k];

            } /* ... for (k=0;k<10;k++) ... */

            /******************************************************/
            /* Check to see if this font has already appeared.    */
            /******************************************************/
            prdm_CheckMatchParameters( );

        } /* ... for (i = Iterations; i > 0 ; i--) ... */

        /**********************************************************/
        /* Free the segment used to hold the FMF data.            */
        /**********************************************************/
/*      SSFREESEG( SELECTOROF(pFMFData) );                            CON3201 */
        SSFREEMEM( pFMFData );
        pFMFData = FNULL;
    }
    /* .... for ( j = 0; j < NoOfFMFs; j++ ) .................... */


    /**************************************************************/
    /* Free the segment used to hold the CDF data.                */
    /**************************************************************/
/*  SSFREESEG( SELECTOROF(pCDFData) );                                CON3201 */
    SSFREEMEM( pCDFData );
    pCDFData = FNULL;


    return;
}
#undef TFUNC

/**********************************************************************/
/*                                                                    */
/*   Function        = prdm_ExpandFaceName                            */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   PFOCAMETRICS     pMetrics                                        */
/*   USHORT           Quality                                         */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   Expands the facename for Quiet III cartridge fonts.              */
/*                                                                    */
/**********************************************************************/
#if 0
VOID prdm_ExpandFaceName(   pMetrics,
                            Quality )

PFOCAMETRICS     pMetrics;
USHORT          Quality;
#endif

VOID prdm_ExpandFaceName( PFOCAMETRICS   pMetrics,         /* CON3201 */
                          USHORT         Quality )         /* CON3201 */

{
#define TFUNC "prdm_ExpandFaceName"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    PBYTE               pSource, pDest;     /* Working pointers       */

    /******************************************************************/
    /* Move our working pointer to the end of the facename.           */
    /******************************************************************/
    for (pDest = pMetrics->szFacename; *pDest != '\0';pDest++);

    /******************************************************************/
    /* Get the pointer to the quality string.                         */
    /******************************************************************/
    switch ( Quality )
    {
         case 1:
             pSource = szQualityString1;
             break;

         case 2:
             /*********************************************************/
             /* PD00731: use alternate Quality string if facename too */
             /*          long (31-8=23) where _Quality is 8           */
             /*********************************************************/
             if ((pDest - (PBYTE)pMetrics->szFacename) <= 23)
                 pSource = szQualityString2;
             else pSource = szQualityString2a;
             break;

         case 3:
         default:
             pSource = szQualityString3;
             break;
    }

    /******************************************************************/
    /* Add the quality string to the end of the facename.             */
    /******************************************************************/
    for ( ; *pSource != '\0'; )
        *pDest++ = *pSource++;

    /******************************************************************/
    /* PD00205: Slap an ending '\0' to delimit the end of the face    */
    /* name.                                                          */
    /******************************************************************/
    *pDest = '\0';

    return;
}
#undef TFUNC

/**********************************************************************/
/*                                                                    */
/*   Function        = prdm_LoadMatchParameters                       */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   lpFMFFileStruc    pFMFData                                       */
/*   USHORT            Quality                                        */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function copies data from the FMF provided into the match   */
/*   parameters in the current entry of the default font list.        */
/*                                                                    */
/**********************************************************************/
#if 0
VOID prdm_LoadMatchParameters( pMetrics,
                               Quality)

PFOCAMETRICS      pMetrics;
USHORT            Quality;
#endif

VOID prdm_LoadMatchParameters( PFOCAMETRICS pMetrics,      /* CON3201 */
                               USHORT       Quality)       /* CON3201 */

{
#define TFUNC "prdm_LdMatchParms"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    lpDDTType            pDDT;
    lpDfltFontTable      DefaultFontTable;
    lpDfltFontList       DefaultFontList;
    USHORT               i;
    USHORT               CurrentEntry;
    USHORT               PrinterType;
    FOCAMETRICS          TempMetrics;

    /******************************************************************/
    /* Set up local pointers.                                         */
    /******************************************************************/
    DefaultFontList  = &(DMData.DefaultFontList);
    DefaultFontTable = DefaultFontList->DefaultFontTable;
    CurrentEntry     = DefaultFontList->CurrentEntry;
    PrinterType      = pDMSettings->PrinterType;
    pDDT =             DDT[PrinterType];

    /******************************************************************/
    /* Indicate that this entry is valid.                             */
    /******************************************************************/
    DefaultFontTable[CurrentEntry].Valid = TRUE;

    /******************************************************************/
    /* Copy the facename, fgid, and point size to FontMatch.          */
    /******************************************************************/
    if ( (pDDT->DDTFontFlags & DDT_ADD_QUALITY_TO_FACE) &&  Quality)
    {
        /**************************************************************/
        /* Card fonts can have a quality associated with them, so add */
        /* it if necessary.                                           */
        /*                                                            */
        /* PD00205 : First we have to make a copy of the metrics so   */
        /* we don't have problems.                                    */
        /**************************************************************/
        TempMetrics = *pMetrics;

        prdm_ExpandFaceName( &TempMetrics, Quality );

        prdu_strcpy((PBYTE)DefaultFontTable[CurrentEntry].FontMatch.Facename,
                 TempMetrics.szFacename);
    }
    else
    {
        /**************************************************************/
        /* PD00205 : No quality to be added so grab the facename      */
        /* directly from the original metrics.                        */
        /**************************************************************/
        prdu_strcpy((PBYTE)DefaultFontTable[CurrentEntry].FontMatch.Facename,
                 pMetrics->szFacename);
    }


    DefaultFontTable[CurrentEntry].FontMatch.Fgid =
                                       pMetrics->usRegistryId;

    DefaultFontTable[CurrentEntry].FontMatch.PointSize =
                                       pMetrics->usNominalPointSize;

    /******************************************************************/
    /* If printer has outline fonts, set point size to zero for       */
    /* default outline fonts instead of the nominal size because      */
    /* we will display a seperate point size list box.   PD00137      */
    /* Also PD00332                                                   */
    /******************************************************************/
    if (pDDT->DDTDialogFlags & DDT_DEF_OUTLN_FNT_PSZ)
    {
       if (pMetrics->fsDefn & FM_DEFN_OUTLINE)
           DefaultFontTable[CurrentEntry].FontMatch.PointSize = 0;
    }

    /******************************************************************/
    /* Get the code page of the font.                                 */
    /******************************************************************/
    DefaultFontTable[CurrentEntry].FontMatch.CodePage =
                                           pMetrics->usCodePage;

    /******************************************************************/
    /* If the codepage is 0, then the codepage is a root code page.   */
    /* If not 0, then we check to see if it is one of the other root */
    /* codepages. If it is we set codepage to 0.                      */
    /******************************************************************/
    if (DefaultFontTable[CurrentEntry].FontMatch.CodePage != 0)
    {
        for (i = 0; i < 3; i++)
        {
            if (pMetrics->usCodePage == CPTUseTable[0].RootCPList[i])
            {
                DefaultFontTable[CurrentEntry].FontMatch.CodePage = 0;
                break;
            } /* ... if (pMetrics->usCodePage                     ... */
        } /* ... for (i = 0; i < 3; i++) ... */
    } /* ... if (DefaultFontTable[CurrentEntry.FontMatch.CodePage ... */

    return;
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   Function        = prdm_CheckMatchParameters                      */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   lpFMFFileStruc   pFMFData                                        */
/*   USHORT           Quality                                         */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   Checks to see if the current font is valid and whether or not    */
/*   it is the default font.  If it is valid CurrentEntry is bumped   */
/*   to point to the next entry.                                      */
/*                                                                    */
/**********************************************************************/

VOID prdm_CheckMatchParameters( )

{
#define TFUNC "prdm_ChckMatchParms"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    lpDfltFontTable      FontTable;
    lpDfltFontList       DefaultFontList;
    USHORT               CurrentEntry;
    USHORT               MatchFound;
    USHORT               Facename;
    USHORT               Fgid;
    USHORT               Pointsize;
    USHORT               Result;
    USHORT               i;

    /******************************************************************/
    /* Set up the pointers and initial values                         */
    /******************************************************************/
    DefaultFontList = &(DMData.DefaultFontList);
    FontTable = DefaultFontList->DefaultFontTable;
    CurrentEntry = DefaultFontList->CurrentEntry;
    MatchFound = FALSE;
    Result = 0;                                          /* PD00299   */

    /******************************************************************/
    /* First see if we've found the default font already.             */
    /******************************************************************/
    if ( !DefaultFontList->DefaultFontFound )
    {
        /**************************************************************/
        /* If we haven't found it, see if the current font entry is   */
        /* the default.  If it is set DefaultFontFound and Default    */
        /* FontIndex.                                                 */
        /**************************************************************/
        Result = prdm_CheckDefaultFont();
        if (Result)
        {
            DefaultFontList->DefaultFontFound = TRUE;
            DefaultFontList->DefaultFontIndex =
                               DefaultFontList->CurrentEntry;
        }
    } /* ... if ( !DefaultFontList->DefaultFontFound ) ... */

    /******************************************************************/
    /* Now search the list to see if there is any matching fonts.     */
    /* This is done so that if a font is available in all OS/2        */
    /* codepages, it only appears once in the listbox, with no        */
    /* codepage associated with it.                                   */
    /*                                                                */
    /*  PD00052 : Check Fgid, Facename, & Pointsize for all printers. */
    /******************************************************************/
    for ( i = 1; i < CurrentEntry ; i++)
    {
        Fgid = (FontTable[i].FontMatch.Fgid ==
                       FontTable[CurrentEntry].FontMatch.Fgid );

        Facename = !(prdu_strcmp(
               (PBYTE) FontTable[i].FontMatch.Facename,
               (PBYTE) FontTable[CurrentEntry].FontMatch.Facename));

        Pointsize = (FontTable[i].FontMatch.PointSize ==
                     FontTable[CurrentEntry].FontMatch.PointSize);


        if (Fgid && Facename && Pointsize)
        {
            MatchFound = i;
            break;
        }
    } /* ... for ( i = 1; i < CurrentEntry ; i++) ... */

    /******************************************************************/
    /* If we don't find a match then go increment CurrentEntry to     */
    /* point to the next entry in FontTable.                          */
    /******************************************************************/
    if ( !MatchFound )
    {
        /**************************************************************/
        /* Check to see if we've run out of table space and allocate  */
        /* more memory if needed.                                     */
        /**************************************************************/
        if (CurrentEntry == (DefaultFontList->FontTableSize-1))
            prdm_MoreFontTableMemory( );
        else
            DefaultFontList->CurrentEntry += 1;
    }
    else
    {
        /**************************************************************/
        /* If the matched font is not a root font (CodePage = 0),     */
        /* then check to see if the current font is a root font.      */
        /**************************************************************/
        if (FontTable[MatchFound].FontMatch.CodePage != 0)
        {
            /**********************************************************/
            /* If the neither the matched font nor the current font   */
            /* is a root font then increment CurrentEntry to point to */
            /* the next entry.                                        */
            /**********************************************************/
            if (FontTable[CurrentEntry].FontMatch.CodePage != 0)
            {
                /******************************************************/
                /* Check to see if we've run out of table space and   */
                /* allocate more memory if needed.                    */
                /******************************************************/
                if (CurrentEntry == (DefaultFontList->FontTableSize-1))
                    prdm_MoreFontTableMemory( );
                else
                    DefaultFontList->CurrentEntry += 1;
            }
            else
            {
                /******************************************************/
                /* The current font is a root font so we need to      */
                /* set the matched font to say that this font is      */
                /* root, tag the current font as invalid, and then    */
                /* check all fonts between match and current and tag  */
                /* any matching fonts invalid.                        */
                /*                                                    */
                /*  PD00299 : If the current font is the default      */
                /*  font reset the default font index to the matched  */
                /*  font.                                             */
                /******************************************************/
                FontTable[MatchFound].FontMatch.CodePage = 0;
                FontTable[CurrentEntry].Valid = FALSE;

                if (Result)
                {
                    DefaultFontList->DefaultFontIndex = MatchFound; /*PD00299*/
                }

                for (i = MatchFound+1; i < CurrentEntry ; i++)
                {
                    /**************************************************/
                    /* PD00052 : Check fgid, facename, and pointsize  */
                    /* for all printers.                              */
                    /**************************************************/
                    Fgid = (FontTable[MatchFound].FontMatch.Fgid ==
                            FontTable[CurrentEntry].FontMatch.Fgid );

                    Facename = ! (prdu_strcmp(
                       (PBYTE) FontTable[i].FontMatch.Facename,
                       (PBYTE) FontTable[CurrentEntry].FontMatch.Facename));

                    Pointsize = (FontTable[i].FontMatch.PointSize ==
                                 FontTable[CurrentEntry].FontMatch.PointSize);

                    if (Fgid && Facename && Pointsize)
                    {
                        DefaultFontList->InvalidEntries =
                                TRUE;
                        FontTable[i].Valid = FALSE;

                        /**********************************************/
                        /* If the current font is the default font we */
                        /* have to reset the default font index to    */
                        /* the matched font                           */
                        /**********************************************/
                        if (DefaultFontList->DefaultFontIndex ==
                                                i)
                            DefaultFontList->DefaultFontIndex =
                                         MatchFound;
                    }

                } /* ... for (i = MatchFound+1; i < CurrentEntry ...  */

            } /* ... if (FontTable[CurrentEntry].FontMatch ...        */

        } /* ... if (FontTable[MatchFound].FontMatch.CodePage ...     */

        else
        {
            /**************************************************************/
            /* Matched font is a root font so current entry is invalid.   */
            /**************************************************************/
            FontTable[CurrentEntry].Valid = FALSE;

            /**********************************************************/
            /* PD00299: If the current entry is the default make sure */
            /* we make the matched font the default.                  */
            /**********************************************************/
            if (Result)
            {
                DefaultFontList->DefaultFontIndex = MatchFound;
            }
        }

    } /* ... if ( !MatchFound ) ...                                   */

    return;
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   Function        = prdm_CheckDefaultFont                          */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This tests the current entry in the default font list to see     */
/*   if it is the default font.                                       */
/*                                                                    */
/**********************************************************************/

USHORT prdm_CheckDefaultFont( )

{
#define TFUNC "prdm_ChckDfltFont"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    lpDfltFontTable      FontTable;
    lpDfltFontList       DefaultFontList;
    USHORT               CurrentEntry;
    USHORT               DefaultFontType;
    USHORT               DefaultIndex;
    USHORT               DefaultCodePage;
    PCHAR                DefaultCardName;
    USHORT               CurrentFontType;
    USHORT               CurrentIndex;
    USHORT               CurrentCodePage;
    PCHAR                CurrentCardName;
    USHORT               NamesMatch;
    USHORT               RetVal;

    /******************************************************************/
    /* Set up local pointers.                                         */
    /******************************************************************/
    DefaultFontList = &(DMData.DefaultFontList);
    FontTable = DefaultFontList->DefaultFontTable;

    /******************************************************************/
    /* Compare the current font to the default font and return true   */
    /* if the current font matches                                    */
    /******************************************************************/
    CurrentEntry    = DefaultFontList->CurrentEntry;
    RetVal          = FALSE;
    DefaultFontType = FontTable[0].FontDescription.FontType;
    DefaultIndex    = FontTable[0].FontDescription.FontIndex;
    DefaultCodePage = FontTable[0].FontDescription.FontCodePage;
    DefaultCardName = FontTable[0].FontDescription.FontCardName;
    CurrentFontType = FontTable[CurrentEntry].FontDescription.FontType;
    CurrentIndex    = FontTable[CurrentEntry].FontDescription.FontIndex;
    CurrentCodePage = FontTable[CurrentEntry].FontDescription.FontCodePage;
    CurrentCardName = FontTable[CurrentEntry].FontDescription.FontCardName;
    NamesMatch      = !(prdu_strcmp( (PBYTE) CurrentCardName,
                                     (PBYTE) DefaultCardName));

    switch (DefaultFontType)
    {
        case FT_RESIDENT:
            if ( (CurrentFontType == FT_RESIDENT )  &&
                 (CurrentIndex == DefaultIndex ) )
                RetVal = TRUE;
            break;
        case FT_CODE_PAGE:
            if ( (CurrentFontType == FT_CODE_PAGE ) &&
                 (CurrentIndex == DefaultIndex )    &&
                 (CurrentCodePage == DefaultCodePage) )
                RetVal = TRUE;
            break;
        default:
            break;

    }

    return(RetVal);
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_DisplayPontSzList                    PD00137      */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   HWND   hwnd;      The handle for the dialog window we are in     */
/*   USHORT WndId;     The window ID for the window to put the point  */
/*                     sizes in.                                      */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function sends messages to the window specified by WindId   */
/*   (a listbox) to insert all the defined pointsizes for the default */
/*   outline fonts                                                    */
/*                                                                    */
/**********************************************************************/
#if 0
void prdm_DisplayPointSzList( hwnd, WndId )

HWND       hwnd;
USHORT     WndId;
#endif

void prdm_DisplayPointSzList( HWND   hwnd,                 /* CON3201 */
                              USHORT WndId )               /* CON3201 */

{
#define TFUNC "prdm_DisplayPointSzLst"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    USHORT       i;           /* index for def font pointsize Table   */
    MRESULT      DlgResult;   /* The result of a Win.. call           */
    SHORT        SelectedIndex;/* index to selected point size        */
    lpDfltFontTable      DefaultFontTable;
    lpDfltFontList       DefaultFontList;


    /******************************************************************/
    /* Return if the pointsize list already displayed.                */
    /******************************************************************/
    /******************************************************************/
    /*  PD00334: fix for os/2 2.0. SHORT1FROMMR was missing. Can't    */
    /*           explain why it worked okay on 1.3                    */
    /******************************************************************/
    SelectedIndex = SHORT1FROMMR( WinSendDlgItemMsg( hwnd,
                                                     WndId,
                                                     LM_QUERYTOPINDEX,
                                                     FNULL,
                                                     FNULL) );
    if (SelectedIndex != LIT_NONE)
    {
       return;
    }

    /******************************************************************/
    /* First set up some pointers.                                    */
    /******************************************************************/
    DefaultFontList = &(DMData.DefaultFontList);
    DefaultFontTable = DefaultFontList->DefaultFontTable;

    /******************************************************************/
    /* Enable the listbox window.          removed on 07/24/91        */
    /******************************************************************/
    //  WinEnableWindow(WinWindowFromID(hwnd,WndId),TRUE);

    /******************************************************************/
    /* List all the point sizes in the pointsize listbox              */
    /******************************************************************/
    for ( i=0; *DfltFontPSzTable[i] != (CHAR)NULL; i++)
    {
        prdu_strcpy(szMessage,DfltFontPSzTable[i]);
        if (i)
        {
           /**************************************************************/
           /* Use decimal point from PMNational, not just a '.'          */
           /**************************************************************/
           szMessage[2] = (BYTE)DMData.DecimalPoint;

           /**************************************************************/
           /* Blank the first digit for single digit point sizes         */
           /**************************************************************/
           if (szMessage[0] == '0')
                szMessage[0] = ' ';

        }
        else
        {
           /**********************************************************/
           /* description string from the RC  file.                  */
           /**********************************************************/
           WinLoadString( hab,
                          DMData.HModule,
                          IDS_DFLT_PT_SIZE,
                          MAX_PRNTR_NAME,
                          (PSZ)szMessage );
        }
        DlgResult = WinSendDlgItemMsg( hwnd,
                                       WndId,
                                       LM_INSERTITEM,
                                       (MPARAM)(ULONG)LIT_END,
                                       MPFROMP(szMessage) );
    }

}
#undef TFUNC





/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_GetPointSzIndex                      PD00137      */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function figures out the index to the Default outline font  */
/*   pointsize table from the pointsize value passed to the routine   */
/*                                                                    */
/**********************************************************************/
#if 0
USHORT prdm_GetPointSzIndex(PointSize)

USHORT     PointSize;
#endif
USHORT prdm_GetPointSzIndex(USHORT PointSize)              /* CON3201 */

{
#define TFUNC "prdm_GetPointSzIndex"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    USHORT  PointSizeIndex;
    PCHAR   pPSzStr;
    USHORT  i;

    pPSzStr = szMessage;
    /******************************************************************/
    /* Convert pointsize to text                                      */
    /******************************************************************/
    prdm_WriteTextFromWord( PointSize,
                            NO_POINTSIZE_DIGITS,
                            pPSzStr);


    /******************************************************************/
    /* Get the index in the pointsize table from the pointsize value  */
    /******************************************************************/
    PointSizeIndex=0;
    for ( i=0; ((*DfltFontPSzTable[i] != (CHAR)NULL) &&
                                             (PointSizeIndex==0)); i++)
    {
       if (!prdu_strcmpN(DfltFontPSzTable[i],szMessage,NO_POINTSIZE_DIGITS))
          PointSizeIndex = i;
    }
    return(PointSizeIndex);
}
#undef TFUNC



/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_EnterFontPointSz                        PD00137   */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function queries the pointsize selection and figures out    */
/*   the pointsize value from the index when the user hits ENTER      */
/*   when exiting out of the default font dialog.                     */
/*                                                                    */
/**********************************************************************/
#if 0
USHORT prdm_EnterFontPointSz(hwnd,WindowID)

HWND       hwnd;
USHORT     WindowID;
#endif

USHORT prdm_EnterFontPointSz( HWND   hwnd,                 /* CON3201 */
                              USHORT WindowID )            /* CON3201 */

{
#define TFUNC "prdm_EnterFontPointSz"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    USHORT  SelectedPSIndex;
    USHORT  SelectedPointSize;
    PCHAR   PointSzPtr;

    /***************************************************/
    /* Check if a PointSize has been selected          */
    /***************************************************/
    SelectedPSIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                                      hwnd,
                                                      WindowID,
                                                      LM_QUERYSELECTION,
                                                      MPFROMSHORT(LIT_FIRST),
                                                      FNULL) );

    /***************************************************/
    /* If selected, convert to word from text          */
    /***************************************************/
     if (SelectedPSIndex)
     {
        PointSzPtr = DfltFontPSzTable[SelectedPSIndex];
        prdm_ReadWordFromText( SelectedPointSize,
                               NO_POINTSIZE_DIGITS,
                               PointSzPtr);
     }
     else
     {
        SelectedPointSize = 0;
     }

     return(SelectedPointSize);
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_DfltFontPSzControlProc                  PD00137   */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function queries the font selection and displays the        */
/*   the pointsizes if outline OR clears the pointsize listbox        */
/*   if the default font selected is not an outline font. Also        */
/*   each time a different outline font is selected, the default      */
/*   poitsize (12.0) is highlighted.                                  */
/*                                                                    */
/**********************************************************************/
#if 0
VOID prdm_DfltFontPSzControlProc(hwnd,WindowID)

HWND       hwnd;
USHORT     WindowID;
#endif

VOID prdm_DfltFontPSzControlProc( HWND   hwnd,             /* CON3201 */
                                  USHORT WindowID )        /* CON3201 */

{
#define TFUNC "prdm_DfltFontPSzControlProc"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    lpDfltFontTable      DefaultFontTable;
    lpDfltFontList       DefaultFontList;
    USHORT               SelectedIndex;
    lpDDTType     pDDT;        /* Pointer to DDT                      */
    MRESULT       DlgResult;   /* The result of a Win.. call          */

    /******************************************************************/
    /* First set up some pointers.                                    */
    /******************************************************************/
    DefaultFontList = &(DMData.DefaultFontList);
    DefaultFontTable = DefaultFontList->DefaultFontTable;
    /******************************************************************/
    /* Set up pointer to the DDT.                                     */
    /******************************************************************/
    pDDT = DDT[pDMSettings->PrinterType];

    SelectedIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                                    hwnd,
                                                    WindowID,
                                                    LM_QUERYSELECTION,
                                                    MPFROMSHORT(LIT_FIRST),
                                                    FNULL) );

    /***************************************************/
    /* Get pointsize window id                         */
    /***************************************************/
    if (WindowID == DB_LST_PP_DFLTFONTS)
       WindowID = DB_LST_PPPOINTSZ;
    else
       WindowID = DB_LST_JPPOINTSZ;

    /***************************************************/
    /* If selected font is not system font and not     */
    /* bitmap font, display the pointsize list         */
    /***************************************************/

    /************************************************************/
    /* PD00341  Pointsize selection for card fonts              */
    /************************************************************/
    if ((SelectedIndex != 0) &&
         ((DefaultFontTable[SelectedIndex].FontDescription.FontType ==
          FT_RESIDENT) ||
            (DefaultFontTable[SelectedIndex].FontDescription.FontType ==
              FT_CARD)) &&
         ( !(DefaultFontTable[SelectedIndex].FontMatch.PointSize) ))
    {
       prdm_DisplayPointSzList( hwnd, WindowID);
       /**********************************************************/
       /* Select the "default" pointsize  in the listbox.        */
       /**********************************************************/
       DlgResult = WinSendDlgItemMsg(
                      hwnd,
                      WindowID,
                      LM_SELECTITEM,
                      (MPARAM)(ULONG)prdm_GetPointSzIndex(pDDT->DDTDefFontPSz),
                      (MPARAM)(ULONG)TRUE );
    }
    else
    {
      /***************************************************/
      /* If selected font is system font or bitmap font  */
      /* delete the items in pointsize listbox.          */
      /***************************************************/
       DlgResult = WinSendDlgItemMsg( hwnd,
                                      WindowID,
                                      LM_DELETEALL,
                                      FNULL,
                                      FNULL );
      /***************************************************/
      /* Disable the listbox window.  removed on 07/24/91*/
      /***************************************************/
      /*  WinEnableWindow(WinWindowFromID(hwnd,WindowID),FALSE); */
    }
}
#undef TFUNC
