/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDLSETO
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdl_SetLineOrigin
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32               /* CON3201 */
#define INCL_DOSPROCESS       /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS        /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS

#define INCL_DDIMISC
#define INCL_DDICOMFLAGS
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIMISC
#undef INCL_DDICOMFLAGS
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                /* CON3201 */

#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL

#include <prdlcone.h>

#include <prdltypt.h>

#include <prdlextf.h>

extern USHORT      LineTypeTable [];
extern DLINEBUNDLE prda_DefLinAts;

/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdl_SetLineOrigin                                     */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*                                                                    */
/*   hanDC          DcH;                                              */
/*   PPOINTL        CurrPos;                                          */
/*   ULONG          Style;                                            */
/*   lpDCI          DCIData;                                          */
/*   ULONG          FunN;                                             */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   Sets the current style state in the DC Instance data. Also sets  */
/*   the current position to CurrPos.  The style state is a word in   */
/*   the DC Instance data, the low byte is the style mask and the     */
/*   high byte is the style error value.                              */
/*                                                                    */
/**********************************************************************/
ULONG prdl_SetLineOrigin ( hanDC      DcH,
                           PPOINTL    CurrPos,
                           ULONG      Style,
                           lpDCI      DCIData,
                           ULONG      FunN)

{
#define TFUNC "prdl_SetLineOrigin"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    BYTE        StyleMask;              /* The style mask             */
    ULONG       Result;

    prdm_EnterDriver(DCIData);

    /******************************************************************/
    /* Trace the parameters.                                          */
    /******************************************************************/
    TRACE8(TFUNC, "FunN", &(FunN), 1);
    TRACE8(TFUNC, "DcH", &(DcH), 1);
    TRACE8(TFUNC, "Style", &Style, 1);
    TRACE8(TFUNC, "CurrPos", &CurrPos, 1);
    TRACE8(TFUNC, "DCIData address", &DCIData, 1);

    /******************************************************************/
    /* Get the current line style pattern byte.  If the current line  */
    /* type is invalid then use the default line style pattern.       */
    /******************************************************************/
    if ((DCIData->DCICurLinAts->lbnd.usType == 0) ||
        (DCIData->DCICurLinAts->lbnd.usType >= NUMBER_LINETYPES))
    {
        StyleMask = (BYTE)LineTypeTable [prda_DefLinAts.lbnd.usType];
    }
    else
    {
        StyleMask =
               (BYTE)LineTypeTable [DCIData->DCICurLinAts->lbnd.usType];
    }

    /******************************************************************/
    /* Set the field in the DC Instance data to the new value         */
    /******************************************************************/
    DCIData->StyleNumber = (Style & 0xffffff00) | StyleMask;
    TRACE4(TFUNC,"new style numbers",&DCIData->StyleNumber,1);

    /******************************************************************/
    /* Set the current position (ensuring that this call is not       */
    /* redispatched to the engine). ???                               */
    /******************************************************************/
 /* HIUSHORT(FunN) &= ~(COM_PATH | COM_AREA);                         */
/*  ((PUSHORT)(&FunN))[1] &= ~(COM_PATH | COM_AREA);          CON3201 */
    FunN &= ~(COM_PATH | COM_AREA);                        /* CON3201 */

    Result = prdl_SetCurrentPosition ( (HDC)DcH,
                                       CurrPos,
                                       DCIData,
                                       FunN );


    prdm_LeaveDriver(DCIData);
    return(Result);

} /* prdl_SetLineOrigin */
#undef TFUNC


