/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDLSETC
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdl_SetCurrentPosition
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS

#define INCL_DDIMISC
#define INCL_DDICOMFLAGS
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIMISC
#undef INCL_DDICOMFLAGS
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL

#include <prdconse.h>
#include <prddcone.h>

#include <prdltypt.h>

#include <prdgextf.h>
#include <prdlextf.h>
#include <prdyextf.h>

extern PFNL da_SetCurrentPosition;
extern BYTE LineTypeTable [];

/******************************************************************************/
/*                                                                            */
/*   FUNCTION: prdl_SetCurrentPosition                                        */
/*                                                                            */
/*   PARAMETERS:                                                              */
/*                                                                            */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers"         */
/*                                                                            */
/*   HDC           DcH;                                                       */
/*   PPOINTL       ArgNewXY;                                                  */
/*   lpDCI         DCIData;                                                   */
/*   ULONG         FunN;                                                      */
/*                                                                            */
/*   DESCRIPTION:                                                             */
/*                                                                            */
/*   Sets the current position to ArgNewXY, resets the line type              */
/*   mask and initailises the style number.  If COM_TRANSFORM is set          */
/*   then ArgNewXY are taken as world coordinates and converted to            */
/*   device coordinates.  If not ArgNewXY are taken as device                 */
/*   coordinates and converted to world coordinates.                          */
/*                                                                            */
/******************************************************************************/
#if 0
ULONG EXPENTRY prdl_SetCurrentPosition ( DcH,
                                         ArgNewXY,
                                         DCIData,
                                         FunN )

HDC           DcH;
PPOINTL       ArgNewXY;
lpDCI         DCIData;
ULONG         FunN;
#endif

ULONG EXPENTRY prdl_SetCurrentPosition ( HDC     DcH,              /* CON3201 */
                                         PPOINTL ArgNewXY,         /* CON3201 */
                                         lpDCI   DCIData,          /* CON3201 */
                                         ULONG   FunN )            /* CON3201 */

{
#define TFUNC "prdl_SetCurrPos"

    /**************************************************************************/
    /* Local variables                                                        */
    /**************************************************************************/
    ULONG               Command;        /* Command bits                */

    /**************************************************************************/
    /* Do entry processing                                                    */
    /**************************************************************************/
#ifdef PRD_TIMING
    DEKHOOK0(A,8,12)
#endif
    prdm_EnterDriver(DCIData);
/*  Command = HIUSHORT(FunN);                                        CON3201 */
    Command = FunN & 0xFFFF0000;

    /**************************************************************************/
    /* Reset Line Type mask                                                   */
    /**************************************************************************/
    DCIData->DCILineTypMask = 0x8000;

    /**************************************************************************/
    /* Set bit 0 of the top word of the style number to indicate that first   */
    /* pel is drawn on a drawing command in apath or area                     */
    /**************************************************************************/
    DCIData->StyleNumber |= 0x0001FF00;

    if ( Command & COM_TRANSFORM )
    {
        /**********************************************************************/
        /* Set current position indicated by ArgNewXY.                        */
        /**********************************************************************/
     /* DCIData->DCICurrPosWcs = *((WcsPoint far *)ArgNewXY); */
        DCIData->DCICurrPosWcs = *((WcsPoint *)ArgNewXY);          /* CON3201 */

        /**********************************************************************/
        /* Convert world coordinates to device coordinates                    */
        /**********************************************************************/
        /**********************************************************************/
        /* PD00525 : Check size of world coordinates to make sure they will   */
        /* fit in a Short (16 bits) variable before converting to device      */
        /* coordinates.                                                       */
        /* PD00701 : Remove check on world coordinates since they can be      */
        /* larger than 32K. Removed both if stmt and else stmt.               */
        /**********************************************************************/
#if 0
// ***  if ( ( labs(ArgNewXY->x) <= 32767 ) && ( labs(ArgNewXY->y) <= 32767 ) )
// ***  {
#endif
            /******************************************************************/
            /* Only convert current position when point is a valid short size */
            /* number.                                                        */
            /******************************************************************/
            if ( prdg_Convert (
                      (PULONG)&(DCIData->DCICurrPosWcs),
                      (PULONG)&(DCIData->DCICurrPosDev),
                      COORD_WORLD, COORD_DEVICE_WORD, 1L,
                      (hanDC)DcH, Command ) != OK )
            {
                prdm_LeaveDriver(DCIData);
#ifdef PRD_TIMING
    DEKHOOK0(A,8,92)
#endif
                return (ERROR_ZERO);
            }
        /**********************************************************************/
        /* PD00701 : Remove else leg since world coords can be > 32K.         */
        /**********************************************************************/
#if 0
// ***  }
// ***  else                                /* PD00589  coords too large      */
// ***  {
#endif
            /******************************************************************/
            /* PD00589 : Log error when coordinate exceeds 32767              */
            /******************************************************************/
#if 0
// ***      LOGERR(TFUNC, "Coord Overflow", &ArgNewXY, 1,
// ***                                        PMERR_COORDINATE_OVERFLOW);
// ***      prdm_LeaveDriver(DCIData);
// ***      return((ULONG)ERROR_ZERO);
// ***  }
#endif
    }
    else
    {
        /**********************************************************************/
        /* Set current position indicated by ArgNewXY.                        */
        /**********************************************************************/

        /**********************************************************************/
        /* PD00525 : Check size of coordinates before converting to short type*/
        /**********************************************************************/
        /* PD00767 : Correct check to allow -32768                            */
        /**********************************************************************/
        if ( ( ArgNewXY->x <= 32767 ) && ( ArgNewXY->x >= -32768 ) &&
             ( ArgNewXY->y <= 32767 ) && ( ArgNewXY->y >= -32768 )   )
        {
            /******************************************************************/
            /* Only update current position when point is a valid short size  */
            /* number.                                                        */
            /******************************************************************/
            DCIData->DCICurrPosDev.X = (SHORT)ArgNewXY->x;
            DCIData->DCICurrPosDev.Y = (SHORT)ArgNewXY->y;
        }
        else
        {
            /******************************************************************/
            /* PD00589 : Log error when coordinate exceeds 32767              */
            /* PD00767 : or less than -32768                                  */
            /******************************************************************/
            LOGERR(TFUNC, "Coord Overflow", &ArgNewXY, 1,
                                                    PMERR_COORDINATE_OVERFLOW);
            prdm_LeaveDriver(DCIData);
            return((ULONG)ERROR_ZERO);
        }


        /**********************************************************************/
        /* Convert device coordinates to world coordinates                    */
        /**********************************************************************/
        /**********************************************************************/
        /* Cannot use g_Convert, as this does no conversion unless the        */
        /* COM_TRANSFORM bit is set.  Best to do it explicitly.  Temp tweek:  */
        /* set the flag.                                                      */
        /**********************************************************************/
        if ( prdg_Convert (
                  (PULONG)&(DCIData->DCICurrPosDev),
                  (PULONG)&(DCIData->DCICurrPosWcs),
                  COORD_DEVICE_WORD, COORD_WORLD, 1L,
                  (hanDC)DcH, Command | COM_TRANSFORM ) != OK )
        {
            prdm_LeaveDriver(DCIData);
#ifdef PRD_TIMING
    DEKHOOK0(A,8,92)
#endif
            return (ERROR_ZERO);
        }
    }

    /**************************************************************************/
    /* Current position in font coords is set and used only by                */
    /* prdt_TextOutDevFont.                                                   */
    /**************************************************************************/
    DCIData->DCIStateFlags &= ~FONT_COORDS_VALID;

    /**************************************************************************/
    /* If an implicit close of a path then pass on to the default engine      */
    /* handler.                                                               */
    /**************************************************************************/
    prdm_LeaveDriver(DCIData);

#ifdef PRD_TIMING
    DEKHOOK0(A,8,92)
#endif

    if ( Command & (COM_PATH | COM_AREA) )
        return (da_SetCurrentPosition(DcH, ArgNewXY, DCIData, FunN));
    else
        return (OK);
}
#undef TFUNC

