/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDLGRAT
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdl_GetStyleRatio
 *             prdl_SetStyleRatio
 *             prdl_GetDCOrigin
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                   /* CON3201 */
#define INCL_DOSPROCESS           /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS            /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS

#define INCL_DDIMISC
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDICOMFLAGS
#include <pmddi.h>
#undef INCL_DDIMISC
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDICOMFLAGS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                    /* CON3201 */


#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL

#include <prdltypt.h>
#include <prdlextf.h>




/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdl_GetStyleRatio                                     */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*                                                                    */
/*   hanDC      DcH;                                                  */
/*   lpDCI      DCIData;                                              */
/*   ULONG      FunN;                                                 */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   Returns the style ratio from the DCI via lpRatio.  This          */
/*   function is only relevant for brute force printers - i.e. not    */
/*   us.                                                              */
/*                                                                    */
/**********************************************************************/
ULONG prdl_GetStyleRatio (hanDC     DcH,
                          PUSHORT   lpRatio,
                          lpDCI     DCIData,
                          ULONG     FunN )


{
    prdm_EnterDriver(DCIData);
    *lpRatio = DCIData->DCIStyleRatio;
    prdm_LeaveDriver(DCIData);

    return (OK);
}




/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdl_SetStyleRatio                                     */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*                                                                    */
/*   hanDC      DcH;                                                  */
/*   PUSHORT    lpRatio;                                              */
/*   lpDCI      DCIData;                                              */
/*   ULONG      FunN;                                                 */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   Stores the style ratio in the DCI Data.  This                    */
/*   function is only relevant for brute force printers - i.e. not    */
/*   us.                                                              */
/*                                                                    */
/**********************************************************************/
ULONG prdl_SetStyleRatio (hanDC     DcH,
                          PULONG    lpRatio,
                          lpDCI     DCIData,
                          ULONG     FunN)



{
    prdm_EnterDriver(DCIData);
    DCIData->DCIStyleRatio = (USHORT)(*lpRatio);
    prdm_LeaveDriver(DCIData);

    return(OK);
}




/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdl_GetDCOrigin                                       */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*   hanDC      DcH;                                                  */
/*   PULONG     DCOrigin;                                             */
/*   lpDCI      DCIData;                                              */
/*   ULONG      FunN;                                                 */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
ULONG prdl_GetDCOrigin(hanDC   DcH,
                       PULONG  DCOrigin,
                       lpDCI   DCIData,
                       ULONG   FunN)


{
    prdm_EnterDriver(DCIData);

    DCOrigin[0] = (ULONG)DCIData->DCIOrigin.X;
    DCOrigin[1] = (ULONG)DCIData->DCIOrigin.Y;

    prdm_LeaveDriver(DCIData);
    return(OK);
}

