/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDJQSTD
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdn_CreateSTDSpoolFile
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_DOSFILEMGR
#define INCL_SPL
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_DOSFILEMGR
#undef INCL_SPL
#undef INCL_GPIERRORS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_GRE_JOURNALING
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_GRE_JOURNALING

#define INCL_WINP_SELSERVER
#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELSERVER
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef PRDMTYPE_INCL

#include <prdjextf.h>
#include <prdyextf.h>

#include <prdconse.h>
#include <prdncone.h>
#include <prdbsize.h>




/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdn_CreateSTDSpoolFile                                */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   lpDCI DCIData;    Pointer to DC Instance data                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function closes the metafile associated with the current    */
/*   DC and writes its contents to a standard (STD) spool file.  It   */
/*   then deletes the metafile and issues an EndDoc call on the spool */
/*   file.                                                            */
/*                                                                    */
/**********************************************************************/
#if 0
USHORT pascal prdn_CreateSTDSpoolFile ( DCIData )

lpDCI DCIData;
#endif

SHORT prdn_CreateSTDSpoolFile ( lpDCI DCIData )            /* CON3201 */

{
#define TFUNC "CreSTDSplF"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    LONG   TotalLength;               /* Total length of metafile    */
    ULONG   BytesWritten;              /* Bytes put in the STD spool  */
                                       /* file                        */
    ULONG   BytesToRead;               /* The number of bytes to be   */
                                       /* transferred from the        */
                                       /* metafile to the spool file  */
                                       /* (must be < 65536)           */
    ULONG   Offset;                    /* Current offset into the     */
                                       /* metafile                    */
    ULONG   StdHandle;                 /* Handle to the metafile      */
    PBYTE   Data;                      /* The buffer used for passing */
                                       /* data between the metafile   */
                                       /* and the spool file          */
    ULONG  Result;                     /* Result of SplQmWrite        */
    USHORT  BufferLength;              /* size of buffer allocated    */

    /******************************************************************/
    /* First close the metafile and return an error if this fails.    */
    /******************************************************************/
    if ( !(StdHandle = (ULONG)SplStdStop ( (HDC)DCIData->DcH )) )
    {
        TRACE4(TFUNC, "Stop metafile failed", FNULL, 0);
        return( ERROR );
    }

    /******************************************************************/
    /* Get the total length of the data in the metafile and return an */
    /* error if this fails.                                           */
    /******************************************************************/
    if ( (TotalLength = SplStdQueryLength( (HSTD)StdHandle ))
                                                          == SPL_ERROR )
                                           /* CON3201     == ERROR_NEG ) */
    {
        TRACE4(TFUNC, "Metafile query failed", FNULL, 0);
        return( ERROR );
    }

    /******************************************************************/
    /* Allocate a buffer for the data being read from the metafile    */
    /******************************************************************/
    if (TotalLength > 0xffffL)
        BufferLength = 0xffff;
    else
        BufferLength = (USHORT)TotalLength;

 /* if ( (Result = SSALLOCSEG (BufferLength,&SELECTOROF(Data), 0)) ) */
    if ( (Result = SafeSSALLOCMEM (&Data, BufferLength, 0)) )   /* CON3201 */
    {
     /* LOGDOSERR(TFUNC, "SSALLOCSEG Error",&Result, 1, Result); */
        LOGDOSERR(TFUNC, "SSALLOCMEM Error",&Result, 1, Result); /*CON3201*/
        return( ERROR );
    }
/*  OFFSETOF(Data) = 0;                                           CON3201 */

    /******************************************************************/
    /* Initialise loop variables and keep reading from metafile and   */
    /* writing to spool file until all data processed.                */
    /******************************************************************/
    Offset = 0;
    BytesWritten = 0;
    do
    {
        if ((TotalLength - BytesWritten) >= BufferLength)
        {
            /**********************************************************/
            /* There are more bytes left than will fit in the buffer  */
            /* so set BytesToRead to BUFFER_LENGTH.                   */
            /**********************************************************/
            BytesToRead = BufferLength;
        }
        else
        {
            /**********************************************************/
            /* Otherwise we can process the final block of data.      */
            /**********************************************************/
            BytesToRead = TotalLength - BytesWritten;
        }

        /**************************************************************/
        /* Copy the data from the metafile to our data buffer and     */
        /* return an error if this fails.                             */
        /**************************************************************/
        if ( SplStdGetBits ((HSTD)StdHandle,
                              Offset,
                              BytesToRead,
                              (PBYTE)Data) != OK)
        {
            TRACE4(TFUNC, "SplStdGetBits failed", FNULL, 0);
         /* SSFREESEG(SELECTOROF(Data)); */
            SSFREEMEM(Data);                               /* CON3201 */
            return( ERROR );
        }

        /**************************************************************/
        /* Write the data from our data buffer to the spool file      */
        /* specified in the DC Instance data and return an error if   */
        /* this fails.                                                */
        /**************************************************************/
        if ( SplQmWrite ((HSPL)DCIData->DCISplHandle,
                         (ULONG) BytesToRead,
                         (PBYTE) Data) != OK )
        {
            TRACE4(TFUNC, "Spool write failed", &Result, 1);
         /* SSFREESEG(SELECTOROF(Data)); */
            SSFREEMEM(Data);                               /* CON3201 */
            return( ERROR );
        }

        /**************************************************************/
        /* Update the variables for keeping track of our progress     */
        /* through the metafile.                                      */
        /**************************************************************/
        BytesWritten += BytesToRead;
        Offset += BytesToRead;

    } while ((TotalLength - BytesWritten) > 0);

    /******************************************************************/
    /* We have finished with the metafile so delete it.               */
    /******************************************************************/
    if ( SplStdDelete ((HSTD)StdHandle) != OK )
    {
        TRACE4(TFUNC, "SplStdDelete failed", FNULL, 0);
     /* SSFREESEG(SELECTOROF(Data)); */
        SSFREEMEM(Data);                                   /* CON3201 */
        return( ERROR );
    }

 /* SSFREESEG(SELECTOROF(Data)); */
    SSFREEMEM(Data);                                       /* CON3201 */

    return( OK );
}

#undef TFUNC


