/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDGXFRM
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdg_GetXformMatrix
 *             prdg_ScaleValue
 *             prdg_XformPoint
 *             prdg_ScaleUpPoint
 *             prdg_MatrixScaleDifferent
 *             prdg_PointToAngle
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS

#define INCL_DDICOMFLAGS
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDIMISC
#define INCL_GRE_XFORMS
#include <pmddi.h>
#undef INCL_DDICOMFLAGS
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDIMISC
#undef INCL_GRE_XFORMS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>
#include <prdtcone.h>
#include <prdinclt.h>
#include <prdbtyp1.h>
#include <prdbextf.h>
#include <prdcextf.h>
#include <prdgextf.h>
#include <prdiextf.h>
#include <prdtextf.h>
#include <prduextf.h>
/******************************************************************************/
/*  Set up access to engine convert function                                  */
/******************************************************************************/
extern PFNL  da_Convert;
extern PFNL  da_ConvertWithMatrix;

extern long int _Optlink labs( long int );    /*****CON32O2*******/

/******************************************************************************/
/*  FUNCTION: prdg_GetXformMatrix                                             */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*  HDC     DcH;                                                              */
/*  USHORT  fsXform;  Handling flags                                          */
/*  PXFORM  pxfm;     Xform matrix buffer                                     */
/*  lpDCI   DCIData;                                                          */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function gets a transform matrix depending on the given handling     */
/*  flags.  The conversion can be either Font <-> World or Device <-> World or*/
/*  Device <-> Font; it can include or exclude the origin shift.              */
/*                                                                            */
/*  The 6 matrix elements comprise a transform of the form:                   */
/*                                                                            */
/*       ( x')     (M11  M21)   ( x )     ( M41 )                             */
/*       (   )  =  (        ) * (   )  +  (     )                             */
/*       ( y')     (M12  M22)   ( y )     ( M42 )                             */
/*                                                                            */
/*  NOTE:                                                                     */
/*                                                                            */
/*  Present method uses GreConvert to calculate the matrix elements           */
/*  indirectly.  It may be possible to pick them up directly using Gre calls -*/
/*  but this does not seem to work, with unit matrices always being returned. */
/*  The returned matrix is not always exactly what it should be (eg.  M11 !=  */
/*  14.4 for 100dpi->TWIPS) - there is nothing we can do about this.          */
/*                                                                            */
/*  ASSUMPTION:                                                               */
/*                                                                            */
/*  In all the conversions used in the text handling code there is an         */
/*  assumption that the Device -> World (and hence the Font -> World)         */
/*  transformation is orthagonal - i.e.  the x and y parts are independant of */
/*  each other.  In other words there is no shear or rotation in the transform*/
/*  - to be precise M12 and M21 in the tranform matrix are 0.                 */
/*                                                                            */
/*  If this is not true then (for example) a character string drawn with      */
/*  position vectors, intended to specify the spacing between characters and  */
/*  given in world coords, could be drawn at different y coords.  Also the    */
/*  text box returned in QueryTextBox could be a trapezoid rather than a      */
/*  "straight" rectangle.                                                     */
/*                                                                            */
/*  The function prdg_XformPoint below should be used to transform lengths as */
/*  it works with non-orthogonal transforms.                                  */
/******************************************************************************/
#if 0
USHORT PASCAL prdg_GetXformMatrix(DcH, fsXform, pxfm, DCIData)

HDC     DcH;
USHORT  fsXform;
PXFORM  pxfm;
lpDCI   DCIData;
#endif

USHORT prdg_GetXformMatrix( HDC     DcH,                           /* CON3201 */
                            USHORT  fsXform,                       /* CON3201 */
                            PXFORM  pxfm,                          /* CON3201 */
                            lpDCI   DCIData )                      /* CON3201 */

{

    /**************************************************************************/
    /*  Local Variables.                                                      */
    /**************************************************************************/
    USHORT        usSrcCoords;
    USHORT        usTrgCoords;
    POINTL        Point[3];
    ULONG         M11, M12, M21, M22;
    LONG          M41, M42;
    lpResAdjType  pResAdj;

    /**************************************************************************/
    /*  Matrix is based on the Point array.                                   */
    /**************************************************************************/
    Point[0].x = 0L;
    Point[0].y = 0L;
    Point[1].x = 0x10000;
    Point[1].y = 0L;
    Point[2].x = 0L;
    Point[2].y = 0x10000;

    /**************************************************************************/
    /*  If converting to or from WORLD we need to call the engine convertion  */
    /*  routine so that we can calculate the required matrix.                 */
    /**************************************************************************/
    if (fsXform & (FONT_TO_WORLD | DEVICE_TO_WORLD | WORLD_TO_FONT |
                   WORLD_TO_DEVICE))
    {
        if (fsXform & (FONT_TO_WORLD | DEVICE_TO_WORLD))
        {
            usSrcCoords = COORD_DEVICE;/* note ULONGs here...                 */
            usTrgCoords = COORD_WORLD;
        }
        else
        {
            usSrcCoords = COORD_WORLD; /* ditto...                            */
            usTrgCoords = COORD_DEVICE;
        }
        if (!da_Convert(DcH, (LONG)usSrcCoords, (LONG)usTrgCoords,
                        (PPOINTL)Point, 3L, 0L, NGreConvert))
            return(ERROR_ZERO);
    }

    /**************************************************************************/
    /*  Set up matrix values (defaults to no origin shift) ...                */
    /**************************************************************************/
    if (fsXform & IGNORE_ORIGIN_SHIFT)
    {
        M41 = 0L;
        M42 = 0L;
    }
    else
    {
        M41 = Point[0].x;
        M42 = Point[0].y;
    }

    /**************************************************************************/
    /*  PD00081 : updated fix: elements M12 & M21 were reversed.              */
    /**************************************************************************/
    M11 = Point[1].x - Point[0].x;
    M21 = Point[2].x - Point[0].x;
    M12 = Point[1].y - Point[0].y;
    M22 = Point[2].y - Point[0].y;

    /**************************************************************************/
    /*  Ignore shear - ie force matrix diagonal (not used).                   */
    /**************************************************************************/
    if (fsXform & IGNORE_SHEAR)
    {
        M12 = 0;
        M21 = 0;
    }

    /**************************************************************************/
    /*  PD00081 : If there are off-diagonal terms, and the DIAGONALIZE flag is*/
    /*  set, then diagonalize the matrix - 4019 outline fonts only.           */
    /**************************************************************************/
    if ( (fsXform & DIAGONALIZE) && (M12 || M21) )
    {

        /**********************************************************************/
        /*  Get the square root of M11*M22-M12*M21 Place this into M11 & M22  */
        /*  to diagonalize M.                                                 */
        /**********************************************************************/
        M11 = far_get_sqr_determinant( M11, M12, M21, M22);
        M22 = M11;
        M12 = 0;
        M21 = 0;
    }

    /**************************************************************************/
    /*  ...  and now adjust to allow for scaling from Font <-> Device.  Note  */
    /*  M11, M21 and M41 scale with x, M12, M22 and M42 with y.               */
    /**************************************************************************/
    pResAdj = &DCIData->DCIFontData.ResAdj;
    if (fsXform & (FONT_TO_WORLD | FONT_TO_DEVICE))
    {
        M11 = prdg_ScaleValue(M11, (LONG)pResAdj->DeviceResX,
                              (LONG)pResAdj->FontResX);
        M12 = prdg_ScaleValue(M12, (LONG)pResAdj->DeviceResY,
                              (LONG)pResAdj->FontResY);
        M21 = prdg_ScaleValue(M21, (LONG)pResAdj->DeviceResX,
                              (LONG)pResAdj->FontResX);
        M22 = prdg_ScaleValue(M22, (LONG)pResAdj->DeviceResY,
                              (LONG)pResAdj->FontResY);
        M41 = prdg_ScaleValue(M41, (LONG)pResAdj->DeviceResX,
                              (LONG)pResAdj->FontResX);
        M42 = prdg_ScaleValue(M42, (LONG)pResAdj->DeviceResY,
                              (LONG)pResAdj->FontResY);
    }
    else if (fsXform & (WORLD_TO_FONT | DEVICE_TO_FONT))
    {
        M11 = prdg_ScaleValue(M11, (LONG)pResAdj->FontResX,
                              (LONG)pResAdj->DeviceResX);
        M12 = prdg_ScaleValue(M12, (LONG)pResAdj->FontResY,
                              (LONG)pResAdj->DeviceResY);
        M21 = prdg_ScaleValue(M21, (LONG)pResAdj->FontResX,
                              (LONG)pResAdj->DeviceResX);
        M22 = prdg_ScaleValue(M22, (LONG)pResAdj->FontResY,
                              (LONG)pResAdj->DeviceResY);
        M41 = prdg_ScaleValue(M41, (LONG)pResAdj->FontResX,
                              (LONG)pResAdj->DeviceResX);
        M42 = prdg_ScaleValue(M42, (LONG)pResAdj->FontResY,
                              (LONG)pResAdj->DeviceResY);
    }

    /**************************************************************************/
    /*  OK store the values and go home.                                      */
    /**************************************************************************/
    pxfm->fxM11 = (FIXED)M11;
    pxfm->fxM12 = (FIXED)M12;
    pxfm->fxM21 = (FIXED)M21;
    pxfm->fxM22 = (FIXED)M22;
    pxfm->lM41  = M41;
    pxfm->lM42  = M42;
    return(OK);
}


/******************************************************************************/
/*  FUNCTION: prdg_ScaleValue                                                 */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*   LONG  Value                                                              */
/*   LONG  Multiplier                                                         */
/*   LONG  Divisor                                                            */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/* Tweaked for better accuracy.  Old version would not do 0x12345678 *        */
/* 0x00000678 / 0x00012000 very accurately, as if full 64 bit multiplication  */
/* was done the divisor would be shifted to become 1!                         */
/*                                                                            */
/* New version shifts divisor by minimum required to become a USHORT eg 0x1200*/
/* in the above example.  The result is then shifted to give the final answer.*/
/*                                                                            */
/* Examples (all in hex)                                                      */
/* 123 * 567 / 2           = 3120b                                            */
/* 8888 * fe03 / 1f000     = 45ec                                             */
/* 60001234 * 37 / 5e0123  = 382b                                             */
/* 77773333 * 11110234 / 12378901 =  6feefff1 (6febb620 is full 32bit         */
/*                                   accuracy                                 */
/******************************************************************************/
#if 0
LONG PASCAL prdg_ScaleValue( lValue,
                             lMultiplier,
                             lDivisor )

LONG       lValue;
LONG       lMultiplier;
LONG       lDivisor;
#endif

LONG prdg_ScaleValue( LONG lValue,                                 /* CON3201 */
                      LONG lMultiplier,                            /* CON3201 */
                      LONG lDivisor )                              /* CON3201 */

{
    /**************************************************************************/
    /* Local variables                                                        */
    /**************************************************************************/
    ULONG        ulLoLo, ulLoHi, ulHiLo, ulHiHi;
    SHORT        i, shift;
    USHORT       usRem, pos;
    USHORT       uslo, temp;
    USHORT       usAnswer[4], usProduct[4];
    ULONG        ulNext;
    ULONG        ulWorkLong;
    ULONG        ulRetLong;
    BOOL         roundup;

    /**************************************************************************/
    /* Get absolute values of parameters.                                     */
    /**************************************************************************/
    ULONG        ulValue =       (ULONG)abs(lValue);
    ULONG        ulMultiplier  = (ULONG)abs(lMultiplier);
    ULONG        ulDivisor =     (ULONG)abs(lDivisor);

    /**************************************************************************/
    /* Work out the cross products of the two LONGs.                          */
    /**************************************************************************/
    ulLoLo = ( ulValue & 0xffff ) * ( ulMultiplier & 0xffff );
    ulHiHi = ( ulValue >> 16 )    * ( ulMultiplier >> 16 );
    ulLoHi = ( ulValue >> 16 )    * ( ulMultiplier & 0xffff );
    ulHiLo = ( ulValue & 0xffff ) * ( ulMultiplier >> 16 );

    /**************************************************************************/
    /* Work out the total 64-bit product.                                     */
    /**************************************************************************/

    /**************************************************************************/
    /* The lowest USHORT                                                      */
    /**************************************************************************/
    usProduct[0] = (USHORT)(ulLoLo & 0xffff);

    /**************************************************************************/
    /* The next USHORT and carry to the third.                                */
    /**************************************************************************/
    ulNext = (ulLoLo >> 16) + (ulHiLo & 0xffff) + (ulLoHi & 0xffff);
    usProduct[1] = (USHORT)(ulNext & 0xffff);

    /**************************************************************************/
    /* The third USHORT, and carry to the fourth                              */
    /**************************************************************************/
    ulNext = (ulNext >> 16) + (ulHiLo >> 16) +
           (ulLoHi >> 16) + (ulHiHi & 0xffff);
    usProduct[2] = (USHORT)(ulNext & 0xffff);

    /**************************************************************************/
    /* The 4th (high) USHORT.                                                 */
    /**************************************************************************/
    usProduct[3] = (USHORT)((ulNext >> 16) + (ulHiHi >> 16));


    if ( !usProduct[2] && !usProduct[3] )
    {
        /**********************************************************************/
        /* Product fits into a ULONG, use old method                          */
        /**********************************************************************/
        ulWorkLong = (ulValue * ulMultiplier);
        ulRetLong  = ulWorkLong / ulDivisor;

        /**********************************************************************/
        /* PD00593 : Changed comparsion from >= to > to prevent rounding up   */
        /* of the fraction 0.50.                                              */
        /**********************************************************************/
        if ( (2 * (ulWorkLong % ulDivisor)) > ulDivisor )
            ulRetLong++;

    }
    else
    {
        /**********************************************************************/
        /* Assumption:                                                        */
        /*                                                                    */
        /* The divisor is always either of for XXXX0000 or 0000XXXX.          */
        /*                                                                    */
        /* Not good!                                                          */
        /*                                                                    */
        /* New method: shift until divisor > 0x10000                          */
        /* Other cases are not properly handled (too complicated).            */
        /**********************************************************************/
        shift = 0;
        while (ulDivisor > 0x10000)
        {
            ulDivisor = (ulDivisor >> 1);
            shift++;
        }

        /**********************************************************************/
        /* Do the long division.  Remember this from school?  ???Only go down */
        /* to usAnswer[1] if the result is shifted.                           */
        /**********************************************************************/

        usRem = 0;        /* remainder */
        for ( i = 3; i >= (SHORT)0; i-- )
        {
           ulNext = ((ULONG)usRem << 16) + (ULONG)usProduct[i];
           usAnswer[i] = (USHORT)(ulNext / ulDivisor);   /* result    */
           usRem = (USHORT)(ulNext % ulDivisor);         /* remainder */
        }

        /**********************************************************************/
        /* Rounding is easy: we have the remainder!                           */
        /* Round up if the remainder > half the divisor.                      */
        /* Only if no shifting required.                                      */
        /**********************************************************************/
        roundup = FALSE;

        if (!shift && (usRem > (USHORT)(ulDivisor/2)) )
        {
            roundup = TRUE;
        }
        else if (shift)
        {
            /******************************************************************/
            /* Shift the result down.                                         */
            /******************************************************************/
            uslo = 0;
            for (i = 3; i >=0  ; i-- )
            {
                temp = usAnswer[i];
                usAnswer[i] = (usAnswer[i] >> shift) | uslo;
                uslo = temp << (16 - shift);
            }
            if (uslo & 0x8000)
            {
                /**************************************************************/
                /* round up                                                   */
                /**************************************************************/
                roundup = TRUE;
            }
        }
        if (roundup)
        {
            for ( i = 0; i < 4; i++ )
            {
                if ( (++usAnswer[i]) )
                {
                    /**********************************************************/
                    /* Finished propagating carry.                            */
                    /**********************************************************/
                    break;
                }
                /**************************************************************/
                /* usAnswer[i] has overflowed to zero - repeat for next i.    */
                /**************************************************************/
            }
        }

        /**********************************************************************/
        /* Note: assumes no overflow.                                         */
        /**********************************************************************/
        ulRetLong = *( (PULONG)usAnswer );
    }

    /**************************************************************************/
    /* Now correct the sign.                                                  */
    /*                                                                        */
    /* Note that this assumes that usRetLong < 0x80000000, else returned sign */
    /* will be wrong.                                                         */
    /**************************************************************************/
    if ( sgn(lValue) * sgn(lMultiplier) * sgn(lDivisor) == -1 )
    {
        return( -(LONG)ulRetLong );
    }
    else
    {
        return( (LONG)ulRetLong );
    }

}


/******************************************************************************/
/*  FUNCTION: prdg_PointToAngle                                               */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*   PPOINTL  pPoint                                                          */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This routine converts a point (x,y) to an angle from the X axis.          */
/*                                                                            */
/******************************************************************************/
#if 0
USHORT PASCAL prdg_PointToAngle(Point)

POINTL    Point;
#endif

USHORT prdg_PointToAngle(POINTL Point)                             /* CON3201 */

{

    /**************************************************************************/
    /*  Local variables                                                       */
    /**************************************************************************/
    LONG   x, y;
    USHORT retval;
    ULONG  ax, ay, tmp;
    ULONG  z1, z2;
    USHORT angle;

    x = Point.x;
    y = Point.y;

    ax = abs(x);
    ay = abs(y);

    if ( !ay )
    {
        /**********************************************************************/
        /* along the x-axis                                                   */
        /**********************************************************************/
        if ( x < 0 )
        {
            return( 180 );
        }
        else
        {
            return( 0 );
        }
    }

    if (!ax)
    {
        /**********************************************************************/
        /* along the y-axis                                                   */
        /**********************************************************************/
        if ( y < 0 )
        {
            return( 270 );
        }
        else
        {
            return( 90 );
        }
    }

    if (ax == ay)
    {
        /**********************************************************************/
        /* a multiple of 45 degrees.                                          */
        /**********************************************************************/
        retval = 45;
        if ( x < 0 )
        {
            retval += 90;
        }
        if ( y < 0 )
        {
            retval = 360 - retval;
        }
        return( retval );
    }

    /**************************************************************************/
    /* Now use the approximation                                              */
    /**************************************************************************/
    if (ay > ax)
    {
        /**********************************************************************/
        /* move to first octant                                               */
        /**********************************************************************/
        tmp = ay;
        ay = ax;
        ax = tmp;
    }

    /**************************************************************************/
    /* Now have ay < ax.                                                      */
    /**************************************************************************/

    /**************************************************************************/
    /* Get 225* y/x                                                           */
    /**************************************************************************/
    z1 = prdg_ScaleValue( ay, 225L, ax );

    /**************************************************************************/
    /* Now 225*( (y/x)^3 / 5)                                                 */
    /**************************************************************************/
    z2 = prdg_ScaleValue( z1, ay, ax );
    z2 = prdg_ScaleValue( z2, ay, ax ) / 5;

    /**************************************************************************/
    /* (z1-z2)/4 is the angle in degrees.  (0 to 45)                          */
    /**************************************************************************/
    angle = (USHORT)(z1 - z2) / 4;

    /**************************************************************************/
    /* Allow for rounding errors near 0 and 45 degrees.                       */
    /**************************************************************************/
    if (angle > 45)
    {
        angle = 45;
    }
    else if (angle < 0)
    {
        angle = 0;
    }

    /**************************************************************************/
    /* Move back to correct octant                                            */
    /**************************************************************************/
    if ( abs(y) > abs(x) )
    {
        angle = 90 - angle;
    }

    if ( x < 0 )
    {
       angle = 180 - angle;
    }

    if ( y < 0 )
    {
       angle = 360 - angle;
    }

    /**************************************************************************/
    /* Finished.                                                              */
    /**************************************************************************/
    return( angle );
}


/******************************************************************************/
/*  FUNCTION: prdg_MatrixScaleDifferent                                       */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*  This function checks if xform matrix is different and rescaling of charbox*/
/*  is required. Compares  the determinants of the two matrices and returns   */
/*  TRUE if they are different and FALSE if they are same or within a narrow  */
/*  range of each other.                                                      */
/*                                                                            */
/******************************************************************************/
#if 0
BOOL PASCAL prdg_MatrixScaleDifferent(OldXform, NewXform)

XFORM  OldXform;
XFORM  NewXform;
#endif

BOOL prdg_MatrixScaleDifferent( XFORM  OldXform,                   /* CON3201 */
                                XFORM  NewXform )                  /* CON3201 */

{

    /**************************************************************************/
    /*  Local Variables.                                                      */
    /**************************************************************************/
    LONG     fxOldDet;
    LONG     fxNewDet;

    /**************************************************************************/
    /* Compare determinants of the two matrices.  If equal, or within a range */
    /* of error, then return FALSE, else TRUE.  Note that the matrix          */
    /* coefficients are FIXED, as is the determinant.                         */
    /**************************************************************************/

    fxOldDet = far_get_sqr_determinant( OldXform.fxM11, OldXform.fxM12,
                                        OldXform.fxM21, OldXform.fxM22 );

    fxNewDet = far_get_sqr_determinant( NewXform.fxM11, NewXform.fxM12,
                                        NewXform.fxM21, NewXform.fxM22 );


    if ( labs(fxOldDet - fxNewDet) < 10 )
    {
        /**********************************************************************/
        /* difference is less than 10/65536, so return FALSE.  No rescaling is*/
        /* necessary.  Note that the error range is required due to inaccuracy*/
        /* in the square root function.                                       */
        /**********************************************************************/
        return( FALSE );
    }
    else
    {
        /**********************************************************************/
        /* Rescaling will be necessary.                                       */
        /**********************************************************************/
        return( TRUE );
    }
}


/******************************************************************************/
/*  FUNCTION: prdg_XformPoint                                                 */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function transforms the point given in plPoint using the transform   */
/*  pxfm, removes the origin shift and works out the vector length of the     */
/*  transformed point.  It returns this length.  This task is done by         */
/*  xform_point (in fontxfrm.asm), but prdg_XformPoint assumes that the points*/
/*  passed in are SHORTs although they're passed in as LONGs).                */
/******************************************************************************/
#if 0
ULONG PASCAL prdg_XformPoint(DcH, plPoint, pxfm)

HDC      DcH;
PPOINTL  plPoint;
PXFORM   pxfm;
#endif

ULONG prdg_XformPoint( HDC      DcH,                               /* CON3201 */
                       PPOINTL  plPoint,                           /* CON3201 */
                       PXFORM   pxfm )                             /* CON3201 */

{

    /**************************************************************************/
    /*  Transform the point.                                                  */
    /**************************************************************************/
    if (!da_ConvertWithMatrix(DcH, plPoint, 1L, pxfm, 0L,
                              NGreConvertWithMatrix))
    {
        return(ULONG)0xFFFFFFFF;
    }

    /**************************************************************************/
    /*  Now plPoint has been transformed.  Remove the origin shift.           */
    /**************************************************************************/
    plPoint->x -= pxfm->lM41;
    plPoint->y -= pxfm->lM42;

    /**************************************************************************/
    /*  Call the assembler routine far_get_vector_length.                     */
    /**************************************************************************/
    return(far_get_vector_length(plPoint));
}


/******************************************************************************/
/*  FUNCTION: prdg_ScaleUpPoint                                               */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*  This function scales the coordinate values until one of the values is     */
/*  greater than the given Minimum value. Used to maintain accuracy for       */
/*  calculations.                                                             */
/*                                                                            */
/******************************************************************************/
#if 0
ULONG PASCAL prdg_ScaleUpPoint( Point, Min, pPt)

POINTL   Point;
LONG     Min;
PPOINTL  pPt;
#endif

ULONG prdg_ScaleUpPoint( POINTL   Point,                           /* CON3201 */
                         LONG     Min,                             /* CON3201 */
                         PPOINTL  pPt )                            /* CON3201 */

{

    /**************************************************************************/
    /*  Local Variables.                                                      */
    /**************************************************************************/
    LONG     x;
    LONG     y;

    x = Point.x;
    y = Point.y;

    /**************************************************************************/
    /* No need to scale up if one value is zero.                              */
    /**************************************************************************/
    if (x != 0 || y != 0)
    {
        while ( (abs(x) < Min) && (abs(y) < Min) )
        {
            /******************************************************************/
            /* Keep scaling up until one value is > max                       */
            /******************************************************************/
            x *= 16;
            y *= 16;
        }
    }
    pPt->x = x;
    pPt->y = y;

    return(OK);
}
