/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDEFLDB
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prde_FillLdb
 *             prde_GetProcessID
 *             prde_GetOSVersionNumber
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES              /* Convert to C/SET2    CON3201       */
#define INCL_DOSRESOURCES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#define INCL_DOSERRORS
#define INCL_DOSPROCESS
//#define INCL_DOSMEMMGR
#define INCL_DOSMODULEMGR
#define INCL_DEV
//#define INCL_WINPOINTERS
#define INCL_DOSMISC
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSRESOURCES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS
#undef INCL_DOSERRORS
#undef INCL_DOSPROCESS
#undef INCL_DOSMEMMGR
#undef INCL_DOSMODULEMGR
#undef INCL_DEV
#undef INCL_WINPOINTERS
#undef INCL_DOSMISC

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDIMISC
#define INCL_GREALL
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDIMISC
#undef INCL_GREALL

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>
#include <prddcone.h>                  /* PD00769 */

#define ENCON_INCL
#define PRDLTYPE_INCL
#define PRDBTYPE_INCL
#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef ENCON_INCL
#undef PRDLTYPE_INCL
#undef PRDBTYPE_INCL
#undef PRDMTYPE_INCL

#include <prdbtyp1.h>
#include <prdbtyp4.h>

#define PRD_DISPATCH_ONLY
#include <prdaextf.h>
#include <prdbextf.h>
#include <prdcextf.h>
#include <prdeextf.h>
#include <prdgextf.h>
#include <prdiextf.h>
#include <prdlextf.h>
#include <prdoextf.h>
#include <prdqextf.h>
#include <prdsextf.h>
#include <prdtextf.h>
#include <prdyextf.h>
#undef PRD_DISPATCH_ONLY

/******************************************************************************/
/*  Set up access to external data.                                           */
/******************************************************************************/
extern enum DDState  prd_DDState;
/* extern PFSRSEM       lpCreateHeapSem;                              CON3201 */
extern HMTX          hmtxCreateHeapSem;
/* extern HHEAP         HeapHandle;                                   CON3201 */
/* extern unsigned      HeapSelector;                                 CON3201 */
/* extern USHORT        prdd_HugeInc;                                 CON3201 */

/* extern USHORT        LoadingProcId;                                CON3201 */
extern ULONG         LoadingProcId;
/* extern HHEAP         GlobalHeapArray [10];                         CON3201 */
/* extern USHORT        GlobalSelectorArray [10];                     CON3201 */
extern PBYTE         GlobalHeapArray [10];                         /* CON3201 */
extern USHORT        GlobalHeapSegCount;

extern HMODULE       prdd_ModHandle;
/* extern USHORT        prdd_ModHandle;                               CON3201 */
/* extern USHORT        PMVersion;                                    CON3201 */
/* extern ULONG        OS2Version;                                    CON3201 */
extern USHORT        DRIVER_TYPE;      /* PD00769 */

BOOL   bFirstTime = TRUE;

/******************************************************************************/
/*  This module sets up these variables which must be external as they are    */
/*  used throughout the driver to pass control to the engine.                 */
/******************************************************************************/
extern PFNL  da_ErasePS;
extern PFNL  da_GetDCOrigin;
extern PFNL  da_PolyLine;
extern PFNL  da_DrawLinesInPath;
extern PFNL  da_PolyShortLine;
extern PFNL  da_GetCurrentPosition;
extern PFNL  da_SetCurrentPosition;
extern PFNL  da_GetLineOrigin;
extern PFNL  da_SetLineOrigin;
extern PFNL  da_PolyScanLine;
extern PFNL  da_DeviceCreateBitmap;
extern PFNL  da_DeviceDeleteBitmap;
extern PFNL  da_DeviceSelectBitmap;
extern PFNL  da_GetPel;
extern PFNL  da_SetPel;
extern PFNL  da_ImageData;
extern PFNL  da_BitBlt;
extern PFNL  da_GetBitmapBits;
extern PFNL  da_SetBitmapBits;
extern PFNL  da_CharStringPos;
extern PFNL  da_QueryTextBox;
extern PFNL  da_QueryWidthTable;
extern PFNL  da_QueryCharPositions;
extern PFNL  da_CharString;
extern PFNL  da_GetKerningPairTable;
extern PFNL  da_DeviceSetAttributes;
extern PFNL  da_DeviceGetAttributes;
extern PFNL  da_DeviceSetGlobalAttribute;
extern PFNL  da_NotifyClipChange;
extern PFNL  da_RealizeFont;
extern PFNL  da_Convert;
extern PFNL  da_ConvertWithMatrix;
extern PFNL  da_NotifyTransformChange;
extern PFNL  da_AccumulateBounds;
extern PFNL  da_DeviceQueryFontAttributes;
extern PFNL  da_DeviceQueryFonts;
extern PFNL  da_GetCodePage;
extern PFNL  da_SetCodePage;
extern PFNL  da_QueryColorData;
extern PFNL  da_QueryLogColorTable;
extern PFNL  da_CreateLogColorTable;
extern PFNL  da_RealizeColorTable;
extern PFNL  da_UnrealizeColorTable;
extern PFNL  da_QueryRealColors;
extern PFNL  da_QueryNearestColor;
extern PFNL  da_QueryColorIndex;
extern PFNL  da_QueryRGBColor;
extern PFNL  da_QueryDeviceBitmaps;
extern PFNL  da_QueryDeviceCaps;
extern PFNL  da_Escape;
extern PFNL  da_QueryHardcopyCaps;
extern PFNL  da_QueryDevResource;
extern PFNL  da_PolyMarker;
extern PFNL  da_ResetBounds;
extern PFNL  da_GetBoundsData;
extern PFNL  da_GetStyleRatio;
extern PFNL  da_SetStyleRatio;
extern PFNL  da_DrawBorder;
extern PFNL  da_SetDCOrigin;
extern PFNL  da_LockDevice;
extern PFNL  da_UnLockDevice;
extern PFNL  da_FillPath;                       /* PD00769 */

/******************************************************************************/
/*  FUNCTION: prde_FillLdb                                                    */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*  See "OS/2 Technical Reference: I/O Subsytems and Device Drivers"          */
/*  FillLogicalDeviceBlock                                                    */
/*                                                                            */
/*  FLParamsLst  far  *param1;                                                */
/*  FLReturnsLst far  *param2;                                                */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function uses prde_ExchangeDispatch to substitute our own function   */
/*  addresses for the engine function handlers in the printer driver's        */
/*  dispatch table.  The engine function's addresses are saved for possible   */
/*  future use (ie simulations and passing calls on after processing by the   */
/*  printer driver).  The flags in the structure pointed to by param2 are set */
/*  to indicate: Each DC requires a physical device block; multiple DCs can   */
/*  co-exist; device and file name fields in a OpenDevDC call are significant.*/
/******************************************************************************/
#if 0
USHORT pascal prde_FillLdb(param1, param2)

FLParamsLst  far *  param1;
FLReturnsLst far *  param2;
#endif
USHORT prde_FillLdb( FLParamsLst  *param1,                         /* CON3201 */
                     FLReturnsLst *param2 )                        /* CON3201 */

{
#define TFUNC "prde_FillLdb"

    /**************************************************************************/
    /*  Local Variables                                                       */
    /**************************************************************************/
    USHORT      Result;
    PULONG      DispTab;               /* Pointer to start of dispatch table  */
    USHORT      i;                     /* Loop control variable               */

    /**************************************************************************/
    /*  Add the Enable Termination routine to this application's DosExitList, */
    /*  so that this Dynamic Link Library gets control when the application   */
    /*  terminates (normally or abnormally).                                  */
    /**************************************************************************/
    if ((Result = DosExitList((USHORT)EXLST_ADD | EXLST_PRTY_UNLOCK,
                              (PFNEXITLIST)prde_Termination_Ring3_Stub)))
    {
        LOGDOSERR(TFUNC, "DosExitList failed", FNULL, 0, Result);
        return(ERROR_ZERO);
    }

    /**************************************************************************/
    /*  Open the Device Driver Trace File.  For the first attach use TRUE to  */
    /*  create the Trace File.                                                */
    /**************************************************************************/
#if PRD_TRACE
    prdz_Init(TRUE);
#endif
#ifdef PRD_DEBUG
    haltproc();
#endif

    /**************************************************************************/
    /*  Change the first time flag                                            */
    /**************************************************************************/
    if (bFirstTime)
    {

        /**********************************************************************/
        /*  Get the process ID of the process which loaded the driver This is */
        /*  used when other processes need to allocate a global segment.  They*/
        /*  can then give it to the loading process so that it is always      */
        /*  available                                                         */
        /**********************************************************************/
        LoadingProcId = prde_GetProcessID();
        TRACE4(TFUNC, "LoadingProcId ", &LoadingProcId, 1);
/*      PMVersion = prde_GetOSVersionNumber(); No longer needed       CON3201 */
/*      DosGetVersion(&OS2Version);            No longer needed       CON3201 */
        /**********************************************************************/
        /*  Reset bFirstTime flag.                                            */
        /**********************************************************************/
        bFirstTime = FALSE;
    }
    else
    {

        /**********************************************************************/
        /*  Get access to all the segments used as part of global heap        */
        /**********************************************************************/
/* CON3201 - Using SSAllocMem, no need to specify the need for memory access
**      for (i = 0; i < GlobalHeapSegCount; i++)
**      {
**          if (DosGetSeg(GlobalSelectorArray[i]) != DOS_OK)
**              return(ERROR_ZERO);
**      }
*/
    }

    /**************************************************************************/
    /*  Get the create global heap semaphore to serialise this call           */
    /**************************************************************************/
    (VOID)prdg_RequestSemaphore(hmtxCreateHeapSem, 0);

    /**************************************************************************/
    /*  Update the Dispatch Table provided to intercept the functions which we*/
    /*  are required to support.  For all entries in the Dispatch Table save  */
    /*  the address of the Default Graphics Engine Handler in the dGRE table, */
    /*  for later calls for simulations or hand-ons.                          */
    /**************************************************************************/

    /**************************************************************************/
    /*  If the dispatch table pointer is not NULL then the engine dispatch    */
    /*  table must be set up.                                                 */
    /**************************************************************************/
    if (DispTab = param2->DispTab)
    {

        /**********************************************************************/
        /*  Now we need to save off the engine's function handlers to our     */
        /*  private table and replace the addresses in the engine's table with*/
        /*  the addresses of our handlers.  The address of the engine's table */
        /*  is found from param2->DispTab which is passed to us in the        */
        /*  function parameters.                                              */
        /**********************************************************************/
        if (prd_DDState == prd_Reset)
        {
            da_ErasePS = prde_ExchangeDispatch((PFNL)prdo_ErasePS,
                                               NGreErasePS,
                                               DispTab);

            da_GetDCOrigin = prde_ExchangeDispatch((PFNL)prdl_GetDCOrigin,
                                                   NGreGetDCOrigin,
                                                   DispTab);

            da_PolyLine = prde_ExchangeDispatch((PFNL)prdl_PolyLine,
                                                NGrePolyLine,
                                                DispTab);

            da_DrawLinesInPath = prde_ExchangeDispatch((PFNL)prdl_DrawLinesInPath,
                                                       NGreDrawLinesInPath,
                                                       DispTab);

            da_PolyShortLine = prde_ExchangeDispatch((PFNL)prdl_PolyShortLine,
                                                     NGrePolyShortLine,
                                                     DispTab);

            da_GetLineOrigin = prde_ExchangeDispatch((PFNL)prdl_GetLineOrigin,
                                                     NGreGetLineOrigin,
                                                     DispTab);

            da_SetLineOrigin = prde_ExchangeDispatch((PFNL)prdl_SetLineOrigin,
                                                     NGreSetLineOrigin,
                                                     DispTab);

            da_GetCurrentPosition =
                          prde_ExchangeDispatch((PFNL)prdl_GetCurrentPosition,
                                                NGreGetCurrentPosition,
                                                DispTab);

            da_SetCurrentPosition =
                          prde_ExchangeDispatch((PFNL)prdl_SetCurrentPosition,
                                                NGreSetCurrentPosition,
                                                DispTab);

            da_PolyScanLine = prde_ExchangeDispatch((PFNL)prds_PolyScanLine,
                                                    NGrePolyScanline,
                                                    DispTab);
                                                          /*CON32O2*/
            da_DeviceCreateBitmap =
                          prde_ExchangeDispatch((PFNL)prdn_DeviceCreateBitmap,
                                                NGreDeviceCreateBitmap,
                                                DispTab);

            da_DeviceDeleteBitmap =
                          prde_ExchangeDispatch((PFNL)prdb_DeviceDeleteBitmap,
                                                NGreDeviceDeleteBitmap,
                                                DispTab);

            da_DeviceSelectBitmap =
                          prde_ExchangeDispatch((PFNL)prdb_DeviceSelectBitmap,
                                                NGreDeviceSelectBitmap,
                                                DispTab);

            da_GetPel = prde_ExchangeDispatch((PFNL)prdb_GetPel,
                                              NGreGetPel,
                                              DispTab);

            da_SetPel = prde_ExchangeDispatch((PFNL)prdb_SetPel,
                                              NGreSetPel,
                                              DispTab);

            da_ImageData = prde_ExchangeDispatch((PFNL)prdb_ImageData,
                                                 NGreImageData,
                                                 DispTab);

            da_BitBlt = prde_ExchangeDispatch((PFNL)prdb_BitBlt,
                                              NGreBitblt,
                                              DispTab);
                                                          /*CON32O2*/

            da_GetBitmapBits = prde_ExchangeDispatch((PFNL)prdn_GetSetBitmapBits,
                                                     NGreGetBitmapBits,
                                                     DispTab);
                                                          /*CON32O2*/

            da_SetBitmapBits = prde_ExchangeDispatch((PFNL)prdn_GetSetBitmapBits,
                                                     NGreSetBitmapBits,
                                                     DispTab);

            da_CharStringPos = prde_ExchangeDispatch((PFNL)prdt_CharStringPos,
                                                     NGreCharStringPos,
                                                     DispTab);

            da_QueryTextBox = prde_ExchangeDispatch((PFNL)prdt_QueryTextBox,
                                                    NGreQueryTextBox,
                                                    DispTab);

            da_QueryWidthTable = prde_ExchangeDispatch((PFNL)prdt_QueryWidthTable,
                                                       NGreQueryWidthTable,
                                                       DispTab);

            da_QueryCharPositions =
                          prde_ExchangeDispatch((PFNL)prdt_QueryCharPositions,
                                                NGreQueryCharPositions,
                                                DispTab);

            da_CharString = prde_ExchangeDispatch((PFNL)prdt_CharString,
                                                  NGreCharString,
                                                  DispTab);

#ifdef DDT_KERNING_ENABLED
            /******************************************************************/
            /*  Don't hook kerning functions - these are always handled by    */
            /*  engine.  PD00075 : this function is now hooked.               */
            /******************************************************************/
            da_GetKerningPairTable =
                         prde_ExchangeDispatch((PFNL)prda_GetKerningPairTable,
                                               NGreGetPairKerningTable,
                                               DispTab);
#endif

            da_DeviceSetAttributes =
                         prde_ExchangeDispatch((PFNL)prda_DeviceSetAttributes,
                                               NGreDeviceSetAttributes,
                                               DispTab);

            da_DeviceGetAttributes =
                         prde_ExchangeDispatch((PFNL)prda_DeviceGetAttributes,
                                               NGreDeviceGetAttributes,
                                               DispTab);

            da_DeviceSetGlobalAttribute =
                    prde_ExchangeDispatch((PFNL)prda_DeviceSetGlobalAttribute,
                                          NGreDeviceSetGlobalAttribute,
                                          DispTab);

            da_NotifyClipChange = prde_ExchangeDispatch((PFNL)prdi_NotifyClipChange,
                                                        NGreNotifyClipChange,
                                                        DispTab);

            da_RealizeFont = prde_ExchangeDispatch((PFNL)prda_RealizeFont,
                                                   NGreRealizeFont,
                                                   DispTab);

            da_AccumulateBounds = prde_ExchangeDispatch((PFNL)prdg_AccumulateBounds,
                                                        NGreAccumulateBounds,
                                                        DispTab);

            da_GetBoundsData = prde_ExchangeDispatch((PFNL)prdg_GetBoundsData,
                                                     NGreGetBoundsData,
                                                     DispTab);

            da_ResetBounds = prde_ExchangeDispatch((PFNL)prdg_ResetBounds,
                                                   NGreResetBounds,
                                                   DispTab);

            da_DeviceQueryFontAttributes =
                   prde_ExchangeDispatch((PFNL)prda_DeviceQueryFontAttributes,
                                         NGreDeviceQueryFontAttributes,
                                         DispTab);

            da_DeviceQueryFonts = prde_ExchangeDispatch((PFNL)prda_DeviceQueryFonts,
                                                        NGreDeviceQueryFonts,
                                                        DispTab);

            da_GetCodePage = prde_ExchangeDispatch((PFNL)prda_GetCodePage,
                                                   NGreGetCodePage,
                                                   DispTab);

            da_SetCodePage = prde_ExchangeDispatch((PFNL)prda_SetCodePage,
                                                   NGreSetCodePage,
                                                   DispTab);

            da_QueryColorData = prde_ExchangeDispatch((PFNL)prdc_QueryColorData,
                                                      NGreQueryColorData,
                                                      DispTab);

            da_QueryLogColorTable =
                          prde_ExchangeDispatch((PFNL)prdc_QueryLogColorTable,
                                                NGreQueryLogColorTable,
                                                DispTab);

            da_CreateLogColorTable =
                         prde_ExchangeDispatch((PFNL)prdc_CreateLogColorTable,
                                               NGreCreateLogColorTable,
                                               DispTab);

            da_RealizeColorTable =
                           prde_ExchangeDispatch((PFNL)prdc_RealizeColorTable,
                                                 NGreRealizeColorTable,
                                                 DispTab);

            da_UnrealizeColorTable =
                         prde_ExchangeDispatch((PFNL)prdc_UnRealizeColorTable,
                                               NGreUnrealizeColorTable,
                                               DispTab);

            da_QueryRealColors = prde_ExchangeDispatch((PFNL)prdc_QueryRealColors,
                                                       NGreQueryRealColors,
                                                       DispTab);

            da_QueryNearestColor = prde_ExchangeDispatch((PFNL)prdc_QueryNearestColor,
                                                         NGreQueryNearestColor,
                                                         DispTab);

            da_QueryColorIndex = prde_ExchangeDispatch((PFNL)prdc_QueryColorIndex,
                                                       NGreQueryColorIndex,
                                                       DispTab);

            da_QueryRGBColor = prde_ExchangeDispatch((PFNL)prdc_QueryRGBColor,
                                                     NGreQueryRGBColor,
                                                     DispTab);

            da_QueryDeviceBitmaps =
                          prde_ExchangeDispatch((PFNL)prdq_QueryDeviceBitmaps,
                                                NGreQueryDeviceBitmaps,
                                                DispTab);

            da_QueryDeviceCaps = prde_ExchangeDispatch((PFNL)prdq_QueryDeviceCaps,
                                                       NGreQueryDeviceCaps,
                                                       DispTab);

            da_Escape = prde_ExchangeDispatch((PFNL)prdq_Escape,
                                              NGreEscape,
                                              DispTab);

            da_QueryHardcopyCaps = prde_ExchangeDispatch((PFNL)prdq_QueryHardcopyCaps,
                                                         NGreQueryHardcopyCaps,
                                                         DispTab);

            da_QueryDevResource = prde_ExchangeDispatch((PFNL)prdq_QueryDevResource,
                                                        NGreQueryDevResource2,
/* CON3201 changed name from NGreQueryDevResource to NGreQueryDevResource2    */
                                                        DispTab);

            da_PolyMarker = prde_ExchangeDispatch((PFNL)prdb_PolyMarker,
                                                  NGrePolyMarker,
                                                  DispTab);

            da_GetStyleRatio = prde_ExchangeDispatch((PFNL)prdl_GetStyleRatio,
                                                     NGreGetStyleRatio,
                                                     DispTab);

            da_SetStyleRatio = prde_ExchangeDispatch((PFNL)prdl_SetStyleRatio,
                                                     NGreSetStyleRatio,
                                                     DispTab);

            da_DrawBorder = prde_ExchangeDispatch((PFNL)prdo_DrawBorder,
                                                  NGreDrawBorder,
                                                  DispTab);

            da_SetDCOrigin = prde_ExchangeDispatch((PFNL)prdo_SetDCOrigin,
                                                   NGreDeviceSetDCOrigin,
                                                   DispTab);

            da_LockDevice = prde_ExchangeDispatch((PFNL)LockDevice,
                                                  NGreLockDevice,
                                                  DispTab);

            da_UnLockDevice = prde_ExchangeDispatch((PFNL)UnLockDevice,
                                                    NGreUnlockDevice,
                                                    DispTab);

            da_NotifyTransformChange =
                 prde_ExchangeDispatch((PFNL)prdg_NotifyTransformChange,
                                       NGreNotifyTransformChange,
                                       DispTab);

            /******************************************************************/
            /*  We don't have to hook the following convert functions but we  */
            /*  do need to call them from our own conversion routines.        */
            /******************************************************************/
            da_Convert = (PFNL)(*(((DispTab ) + (NGreConvert & 0xFFL))));
            da_ConvertWithMatrix =
               (PFNL)(*(((DispTab) + (NGreConvertWithMatrix & 0xFFL))));

            /******************************************************************/
            /*  Set the global state of the Device Driver to Ready to show we */
            /*  are moving out of Reset state.                                */
            /******************************************************************/
            prd_DDState = prd_Ready;
        }
        else

        /**********************************************************************/
        /*  Dispatch table and da_ variables already set up so don't do an    */
        /*  exchange.  Instead, just copy the device driver address into the  */
        /*  dispatch table                                                    */
        /**********************************************************************/
        {
            SetAdd(prdo_ErasePS,NGreErasePS,DispTab);

            SetAdd(prdl_GetDCOrigin,NGreGetDCOrigin,DispTab);

            SetAdd(prdl_PolyLine,NGrePolyLine,DispTab);

            SetAdd(prdl_DrawLinesInPath,NGreDrawLinesInPath,DispTab);

            SetAdd(prdl_PolyShortLine,NGrePolyShortLine,DispTab);

            SetAdd(prdl_GetLineOrigin,NGreGetLineOrigin,DispTab);

            SetAdd(prdl_SetLineOrigin,NGreSetLineOrigin,DispTab);

            SetAdd(prdl_GetCurrentPosition,NGreGetCurrentPosition,DispTab);

            SetAdd(prdl_SetCurrentPosition,NGreSetCurrentPosition,DispTab);

            SetAdd(prds_PolyScanLine,NGrePolyScanline,DispTab);
                       /*CON3202*/
            SetAdd(prdn_DeviceCreateBitmap,NGreDeviceCreateBitmap,DispTab);

            SetAdd(prdb_DeviceDeleteBitmap,NGreDeviceDeleteBitmap,DispTab);

            SetAdd(prdb_DeviceSelectBitmap,NGreDeviceSelectBitmap,DispTab);

            SetAdd(prdb_GetPel,NGreGetPel,DispTab);

            SetAdd(prdb_SetPel,NGreSetPel,DispTab);

            SetAdd(prdb_ImageData,NGreImageData,DispTab);

            SetAdd(prdb_BitBlt,NGreBitblt,DispTab);
                       /*CON3202*/

            SetAdd(prdn_GetSetBitmapBits,NGreGetBitmapBits,DispTab);
                       /*CON3202*/

            SetAdd(prdn_GetSetBitmapBits,NGreSetBitmapBits,DispTab);

            SetAdd(prdt_CharStringPos,NGreCharStringPos,DispTab);

            SetAdd(prdt_QueryTextBox,NGreQueryTextBox,DispTab);

            SetAdd(prdt_QueryWidthTable,NGreQueryWidthTable,DispTab);

            SetAdd(prdt_QueryCharPositions,NGreQueryCharPositions,DispTab);

            SetAdd(prdt_CharString,NGreCharString,DispTab);

#ifdef DDT_KERNING_ENABLED
            /******************************************************************/
            /*  Kerning always handled by engine.  PD00075 : This function is */
            /*  now hooked.                                                   */
            /******************************************************************/
            SetAdd(prda_GetKerningPairTable,NGreGetPairKerningTable,DispTab);
#endif

            SetAdd(prda_DeviceSetAttributes,NGreDeviceSetAttributes,DispTab);

            SetAdd(prda_DeviceGetAttributes,NGreDeviceGetAttributes,DispTab);

            SetAdd(prda_DeviceSetGlobalAttribute, NGreDeviceSetGlobalAttribute,
                   DispTab);

            SetAdd(prdi_NotifyClipChange,NGreNotifyClipChange,DispTab);

            SetAdd(prda_RealizeFont,NGreRealizeFont,DispTab);

            SetAdd(prdg_AccumulateBounds,NGreAccumulateBounds,DispTab);

            SetAdd(prdg_GetBoundsData,NGreGetBoundsData,DispTab);

            SetAdd(prdg_ResetBounds,NGreResetBounds,DispTab);

            SetAdd(prda_DeviceQueryFontAttributes,
                   NGreDeviceQueryFontAttributes, DispTab);

            SetAdd(prda_DeviceQueryFonts,NGreDeviceQueryFonts,DispTab);

            SetAdd(prda_GetCodePage,NGreGetCodePage,DispTab);

            SetAdd(prda_SetCodePage,NGreSetCodePage,DispTab);

            SetAdd(prdc_QueryColorData,NGreQueryColorData,DispTab);

            SetAdd(prdc_QueryLogColorTable,NGreQueryLogColorTable,DispTab);

            SetAdd(prdc_CreateLogColorTable,NGreCreateLogColorTable,DispTab);

            SetAdd(prdc_RealizeColorTable,NGreRealizeColorTable,DispTab);

            SetAdd(prdc_UnRealizeColorTable,NGreUnrealizeColorTable,DispTab);

            SetAdd(prdc_QueryRealColors,NGreQueryRealColors,DispTab);

            SetAdd(prdc_QueryNearestColor,NGreQueryNearestColor,DispTab);

            SetAdd(prdc_QueryColorIndex,NGreQueryColorIndex,DispTab);

            SetAdd(prdc_QueryRGBColor,NGreQueryRGBColor,DispTab);

            SetAdd(prdq_QueryDeviceBitmaps,NGreQueryDeviceBitmaps,DispTab);

            SetAdd(prdq_QueryDeviceCaps,NGreQueryDeviceCaps,DispTab);

            SetAdd(prdq_Escape,NGreEscape,DispTab);

            SetAdd(prdq_QueryHardcopyCaps,NGreQueryHardcopyCaps,DispTab);

/* CON3201  SetAdd(prdq_QueryDevResource,NGreQueryDevResource,DispTab);       */
            SetAdd(prdq_QueryDevResource,NGreQueryDevResource2,DispTab);

            SetAdd(prdb_PolyMarker,NGrePolyMarker,DispTab);

            SetAdd(prdl_GetStyleRatio,NGreGetStyleRatio,DispTab);

            SetAdd(prdl_SetStyleRatio,NGreSetStyleRatio,DispTab);

            SetAdd(prdo_DrawBorder,NGreDrawBorder,DispTab);

            SetAdd(prdo_SetDCOrigin,NGreDeviceSetDCOrigin,DispTab);

            SetAdd(LockDevice,NGreLockDevice,DispTab);

            SetAdd(UnLockDevice,NGreUnlockDevice,DispTab);

            SetAdd(prdg_NotifyTransformChange, NGreNotifyTransformChange,
                   DispTab);

        }
    }

    /**************************************************************************/
    /*  Free the create heap (initialisation) semaphore which serialises      */
    /*  access to prd_DDState                                                 */
    /**************************************************************************/
    (VOID)prdg_ClearSemaphore(hmtxCreateHeapSem);

    /**************************************************************************/
    /* Set the flags to show that we want:                                    */
    /*   bit 0 = 1 => each DC requires its own pDeviceBlock (Pdb)             */
    /*   bit 1 = 0 => an arbitary number of DCs can co-exist                  */
    /*   bit 2 = 0 => the device and file name fields of OpenDevDc            */
    /*                are significant, and should not be ignored.             */
    /* All other bits are reserved and should not be modified.                */
    /**************************************************************************/
    *(param2->Flags) &= 0xFFFFFFF8L;
    *(param2->Flags) |= 0x00000081L;
    return(OK);
}
#undef TFUNC

/******************************************************************************/
/*  FUNCTION: prde_GetProcessID                                               */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*  None                                                                      */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function calls DosGetInfoSeg to get a the selector for the local     */
/*  info segment and then uses this to determine the process ID for the       */
/*  current process.                                                          */
/******************************************************************************/
/* CON3201
**USHORT pascal prde_GetProcessID(VOID)
*/
ULONG prde_GetProcessID(VOID)                                     /* CON3201 */
{
#define TFUNC "prde_GetProcID"

    /**************************************************************************/
    /*  Local Variables                                                       */
    /**************************************************************************/
#if 0
/* CON3201 variables not needed */
    USHORT     LocalSel;               /* Local and ..                        */
    USHORT     GlobalSel;              /*  ... global info segment selectors  */
    PLINFOSEG  LocalSeg;               /* The local info seg type             */
    USHORT     DosResult;              /* DOS return code                     */
#endif

    PTIB       pThreadInfo;
    PPIB       pProcessInfo;

    /**************************************************************************/
    /*  Call DosGetInfoSeg                                                    */
    /**************************************************************************/
/* CON3201 - DosGetInfoSeg not supported
**  if ((DosResult = DosGetInfoSeg((unsigned short far *)&GlobalSel,
**                                 (unsigned short far *)&LocalSel)) != DOS_OK)
*/
    DosGetInfoBlocks(&pThreadInfo, &pProcessInfo); /* CON3201 */
    return(pProcessInfo->pib_ulpid);
}
#undef TFUNC

#if 0
/*
** CON3201 - This function is no longer needed
*/
/******************************************************************************/
/*  FUNCTION: prde_GetOSVersionNumber                                         */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*  None                                                                      */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function looks for PrtAbort in the PMSPL module. If present it       */
/*  returns 2 (OS/2 v1.2) else it returns 1 (OS/2 v1.1).                      */
/******************************************************************************/
USHORT prde_GetOSVersionNumber(VOID)
{

/*  CON3201  Remove extraneous logic                                          */
*/
    /**************************************************************************/
    /*  Local Variables                                                       */
    /**************************************************************************/
/*  HMODULE  PMSPLModuleHandle;        /* Module for PMSPL                    */
**  PFN      pPrtAbort;                /* Address of PrtAbort                 */
**  USHORT   DosResult;                /* Return value from DOS               */
*/
    USHORT   Version;                  /* Return value from DOS               */


    /**************************************************************************/
    /*  Calculate which version of PM is running (1.1 or 1.2) and return 1 or */
    /*  2 respectively.                                                       */
    /*                                                                        */
    /*  We calculate which version is installed by looking for the procedure  */
    /*  PrtAbort in module PMSPL.  If this function is present then the       */
    /*  version is 1.2, otherwise it is 1.1.                                  */
    /**************************************************************************/
/*  if (DOS_OK == DosLoadModule(FNULL, 0, "PMSPL", &PMSPLModuleHandle))
**  {
**
**      /**********************************************************************/
**      /*  PMSPL is loaded...  now try and get the address of PrtAbort..     */
**      /**********************************************************************/
**      if (DOS_OK == DosGetProcAddr(PMSPLModuleHandle, "PRTABORT", &pPrtAbort))
**      {
**
**          /******************************************************************/
**          /*  We have successfully read the address of the PrtAbort         */
**          /*  function, so this must be PM version 1.2                      */
**          /******************************************************************/
*/
            Version = 2;
/*
**      }
**      else
**      {
**          Version = 1;
**      }
**      DosResult = DosFreeModule(PMSPLModuleHandle);
**  }
**  else
**  {
*/
        /**********************************************************************/
        /*  We failed to load PMSPL.  This should never happen, but just in   */
        /*  case it does we will set PMVersion to 1.                          */
        /**********************************************************************/
/*      Version = 1;
**  }
*/
    return(Version);
}
/* CON3201 - This function is no longer needed */
#endif
