/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDEDPDB
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prde_DisablePdb
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES              /* Convert to C/SET2    CON3201       */
#define INCL_GREALL
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES               /* Convert to C/SET2    CON3201       */
#undef INCL_GREALL
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELSERVER
#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_WINP_SELSERVER
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>

#include <prddcone.h>

#define NO_SYS
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS

#include <prdecone.h>
#include <prdmtypt.h>

#include <prdeextf.h>
#include <prdgextf.h>
#include <prdyextf.h>
#include <prduextf.h>


/**********************************************************************/
/* Set up access to external variables.                               */
/**********************************************************************/
/*extern HHEAP            HeapHandle;         CON3201 */
extern PBYTE            pbGlobalHeap;
/*extern unsigned         HeapSelector;       CON3201 */
/*extern PFSRSEM          lpGlobalHeapSem;    CON3201 */
extern HMTX             hmtxGlobalHeapSem; /* CON3201 */
extern enum DDState     prd_DDState;
/* extern USHORT           PMVersion;         CON3201 */


/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prde_DisablePdb                                        */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   lpPDBI        param1; Pointer to PDB Instance data               */
/*   PBYTE         param2; Unused parameter                           */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function disables the physical device block (PDB).  It      */
/*   frees the memory used to store the driver name and the output    */
/*   name and it frees the PDB heap.                                  */
/*                                                                    */
/**********************************************************************/
USHORT prde_DisablePdb( lpPDBI param1,                     /* CON3201 */
                        PBYTE  param2 )                    /* CON3201 */

{
#define TFUNC "prde_DisablePdb"
    /******************************************************************/
    /* Local variables.                                               */
    /******************************************************************/
    PBYTE                BufferPtr;

    TRACE8(TFUNC, "Entry", NULL,0);
    TRACE8(TFUNC, "param1", &param1,1);
    TRACE8(TFUNC, "param1 data", param1,7);

#ifdef DEBUG_FSM
    OutputString("Enter DisablePdb");
#endif
#ifdef PRD_TIMING
    DEKHOOK0(A,7,2F)
#endif

    /******************************************************************/
    /* Get the heap semaphore to allow freeing of heap.               */
    /******************************************************************/
    (void)prdg_RequestSemaphore( hmtxGlobalHeapSem, 0);

    /******************************************************************/
    /* Free the heap used for the driver name - if it is not null     */
    /* (otherwise strlen crashes)                                     */
    /******************************************************************/
    if (param1->PDBDriverName != FNULL)
    {
        TRACE4(TFUNC,"free driver name heap",FNULL,0);
        TRACE4(TFUNC, "PDBI->DriverName",param1->PDBDriverName, 3);

        (void) prdg_FreeGlobalHeapItem(
                         prdu_strlen(param1->PDBDriverName) + 1,
                         (PUSHORT*)&(param1->PDBDriverName));
    }

    /******************************************************************/
    /* Free the heap used for the output name - if it is not null     */
    /* (otherwise strlen crashes)                                     */
    /******************************************************************/
    if (param1->PDBLogAddress != FNULL)
    {
        TRACE4(TFUNC,"free op. name heap",FNULL,0);
        TRACE4(TFUNC, "PDBI->OutputName",param1->PDBLogAddress, 3);

        (void) prdg_FreeGlobalHeapItem(
                     prdu_strlen(param1->PDBLogAddress) + 1,
                     (PUSHORT*)&(param1->PDBLogAddress));
    }

    /******************************************************************/
    /* FIX : AK 04/24/91 - free the second form FormInfoPtr here,     */
    /* if this is a dual form job.                                    */
    /*                                                                */
    /* PD00064 : FORM_DIMS_LENGTH + 1 is used to allow for terminating*/
    /* null.                                                          */
    /******************************************************************/
    if (param1->NumberOfForms == 2)
    {
         (void)prdg_FreeGlobalHeapItem(
                 FORM_DIMS_LENGTH + 1,
                 (PUSHORT*)&(param1->PPMInfo[1].FormInfoPtr) );
    }

    if (param1->pStartPtr != NULL)
    {
/*     SSFREESEG(SELECTOROF(param1->pStartPtr)); CON3201 */
       SSFREEMEM(param1->pStartPtr);
    }


    /******************************************************************/
    /* Free the SplData                             Pd00227           */
    /******************************************************************/
    if (param1->lpSplData != FNULL)
    {
       if (param1->lpSplData->pszSpoolerParams != FNULL)
       {
/* CON3201  *******************************************************************/
/* PMVersion checked for 1.1 or 1.2 PMVersion would always be true so will    */
/* eliminate the check                                                        */
/*        if ( (param1->FormSpecifiedOnOpen) && (PMVersion > 1) ) CON3201     */
          if (param1->FormSpecifiedOnOpen)
          {
/* CON3201   SSFREESEG(SELECTOROF(param1->lpSplData->pszSpoolerParams)); */
           SSFREEMEM(param1->lpSplData->pszSpoolerParams);
          }
          else
          {
             BufferPtr = (PBYTE)param1->lpSplData->pszSpoolerParams;
             (void)prdg_FreeGlobalHeapItem(
                                           prdu_strlen(BufferPtr) + 1,
                                           (PUSHORT*)&BufferPtr );
          }
       }

       if (param1->lpSplData->pszQueueProcParams != FNULL)
       {
/* CON3201 SSFREESEG(SELECTOROF(param1->lpSplData->pszQueueProcParams));      */
           SSFREEMEM( param1->lpSplData->pszQueueProcParams );
       }

       BufferPtr = (PBYTE)param1->lpSplData->pszNetworkParams;
       if ( BufferPtr != FNULL )
       {
            (void)prdg_FreeGlobalHeapItem(
                                           prdu_strlen(BufferPtr) + 1,
                                           (PUSHORT*)&BufferPtr );
       }

       BufferPtr = (PBYTE)param1->lpSplData->pszQueueProcName;
       if ( BufferPtr != FNULL)
       {
            (void)prdg_FreeGlobalHeapItem(
                                          prdu_strlen(BufferPtr) + 1,
                                          (PUSHORT*)&BufferPtr );
       }

       BufferPtr = (PBYTE)param1->lpSplData->pszComment;
       if ( BufferPtr != FNULL)
       {
            (void)prdg_FreeGlobalHeapItem(
                                          prdu_strlen(BufferPtr) + 1,
                                          (PUSHORT*)&BufferPtr );
       }

       BufferPtr = (PBYTE)param1->lpSplData->pdriv;
       if ( BufferPtr != FNULL)
       {
/******************************************************************************/
/* PD00802 : Free correct amount of memory for DRIVDATA structure (pdriv)     */
/******************************************************************************/
            (void)prdg_FreeGlobalHeapItem(
                           (USHORT)( param1->lpSplData->pdriv->cb ),
                           (PUSHORT*)&BufferPtr );
       }

       (void)prdg_FreeGlobalHeapItem(
                                     sizeof(DEVOPENSTRUC),
                                     (PUSHORT*)&(param1->lpSplData) );
    }

    /******************************************************************/
    /* Free the PDB instance heap                                     */
    /******************************************************************/
    TRACE4(TFUNC,"free PDB inst heap",FNULL,0);
    (void) prdg_FreeGlobalHeapItem(
                             sizeof(PDBIType),
                             (PUSHORT*)&param1);

    /******************************************************************/
    /* Clear the heap semaphore                                       */
    /******************************************************************/
    (void)prdg_ClearSemaphore(hmtxGlobalHeapSem);

    TRACE8(TFUNC, "EXIT", FNULL,0);
#ifdef PRD_TIMING
    DEKHOOK0(A,7,AF)
#endif
    return(OK);
}
#undef TFUNC

