/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDEDDC
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prde_DisableDC
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_DOSPROCESS
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_SPL
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_DOSPROCESS
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_SPL
#undef INCL_GPIERRORS

#define INCL_DDIMISC
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIMISC
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELSERVER
#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELSERVER
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>

#include <prddcone.h>

#define NO_SYS
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS

#include <prdecone.h>
#include <prdftypt.h>
#include <prdmtypt.h>

#include <prdeextf.h>
#include <prdjextf.h>
#include <prdaextf.h>
#include <prdgextf.h>
#include <prdpextf.h>
#include <prdfextf.h>
#include <prdyextf.h>
#include <prdbsize.h>
#include <prdncone.h>



/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prde_DisableDC                                         */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   lpDCI           DCIData;  Pointer to DC Instance data            */
/*   Dptr            param2;   Unused parameter                       */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function stops the printer and closes the spool file as     */
/*   necessary.  It also frees the font table memory and frees the    */
/*   DC heap and Instance data memory.                                */
/*                                                                    */
/* Note: closing the printer, freeing the band now done elsewhere.    */
/*                                                                    */
/**********************************************************************/
#if 0
USHORT pascal prde_DisableDC( DCIData )

lpDCI           DCIData;
#endif
USHORT prde_DisableDC( lpDCI DCIData )                     /* CON3201 */

{
#define TFUNC "prde_DisableDC"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
 /* HeapListType far * HeapEntryPtr; */  /* ptr to heap list entry    */
                                                           /* CON3201 */
    HeapListType     * HeapEntryPtr;     /* ptr to heap list entry    */
    HeapListType     * HeapDelPtr;
    HeapListType     * HeapPtrNext;
// CON3201     USHORT             HeapSelector;     /* hnd of heap to free       */
// CON3201     USHORT             NextHeapSelector; /* hnd of next heap to free  */

#ifdef DEBUG_FSM
    OutputString("Enter DisableDC");
#endif
#ifdef PRD_TIMING
    DEKHOOK0(A,7,35)
#endif
    /**************************************************************/
    /* Clear the semaphore. PD00636                               */
    /**************************************************************/

    if (DCIData->DCIPdbInstance->PDBPrtOpen)
    {
        (VOID) prdg_ClearSemaphore(
                DCIData->DCIPdbInstance->PDBDevice->ControlSemaphore);
    }
    /******************************************************************/
    /* DEBUG_SEGMENTS : free up the segment allocated by LocateFont   */
    /* for FMFs                                                       */
    /******************************************************************/
 /* CON3201 **********************************************************/
 /* if ( SELECTOROF(DCIData->DCIFontData.Info.pFont) )               */
 /* {                                                                */
 /*     SSFREESEG( SELECTOROF(DCIData->DCIFontData.Info.pFont) );    */
 /* }                                                                */
 /********************************************************************/

    if (DCIData->DCIFontData.Info.pFont)
    {
        SSFREEMEM( DCIData->DCIFontData.Info.pFont );
    }

    /******************************************************************/
    /* Loop round freeing all DC Heaps and Instance Data before exit. */
    /* Note we have to do the prdm_LeaveDriver while the DCIData is   */
    /* still valid.                                                   */
    /*                                                                */
    /* We have to be quite careful here because the handle of the heap*/
    /* we want to free is stored in the heap itself. So we have to    */
    /* make sure we have the handle to the next heap (if any) before  */
    /* we free the heap we're dealing with.                           */
    /******************************************************************/
/* CON3201 ********************************************************************/
/*  HeapEntryPtr = &DCIData->DCIHeapList;                             CON3201 */
/*  HeapSelector = (*HeapEntryPtr).HeapSel;                           CON3201 */
/*                                                                    CON3201 */
/*  do                                                                CON3201 */
/*  {                                                                 CON3201 */
/*      HeapEntryPtr = (*HeapEntryPtr).Next;                          CON3201 */
/*                                                                    CON3201 */
/*      if (HeapEntryPtr != FNULL)                                    CON3201 */
/*      {                                                             CON3201 */
/*          NextHeapSelector = (*HeapEntryPtr).HeapSel;               CON3201 */
/*      }                                                             CON3201 */
/*      (void) prdg_DeleteHeap( HeapSelector );                       CON3201 */
/*      HeapSelector = NextHeapSelector;                              CON3201 */
/*                                                                    CON3201 */
/*                                                                    CON3201 */
/*  } while (HeapEntryPtr != FNULL);                                  CON3201 */
/******************************************************************************/

    HeapDelPtr  = &DCIData->DCIHeapList;
    HeapPtrNext = HeapDelPtr;
    if (HeapDelPtr->Next != FNULL)       /* Make sure it points to something*/
      {
        do
        {
            HeapPtrNext = HeapDelPtr->Next;
            (void)prdg_DeleteHeap(HeapDelPtr->pbHLEHeap);
            HeapDelPtr = HeapPtrNext;
            HeapPtrNext = HeapPtrNext->Next;
        } while (HeapDelPtr->Next != FNULL);
      }
    (void)prdg_DeleteHeap(HeapDelPtr->pbHLEHeap);

#if 0
    HeapEntryPtr = &DCIData->DCIHeapList;  /* Set pointer to head of list */
    if (HeapEntryPtr->Next != FNULL)       /* Make sure it points to something*/
    {
        do                                 /* Iterate the list deleting heaps */
        {                                  /* along the way                   */
            HeapEntryPtr = HeapEntryPtr->Next;
            (void)prdg_DeleteHeap(HeapEntryPtr->pbHLEHeap);
        }while (HeapEntryPtr->Next != FNULL);
    }

#endif




    TRACE4(TFUNC, "Exit OK", NULL, 0);
#ifdef PRD_TIMING
    DEKHOOK0(A,7,B5)
#endif
    return(OK);

}
#undef TFUNC


