/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDEBCLS
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS  prde_BeginClose
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#define INCL_SPL
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS
#undef INCL_SPL

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdncone.h>

#define NO_SYS
#define ENCON_INCL
#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef PRDMTYPE_INCL
#undef NO_SYS
#undef ENCON_INCL

#include <prduextf.h>
#include <prdeextf.h>
#include <prdjextf.h>
#include <prdnextf.h>
#include <prdncone.h>

/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prde_BeginClose                                        */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   hanDC      DcH;       Handle to DC                               */
/*   lpDCI      DCIData;   Pointer to DC Instance data                */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/* State => RESET                                                     */
/* If a page is active (EXPLICIT, RAW_xx, or IMPLICIT (& drawn) then  */
/* ProcessPage is called to output it and close the document.         */
/* If IMPLICIT and no drawing has occured, then metafiling is stopped,*/
/* the band is freed, and SplQmEndDoc issued if necessary (ie after   */
/* C_OPEN,NEWFRAME ).                                                 */
/* The metafiler and spooler are closed.                              */
/*                                                                    */
/**********************************************************************/
#if 0
USHORT pascal prde_BeginClose (DcH, DCIData)

hanDC      DcH;
lpDCI      DCIData;
#endif

SHORT prde_BeginClose ( hanDC  DcH,                        /* CON3201 */
                        lpDCI  DCIData )                   /* CON3201 */

{
#define TFUNC "prde_BeginClose"

 /* USHORT      return_value; */
    SHORT      return_value;                               /* CON3201 */

#ifdef PRD_TIMING
    DEKHOOK0(A,7,2D)
#endif

#ifdef DEBUG_FSM
    OutputPrompt("Enter BeginClose");
#endif

    /******************************************************************/
    /*                                                                */
    /******************************************************************/
#ifdef PRD_SCANDEBUG
    haltproc();
    Dummy1++;
#endif

    /******************************************************************/
    /* If we are in exit list processing then force entry by setting  */
    /* the lock count and tid lock to zero.  This is necessary since  */
    /* the process may have terminated while the DC is locked.  This  */
    /* would lock out exit list CloseDC and prevent deletion.         */
    /******************************************************************/
 /* if (DCIData->LIS->rfProcStatus & PS_EXITLIST) */
    if (DCIData->ppibDCI->pib_flstatus & PS_EXITLIST)
    {
        DCIData->LockDCInfo.LockCount = 0;
        DCIData->LockDCInfo.tidLock = 0;
    }

    /******************************************************************/
    /* Do entry processing                                            */
    /******************************************************************/
    prdm_EnterDriver(DCIData);

    /******************************************************************/
    /* PD00474 : Free the pattern data if it is present               */
    /******************************************************************/
    (void) prdu_FreePatternMemory ( DCIData );

    /******************************************************************/
    /* For memory dc don't need to do any shutdown?                   */
    /******************************************************************/
    if ( !(DCIData->Flags & MEMORY) )
    {

        switch ( DCIData->State )
        {

            case WAIT_START:
            case PURGE:
                /* Just do shutdown */
                break;

            case IMPLICIT:
                if (DCIData->Flags & QUEUED_STD)
                {
                    /**************************************************/
                    /* Enforce StartDoc-EndDoc                        */
                    /**************************************************/
                    break;
                }
                /* continue ... */

            case EXPLICIT:
            case RAW_IMPLICIT:
            case RAW_EXPLICIT:

                if ((return_value = prdn_ProcessLastPage(DCIData)) != OK)
                {
                    /**********************************************/
                    /* May have ERROR, ERROR_ABORT, ERROR_PURGE   */
                    /**********************************************/
                    if ( return_value == ERROR )
                    {
                        goto ERROR_RETURN;
                    }
                    else
                    {
                        /**********************************************/
                        /* continue to end and return OK              */
                        /**********************************************/
                    }
                }

                break;

        } /* ...switch */
    } /* if !memory_dc */

    if ( DCIData->Flags & QUEUED )
    {
        if ( DCIData->Flags & QUEUED_STD)
        {
            /**********************************************************/
            /* close the metafiler.                                   */
            /**********************************************************/
            SplStdClose( (HDC)DCIData->DcH );
        }
        /* SplQmEndDoc done by ProcessPage, or above */

        if ( SplQmClose( (HSPL)DCIData->DCISplHandle ) != OK )
        {
            goto ERROR_RETURN;
        }
    }
#ifdef DEBUG_FSM
    OutputPrompt("Exit BeginClose OK");
#endif

    prdm_LeaveDriver( DCIData );
#ifdef PRD_TIMING
    DEKHOOK0(A,7,AD)
#endif
    return( OK );

ERROR_RETURN:
#ifdef DEBUG_FSM
    OutputPrompt("Exit BeginClose Error");
#endif
    prdm_LeaveDriver( DCIData );
#ifdef PRD_TIMING
    DEKHOOK0(A,7,AD)
#endif
    return ( ERROR_NEG );

}

#undef TFUNC


