/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDDEST
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION  Printer Device Driver EST/DCT Tables
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                /* CON3201 */
#define INCL_DOSPROCESS        /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#include <os2.h>
#undef INCL_DOSPROCESS         /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                      /* CON3201 */

#include <prddcone.h>

#define NO_SYS
#define INCL_HELP
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS
#undef INCL_HELP

/******************************************************************************/
/*  Escape Sequence Table                                                     */
/*                                                                            */
/*  Note : Changes to order of entries in this table must be reflected in the */
/*  EST_ constants defined in PRDDCONE.H                                      */
/******************************************************************************/

ESTEntryType  EST [EST_NUMBER_ENTRIES] =
    {

                                       /* EST_NULL                            */
        { "",
          0,0x0000 },

                                       /* EST_BACKSPACE                       */
                                       /* Command  : BS                       */
        { "\x08",
          1, 0x0000 },

                                       /* EST_LINE_FEED                       */
                                       /* Command  : LF                       */
        { "\x0A",
          1, 0x0000 },

                                       /* EST_FORM_FEED                       */
                                       /* Command  : FF                       */
        { "\x0C",
          1, 0x0000 },

                                       /* EST_CARRIAGE_RETURN                 */
                                       /* Command  : CR                       */
        { "\x0D",
          1, 0x0000 },

                                       /* EST_SPACE                           */
                                       /* Command  : SP                       */
        { "\x20",
          1, 0x0000 },

                                       /* EST_PRO_INIT_1                      */
        { "\x1B\x35\x00\x1B\x34\x12\x1B\x52\x1B\x36\x1B\x5B\x40\x04\x00\x00\x00\x11\x01\x1B\x57\x00",
          22, 0x0000 },

                                       /* EST_PRO_INIT_2                      */
        { "\x1B\x58\x01\xFF\x0D\x1B\x55\x00\x1B\x46\x1B\x48",
          12, 0x0000 },

                                       /* EST_PRO_INIT_3                      */
        { "\x1B\x54\x1B\x5F\x00\x1B\x2D\x00",
          8, 0x0000 },

                                       /* EST_QUIET_INIT_1                    */
        { "\x1B\x35\x00\x1B\x34\x12\x1B\x52\x1B\x36",
          10, 0x0000 },

                                       /* EST_QUIET_INIT_2                    */
        { "\x1B\x58\x01\xFF\x0D\x1B\x55\x00\x1B\x46\x1B\x48",
          12, 0x0000 },

                                       /* EST_QUIET_INIT_3                    */
        { "\x1B\x54\x1B\x5F\x00\x1B\x2D\x00",
          8, 0x0000 },

                                       /* EST_SET_VERTICAL_UNITS              */
                                       /* Command  : ESC [ \ 4 0              */
                                       /*                Lt Ht Lg Hg          */
        { "\x1B\x5B\x5C\x04\x00\x48\x00\x00\x00",
          9, 0x0080 },

                                       /* EST_SET_T_LINE_SPACING              */
                                       /* Command  : ESC A n Esc 2            */
        { "\x1B\x41\x00\x1B\x32",
          5, 0x0004 },

                                       /* EST_SET_G_LINE_SPACING              */
                                       /* Command  : ESC 3 n                  */
        { "\x1B\x33\x00",
          3, 0x0004 },

                                       /* EST_SET_PAGE_LENGTH                 */
                                       /* Command  : ESC C length             */
        { "\x1B\x43\x00",
          3, 0x0004 },

                                       /* EST_VARIABLE_LINE_FEED              */
                                       /* Command  : ESC J n                  */
        { "\x1B\x4A\x00",
          3, 0x0004 },

                                       /* EST_NORMAL_DENSITY                  */
                                       /* EST_GRAPHICS_MODE_0                 */
                                       /* Command  : ESC K n1 n2              */
        { "\x1B\x4B\x00\x00",
          4, 0x000C },

                                       /* EST_DUAL_DENSITY_HALF_SPEED         */
                                       /* EST_GRAPHICS_MODE_1                 */
                                       /* Command  : ESC L n1 n2              */
        { "\x1B\x4C\x00\x00",
          4, 0x000C },

                                       /* EST_HIGH_DENSITY                    */
                                       /* EST_GRAPHICS_MODE_3                 */
                                       /* Command  : ESC Z n1 n2              */
        { "\x1B\x5A\x00\x00",
          4, 0x000C },

                                       /* EST_HIGH_RESOLUTION_A               */
                                       /* EST_GRAPHICS_MODE_8                 */
                                       /* Command  : ESC [ g n1 n2 8          */
        { "\x1B\x5B\x67\x01\x01\x08",
          6, 0x0018 },

                                       /* EST_HIGH_RESOLUTION_B               */
                                       /* EST_GRAPHICS_MODE_9                 */
                                       /* Command  : ESC [ g n1 n2 9          */
        { "\x1B\x5B\x67\x01\x01\x09",
          6, 0x0018 },

                                       /* EST_HIGH_RESOLUTION_C               */
                                       /* EST_GRAPHICS_MODE_10                */
                                       /* Command  : ESC [ g n1 n2 10         */
        { "\x1B\x5B\x67\x01\x01\x0A",
          6, 0x0018 },

                                       /* EST_HIGH_RESOLUTION_D               */
                                       /* EST_GRAPHICS_MODE_11                */
                                       /* Command  : ESC [ g n1 n2 11         */
        { "\x1B\x5B\x67\x01\x01\x0B",
          6, 0x0018 },

                                       /* EST_HIGH_RESOLUTION_E               */
                                       /* EST_GRAPHICS_MODE_12                */
                                       /* Command  : ESC [ g n1 n2 12         */
        { "\x1B\x5B\x67\x01\x01\x0C",
          6, 0x0018 },

                                       /* EST_SET_ASPECT_RATIO                */
                                       /* Command  : ESC n ratio              */
        { "\x1B\x6E\x00",
          3, 0x0004 },

                                       /* EST_DOWNLOAD_FONT                   */
                                       /* Command  : ESC = n1 n2              */
        { "\x1B\x3D\x03\x00\x31\x08\x00",
          7, 0x0040 },

                                       /* EST_SELECT_FONT                     */
                                       /* Command  : ESC I n                  */
        { "\x1B\x49\x00",
          3, 0x0004 },

                                       /* EST_PRINT_TEXT                      */
                                       /* Command  : ESC \ n 0                */
        { "\x1B\x5C\x00\x00",
          4, 0x0004 },

                                       /* EST_MOVE_RIGHT                      */
                                       /* Command  : ESC d Ln Hn              */
        { "\x1B\x64\x00\x00",
          4, 0x000C },

                                       /* EST_CR_THEN_MOVE_RIGHT              */
                                       /* Command  : CR ESC e Ln Hn           */
        { "\x0D\x1B\x64\x00\00",
          5, 0x0018 },

                                       /* EST_MOVE_LEFT                       */
                                       /* Command  : ESC e Ln Hn              */
        { "\x1B\x65\x00\00",
          4, 0x000C },

                                       /* EST_10_CPI                          */
                                       /* Command  : DC2                      */
        { "\x12",
          1, 0x0000 },

                                       /* EST_12_CPI                          */
                                       /* Command  : ESC :                    */
        { "\x1B\x3A",
          2, 0x0000 },

                                       /* EST_15_CPI (on 4224)                */
                                       /* EST_17_CPI (on ProPrinters)         */
                                       /* Command  : SI                       */
        { "\x0F",
          1, 0x0000 },

                                       /* EST_20_CPI                          */
                                       /* Command  : ESC : SI                 */
        { "\x1B\x3A\x0F",
          3, 0x0000 },

                                       /* EST_PROP_SPACING_ON                 */
                                       /* Command  : ESC P 1                  */
        { "\x1B\x50\x01",
          3, 0x0000 },

                                       /* EST_PROP_SPACING_OFF                */
                                       /* Command  : ESC P 0                  */
        { "\x1B\x50\x00",
          3, 0x0000 },

                                       /* EST_D_WIDE_ON                       */
                                       /* Command  : ESC W 1                  */
        { "\x1B\x57\x01",
          3, 0x0000 },

                                       /* EST_D_WIDE_OFF                      */
                                       /* Command  : ESC W 0                  */
        { "\x1B\x57\x00",
          3, 0x0000 },

                                       /* EST_D_HIGH_ON                       */
                                       /* Command  : ESC [ @ 4 0 0 0          */
                                       /*                0x22 0               */
        { "\x1B\x5B\x40\x04\x00\x00\x00\x22\x00",
          9, 0x0000 },

                                       /* EST_D_HIGH_OFF                      */
                                       /* Command  : ESC [ @ 4 0 0 0          */
                                       /*                0x11 0               */
        { "\x1B\x5B\x40\x04\x00\x00\x00\x11\x00",
          9, 0x0000 },

                                       /* EST_D_WIDE_HIGH_ON                  */
                                       /* Command  : ESC [ @ 4 0 0 0          */
                                       /*                0x22 2               */
        { "\x1B\x5B\x40\x04\x00\x00\x00\x22\x02",
          9, 0x0000 },

                                       /* EST_D_WIDE_HIGH_OFF                 */
                                       /* Command  : ESC [ @ 4 0 0 0          */
                                       /*                0x11 1               */
        { "\x1B\x5B\x40\x04\x00\x00\x00\x11\x01",
          9, 0x0000 },

                                       /* EST_UNDERSCORE_ON                   */
                                       /* Command  : ESC - 1                  */
        { "\x1B\x2D\x01",
          3, 0x0000 },

                                       /* EST_UNDERSCORE_OFF                  */
                                       /* Command  : ESC - 0                  */
        { "\x1B\x2D\x00",
          3, 0x0000 },

                                       /* EST_BOLD_ON                         */
                                       /* Command  : ESC E                    */
        { "\x1B\x45",
          2, 0x0000 },

                                       /* EST_BOLD_OFF                        */
                                       /* Command  : ESC F                    */
        { "\x1B\x46",
          2, 0x0000 },

                                       /* EST_BOLD_D_WIDE_ON                  */
                                       /* Command  : ESC E ESC W 1            */
        { "\x1B\x45\x1B\x57\x01",
          5, 0x0000 },

                                       /* EST_BOLD_D_WIDE_OFF                 */
                                       /* Command  : ESC F ESC W 0            */
        { "\x1B\x46\x1B\x57\x00",
          5, 0x0000 },

                                       /* EST_BOLD_D_HIGH_ON                  */
                                       /* Command  : ESC E                    */
                                       /*  ESC [ @ 4 0 0 0 0x22 0             */
        { "\x1B\x45\x1B\x5B\x40\x04\x00\x00\x00\x22\x00",
          11, 0x0000 },

                                       /* EST_BOLD_D_HIGH_OFF                 */
                                       /* Command  : ESC F                    */
                                       /*  ESC [ @ 4 0 0 0 0x11 0             */
        { "\x1B\x46\x1B\x5B\x40\x04\x00\x00\x00\x11\x00",
          11, 0x0000 },

                                       /* EST_BOLD_D_WIDE_HIGH_ON             */
                                       /* Command  : ESC E                    */
                                       /*  ESC [ @ 4 0 0 0 0x22 2             */
        { "\x1B\x45\x1B\x5B\x40\x04\x00\x00\x00\x22\x02",
          11, 0x0000 },

                                       /* EST_BOLD_D_WIDE_HIGH_OFF            */
                                       /* Command  : ESC F                    */
                                       /*  ESC [ @ 4 0 0 0 0x11 1             */
        { "\x1B\x46\x1B\x5B\x40\x04\x00\x00\x00\x11\x01",
          11, 0x0000 },

                                       /* EST_BOLD_UNDERSCORE_ON              */
                                       /* Command  : ESC E ESC - 1            */
        { "\x1B\x45\x1B\x2D\x01",
          5, 0x0000 },

                                       /* EST_BOLD_UNDERSCORE_OFF             */
                                       /* Command  : ESC F ESC - 0            */
        { "\x1B\x46\x1B\x2D\x00",
          5, 0x0000 },

                                       /* EST_D_STRIKE_D_WIDE_ON              */
                                       /* Command  : ESC G ESC W 1            */
        { "\x1B\x47\x1B\x57\x01",
          5, 0x0000 },

                                       /* EST_D_STRIKE_D_WIDE_OFF             */
                                       /* Command  : ESC H ESC W 0            */
        { "\x1B\x48\x1B\x57\x00",
          5, 0x0000 },

                                       /* EST_D_STRIKE_UNDERSCORE_ON          */
                                       /* Command  : ESC G ESC - 1            */
        { "\x1B\x47\x1B\x2D\x01",
          5, 0x0000 },

                                       /* EST_D_STRIKE_UNDERSCORE_OFF         */
                                       /* Command  : ESC F ESC - 0            */
        { "\x1B\x48\x1B\x2D\x00",
          5, 0x0000 },

                                       /* EST_DRAFT_MODE                      */
                                       /* Command  : ESC I 1                  */
        { "\x1B\x49\x01",
          3, 0x0000 },

                                       /* EST_QUALITY_MODE                    */
                                       /* Command  : ESC I 2                  */
        { "\x1B\x49\x02",
          3, 0x0000 },

                                       /* EST_ENHANCED_MODE                   */
                                       /* Command  : ESC I 3                  */
        { "\x1B\x49\x03",
          3, 0x0000 },

                                       /* EST_SELECT_SOURCE                   */
                                       /* Command : ESC [ F 3 0               */
                                       /*               pft fc sd             */
        { "\x1B\x5B\x46\x04\x00\x00\x00\x00\x40",
          9, 0x00E0 },

                                       /* EST_SIC_PRO_X24                     */
                                       /* Command  : ESC [ K n1 n2 init       */
                                       /*            id parm1                 */
                                       /* Note that this leaves the           */
                                       /* download area alone                 */
                                       /* Slip in a Set Char Set 2 here       */
                                       /*  (to fix Ohio     PQ00571)          */
        { "\x1B\x5B\x4B\x03\x00\x00\x16\x21\x1B\x36",
          10, 0x0000 },

                                       /* EST_SIC_SET_MODE                    */
                                       /* Command  : ESC [ K n1 n2 mode       */
                                       /*            ESC 6                    */
                                       /* Slip in a Set Char Set 2 here       */
                                       /* as in other init sequences          */
        { "\x1B\x5B\x4B\x01\x00\x00\x1B\x36",
          8, 0x0000 },

                                       /* EST_SIC_INIT_CODE_PAGE_850          */
                                       /* Command  : ESC [ K n1 n2 init       */
                                       /*            id parm1 parm2           */
        { "\x1B\x5B\x4B\x04\x00\x01\x16\x80\x40",
          9, 0x0000 },

                                       /* EST_SET_CODE_PAGE                   */
                                       /* Command  : ESC [ T n1 n2            */
                                       /*            cpidhigh cpidlow         */
        { "\x1B\x5B\x54\x04\x00\x00\x00\x00\x00",
          9, 0x0180 },

                                       /* EST_SET_CODE_PAGE_4224              */
                                       /* Command  : ESC [ Z n1 n2 init       */
                                       /*            id parm1 parm2           */
        { "\x1B\x5B\x5A\x05\x00\x00\x00\x00\x00\x00",
          10, 0x0380 },

                                       /* EST_INIT_LOCAL_FONT                 */
        { "\x1B\x5B\x59\x03\x00\x00\x00\x00",
           8, 0x00E0 },

                                       /* EST_SET_FORE_COLOR                  */
                                       /* Command  : ESC [ M 01 00 Col        */
        { "\x1B\x5B\x4D\x01\x00\x00",
          6, 0x0020 },

                                       /* EST_SEL_OCR_A_876                   */
                                       /* Command  : ESC I 0x12               */
        { "\x1B\x49\x12",
          3, 0x0000 },

                                       /* EST_SEL_OCR_B_877                   */
                                       /* Command  : ESC I 0x13               */
        { "\x1B\x49\x13",
          3, 0x0000 },

                                       /* EST_SPH_SET_ITALIC                  */
                                       /* Command  : ESC [ A n1 n2            */
                                       /*            mode                     */
        { "\x1B\x5B\x40\x01\x00\x01",
           6, 0x0000 },

                                       /* EST_SPH_RESET_ITALIC                */
                                       /* Command  : ESC [ A n1 n2            */
                                       /*            mode                     */
        { "\x1B\x5B\x40\x01\x00\x03",
           6, 0x0000 },

                                       /* EST_SPH_SET_ITALIC_15               */
                                       /* Command  : SI                       */
                                       /*            ESC [ A n1 n2            */
                                       /*            mode                     */
        { "\x0F\x1B\x5B\x40\x01\x00\x01",
           7, 0x0000 },

                                       /* EST_SPH_SET_ITALIC_12               */
                                       /* Command  : ESC :                    */
                                       /*            ESC [ A n1 n2            */
                                       /*            mode                     */
        { "\x1B\x3A\x1B\x5B\x40\x01\x00\x01",
           8, 0x0000 },

                                       /* EST_SPH_RESET_ITALIC_10             */
                                       /* Command  : DC2                      */
                                       /*            ESC [ A n1 n2            */
                                       /*            mode                     */
        { "\x12\x1B\x5B\x40\x01\x00\x03",
           7, 0x0000 },

                                       /* EST_SET_ORIENTATION                 */
                                       /* Command  : ESC orientation          */
        { "\x1B\x00",
           2, 0x0002 },

                                       /* EST_SET_FONT_GLOBAL_3816            */
                                       /* Command  : ESC [ I n1 n2            */
                                       /*         FGIDhigh  FGIDlow           */
                                       /*         FShigh  FSlow  SM           */
                                       /*         CPGIDhigh  CPIDlow          */
        { "\x1B\x5B\x49\x07\x00\x00\x00\x00\x00\x00\x00\x00",
           12, 0x0FE0 },

                                       /* EST_DEL_LOCAL_FONTS                 */
        { "\x1B\x5B\x5B\x01\x00\xFF",
           6, 0x0000 },

                                       /* EST_D_STRIKE_ON                     */
                                       /* Command  : ESC G                    */
        { "\x1B\x47",
          2, 0x0000 },

                                       /* EST_D_STRIKE_OFF                    */
                                       /* Command  : ESC F                    */
        { "\x1B\x48",
           2, 0x0000 },

                                       /* EST_SIC_3816_SIMPLEX                */
                                       /* Command  : ESC [ K n1 n2 mode       */
                                       /*            ESC 6                    */
                                       /* Slip in a Set Char Set 2 here       */
                                       /* as in other init sequences          */
        { "\x1B\x5B\x4B\x04\x00\x00\x34\x80\x08\x1B\x36",
          11, 0x0000 },

                                       /* EST_SIC_3816_DUPLEX                 */
                                       /* Command  : ESC [ K n1 n2 mode       */
                                       /*            34 ignored duplex        */
                                       /*            ESC 6                    */
                                       /* Slip in a Set Char Set 2 here       */
                                       /* as in other init sequences          */
        { "\x1B\x5B\x4B\x04\x00\x00\x34\x80\x00\x1B\x36",
          11, 0x0100 },

                                       /* EST_NUL_SACRIFICE                   */
                                       /* Command  : NUL NUL NUL NUL          */
        { "\x00\x00\x00\x00",
          4, 0x0000 },

                                       /* EST_MARGINS                         */
                                       /* Command  : ESC X n m                */
        { "\x1B\x58\x01\x00",
          4, 0x0008  },

                                       /* EST_DUMMY_DOWNLOAD                  */
                                       /* Command  : ESC = 1 0 15 ESC         */
                                       /*            = 0 0                    */
        { "\x1B\x3D\x01\x00\x15\x1B\x3D\x00\x00",
          9, 0x0000 },

        /**********************************************************************/
        /*  PD00432 : Changed SIC to handle the termination of a PostScript   */
        /*  job.                                                              */
        /**********************************************************************/
                                       /* EST_SIC_4019                        */
                                       /* Command  : ESC [ K n1 n2            */
                                       /*      mode  pid dsm                  */
        { "\x1B\x5B\x4B\x18\x00\x00\x31\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x1B\x5B\x4B\x03\x00\x00\x31\x01",
          29, 0x0000 },

                                       /* EST_SELECT_SOURCE_FORM              */
                                       /* Command : ESC [ F 3 0               */
                                       /*               pft fc sd             */
        { "\x1B\x5B\x46\x04\x00\x00\x00\x00\x00",
          9, 0x01E0 },

                                       /* EST_MOVE_SCP                        */
                                       /* Command : ESC [ Q 6 0 1 4           */
                                       /*     HHoriz LHoriz HVert LVert       */
        { "\x1B\x5B\x51\x06\x00\x01\x04\x00\x00\x00\x00",
          11, 0x0780 },

                                       /* EST_RIG                             */
                                       /* Command : ESC [ h Ln Hn 8           */
                                       /* HRes VRes BlockF Write              */
                                       /* Compress n1...nk                    */
        { "\x1B\x5B\x68\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00",
          14, 0x3FD8 },

                                       /* EST_DLF                             */
                                       /* Command : ESC = 3 0 PrId            */
                                       /*           Command FontId            */
        { "\x1B\x3D\x03\x00\x00\x00\x00",
          7, 0x0070 },

                                       /* EST_SET_FONT_GLOBAL_4019            */
                                       /* Command  : ESC [ I n1 n2            */
                                       /*        FGIDhigh  FGIDlow            */
                                       /*        FShigh  FSlow  FA  ST        */
                                       /*        CPGIDhigh  CPIDlow           */
        { "\x1B\x5B\x49\x08\x00\x00\x00\x00\x00\x00\x01\x00\x00",
           13, 0x1BE0 },

        /**********************************************************************/
        /*  PD00155 : Added Shear angle to EST_FSC_FGID_PART_3 string so      */
        /*  increase the command length from 32 to 36 bytes.                  */
        /**********************************************************************/
                                       /* NOTE: the FSC_FGID selects          */
                                       /* by fgid only - plus shear           */
                                       /* EST_FSC_FGID_PART_1                 */
                                       /* Command  : ESC [ Z Ln Hn            */
                                       /*        BF S 8 2 CPIDHigh            */
                                       /*        CPIDlow  10 1 Escape         */
        { "\x1B\x5B\x5A\x24\x00\x01\x84\x08\x02\x00\x00\x0A\x01\x00",
           14, 0x2600 },

                                       /* EST_FSC_FGID_PART_2                 */
                                       /* Command  :  20 2 FGIDhigh           */
                                       /*        FGIDlow 11 7 NVFS[7]         */
        { "\x14\x02\x00\x00\x0B\x07\x00\x00\x00\x00\x00\x00\x00",
           13, 0x1FCC },

        /**********************************************************************/
        /*  PD00155 : Added Posture (Shear) angle to this string.             */
        /**********************************************************************/
                                       /* EST_FSC_FGID_PART_3                 */
                                       /* Command  :  14  8 NHFSType          */
                                       /*        NHFS[7] 25 2 Shear[2]        */
        { "\x0E\x08\x31\x00\x00\x00\x00\x00\x00\x00\x19\x02\x00\x00",
           14, 0x33F8 },

                                       /* EST_SIC_4019_END                    */
                                       /* Command  :    ESC [ K n1 n2         */
                                       /*      mode  pid dsm                  */
        { "\x1B\x5B\x4B\x03\x00\x00\x31\x00",
          8, 0x0000 },

                                       /* EST_SELECT_ITALIC                   */
                                       /* Command  : ESC [ A n1 n2            */
                                       /*            mode                     */
        { "\x1B\x5B\x40\x01\x00\x00",
           6, 0x0020 },

                                       /* EST_SELECT_SOURCE_DUPLEX            */
                                       /* Command : ESC [ F 3 0               */
                                       /*               pft fc sd             */
                                       /*               size copies fit       */
                                       /*               duplex                */
        { "\x1B\x5B\x46\x07\x00\x00\x00\x00\x00\x00\x00\x00",
          12, 0x09E0 },

                                       /* EST_RF                              */
                                       /* Command  : ESC [ i Ln Hn U          */
                                       /*        W Hw Lw Hh Lh T D            */
        { "\x1B\x5B\x69\x08\x00\x01\x01\x00\x00\x00\x00\x01\x00",
           13, 0x0780 },

        /**********************************************************************/
        /*  PD00155 : The following FSC_SHEAR command in NOT used since the   */
        /*  posture/shear angle is included in the FSC_FGID command above.    */
        /*  This command is left here just in case it is needed in the future.*/
        /**********************************************************************/
                                       /* NOTE: the FSC_SHEAR selects         */
                                       /* by familyname, widthclass,          */
                                       /* weightclass, shear.                 */
                                       /* EST_FSC_SHEAR_PART_1                */
                                       /* Command  : ESC [ Z Ln Hn            */
                                       /*        BF S 8 2 CPIDHigh            */
                                       /*        CPIDlow  10 1 Escape         */
        { "\x1B\x5B\x5A\x00\x00\x01\x84\x08\x02\x00\x00\x0A\x01\x00",
           14, 0x2618 },

                                       /* EST_FSC_SHEAR_PART_2                */
                                       /* Command  : 27 1 WeightClass         */
                                       /*            28 1 WidthClass          */
                                       /*            23 Ln (FamilyName)       */
        { "\x1B\x01\x00\x1C\x01\x00\x17\x00",
           8, 0x00A4 },

                                       /* EST_FSC_SHEAR_PART_3                */
                                       /* Command  :  11 7 NVFS[7]            */
        { "\x0B\x07\x00\x00\x00\x00\x00\x00\x00",
           9, 0x01FC },

                                       /* EST_FSC_SHEAR_PART_4                */
                                       /* Command  :  14  8 NHFSType          */
                                       /*        NHFS[7] Shear[2]             */
        { "\x0E\x08\x31\x00\x00\x00\x00\x00\x00\x00\x19\x02\x00\x00",
           14, 0x33F8 },

                                       /* EST_SELECT_PRINT_ANGLE              */
                                       /* Command  :  ESC [ y Ln Hn           */
                                       /*             AngleH AngleL np        */
        { "\x1B\x5B\x79\x03\x00\x00\x00\x00",
           8, 0x0060 },

                                       /* DIAL/NILE :                         */
                                       /* EST_SET_FONT_GLOBAL_NT              */
                                       /* DIAL/NILE :                         */
                                       /* Command  : ESC [ i n1 n2            */
                                       /*    Hf Lf Hs Ls Sm 00 Hc Lc          */
        {  "\x1B\x5B\x49\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00",
           13, 0x1BE0 },

                                       /* DIAL/NILE :                         */
                                       /* EST_NT_FAST_DRAFT                   */
                                       /* Command  : ESC [ d 01               */
        {  "\x1B\x5B\x64\x01\x00\x01",
           6, 0x0000 },

                                       /* DIAL/NILE :                         */
                                       /* EST_NT_DRAFT                        */
                                       /* Command  : ESC [ d 64               */
        {  "\x1B\x5B\x64\x01\x00\x40",
           6, 0x0000 },

                                       /* DIAL/NILE :                         */
                                       /* EST_NT_LQ                           */
                                       /* Command  : ESC [ d 128              */
        {  "\x1B\x5B\x64\x01\x00\x80",
           6, 0x0000 },

                                       /* DIAL/NILE :                         */
                                       /* EST_BEGIN_NT_SIC                    */
                                       /* Command  : ESC [ K  03              */
                                       /*            00 00 B6 01              */
                                       /* Switch into PPDS                    */
        {  "\x1B\x5B\x4B\x03\x00\x00\xB6\x01",
           8, 0x0000 },

                                       /* PD00222 :                           */
                                       /* EST_BEGIN_NT_SIC_2                  */
                                       /* Command  : ESC [ K 03 00 00         */
                                       /*            16 21                    */
                                       /* Set up required stuff like          */
                                       /* form length and char set            */
                                       /*            ESC 6                    */
                                       /* Slip in a Set Char Set 2 here       */
                                       /*  (to fix Ohio     PQ00571)          */
                                       /* PD00387: change to user             */
                                       /* defaults as factory defaults        */
                                       /* turn off the sheet feed             */
        { "\x1B\x5B\x4B\x03\x00\x00\x16\x21\x1B\x36",
          10, 0x0000 },

                                       /* DIAL/NILE :                         */
                                       /* EST_END_NT_SIC                      */
                                       /* Command  : ESC [ K  03              */
                                       /*            00 00 B6 00              */
                                       /* Switch back to user-defaults        */
        {  "\x1B\x5B\x4B\x03\x00\x00\xB6\x00",
           8, 0x0000 },

                                       /* PD00556 : Change control byte to    */
                                       /* 0x0180 so that Hg will be merged for*/
                                       /* 360x360                             */
                                       /* EST_SET_NT_VERTICAL_UNITS           */
                                       /* Command  : ESC [ \ 4 0              */
                                       /*                0 0 Lg Hg            */
        { "\x1B\x5B\x5C\x04\x00\x00\x00\x00\x00",
          9, 0x0180 },

                                       /* DIAL/NILE :      PD00333            */
                                       /* EST_SET_FONT_GOTHIC_10              */
                                       /* DIAL/NILE :                         */
                                       /* Command  : ESC [ i n1 n2            */
                                       /*    Hf Lf Hs Ls Sm 00 Hc Lc          */
        {  "\x1B\x5B\x49\x08\x00\x00\x24\x00\x90\x01\x00\x01\xB5",
           13, 0x0000 },

                                       /* DIAL/NILE :      PD00537            */
                                       /* EST_SET_NT_DRAFT_HORZ_SP            */
                                       /* DIAL/NILE :                         */
                                       /* Command  : ESC [ d 128 ESC [ i      */
                                       /*    n1 n2 Hf Lf Hs Ls Sm 00 Hc Lc    */
        {  "\x1B\x5B\x64\x01\x00\x80\x1B\x5B\x49\x08\x00\x00\x24\x00\x90\x01\x00\x01\xB5",
           19, 0x0000 },

                                       /* INKJET : 360 x 360 resolution       */
                                       /* EST_HIGH_RESOLUTION_F               */
                                       /* EST_GRAPHICS_MODE_16                */
                                       /* Command  : ESC [ g n1 n2 16         */
        { "\x1B\x5B\x67\x01\x01\x10",
          6, 0x0018 },

                                       /* INKJET :                            */
                                       /* EST_FONT_LQ_GOTHIC_10               */
                                       /* Command  : ESC [ i n1 n2            */
                                       /*    Hf Lf Hs Ls Sm 00 Hc Lc Esc [ d  */
                                       /*    128                              */
        {  "\x1B\x5B\x49\x08\x00\x00\x24\x00\x90\x01\x00\x01\xB5\x1B\x5B\x64\x01\x00\x00",
           19, 0x0000 },

                                       /* EST_MOVE_SCP_600_DPI                */
                                       /* Command : ESC [ Q 6 0 1 2           */
                                       /*     HHoriz LHoriz HVert LVert       */
        { "\x1B\x5B\x51\x06\x00\x01\x02\x00\x00\x00\x00",
          11, 0x0780 },

                                       /* EST_RF_600_DPI                      */
                                       /* Command  : ESC [ i Ln Hn U          */
                                       /*        W Hw Lw Hh Lh T D            */
        { "\x1B\x5B\x69\x08\x00\x04\x01\x00\x00\x00\x00\x06\x00",
           13, 0x0780 },

   };

/******************************************************************************/
/*  Attribute Table - needs to correspond to list in PRDTCONE.H               */
/******************************************************************************/
AttTableType  AttTable [] =
    {
        { EST_NULL,
          EST_NULL },                /* FATT_NONE                           */

        { EST_D_WIDE_ON,
          EST_D_WIDE_OFF },

        { EST_D_HIGH_ON,
          EST_D_HIGH_OFF },

        { EST_D_WIDE_HIGH_ON,
          EST_D_WIDE_HIGH_OFF },

        { EST_BOLD_ON,
          EST_BOLD_OFF },

        { EST_UNDERSCORE_ON,
          EST_UNDERSCORE_OFF },

        { EST_BOLD_D_WIDE_ON,
          EST_BOLD_D_WIDE_OFF },

        { EST_BOLD_D_HIGH_ON,
          EST_BOLD_D_HIGH_OFF },

        { EST_BOLD_D_WIDE_HIGH_ON,
          EST_BOLD_D_WIDE_HIGH_OFF },

        { EST_BOLD_UNDERSCORE_ON,
          EST_BOLD_UNDERSCORE_OFF },

        { EST_D_STRIKE_D_WIDE_ON,
          EST_D_STRIKE_D_WIDE_OFF },

        { EST_D_STRIKE_UNDERSCORE_ON,
          EST_D_STRIKE_UNDERSCORE_OFF },

        { EST_D_STRIKE_ON,
          EST_D_STRIKE_OFF }
    };
