/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDDCPGE
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION  Printer Device Driver Code Page Tables
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


/**********************************************************************/
/* Code Page List.                                                    */
/**********************************************************************/
DVTCPListType  DVTCodePageList[] =
    {
        { 437, IDS_CODE_PAGE_437 },
        { 850, IDS_CODE_PAGE_850 },
        { 851, IDS_CODE_PAGE_851 },
        { 852, IDS_CODE_PAGE_852 },
        { 853, IDS_CODE_PAGE_853 },
        { 855, IDS_CODE_PAGE_855 },
        { 862, IDS_CODE_PAGE_862 },
        { 863, IDS_CODE_PAGE_863 },
        { 864, IDS_CODE_PAGE_864 }
    };

/**********************************************************************/
/* Code Page Binary File Names.                                       */
/**********************************************************************/
#define Rid850ProII     (PSZ)IDR_850_BIN_PRO_II
#define Sze850ProII     (lpNLSDiskPair)3058

#define Rid850ProIII    (PSZ)IDR_850_BIN_PRO_III
#define Sze850ProIII    (lpNLSDiskPair)2345
/*#define Sze850ProIII    (lpNLSDiskPair)5403*/

#define Rid850ProX24    (PSZ)IDR_850_BIN_PRO_X24
#define Sze850ProX24    (lpNLSDiskPair)11920

#define BIN851ProII     (PSZ)"DLQ2851"
#define BIN852ProII     (PSZ)"DLQ2852"
#define BIN853ProII     (PSZ)"DLQ2853"
#define BIN855ProII     (PSZ)"DLQ2855"
#define BIN862ProII     (PSZ)"DLQ2862"
#define BIN864ProII     (PSZ)"DLQ2864"

#define BIN851ProIII    (PSZ)"DPQ2851"
#define BIN852ProIII    (PSZ)"DPQ2852"
#define BIN853ProIII    (PSZ)"DPQ2853"
#define BIN855ProIII    (PSZ)"DPQ2855"
#define BIN862ProIII    (PSZ)"DPQ2862"
#define BIN864ProIII    (PSZ)"DPQ2864"

#define BIN000ProX24E   (PSZ)"DL4208A"

/**********************************************************************/
/* Code Page NLS Character Supplement Diskette Names for 3 1/2        */
/* (crispyies) and 5 1/4 (floppies).                                  */
/**********************************************************************/
NLSDiskPairType  NLS851ProIII  = { (PSZ)"23F5222", (PSZ)"23F5218" };
NLSDiskPairType  NLS852ProIII  = { (PSZ)"23F5231", (PSZ)"23F5227" };
NLSDiskPairType  NLS853ProIII  = { (PSZ)"23F5240", (PSZ)"23F5236" };
NLSDiskPairType  NLS855ProIII  = { (PSZ)"23F5249", (PSZ)"23F5245" };
NLSDiskPairType  NLS862ProIII  = { (PSZ)"94X6189", (PSZ)"6934705" };
NLSDiskPairType  NLS864ProIII  = { (PSZ)"94X6190", (PSZ)"6934706" };

NLSDiskPairType  NLS851ProX24E  = { (PSZ)"88X8791", (PSZ)"88X8783" };
NLSDiskPairType  NLS852ProX24E  = { (PSZ)"23F5260", (PSZ)"23F5256" };
NLSDiskPairType  NLS853ProX24E  = { (PSZ)"88X8792", (PSZ)"88X8784" };
NLSDiskPairType  NLS855ProX24E  = { (PSZ)"88X8793", (PSZ)"88X8785" };
NLSDiskPairType  NLS862ProX24E  = { (PSZ)"88X8794", (PSZ)"88X8786" };
NLSDiskPairType  NLS863ProX24E  = { (PSZ)"88X8850", (PSZ)"88X8849" };
NLSDiskPairType  NLS864ProX24E  = { (PSZ)"88X8795", (PSZ)"88X8787" };

/**********************************************************************/
/* Code Page Capabities Array.                                        */
/**********************************************************************/
DVTCPSourceType  DVTCodePageCapsProII [] =
    {
        {         NULL,          NULL, CP_RESIDENT  },     /*  437  */
        {   Rid850ProII,    Sze850ProII, CP_RESOURCE  },     /*  850  */
        {   BIN851ProII,  &NLS851ProIII, CP_DOWNLOAD  },     /*  851  */
        {   BIN852ProII,  &NLS852ProIII, CP_DOWNLOAD  },     /*  852  */
        {   BIN853ProII,  &NLS853ProIII, CP_DOWNLOAD  },     /*  853  */
        {   BIN855ProII,  &NLS855ProIII, CP_DOWNLOAD  },     /*  855  */
        {   BIN862ProII,  &NLS862ProIII, CP_DOWNLOAD  },     /*  862  */
        {         NULL,          NULL, CP_NOT_AVAIL },     /*  863  */
        {   BIN864ProII,  &NLS864ProIII, CP_DOWNLOAD  }      /*  864  */
    };

DVTCPSourceType  DVTCodePageCapsProIII [] =
    {
        {         NULL,          NULL, CP_RESIDENT  },     /*  437  */
        {  Rid850ProIII,   Sze850ProIII, CP_RESOURCE  },     /*  850  */
        {  BIN851ProIII,  &NLS851ProIII, CP_DOWNLOAD  },     /*  851  */
        {  BIN852ProIII,  &NLS852ProIII, CP_DOWNLOAD  },     /*  852  */
        {  BIN853ProIII,  &NLS853ProIII, CP_DOWNLOAD  },     /*  853  */
        {  BIN855ProIII,  &NLS855ProIII, CP_DOWNLOAD  },     /*  855  */
        {  BIN862ProIII,  &NLS862ProIII, CP_DOWNLOAD  },     /*  862  */
        {         NULL,          NULL, CP_NOT_AVAIL },     /*  863  */
        {  BIN864ProIII,  &NLS864ProIII, CP_DOWNLOAD  }      /*  864  */
    };

DVTCPSourceType  DVTCodePageCapsProX24 [] =
    {
        {         NULL,          NULL, CP_RESIDENT  },     /*  437  */
        {  Rid850ProX24,   Sze850ProX24, CP_RESOURCE  },     /*  850  */
        { BIN000ProX24E, &NLS851ProX24E, CP_DOWNLOAD  },     /*  851  */
        { BIN000ProX24E, &NLS852ProX24E, CP_DOWNLOAD  },     /*  852  */
        { BIN000ProX24E, &NLS853ProX24E, CP_DOWNLOAD  },     /*  853  */
        { BIN000ProX24E, &NLS855ProX24E, CP_DOWNLOAD  },     /*  855  */
        { BIN000ProX24E, &NLS862ProX24E, CP_DOWNLOAD  },     /*  862  */
        { BIN000ProX24E, &NLS863ProX24E, CP_DOWNLOAD  },     /*  863  */
        { BIN000ProX24E, &NLS864ProX24E, CP_DOWNLOAD  }      /*  864  */
    };

DVTCPSourceType  DVTCodePageCapsProX24E [] =
    {
        {         NULL,          NULL, CP_RESIDENT  },     /*  437  */
        {         NULL,          NULL, CP_RESIDENT  },     /*  850  */
        { BIN000ProX24E, &NLS851ProX24E, CP_DOWNLOAD  },     /*  851  */
        { BIN000ProX24E, &NLS852ProX24E, CP_DOWNLOAD  },     /*  852  */
        { BIN000ProX24E, &NLS853ProX24E, CP_DOWNLOAD  },     /*  853  */
        { BIN000ProX24E, &NLS855ProX24E, CP_DOWNLOAD  },     /*  855  */
        { BIN000ProX24E, &NLS862ProX24E, CP_DOWNLOAD  },     /*  862  */
        { BIN000ProX24E, &NLS863ProX24E, CP_DOWNLOAD  },     /*  863  */
        { BIN000ProX24E, &NLS864ProX24E, CP_DOWNLOAD  }      /*  864  */
    };

DVTCPSourceType  DVTCodePageCaps4224 [] =
    {
        {  NULL,  NULL, CP_RESIDENT  },                    /*  437  */
        {  NULL,  NULL, CP_RESIDENT  },                    /*  850  */
        {  NULL,  NULL, CP_NOT_AVAIL },                    /*  851  */
        {  NULL,  NULL, CP_NOT_AVAIL },                    /*  852  */
        {  NULL,  NULL, CP_NOT_AVAIL },                    /*  853  */
        {  NULL,  NULL, CP_NOT_AVAIL },                    /*  855  */
        {  NULL,  NULL, CP_NOT_AVAIL },                    /*  862  */
        {  NULL,  NULL, CP_NOT_AVAIL },                    /*  863  */
        {  NULL,  NULL, CP_NOT_AVAIL }                     /*  864  */
    };

lpDVTCPSource  DVTCodePageCaps [] =
    {
        DVTCodePageCapsProII,         /*  IBM_PRO_PRINTER_I           */
        DVTCodePageCapsProII,         /*  IBM_PRO_PRINTER_II          */
        DVTCodePageCapsProIII,        /*  IBM_PRO_PRINTER_III         */
        DVTCodePageCapsProII,         /*  IBM_PRO_PRINTER_XL          */
        DVTCodePageCapsProII,         /*  IBM_PRO_PRINTER_II_XL       */
        DVTCodePageCapsProIII,        /*  IBM_PRO_PRINTER_III_XL      */
        DVTCodePageCapsProX24,        /*  IBM_PRO_PRINTER_X24         */
        DVTCodePageCapsProX24E,       /*  IBM_PRO_PRINTER_X24E        */
        DVTCodePageCapsProX24,        /*  IBM_PRO_PRINTER_XL24        */
        DVTCodePageCapsProX24E,       /*  IBM_PRO_PRINTER_XL24E       */
        DVTCodePageCaps4224,          /*  IBM_4224_COLOR              */
        DVTCodePageCaps4224           /*  IBM_4224_MONO               */
    };


/**********************************************************************/
/* Code Page fonts for the ProPrinters                                */
/**********************************************************************/
FontCPListType   Draft9SansSerif10CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_10, VALUE_NOT_SET, NULL },
        {          NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_10, VALUE_NOT_SET, NULL },
    };

FontCPListType   Draft9SansSerif12CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_12, VALUE_NOT_SET, NULL },
        {          NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_12, VALUE_NOT_SET, NULL }
    };

FontCPListType   Draft9SansSerif17ProICP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        {          NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL }
    };

FontCPListType   Draft9SansSerif17ProIIICP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL },
        {          NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_17, VALUE_NOT_SET, NULL }
    };

FontCPListType   Draft9SansSerif20CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_DRAFT_20, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_20, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_20, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_20, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_20, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_20, VALUE_NOT_SET, NULL },
        {          NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_DRAFT_20, VALUE_NOT_SET, NULL }
    };

FontCPListType   Draft9SansSerifPSCP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_850_9_DRAFT_PS, VALUE_NOT_SET, NULL },
        { IDR_851_9_DRAFT_PS, VALUE_NOT_SET, NULL },
        { IDR_852_9_DRAFT_PS, VALUE_NOT_SET, NULL },
        { IDR_853_9_DRAFT_PS, VALUE_NOT_SET, NULL },
        { IDR_855_9_DRAFT_PS, VALUE_NOT_SET, NULL },
        { IDR_862_9_DRAFT_PS, VALUE_NOT_SET, NULL },
        {          NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_864_9_DRAFT_PS, VALUE_NOT_SET, NULL }
    };

FontCPListType   Draft24SansSerif10CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_24_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_10, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_10, VALUE_NOT_SET, NULL }
    };

FontCPListType   Draft24SansSerif12CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_24_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_12, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_12, VALUE_NOT_SET, NULL }
    };

FontCPListType   Draft24SansSerif17CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_24_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_17, VALUE_NOT_SET, NULL },
        { IDR_24_DRAFT_17, VALUE_NOT_SET, NULL }
    };

FontCPListType   FastFont12CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_FASTFONT_12, VALUE_NOT_SET, NULL },
        { IDR_9_FASTFONT_12, VALUE_NOT_SET, NULL },
        { IDR_9_FASTFONT_12, VALUE_NOT_SET, NULL },
        { IDR_9_FASTFONT_12, VALUE_NOT_SET, NULL },
        { IDR_9_FASTFONT_12, VALUE_NOT_SET, NULL },
        { IDR_9_FASTFONT_12, VALUE_NOT_SET, NULL },
        {             NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_FASTFONT_12, VALUE_NOT_SET, NULL }
    };

FontCPListType   NLQSansSerif10ProICP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        {        NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL }
    };

FontCPListType   NLQSansSerif10ProIIICP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL },
        {        NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_10, VALUE_NOT_SET, NULL }
    };

FontCPListType   NLQSansSerif12CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_NLQ_12, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_12, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_12, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_12, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_12, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_12, VALUE_NOT_SET, NULL },
        {        NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_NLQ_12, VALUE_NOT_SET, NULL }
    };

FontCPListType   NLQSansSerifPSCP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_850_9_NLQ_PS, VALUE_NOT_SET, NULL },
        { IDR_851_9_NLQ_PS, VALUE_NOT_SET, NULL },
        { IDR_852_9_NLQ_PS, VALUE_NOT_SET, NULL },
        { IDR_853_9_NLQ_PS, VALUE_NOT_SET, NULL },
        { IDR_855_9_NLQ_PS, VALUE_NOT_SET, NULL },
        { IDR_862_9_NLQ_PS, VALUE_NOT_SET, NULL },
        {        NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_864_9_NLQ_PS, VALUE_NOT_SET, NULL }
    };

/******************************************************************************/
/*  PD00420 : Incorrect Font ID type number.  Changed IDR_862_9_NLQII_10 to   */
/*  IDR_9_NLQII_10.                                                           */
/******************************************************************************/
FontCPListType   NLQIISansSerif10CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_NLQII_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_10, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_10, VALUE_NOT_SET, NULL },
        {          NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_10, VALUE_NOT_SET, NULL }
    };

FontCPListType   NLQIISansSerif12CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_NLQII_12, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_12, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_12, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_12, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_12, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_12, VALUE_NOT_SET, NULL },
        {          NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_NLQII_12, VALUE_NOT_SET, NULL }
    };

FontCPListType   Italic10CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_ITALIC_10, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_10, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_10, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_10, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_10, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_10, VALUE_NOT_SET, NULL },
        {           NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_10, VALUE_NOT_SET, NULL }
    };

FontCPListType   Italic12CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_9_ITALIC_12, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_12, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_12, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_12, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_12, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_12, VALUE_NOT_SET, NULL },
        {           NOT_AVAIL, VALUE_NOT_SET, NULL },
        { IDR_9_ITALIC_12, VALUE_NOT_SET, NULL }
    };

FontCPListType   LQCourier10CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_24_LQ_10, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_10, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_10, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_10, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_10, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_10, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_10, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_10, VALUE_NOT_SET, NULL }
    };

FontCPListType   LQCourier12CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_24_LQ_12, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_12, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_12, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_12, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_12, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_12, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_12, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_12, VALUE_NOT_SET, NULL }
    };

FontCPListType   LQCourier17CP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_24_LQ_17, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_17, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_17, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_17, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_17, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_17, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_17, VALUE_NOT_SET, NULL },
        { IDR_24_LQ_17, VALUE_NOT_SET, NULL }
    };

FontCPListType   LQCourierPSCP[NO_OF_ADDABLE_CPS + 1] =
    {
        { IDR_850_24_LQ_PS, VALUE_NOT_SET, NULL },
        { IDR_851_24_LQ_PS, VALUE_NOT_SET, NULL },
        { IDR_852_24_LQ_PS, VALUE_NOT_SET, NULL },
        { IDR_853_24_LQ_PS, VALUE_NOT_SET, NULL },
        { IDR_855_24_LQ_PS, VALUE_NOT_SET, NULL },
        { IDR_862_24_LQ_PS, VALUE_NOT_SET, NULL },
        { IDR_863_24_LQ_PS, VALUE_NOT_SET, NULL },
        { IDR_864_24_LQ_PS, VALUE_NOT_SET, NULL }
    };


/**********************************************************************/
/* DVTFontCPList for ProPrinters.                                     */
/**********************************************************************/
lpFontCPListType   DVTFontCPListProI [] =
    {
        Draft9SansSerif10CP,
        Draft9SansSerif12CP,
        Draft9SansSerif17ProICP,
        NLQSansSerif10ProICP,
        NLQSansSerif12CP
    };

lpFontCPListType   DVTFontCPListProXL [] =
    {
        Draft9SansSerif10CP,
        Draft9SansSerif12CP,
        Draft9SansSerif17ProICP,
        Draft9SansSerifPSCP,
        NLQSansSerif10ProIIICP,
        NLQSansSerif12CP,
        NLQSansSerifPSCP
    };

lpFontCPListType   DVTFontCPListProII [] =
    {
        Draft9SansSerif10CP,
        Draft9SansSerif12CP,
        Draft9SansSerif17ProICP,
        Draft9SansSerifPSCP,
        FastFont12CP,
        NLQSansSerif10ProIIICP,
        NLQSansSerif12CP,
        NLQSansSerifPSCP,
        NLQIISansSerif10CP,
        NLQIISansSerif12CP
    };

lpFontCPListType   DVTFontCPListProIII [] =
    {
        Draft9SansSerif10CP,
        Draft9SansSerif12CP,
        Draft9SansSerif17ProIIICP,
        Draft9SansSerif20CP,
        Draft9SansSerifPSCP,
        FastFont12CP,
        NLQSansSerif10ProIIICP,
        NLQSansSerif12CP,
        NLQSansSerifPSCP,
        NLQIISansSerif10CP,
        NLQIISansSerif12CP,
        Italic10CP,
        Italic12CP
    };

lpFontCPListType   DVTFontCPListProX24 [] =
    {
        Draft24SansSerif10CP,
        Draft24SansSerif12CP,
        Draft24SansSerif17CP,
        LQCourier10CP,
        LQCourier12CP,
        LQCourier17CP,
        LQCourierPSCP
    };






/**********************************************************************/
/* DVT Font Code Page List array for 42XX driver.                     */
/**********************************************************************/
lplpFontCPListType  DVTFontCPList [] =
    {
        DVTFontCPListProI,            /*  IBM_PRO_PRINTER_I           */
        DVTFontCPListProII,           /*  IBM_PRO_PRINTER_II          */
        DVTFontCPListProIII,          /*  IBM_PRO_PRINTER_III         */
        DVTFontCPListProXL,           /*  IBM_PRO_PRINTER_XL          */
        DVTFontCPListProII,           /*  IBM_PRO_PRINTER_II_XL       */
        DVTFontCPListProIII,          /*  IBM_PRO_PRINTER_III_XL      */
        DVTFontCPListProX24,          /*  IBM_PRO_PRINTER_X24         */
        DVTFontCPListProX24,          /*  IBM_PRO_PRINTER_X24E        */
        DVTFontCPListProX24,          /*  IBM_PRO_PRINTER_XL24        */
        DVTFontCPListProX24,          /*  IBM_PRO_PRINTER_XL24E       */
    };

